/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.world.origin;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkProviderOrigin
implements IChunkProvider {
    public Random rand;
    public World world;
    public WorldType worldtype;
    public NoiseGeneratorPerlin noiseGen1;
    public NoiseGeneratorOctaves noiseGen2;
    public NoiseGeneratorOctaves noiseGen3;
    public NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    public double[] stoneNoise = new double[256];
    public final boolean mapFeaturesEnabled;
    public final double[] field_147434_q;
    public final float[] parabolicField;
    public MapGenBase caveGenerator = new MapGenCaves();
    public MapGenStronghold strongholdGenerator = new MapGenStronghold();
    public MapGenVillage villageGenerator = new MapGenVillage();
    public MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    public MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature();
    public MapGenBase ravineGenerator = new MapGenRavine();
    public BiomeGenBase[] biomesForGeneration;
    public double[] NoiseOctaves4;
    public double[] NoiseOctaves2;
    public double[] NoiseOctaves3;
    public double[] NoiseOctaves6;
    public static boolean spawnDEBUG = true;
    public static boolean message = false;

    public ChunkProviderOrigin(World world, long seed, boolean mapFeaturesEnabled) {
        this.world = world;
        this.mapFeaturesEnabled = mapFeaturesEnabled;
        this.worldtype = world.func_72912_H().func_76067_t();
        this.rand = new Random(seed);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen1 = new NoiseGeneratorPerlin(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_147434_q = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
        NoiseGenerator[] noiseGens = new NoiseGenerator[]{this.noiseGen2, this.noiseGen3, this.noiseGen4, this.noiseGen1, this.noiseGen5, this.noiseGen6, this.mobSpawnerNoise};
        noiseGens = TerrainGen.getModdedNoiseGenerators((World)world, (Random)this.rand, (NoiseGenerator[])noiseGens);
        this.noiseGen2 = (NoiseGeneratorOctaves)noiseGens[0];
        this.noiseGen3 = (NoiseGeneratorOctaves)noiseGens[1];
        this.noiseGen4 = (NoiseGeneratorOctaves)noiseGens[2];
        this.noiseGen1 = (NoiseGeneratorPerlin)noiseGens[3];
        this.noiseGen5 = (NoiseGeneratorOctaves)noiseGens[4];
        this.noiseGen6 = (NoiseGeneratorOctaves)noiseGens[5];
        this.mobSpawnerNoise = (NoiseGeneratorOctaves)noiseGens[6];
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
    }

    public Chunk func_73158_c(int chunkX, int chunkZ) {
        return this.func_73154_d(chunkX, chunkZ);
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        Block[] blockArray = new Block[65536];
        byte[] medadataArray = new byte[65536];
        this.firstGenBasicTerrain(chunkX, chunkZ, blockArray);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.replaceBlocksForBiome(chunkX, chunkZ, blockArray, medadataArray, this.biomesForGeneration);
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.world, chunkX, chunkZ, blockArray);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.world, chunkX, chunkZ, blockArray);
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.world, chunkX, chunkZ, blockArray);
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.world, chunkX, chunkZ, blockArray);
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.world, chunkX, chunkZ, blockArray);
            this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.world, chunkX, chunkZ, blockArray);
        }
        Chunk chunk = new Chunk(this.world, blockArray, medadataArray, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int k = 0; k < biomeArray.length; ++k) {
            biomeArray[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void firstGenBasicTerrain(int chunkX, int chunkZ, Block[] blocks) {
        int b0 = 63;
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.genTerrain(chunkX * 4, 0, chunkZ * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double d0 = 0.125;
                    double d1 = this.field_147434_q[k1 + k2];
                    double d2 = this.field_147434_q[l1 + k2];
                    double d3 = this.field_147434_q[i2 + k2];
                    double d4 = this.field_147434_q[j2 + k2];
                    double d5 = (this.field_147434_q[k1 + k2 + 1] - d1) * d0;
                    double d6 = (this.field_147434_q[l1 + k2 + 1] - d2) * d0;
                    double d7 = (this.field_147434_q[i2 + k2 + 1] - d3) * d0;
                    double d8 = (this.field_147434_q[j2 + k2 + 1] - d4) * d0;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            int j3 = i3 + k * 4 << 12 | 0 + j1 * 4 << 8 | k2 * 8 + l2;
                            int short1 = 256;
                            j3 -= short1;
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int k3 = 0; k3 < 4; ++k3) {
                                double d;
                                d15 += d16;
                                blocks[j3 += short1] = d > 0.0 ? Blocks.field_150348_b : (k2 * 8 + l2 < b0 ? Blocks.field_150355_j : null);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, Block[] blocks, byte[] metadatas, BiomeGenBase[] biomelist) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, chunkX, chunkZ, blocks, metadatas, biomelist, this.world);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        double d0 = 0.03125;
        this.stoneNoise = this.noiseGen1.func_151599_a(this.stoneNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                BiomeGenBase biomegenbase = biomelist[dz + dx * 16];
                biomegenbase.func_150573_a(this.world, this.rand, blocks, metadatas, chunkX * 16 + dx, chunkZ * 16 + dz, this.stoneNoise[dz + dx * 16]);
            }
        }
    }

    private void genTerrain(int cX, int zero, int cZ) {
        double d0 = 684.412;
        double d1 = 684.412;
        double d2 = 512.0;
        double d3 = 512.0;
        this.NoiseOctaves6 = this.noiseGen6.func_76305_a(this.NoiseOctaves6, cX, cZ, 5, 5, 200.0, 200.0, 0.5);
        this.NoiseOctaves4 = this.noiseGen4.func_76304_a(this.NoiseOctaves4, cX, zero, cZ, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.NoiseOctaves2 = this.noiseGen2.func_76304_a(this.NoiseOctaves2, cX, zero, cZ, 5, 33, 5, 684.412, 684.412, 684.412);
        this.NoiseOctaves3 = this.noiseGen3.func_76304_a(this.NoiseOctaves3, cX, zero, cZ, 5, 33, 5, 684.412, 684.412, 684.412);
        boolean flag1 = false;
        boolean flag = false;
        int l = 0;
        int i1 = 0;
        double d4 = 8.5;
        for (int dx = 0; dx < 5; ++dx) {
            for (int dz = 0; dz < 5; ++dz) {
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                int b0 = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[dx + 2 + (dz + 2) * 10];
                for (int l1 = -b0; l1 <= b0; ++l1) {
                    for (int i2 = -b0; i2 <= b0; ++i2) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[dx + l1 + 2 + (dz + i2 + 2) * 10];
                        float f3 = biomegenbase1.field_76748_D;
                        float f4 = biomegenbase1.field_76749_E;
                        if (this.worldtype == WorldType.field_151360_e && f3 > 0.0f) {
                            f3 = 1.0f + f3 * 2.0f;
                            f4 = 1.0f + f4 * 4.0f;
                        }
                        float f5 = this.parabolicField[l1 + 2 + (i2 + 2) * 5] / (f3 + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            f5 /= 2.0f;
                        }
                        f += f4 * f5;
                        f1 += f3 * f5;
                        f2 += f5;
                    }
                }
                f /= f2;
                f1 /= f2;
                f = f * 0.9f + 0.1f;
                f1 = (f1 * 4.0f - 1.0f) / 8.0f;
                double d12 = this.NoiseOctaves6[i1] / 8000.0;
                if (d12 < 0.0) {
                    d12 = -d12 * 0.3;
                }
                if ((d12 = d12 * 3.0 - 2.0) < 0.0) {
                    if ((d12 /= 2.0) < -1.0) {
                        d12 = -1.0;
                    }
                    d12 /= 1.4;
                    d12 /= 2.0;
                } else {
                    if (d12 > 1.0) {
                        d12 = 1.0;
                    }
                    d12 /= 8.0;
                }
                ++i1;
                double d13 = f1;
                double d14 = f;
                d13 += d12 * 0.2;
                d13 = d13 * 8.5 / 8.0;
                double d5 = 8.5 + d13 * 4.0;
                for (int j2 = 0; j2 < 33; ++j2) {
                    double d6 = ((double)j2 - d5) * 12.0 * 128.0 / 256.0 / d14;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.NoiseOctaves2[l] / 512.0;
                    double d8 = this.NoiseOctaves3[l] / 512.0;
                    double d9 = (this.NoiseOctaves4[l] / 10.0 + 1.0) / 2.0;
                    double d10 = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (j2 > 29) {
                        double d11 = (float)(j2 - 29) / 3.0f;
                        d10 = d10 * (1.0 - d11) + -10.0 * d11;
                    }
                    this.field_147434_q[l] = d10;
                    ++l;
                }
            }
        }
    }

    public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
        return true;
    }

    public void func_73153_a(IChunkProvider ICP, int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int dx = chunkX * 16;
        int dz = chunkZ * 16;
        BiomeGenBase biomegenbase = this.world.func_72807_a(dx + 16, dz + 16);
        this.rand.setSeed(this.world.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * i1 + (long)chunkZ * j1 ^ this.world.func_72905_C());
        boolean flag = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(ICP, this.world, this.rand, chunkX, chunkZ, flag));
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_75051_a(this.world, this.rand, chunkX, chunkZ);
            flag = this.villageGenerator.func_75051_a(this.world, this.rand, chunkX, chunkZ);
            this.strongholdGenerator.func_75051_a(this.world, this.rand, chunkX, chunkZ);
            this.scatteredFeatureGenerator.func_75051_a(this.world, this.rand, chunkX, chunkZ);
        }
        int k1 = 0;
        int l1 = 0;
        int i2 = 0;
        if (biomegenbase != BiomeGenBase.field_76769_d && biomegenbase != BiomeGenBase.field_76786_s && !flag && this.rand.nextInt(4) == 0 && TerrainGen.populate((IChunkProvider)ICP, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            k1 = dx + this.rand.nextInt(16) + 8;
            l1 = this.rand.nextInt(256);
            i2 = dz + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a(this.world, this.rand, k1, l1, i2);
        }
        if (TerrainGen.populate((IChunkProvider)ICP, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && !flag && this.rand.nextInt(8) == 0) {
            k1 = dx + this.rand.nextInt(16) + 8;
            l1 = this.rand.nextInt(this.rand.nextInt(248) + 8);
            i2 = dz + this.rand.nextInt(16) + 8;
            if (l1 < 63 || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a(this.world, this.rand, k1, l1, i2);
            }
        }
        boolean doGen = TerrainGen.populate((IChunkProvider)ICP, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
        for (k1 = 0; doGen && k1 < 8; ++k1) {
            l1 = dx + this.rand.nextInt(16) + 8;
            i2 = this.rand.nextInt(256);
            int j2 = dz + this.rand.nextInt(16) + 8;
            new WorldGenDungeons().func_76484_a(this.world, this.rand, l1, i2, j2);
        }
        biomegenbase.func_76728_a(this.world, this.rand, dx, dz);
        if (TerrainGen.populate((IChunkProvider)ICP, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            SpawnerAnimals.func_77191_a((World)this.world, (BiomeGenBase)biomegenbase, (int)(dx + 8), (int)(dz + 8), (int)16, (int)16, (Random)this.rand);
        }
        dx += 8;
        dz += 8;
        doGen = TerrainGen.populate((IChunkProvider)ICP, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (k1 = 0; doGen && k1 < 16; ++k1) {
            for (l1 = 0; l1 < 16; ++l1) {
                i2 = this.world.func_72874_g(dx + k1, dz + l1);
                if (this.world.func_72884_u(k1 + dx, i2 - 1, l1 + dz)) {
                    this.world.func_147465_d(k1 + dx, i2 - 1, l1 + dz, Blocks.field_150432_aD, 0, 2);
                }
                if (!this.world.func_147478_e(k1 + dx, i2, l1 + dz, true)) continue;
                this.world.func_147465_d(k1 + dx, i2, l1 + dz, Blocks.field_150431_aC, 0, 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(ICP, this.world, this.rand, chunkX, chunkZ, flag));
        BlockFalling.field_149832_M = false;
    }

    public List func_73155_a(EnumCreatureType type, int x, int y, int z) {
        BiomeGenBase biomegenbase = this.world.func_72807_a(x, z);
        return type == EnumCreatureType.monster && this.scatteredFeatureGenerator.func_143030_a(x, y, z) ? this.scatteredFeatureGenerator.func_82667_a() : biomegenbase.func_76747_a(type);
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "ChunkProviderOrigin";
    }

    public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
        return "Stronghold".equals(p_147416_2_) && this.strongholdGenerator != null ? this.strongholdGenerator.func_151545_a(p_147416_1_, p_147416_3_, p_147416_4_, p_147416_5_) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int p_82695_1_, int p_82695_2_) {
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.world, p_82695_1_, p_82695_2_, (Block[])null);
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.world, p_82695_1_, p_82695_2_, (Block[])null);
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.world, p_82695_1_, p_82695_2_, (Block[])null);
            this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.world, p_82695_1_, p_82695_2_, (Block[])null);
        }
    }
}

