/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.IAccessoryEnchantments;
import project.studio.manametalmod.blocks.BlockTopBottom;
import project.studio.manametalmod.decoration.Decoration;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.undead_grave.UndeadGraveCore;

public class BlockAccessoryEnchantments
extends BlockTopBottom
implements ITileEntityProvider {
    public BlockAccessoryEnchantments() {
        super(Material.field_151576_e, "BlockAccessoryEnchantments", "BlockAccessoryEnchantments_top", "BlockAccessoryEnchantments_bottom");
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
        this.field_149758_A = true;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World world, int data) {
        return new TileEntityEnchantmentTable();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fx, float fy, float fz) {
        if (!world.field_72995_K) {
            ItemStack item;
            int power = (int)this.getPower(world, x, y, z);
            if (power > 100) {
                power = 100;
            }
            if ((item = player.func_71045_bC()) != null) {
                IAccessoryEnchantments acc;
                if (item.func_77973_b() instanceof IAccessoryEnchantments && (acc = (IAccessoryEnchantments)item.func_77973_b()).can_enchantments(item, player, world, x, y, z)) {
                    acc.enchantments(item, player, world, x, y, z, power);
                    this.breakbook(world, x, y, z);
                    MMM.playSoundFromServer(world, MMM.getMODID() + ":accessoryenchant", x, y, z, 1.0, 1.0, 6.0);
                }
            } else {
                MMM.addMessage(player, "MMM.BlockAccessoryEnchantments.power", power);
            }
        }
        return true;
    }

    public boolean breakbook(World world, int posX, int posY, int posZ) {
        int dz = 0;
        int power = 0;
        for (dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                if (dz == 0 && dx == 0 || !world.func_147437_c(posX + dx, posY, posZ + dz) || !world.func_147437_c(posX + dx, posY + 1, posZ + dz)) continue;
                power += this.trybreak(world, posX + dx * 2, posY, posZ + dz * 2);
                power += this.trybreak(world, posX + dx * 2, posY + 1, posZ + dz * 2);
                power += this.trybreak(world, posX + dx * 2, posY + 2, posZ + dz * 2);
                if (dx == 0 || dz == 0) continue;
                power += this.trybreak(world, posX + dx * 2, posY, posZ + dz);
                power += this.trybreak(world, posX + dx * 2, posY + 1, posZ + dz);
                power += this.trybreak(world, posX + dx * 2, posY + 2, posZ + dz);
                power += this.trybreak(world, posX + dx, posY, posZ + dz * 2);
                power += this.trybreak(world, posX + dx, posY + 1, posZ + dz * 2);
                power += this.trybreak(world, posX + dx, posY + 2, posZ + dz * 2);
            }
        }
        return power > 0;
    }

    public int trybreak(World world, int dx, int dy, int dz) {
        if (world.field_73012_v.nextInt(40) == 0 && this.getBlockPower(world, dx, dy, dz) > 0.0f) {
            MMM.breakBlock(world, dx, dy, dz, false);
            return 1;
        }
        return 0;
    }

    public float getPower(World world, int posX, int posY, int posZ) {
        int dz = 0;
        float power = 0.0f;
        for (dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                if (dz == 0 && dx == 0 || !world.func_147437_c(posX + dx, posY, posZ + dz) || !world.func_147437_c(posX + dx, posY + 1, posZ + dz)) continue;
                power += this.getBlockPower(world, posX + dx * 2, posY, posZ + dz * 2);
                power += this.getBlockPower(world, posX + dx * 2, posY + 1, posZ + dz * 2);
                power += this.getBlockPower(world, posX + dx * 2, posY + 2, posZ + dz * 2);
                if (dx == 0 || dz == 0) continue;
                power += this.getBlockPower(world, posX + dx * 2, posY, posZ + dz);
                power += this.getBlockPower(world, posX + dx * 2, posY + 1, posZ + dz);
                power += this.getBlockPower(world, posX + dx * 2, posY + 2, posZ + dz);
                power += this.getBlockPower(world, posX + dx, posY, posZ + dz * 2);
                power += this.getBlockPower(world, posX + dx, posY + 1, posZ + dz * 2);
                power += this.getBlockPower(world, posX + dx, posY + 2, posZ + dz * 2);
            }
        }
        return power;
    }

    public float getBlockPower(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150342_X) {
            return 1.0f;
        }
        if (block == ItemCraft10.BlookEnchantmentsBooks) {
            return 2.0f;
        }
        if (block == UndeadGraveCore.BlockOldBookS) {
            return 2.0f;
        }
        if (block == Decoration.BlookDarkBooks) {
            return 2.0f;
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        super.func_149734_b(world, x, y, z, rand);
        for (int dx = x - 2; dx <= x + 2; ++dx) {
            block1: for (int dz = z - 2; dz <= z + 2; ++dz) {
                if (dx > x - 2 && dx < x + 2 && dz == z - 1) {
                    dz = z + 2;
                }
                if (rand.nextInt(16) != 0) continue;
                for (int dy = y; dy <= y + 2; ++dy) {
                    if (!(this.getBlockPower(world, dx, dy, dz) > 0.0f)) continue;
                    if (!world.func_147437_c((dx - x) / 2 + x, dy, (dz - z) / 2 + z)) continue block1;
                    world.func_72869_a("enchantmenttable", (double)x + 0.5, (double)y + 2.0, (double)z + 0.5, (double)((float)(dx - x) + rand.nextFloat()) - 0.5, (double)((float)(dy - y) - rand.nextFloat() - 1.0f), (double)((float)(dz - z) + rand.nextFloat()) - 0.5);
                }
            }
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        super.func_149749_a(world, x, y, z, block, data);
        world.func_147475_p(x, y, z);
    }

    public boolean func_149696_a(World world, int x, int y, int z, int s1, int s2) {
        super.func_149696_a(world, x, y, z, s1, s2);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity != null ? tileentity.func_145842_c(s1, s2) : false;
    }
}

