/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import project.studio.manametalmod.MMM;

public class FakeItemInsert {
    public static ItemStack tryInsertItemTo(@Nonnull IInventory inv, @Nonnull ItemStack is, ForgeDirection d) {
        if (inv == null || is == null) {
            return is;
        }
        int[] validSlots = null;
        boolean isSidedInventory = inv instanceof ISidedInventory;
        if (d == null || d == ForgeDirection.UNKNOWN) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if ((is = FakeItemInsert.tryInsertItemTo(inv, is, dir)) != null && is.field_77994_a > 0) continue;
                return null;
            }
        } else {
            validSlots = FakeItemInsert.getValidSlots(inv, d);
            if (validSlots == null || validSlots.length <= 0) {
                return is;
            }
            for (int slot : validSlots) {
                if (is == null || is.field_77994_a <= 0) {
                    return null;
                }
                is = FakeItemInsert.tryInsertItemIntoInvSlot(inv, slot, is, d);
            }
        }
        return is;
    }

    private static int[] getValidSlots(IInventory inv, ForgeDirection d) {
        if (inv instanceof ISidedInventory) {
            if (d == null) {
                return null;
            }
            return ((ISidedInventory)inv).func_94128_d(d.ordinal());
        }
        int invSize = inv.func_70302_i_();
        int[] validSlots = new int[invSize];
        for (int i = 0; i < invSize; ++i) {
            validSlots[i] = i;
        }
        return validSlots;
    }

    private static ItemStack tryInsertItemIntoInvSlot(@Nonnull IInventory inv, int slot, @Nonnull ItemStack toput, @Nonnull ForgeDirection d) {
        if (inv == null || toput == null || d == null) {
            return toput;
        }
        if (inv instanceof ISidedInventory && !((ISidedInventory)inv).func_102007_a(slot, toput, d.ordinal()) || !inv.func_94041_b(slot, toput)) {
            return toput;
        }
        int stackLimit = inv.func_70297_j_();
        ItemStack stackInInv = inv.func_70301_a(slot);
        if (stackInInv == null) {
            if (stackLimit >= toput.field_77994_a) {
                return null;
            }
            return toput;
        }
        if (!stackInInv.func_77985_e()) {
            return toput;
        }
        if (FakeItemInsert.mergeItemStack(toput, stackInInv, stackLimit)) {
            inv.func_70296_d();
        }
        if (toput.field_77994_a <= 0) {
            return null;
        }
        return toput;
    }

    private static boolean mergeItemStack(ItemStack is1, ItemStack is2, int stackSizeLimit) {
        if (is1 == null || is2 == null) {
            return false;
        }
        stackSizeLimit = Math.min(is2.func_77976_d(), stackSizeLimit);
        int space = stackSizeLimit - is2.field_77994_a;
        if (space <= 0) {
            return false;
        }
        String foodDataTagName = "foodData";
        String foodTimeTag = "foodTime";
        String saltedTag = "foodSalted";
        String marinatedTag = "foodMarinated";
        if (MMM.isItemStackEqual(is1, is2)) {
            if (space >= is1.field_77994_a) {
                return true;
            }
            return true;
        }
        return FakeItemInsert.isFoodEqual(is1, is2);
    }

    private static boolean isFoodEqual(ItemStack is1, ItemStack is2) {
        String foodDataTagName = "foodData";
        boolean flag = false;
        if (!(MMM.isFoodRoot(is1) && MMM.isFoodRoot(is2) && MMM.isItemStackEqualNoNBT(is1, is2))) {
            return false;
        }
        NBTTagCompound foodtag1 = is1.field_77990_d.func_74775_l(foodDataTagName);
        NBTTagCompound foodtag2 = is2.field_77990_d.func_74775_l(foodDataTagName);
        is1.field_77990_d.func_82580_o(foodDataTagName);
        is2.field_77990_d.func_82580_o(foodDataTagName);
        flag = is1.field_77990_d.equals((Object)is2.field_77990_d);
        is1.field_77990_d.func_74782_a(foodDataTagName, (NBTBase)foodtag1);
        is2.field_77990_d.func_74782_a(foodDataTagName, (NBTBase)foodtag2);
        return flag;
    }
}

