/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class FileEncryptor {
    public static SecretKey generateSecretKey() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(128);
        return keyGenerator.generateKey();
    }

    public static byte[] generateIV() {
        byte[] iv = new byte[16];
        new SecureRandom().nextBytes(iv);
        return iv;
    }

    public static void encryptFile(String inputFile, String outputFile, SecretKey secretKey, byte[] iv) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
        byte[] plaintext = Files.readAllBytes(Paths.get(inputFile, new String[0]));
        byte[] ciphertext = cipher.doFinal(plaintext);
        Files.write(Paths.get(outputFile, new String[0]), ciphertext, new OpenOption[0]);
    }

    public static void decryptFile(String inputFile, String outputFile, SecretKey secretKey, byte[] iv) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
        byte[] ciphertext = Files.readAllBytes(Paths.get(inputFile, new String[0]));
        byte[] plaintext = cipher.doFinal(ciphertext);
        Files.write(Paths.get(outputFile, new String[0]), plaintext, new OpenOption[0]);
    }

    public static void main(String[] args) throws Exception {
        String originalFile = "original.txt";
        String encryptedFile = "encrypted.txt";
        String decryptedFile = "decrypted.txt";
        SecretKey secretKey = FileEncryptor.generateSecretKey();
        byte[] iv = FileEncryptor.generateIV();
        FileEncryptor.encryptFile(originalFile, encryptedFile, secretKey, iv);
        FileEncryptor.decryptFile(encryptedFile, decryptedFile, secretKey, iv);
    }
}

