/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core.export_utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.GLAllocation;
import org.apache.commons.codec.binary.Base64;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import project.studio.manametalmod.MMM;

public final class FBOHelper {
    public int renderTextureSize = 128;
    public int framebufferID = -1;
    public int depthbufferID = -1;
    public int textureID = -1;
    private IntBuffer lastViewport;
    private int lastTexture;
    private int lastFramebuffer;

    public FBOHelper(int textureSize) {
        this.renderTextureSize = textureSize;
        this.createFramebuffer();
    }

    public void resize(int newSize) {
        this.deleteFramebuffer();
        this.renderTextureSize = newSize;
        this.createFramebuffer();
    }

    public void begin() {
        FBOHelper.checkGlErrors("FBO Begin Init");
        this.lastFramebuffer = GL11.glGetInteger((int)36006);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.framebufferID);
        this.lastViewport = GLAllocation.func_74527_f((int)16);
        GL11.glGetInteger((int)2978, (IntBuffer)this.lastViewport);
        GL11.glViewport((int)0, (int)0, (int)this.renderTextureSize, (int)this.renderTextureSize);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        this.lastTexture = GL11.glGetInteger((int)32873);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16640);
        GL11.glCullFace((int)1028);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        FBOHelper.checkGlErrors("FBO Begin Final");
    }

    public void end() {
        FBOHelper.checkGlErrors("FBO End Init");
        GL11.glCullFace((int)1029);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glViewport((int)this.lastViewport.get(0), (int)this.lastViewport.get(1), (int)this.lastViewport.get(2), (int)this.lastViewport.get(3));
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.lastFramebuffer);
        GL11.glBindTexture((int)3553, (int)this.lastTexture);
        FBOHelper.checkGlErrors("FBO End Final");
    }

    public void bind() {
        GL11.glBindTexture((int)3553, (int)this.textureID);
    }

    public void restoreTexture() {
        GL11.glBindTexture((int)3553, (int)this.lastTexture);
    }

    public void saveToFile(File file) {
        GL11.glBindTexture((int)3553, (int)this.textureID);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        IntBuffer texture = BufferUtils.createIntBuffer((int)(width * height));
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)texture);
        int[] texture_array = new int[width * height];
        texture.get(texture_array);
        BufferedImage image = new BufferedImage(this.renderTextureSize, this.renderTextureSize, 2);
        image.setRGB(0, 0, this.renderTextureSize, this.renderTextureSize, texture_array, 0, width);
        file.mkdirs();
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getBase64() {
        GL11.glBindTexture((int)3553, (int)this.textureID);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        IntBuffer texture = BufferUtils.createIntBuffer((int)(width * height));
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)texture);
        int[] texture_array = new int[width * height];
        texture.get(texture_array);
        BufferedImage image = new BufferedImage(this.renderTextureSize, this.renderTextureSize, 2);
        image.setRGB(0, 0, this.renderTextureSize, this.renderTextureSize, texture_array, 0, width);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "PNG", out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Base64.encodeBase64String((byte[])out.toByteArray());
    }

    private void createFramebuffer() {
        this.framebufferID = EXTFramebufferObject.glGenFramebuffersEXT();
        this.textureID = GL11.glGenTextures();
        int currentFramebuffer = GL11.glGetInteger((int)36006);
        int currentTexture = GL11.glGetInteger((int)32873);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.framebufferID);
        GL11.glBindTexture((int)3553, (int)this.textureID);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.renderTextureSize, (int)this.renderTextureSize, (int)0, (int)32993, (int)5121, (ByteBuffer)null);
        GL11.glBindTexture((int)3553, (int)currentTexture);
        this.depthbufferID = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)this.depthbufferID);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)6402, (int)this.renderTextureSize, (int)this.renderTextureSize);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)this.depthbufferID);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)this.textureID, (int)0);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)currentFramebuffer);
    }

    private void deleteFramebuffer() {
        EXTFramebufferObject.glDeleteFramebuffersEXT((int)this.framebufferID);
        GL11.glDeleteTextures((int)this.textureID);
        EXTFramebufferObject.glDeleteRenderbuffersEXT((int)this.depthbufferID);
    }

    public static void checkGlErrors(String message) {
        int error = GL11.glGetError();
        if (error != 0) {
            String error_name = GLU.gluErrorString((int)error);
            MMM.Logg("########## GL ERROR ##########");
            MMM.Logg("@ " + message);
            MMM.Logg(error + ": " + error_name);
        }
    }
}

