/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.instance_dungeon;

import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Particle;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.core.TileEntityUpdate;
import project.studio.manametalmod.dungeon.DungeonCore;
import project.studio.manametalmod.dungeon.TrapDamage;
import project.studio.manametalmod.instance_dungeon.IDungeonDifficult;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonType;
import project.studio.manametalmod.mob.EntityArrowBase;
import project.studio.manametalmod.potion.PotionM3;

public class TileEntityAutoTrap
extends TileEntityUpdate {
    int waittime = 50;
    int time = 0;
    public int type = 0;
    public InstanceDungeonType DungeonType = InstanceDungeonType.FireDungeon;
    public IDungeonDifficult diff = IDungeonDifficult.EASY;

    public TileEntityAutoTrap() {
    }

    public TileEntityAutoTrap(int type) {
        this.type = type;
    }

    public void setTime(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && MMM.isPlayerCreativeMode(player)) {
            this.waittime = player.func_70093_af() ? (this.waittime -= 5) : (this.waittime += 5);
            if (this.waittime > 200) {
                this.waittime = 200;
            }
            if (this.waittime < 5) {
                this.waittime = 5;
            }
            MMM.addMessage(player, "MMM.info.BlockTrapAuto.time", this.waittime);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.waittime = NBTHelp.getIntSafe("waittime", nbt, 40);
        this.type = NBTHelp.getIntSafe("type", nbt, 0);
        this.DungeonType = InstanceDungeonType.values()[NBTHelp.getIntSafe("DungeonType", nbt, 0)];
        this.diff = IDungeonDifficult.values()[NBTHelp.getIntSafe("diff", nbt, 0)];
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("waittime", this.waittime);
        nbt.func_74768_a("type", this.type);
        nbt.func_74768_a("DungeonType", this.DungeonType.ordinal());
        nbt.func_74768_a("diff", this.diff.ordinal());
    }

    @Override
    public void func_145845_h() {
        block12: {
            block11: {
                if (!this.field_145850_b.field_72995_K) {
                    ++this.time;
                    if (this.time > this.waittime) {
                        this.time = 0;
                        switch (this.type) {
                            case 0: {
                                this.doArrow(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                                break;
                            }
                            case 1: {
                                this.doSpikes(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                                break;
                            }
                            case 2: {
                                this.doFire(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                                break;
                            }
                            case 3: {
                                this.doArrowPotion(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            }
                        }
                    }
                }
                if (!this.field_145850_b.field_72995_K) break block11;
                if (this.type != 2 || this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) != 1) break block12;
                for (int s = 0; s < 2; ++s) {
                    FXHelp.spawnParticle(this.field_145850_b, Particle.fire, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.1, (double)this.field_145849_e + 0.5, (0.5f - this.field_145850_b.field_73012_v.nextFloat()) * 0.1f, this.field_145850_b.field_73012_v.nextFloat() * 0.2f, (0.5f - this.field_145850_b.field_73012_v.nextFloat()) * 0.1f, -1.0f);
                    FXHelp.spawnParticle(this.field_145850_b, Particle.flame, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.1, (double)this.field_145849_e + 0.5, (0.5f - this.field_145850_b.field_73012_v.nextFloat()) * 0.1f, this.field_145850_b.field_73012_v.nextFloat() * 0.2f, (0.5f - this.field_145850_b.field_73012_v.nextFloat()) * 0.1f, -1.0f);
                }
                break block12;
            }
            if (this.type == 2 && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
                List list = this.field_145850_b.func_82733_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 2.0), (double)((double)this.field_145849_e + 1.0)), IEntitySelector.field_94557_a);
                for (int s = 0; s < list.size(); ++s) {
                    float damage = 0.3f * (float)(this.diff.ordinal() + 1);
                    ((EntityLivingBase)list.get(s)).func_70097_a(TrapDamage.SpikedTrap, damage * ((EntityLivingBase)list.get(s)).func_110138_aP());
                    ((EntityLivingBase)list.get(s)).func_70015_d(5);
                }
            }
        }
    }

    public void doFire(World world, int x, int y, int z) {
        int data = world.func_72805_g(x, y, z);
        if (data == 0) {
            world.func_72921_c(x, y, z, 1, 2);
            if (!world.field_72995_K) {
                MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":trap_fire", new Pos(this), 1.0, 1.0, 10.0);
            }
        } else {
            world.func_72921_c(x, y, z, 0, 2);
        }
    }

    public void doSpikes(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y + 1, z) == DungeonCore.SpikedTrap) {
            world.func_147468_f(x, y + 1, z);
        } else {
            world.func_147449_b(x, y + 1, z, DungeonCore.SpikedTrap);
            if (!world.field_72995_K) {
                MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":trap_spikes", new Pos(this), 1.0, 1.0, 10.0);
            }
        }
    }

    public void doArrowPotion(World world, int x, int y, int z) {
        EntityArrowBase arrow = new EntityArrowBase(world, x, (double)y, z);
        arrow.field_70161_v += 0.5;
        arrow.field_70165_t += 0.5;
        arrow.field_70163_u += 0.5;
        arrow.field_70181_x += 0.1;
        float damage = 980.0f * (float)(this.diff.ordinal() + 1);
        arrow.func_70239_b(damage);
        arrow.potionFX = PotionM3.potionPoison.ordinal();
        arrow.arrows = new ItemStack(Items.field_151034_e);
        switch (world.func_72805_g(x, y, z)) {
            case 5: {
                arrow.field_70159_w += 1.5;
                arrow.field_70165_t += 0.9;
                break;
            }
            case 4: {
                arrow.field_70159_w += -1.5;
                arrow.field_70165_t += -0.9;
                break;
            }
            case 3: {
                arrow.field_70179_y += 1.5;
                arrow.field_70161_v += 0.9;
                break;
            }
            case 2: {
                arrow.field_70179_y += -1.5;
                arrow.field_70161_v += -0.9;
            }
        }
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)arrow);
            MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":auto_trap_arrow", new Pos(this), 1.0, 1.0, 5.0);
        }
    }

    public void doArrow(World world, int x, int y, int z) {
        EntityArrowBase arrow = new EntityArrowBase(world, x, (double)y, z);
        arrow.field_70161_v += 0.5;
        arrow.field_70165_t += 0.5;
        arrow.field_70163_u += 0.5;
        arrow.field_70181_x += 0.1;
        float damage = 980.0f * (float)(this.diff.ordinal() + 1);
        arrow.func_70239_b(damage);
        switch (world.func_72805_g(x, y, z)) {
            case 5: {
                arrow.field_70159_w += 1.5;
                arrow.field_70165_t += 0.9;
                break;
            }
            case 4: {
                arrow.field_70159_w += -1.5;
                arrow.field_70165_t += -0.9;
                break;
            }
            case 3: {
                arrow.field_70179_y += 1.5;
                arrow.field_70161_v += 0.9;
                break;
            }
            case 2: {
                arrow.field_70179_y += -1.5;
                arrow.field_70161_v += -0.9;
            }
        }
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)arrow);
            MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":auto_trap_arrow", new Pos(this), 1.0, 1.0, 5.0);
        }
    }
}

