/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.mall;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft2;
import project.studio.manametalmod.mall.IcommodityMall;
import project.studio.manametalmod.mall.MallType;

public class MallCore {
    public static int time = 0;
    public static final int timeAnalyze = 576000;
    public static final Map<MallType, ArrayList<IcommodityMall>> map = new HashMap<MallType, ArrayList<IcommodityMall>>();
    public static final String[] categories = new String[]{MallType.fashion.toString(), MallType.effects.toString(), MallType.decoration.toString(), MallType.other.toString()};
    public static final ArrayList<IcommodityMall> functionList = new ArrayList();
    public static String jsonStringCache = null;
    public static boolean isAnalysis = false;

    public static final void tick() {
        if (++time > 576000 && M3Config.OnlineStore) {
            time = 0;
            MallCore.analyze();
        }
    }

    public static final void analyze() {
        isAnalysis = false;
        map.forEach((key, value) -> value.clear());
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    String targetUrl = "https://www.manametal.net/api/cashshop/whitegoldshoplist.php";
                    URL url = new URL(targetUrl);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setDoOutput(true);
                    connection.setRequestProperty("User-agent", "IE/11.0");
                    connection.setRequestProperty("Accept", "application/json; charset=utf-8");
                    int responseCode = connection.getResponseCode();
                    if (MMM.DEBUG()) {
                        MMM.Logg("analyze store items response code : " + responseCode);
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    connection.setConnectTimeout(10000);
                    connection.setReadTimeout(10000);
                    StringBuffer sb = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    connection.disconnect();
                    jsonStringCache = MallCore.analyzeItems(sb.toString());
                    isAnalysis = true;
                    if (MMM.DEBUG()) {
                        map.forEach((key, value) -> {
                            MMM.Logg("*****key : " + key.toString());
                            for (int s = 0; s < value.size(); ++s) {
                                MMM.Logg(((IcommodityMall)value.get(s)).getItem().func_82833_r() + " $ : " + ((IcommodityMall)value.get(s)).getPrice() + " ID: " + ((IcommodityMall)value.get((int)s)).id);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setName("MallServer");
        thread.start();
    }

    public static final String analyzeItems(String data) {
        Gson gson = new Gson();
        JsonParser JP = new JsonParser();
        JsonObject root = JP.parse(data).getAsJsonObject();
        ArrayList<IcommodityMall> list = null;
        int id = 0;
        String name = null;
        int price = 0;
        String[] array = null;
        ItemStack tempitem = null;
        JsonObject itemJson = null;
        JsonArray itemsArray = null;
        for (String category : categories) {
            itemsArray = root.getAsJsonArray(category);
            if (itemsArray == null || (list = map.get((Object)MallType.valueOf(category))) == null) continue;
            for (JsonElement element : itemsArray) {
                itemJson = element.getAsJsonObject();
                id = itemJson.get("id").getAsInt();
                name = itemJson.get("name").getAsString();
                price = itemJson.get("price").getAsInt();
                array = name.split(":");
                if (array == null || array.length != 3 || (tempitem = MMM.findItemStack(array[1], array[0], 1, Integer.parseInt(array[2]))) == null) continue;
                list.add(new IcommodityMall(tempitem, price, id));
            }
        }
        return data;
    }

    static {
        for (int s = 0; s < categories.length; ++s) {
            map.put(MallType.valueOf(categories[s]), new ArrayList());
        }
        functionList.add(new IcommodityMall(new ItemStack(ItemCraft2.ItemMobStatueMakes, 1, 0), 75, -1).setDragonStone(true));
        functionList.add(new IcommodityMall(new ItemStack(ItemCraft2.ItemWarehouseExpansion, 1, 0), 30, -1).setDragonStone(true));
        functionList.add(new IcommodityMall(new ItemStack(ItemCraft2.DoubleEXPReel, 1, 1), 60, -1).setDragonStone(true));
        functionList.add(new IcommodityMall(new ItemStack(ItemCraft2.ItemTeammatesTeleportScrolls, 1, 0), 30, -1).setDragonStone(true));
        functionList.add(new IcommodityMall(new ItemStack(ItemCraft2.ItemTeamTeleportScroll, 1, 0), 120, -1).setDragonStone(true));
        functionList.add(new IcommodityMall(new ItemStack(ItemCraft2.ItemBossCoinMultiple, 1, 0), 60, -1).setDragonStone(true));
        functionList.add(new IcommodityMall(new ItemStack(ItemCraft2.ItemWhiteGoldLifeAmulet, 1, 0), 60, -1).setDragonStone(true));
        functionList.add(new IcommodityMall(new ItemStack(ItemCraft2.ItemTeammatesTeleportScrolls, 10, 0), 180, -1).setDragonStone(true));
        functionList.add(new IcommodityMall(new ItemStack(ItemCraft2.ItemTeamTeleportScroll, 5, 0), 540, -1).setDragonStone(true));
        functionList.add(new IcommodityMall(new ItemStack(ItemCraft2.ItemWhiteGoldLifeAmulet, 10, 0), 540, -1).setDragonStone(true));
    }
}

