/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.potion;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.event.EventFx;
import project.studio.manametalmod.potion.PotionM3;

public class PotionEffectM3 {
    public int TIME;
    public int LV;
    public PotionM3 ID;
    public int data1 = 0;
    public int data2 = 0;
    public int data3 = 0;
    public String cacheData = null;
    public Set<Long> UUIDList;

    public PotionEffectM3 addUUID(long UUID2) {
        if (this.UUIDList == null) {
            this.UUIDList = new HashSet<Long>();
        }
        if (this.UUIDList != null) {
            this.UUIDList.add(UUID2);
        }
        return this;
    }

    public boolean hasUUID(long UUID2) {
        return this.UUIDList != null && this.UUIDList.contains(UUID2);
    }

    public PotionEffectM3(PotionM3 ID, int TIME, int LV2) {
        this.ID = ID;
        this.TIME = TIME;
        this.LV = LV2;
    }

    public PotionEffectM3 copy() {
        return new PotionEffectM3(this.ID, this.TIME, this.LV);
    }

    public NBTTagCompound SaveToNBT(NBTTagCompound tag) {
        tag.func_74768_a("ID", this.ID.ordinal());
        tag.func_74768_a("TIME", this.TIME);
        tag.func_74768_a("LV", this.LV);
        return tag;
    }

    public static PotionEffectM3 readFromNBT(NBTTagCompound tag) {
        return new PotionEffectM3(PotionM3.values()[tag.func_74762_e("ID")], tag.func_74762_e("TIME"), tag.func_74762_e("LV"));
    }

    public static boolean canReadFromNBT(NBTTagCompound tag) {
        return tag.func_150297_b("ID", 3) && tag.func_150297_b("LV", 3) && tag.func_150297_b("TIME", 3);
    }

    public static void clear(ManaMetalModRoot root) {
        root.ManaEntityData.potions.clear();
    }

    public static void clear(EntityLivingBase entity) {
        ManaMetalModRoot root = MMM.getEntityNBT(entity);
        if (root != null) {
            PotionEffectM3.clear(root);
        }
    }

    public static List<PotionEffectM3> getPotions(ManaMetalModRoot root) {
        return root.ManaEntityData.potions;
    }

    public static List<PotionEffectM3> getPotions(EntityLivingBase entity) {
        ManaMetalModRoot root = MMM.getEntityNBT(entity);
        if (root != null) {
            return PotionEffectM3.getPotions(root);
        }
        return null;
    }

    public static PotionEffectM3 getPotionEffectM3(EntityLivingBase entity, PotionM3 ID) {
        ManaMetalModRoot root = MMM.getEntityNBT(entity);
        if (root != null) {
            return PotionEffectM3.getPotionEffectM3(root, ID);
        }
        return null;
    }

    public static PotionEffectM3 getPotionEffectM3(ManaMetalModRoot root, PotionM3 ID) {
        if (root.ManaEntityData.getentity() instanceof EntityLivingBase) {
            for (int s = 0; s < root.ManaEntityData.potions.size(); ++s) {
                if (root.ManaEntityData.potions.get((int)s).ID != ID) continue;
                return root.ManaEntityData.potions.get(s);
            }
        }
        return null;
    }

    public static int getPotionLV(EntityLivingBase entity, PotionM3 ID) {
        ManaMetalModRoot root = MMM.getEntityNBT(entity);
        if (root != null && root.ManaEntityData.getentity() instanceof EntityLivingBase) {
            for (int s = 0; s < root.ManaEntityData.potions.size(); ++s) {
                if (root.ManaEntityData.potions.get((int)s).ID != ID) continue;
                return root.ManaEntityData.potions.get((int)s).LV;
            }
        }
        return -1;
    }

    public static int getPotionLV(ManaMetalModRoot root, PotionM3 ID) {
        if (root.ManaEntityData.getentity() instanceof EntityLivingBase) {
            for (int s = 0; s < root.ManaEntityData.potions.size(); ++s) {
                if (root.ManaEntityData.potions.get((int)s).ID != ID) continue;
                return root.ManaEntityData.potions.get((int)s).LV;
            }
        }
        return -1;
    }

    public static boolean isPotion(EntityLivingBase entity, PotionM3 ... ID) {
        ManaMetalModRoot root = MMM.getEntityNBT(entity);
        if (root != null) {
            return PotionEffectM3.isPotion(root, ID);
        }
        return false;
    }

    public static boolean isPotion(ManaMetalModRoot root, PotionM3 ... ID) {
        if (root.ManaEntityData.getentity() instanceof EntityLivingBase) {
            for (int s = 0; s < root.ManaEntityData.potions.size(); ++s) {
                if (!PotionEffectM3.has(ID, root.ManaEntityData.potions.get((int)s).ID)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean has(PotionM3[] data, PotionM3 target) {
        for (int s = 0; s < data.length; ++s) {
            if (data[s] != target) continue;
            return true;
        }
        return false;
    }

    public static boolean isPotion(EntityLivingBase entity, PotionM3 ID) {
        ManaMetalModRoot root = MMM.getEntityNBT(entity);
        if (root != null) {
            return PotionEffectM3.isPotion(root, ID);
        }
        return false;
    }

    public static boolean isPotion(ManaMetalModRoot root, PotionM3 ID) {
        if (root.ManaEntityData.getentity() instanceof EntityLivingBase) {
            for (int s = 0; s < root.ManaEntityData.potions.size(); ++s) {
                if (root.ManaEntityData.potions.get((int)s).ID != ID) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean removePotion(EntityLivingBase entity, PotionM3 ID) {
        ManaMetalModRoot root = MMM.getEntityNBT(entity);
        if (root != null) {
            return PotionEffectM3.removePotion(root, ID);
        }
        return false;
    }

    public static boolean removePotion(ManaMetalModRoot root, PotionM3 ID) {
        if (!root.ManaEntityData.getentity().field_70170_p.field_72995_K && root.ManaEntityData.getentity() instanceof EntityLivingBase) {
            return root.ManaEntityData.removePotion(ID);
        }
        return false;
    }

    public static void addPotion(EntityLivingBase entity, PotionM3 ID, int TIME, int LV2) {
        ManaMetalModRoot root;
        if (ID.ordinal() < PotionM3.values().length && (root = MMM.getEntityNBT(entity)) != null) {
            PotionEffectM3.addPotion(root, ID, TIME, LV2);
        }
    }

    public static void addPotion(ManaMetalModRoot root, PotionM3 ID, int TIME, int LV2) {
        if (!root.ManaEntityData.getentity().field_70170_p.field_72995_K && root.ManaEntityData.getentity() instanceof EntityLivingBase) {
            PotionEffectM3 effect;
            EntityLivingBase target = (EntityLivingBase)root.ManaEntityData.getentity();
            if (ID.ordinal() < PotionM3.values().length && EventFx.onM3Effect(target, effect = new PotionEffectM3(ID, TIME, LV2))) {
                root.ManaEntityData.addPotion(effect);
            }
        }
    }

    public static void addPotion(EntityLivingBase entity, PotionEffectM3 data) {
        PotionEffectM3.addPotion(entity, data.ID, data.TIME, data.LV);
    }

    public static void addPotion(ManaMetalModRoot root, PotionEffectM3 data) {
        PotionEffectM3.addPotion(root, data.ID, data.TIME, data.LV);
    }

    public static void addPotionList(List list, PotionM3 ID, int TIME, int LV2) {
        for (int s = 0; s < list.size(); ++s) {
            if (list.get(s) == null || !(list.get(s) instanceof EntityLivingBase)) continue;
            PotionEffectM3.addPotion((EntityLivingBase)list.get(s), ID, TIME, LV2);
        }
    }

    public static void removePotionList(List list, PotionM3 ID) {
        for (int s = 0; s < list.size(); ++s) {
            if (list.get(s) == null || !(list.get(s) instanceof EntityLivingBase)) continue;
            PotionEffectM3.removePotion((EntityLivingBase)list.get(s), ID);
        }
    }

    public static void addPotionUpLVList(List list, PotionM3 ID, int TIME, int maxLV) {
        for (int s = 0; s < list.size(); ++s) {
            if (list.get(s) == null || !(list.get(s) instanceof EntityLivingBase)) continue;
            PotionEffectM3.addPotionUpLV((EntityLivingBase)list.get(s), ID, TIME, maxLV);
        }
    }

    public static int isPotion(List list, PotionM3 ... ID) {
        int count = 0;
        for (int s = 0; s < list.size(); ++s) {
            if (list.get(s) == null || !(list.get(s) instanceof EntityLivingBase) || !PotionEffectM3.isPotion((EntityLivingBase)list.get(s), ID)) continue;
            ++count;
        }
        return count;
    }

    public static boolean reducePotionLV(ManaMetalModRoot root, PotionM3 ID) {
        PotionEffectM3 effect = PotionEffectM3.getPotionEffectM3(root, ID);
        if (effect != null) {
            if (effect.LV > 0) {
                --effect.LV;
                root.carrer.send2();
            } else {
                PotionEffectM3.removePotion(root, ID);
            }
            return true;
        }
        return false;
    }

    public static boolean reducePotionLV(EntityLivingBase entity, PotionM3 ID) {
        ManaMetalModRoot root = MMM.getEntityNBT(entity);
        if (root != null) {
            return PotionEffectM3.reducePotionLV(root, ID);
        }
        return false;
    }

    public static int addPotionUpLV(EntityLivingBase entity, PotionM3 ID, int TIME, int maxLV) {
        return PotionEffectM3.addPotionUpLVData(entity, ID, TIME, 1, maxLV);
    }

    public static int addPotionUpLV(ManaMetalModRoot root, PotionM3 ID, int TIME, int maxLV) {
        return PotionEffectM3.addPotionUpLVData(root, ID, TIME, 1, maxLV);
    }

    public static int addPotionUpLVData(EntityLivingBase entity, PotionM3 ID, int TIME, int addLV, int maxLV) {
        int LV2 = PotionEffectM3.getPotionLV(entity, ID);
        if (LV2 > -1) {
            if (LV2 + addLV >= maxLV) {
                PotionEffectM3.addPotion(entity, ID, TIME, maxLV);
                return maxLV;
            }
            PotionEffectM3.addPotion(entity, ID, TIME, LV2 + addLV);
            return LV2 + addLV;
        }
        if (addLV >= 1) {
            PotionEffectM3.addPotion(entity, ID, TIME, addLV - 1);
            return addLV - 1;
        }
        PotionEffectM3.addPotion(entity, ID, TIME, 0);
        return 0;
    }

    public static int addPotionUpLVData(ManaMetalModRoot root, PotionM3 ID, int TIME, int addLV, int maxLV) {
        int LV2 = PotionEffectM3.getPotionLV(root, ID);
        if (LV2 > -1) {
            if (LV2 + addLV >= maxLV) {
                PotionEffectM3.addPotion(root, ID, TIME, maxLV);
                return maxLV;
            }
            PotionEffectM3.addPotion(root, ID, TIME, LV2 + addLV);
            return LV2 + addLV;
        }
        if (addLV >= 1) {
            PotionEffectM3.addPotion(root, ID, TIME, addLV - 1);
            return addLV - 1;
        }
        PotionEffectM3.addPotion(root, ID, TIME, addLV);
        return 0;
    }

    public static int addPotionUpLVDataUUIDVerify(EntityLivingBase entity, PotionM3 ID, int TIME, int addLV, int maxLV, long UUID2) {
        PotionEffectM3 potion = PotionEffectM3.getPotionEffectM3(entity, ID);
        if (potion == null) {
            if (addLV >= 1) {
                PotionEffectM3.addPotion(entity, new PotionEffectM3(ID, TIME, addLV - 1).addUUID(UUID2));
                return addLV - 1;
            }
            PotionEffectM3.addPotion(entity, new PotionEffectM3(ID, TIME, 0).addUUID(UUID2));
            return 0;
        }
        if (!potion.hasUUID(UUID2)) {
            int LV2 = potion.LV;
            if (LV2 + addLV >= maxLV) {
                PotionEffectM3.addPotion(entity, new PotionEffectM3(ID, TIME, maxLV).addUUID(UUID2));
                return maxLV;
            }
            PotionEffectM3.addPotion(entity, new PotionEffectM3(ID, TIME, LV2 + addLV).addUUID(UUID2));
            return LV2 + addLV;
        }
        return -1;
    }
}

