/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.beekeeping;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.produce.beekeeping.BeekeepingCore;

public class WorldBeeGenerator
extends WorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (MMM.getDimensionID(world) == 0) {
            this.gen_overworld(world, random, chunkX * 16, chunkZ * 16);
            return;
        }
        if (MMM.getDimensionID(world) == -1) {
            this.gen_hell(world, random, chunkX * 16, chunkZ * 16);
            return;
        }
        if (MMM.getDimensionID(world) == 1) {
            this.gen_ender(world, random, chunkX * 16, chunkZ * 16);
            return;
        }
    }

    public void gen_hell(World world, Random rand, int dx, int dz) {
        for (int s = 0; s < 32; ++s) {
            int z;
            int y;
            int x = dx + rand.nextInt(16);
            if (!world.func_147437_c(x, y = rand.nextInt(64) + 32, z = dz + rand.nextInt(16)) || world.func_147439_a(x, y + 1, z) != Blocks.field_150424_aL) continue;
            world.func_147465_d(x, y, z, BeekeepingCore.BlockHoneycomb_wild, 4, 2);
        }
    }

    public void gen_ender(World world, Random rand, int dx, int dz) {
        for (int s = 0; s < 32; ++s) {
            int z;
            int y;
            int x = dx + rand.nextInt(16);
            if (!world.func_147437_c(x, y = rand.nextInt(80) + 16, z = dz + rand.nextInt(16)) || world.func_147439_a(x, y + 1, z) != Blocks.field_150377_bs) continue;
            world.func_147465_d(x, y, z, BeekeepingCore.BlockHoneycomb_wild, 5, 2);
        }
    }

    public void gen_overworld(World world, Random rand, int dx, int dz) {
        for (int s = 0; s < 32; ++s) {
            int z;
            int y;
            int x = dx + rand.nextInt(16);
            if (!world.func_147437_c(x, y = rand.nextInt(32) + 60, z = dz + rand.nextInt(16))) continue;
            if (world.func_147439_a(x, y + 1, z).func_149688_o() == Material.field_151584_j) {
                BiomeGenBase biome = world.getBiomeGenForCoordsBody(x, z);
                world.func_147465_d(x, y, z, BeekeepingCore.BlockHoneycomb_wild, this.getBeeType(x, y, z, biome), 2);
                continue;
            }
            if (world.func_147439_a(x, y + 1, z) != Blocks.field_150420_aW && world.func_147439_a(x, y + 1, z) != Blocks.field_150419_aX) continue;
            world.func_147465_d(x, y, z, BeekeepingCore.BlockHoneycomb_wild, 7, 2);
        }
    }

    public int getBeeType(int x, int y, int z, BiomeGenBase biome) {
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return 1;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || biome == BiomeGenBase.field_150585_R) {
            return 2;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL)) {
            return 3;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return 6;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
            return 7;
        }
        return 0;
    }

    public boolean func_76484_a(World world, Random rand, int i, int j, int k) {
        return true;
    }
}

