/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.farming;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.sound.SoundTypeCore;

public class BlockBamboo
extends BlockBush
implements IGrowable {
    @SideOnly(value=Side.CLIENT)
    public IIcon[] icons;
    public String BlockName;
    public Item Crop;
    public Item Seed;
    public Item Stick;

    public BlockBamboo(String Name2) {
        this.func_149675_a(true);
        this.func_149647_a(ManaMetalMod.tab_Crop);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundTypeCore.bamboo);
        this.func_149663_c(Name2);
        this.BlockName = Name2;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int data = world.func_72805_g(x, y, z);
        if (data > 1) {
            this.func_149676_a(0.4f, 0.0f, 0.4f, 0.6f, 1.0f, 0.6f);
        } else {
            this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 1.0f, 0.9f);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int data = world.func_72805_g(x, y, z);
        if (data > 1) {
            return AxisAlignedBB.func_72330_a((double)0.4f, (double)0.0, (double)0.4f, (double)0.6f, (double)1.0, (double)0.6f);
        }
        return AxisAlignedBB.func_72330_a((double)0.1f, (double)0.0, (double)0.1f, (double)0.9f, (double)1.0, (double)0.9f);
    }

    public Item getSeed() {
        if (this.Seed == null) {
            this.Seed = GameRegistry.findItem((String)MMM.getMODID(), (String)(this.BlockName + "_seed"));
        }
        return this.Seed;
    }

    public Item getCrop() {
        if (this.Crop == null) {
            this.Crop = GameRegistry.findItem((String)MMM.getMODID(), (String)(this.BlockName + "_crop"));
        }
        return this.Crop;
    }

    public Item getStick() {
        if (this.Stick == null) {
            this.Stick = GameRegistry.findItem((String)MMM.getMODID(), (String)(this.BlockName + "_stick"));
        }
        return this.Stick;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[6];
        for (int i = 0; i < 6; ++i) {
            this.icons[i] = register.func_94245_a("manametalmod:" + this.BlockName + "_" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (meta) {
            case 0: {
                return this.icons[0];
            }
            case 1: {
                return this.icons[1];
            }
            case 2: 
            case 3: 
            case 4: {
                if (side == 0 || side == 1) {
                    return this.icons[2];
                }
                return this.icons[3];
            }
            case 6: {
                return this.icons[4];
            }
            case 7: {
                return this.icons[5];
            }
        }
        return this.icons[0];
    }

    public int func_149738_a(World world) {
        return 40;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        switch (metadata) {
            case 0: {
                ret.add(new ItemStack(this.getSeed()));
                break;
            }
            case 1: {
                ret.add(new ItemStack(this.getCrop()));
                break;
            }
            case 2: {
                ret.add(new ItemStack(this.getStick()));
                break;
            }
            case 3: {
                ret.add(new ItemStack(this.getStick()));
                break;
            }
            case 4: {
                ret.add(new ItemStack(this.getStick()));
            }
        }
        return ret;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(3) == 0) {
            this.onGrow(world, x, y, z, rand);
        }
        if (rand.nextInt(3) == 0) {
            this.onGrowBambooShoots(world, x, y, z, rand);
        }
    }

    public void onGrow(World world, int x, int y, int z, Random rand) {
        int data = world.func_72805_g(x, y, z);
        if (data == 0) {
            world.func_72921_c(x, y, z, 1, 2);
            return;
        }
        if (data == 1) {
            world.func_72921_c(x, y, z, 3, 2);
            return;
        }
        if (data == 3) {
            if (world.func_147439_a(x, y - 1, z) != this) {
                if (world.func_147437_c(x, y + 1, z)) {
                    world.func_72921_c(x, y, z, 2, 2);
                    world.func_147465_d(x, y + 1, z, (Block)this, 3, 2);
                }
            } else if (world.func_147437_c(x, y + 1, z)) {
                world.func_72921_c(x, y, z, 3, 2);
                world.func_147465_d(x, y + 1, z, (Block)this, 4, 2);
            }
        }
        if (data == 4 && world.func_147439_a(x, y + 1, z) != this && world.func_147439_a(x, y - 1, z) == this && world.func_147439_a(x, y - 2, z) == this && this.canGrowBig(world, x, y, z, rand) && world.func_147437_c(x, y + 1, z)) {
            if (rand.nextInt(2) == 0) {
                world.func_72921_c(x, y - 1, z, 3, 2);
            } else {
                world.func_72921_c(x, y - 1, z, 2, 2);
            }
            if (rand.nextInt(2) == 0) {
                world.func_72921_c(x, y, z, 4, 2);
            } else {
                world.func_72921_c(x, y, z, 3, 2);
            }
            world.func_147465_d(x, y + 1, z, (Block)this, 4, 2);
        }
    }

    public boolean canGrowBig(World world, int x, int y, int z, Random rand) {
        for (int s = 1; s < 11; ++s) {
            if (world.func_147439_a(x, y - s, z) == this) continue;
            return true;
        }
        return false;
    }

    public void onGrowBambooShoots(World world, int x, int y, int z, Random rand) {
        if (MMM.getDimensionID(world) == M3Config.WorldGardenID) {
            return;
        }
        int data = world.func_72805_g(x, y, z);
        if (data > 1) {
            switch (rand.nextInt(4)) {
                case 0: {
                    if (this.isDirt(world, x + 1, y, z) && world.func_147437_c(x + 1, y, z)) {
                        world.func_147465_d(x + 1, y, z, (Block)this, 0, 2);
                    }
                    return;
                }
                case 1: {
                    if (this.isDirt(world, x - 1, y, z) && world.func_147437_c(x - 1, y, z)) {
                        world.func_147465_d(x - 1, y, z, (Block)this, 0, 2);
                    }
                    return;
                }
                case 2: {
                    if (this.isDirt(world, x, y, z + 1) && world.func_147437_c(x, y, z + 1)) {
                        world.func_147465_d(x, y, z + 1, (Block)this, 0, 2);
                    }
                    return;
                }
                case 3: {
                    if (this.isDirt(world, x, y, z - 1) && world.func_147437_c(x, y, z - 1)) {
                        world.func_147465_d(x, y, z - 1, (Block)this, 0, 2);
                    }
                    return;
                }
            }
        }
    }

    public boolean isDirt(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z).canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean d) {
        return world.func_72805_g(x, y, z) != 10;
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        this.func_149674_a(world, x, y, z, world.field_73012_v);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y - 1, z) == this) {
            return true;
        }
        return super.func_149718_j(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public int func_149645_b() {
        return 80094;
    }
}

