/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.textile;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.IQualityItem;
import project.studio.manametalmod.api.Quality;
import project.studio.manametalmod.api.weapon.IMagicItem;
import project.studio.manametalmod.core.ManaItemType;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.entity.nbt.NbtBaubles;
import project.studio.manametalmod.magic.magicItem.IMagicEffect;
import project.studio.manametalmod.magic.magicItem.MagicItemType;

public class MagicItemTextile
extends IMagicItem
implements IQualityItem {
    public MagicItemTextile() {
        super("MagicItemTextile");
    }

    @Override
    public ManaItemType getType(ItemStack item) {
        switch (item.func_77960_j()) {
            case 0: {
                return ManaItemType.Cloak;
            }
            case 1: {
                return ManaItemType.Scarf;
            }
            case 2: {
                return ManaItemType.Sock;
            }
        }
        return ManaItemType.Cloak;
    }

    @Override
    public int TypeCount() {
        return 3;
    }

    @Override
    public void onBeAttack(ItemStack item, EntityPlayer player, EntityLivingBase entity, DamageSource source) {
    }

    @Override
    public void onAttack(ItemStack item, EntityPlayer player, EntityLivingBase target, DamageSource source) {
    }

    @Override
    public void onCrit(ItemStack item, EntityPlayer player, EntityLivingBase entity, DamageSource source) {
    }

    @Override
    public int getNeedLV(ItemStack item, EntityPlayer player) {
        return 1;
    }

    @Override
    public void onEquipment(ItemStack item, EntityLivingBase player) {
    }

    @Override
    public void onDisrobe(ItemStack item, EntityLivingBase player) {
    }

    public List<MagicItemType> getRenderTypes(int id) {
        ArrayList<MagicItemType> list = new ArrayList<MagicItemType>();
        list.add(MagicItemType.crit);
        list.add(MagicItemType.avoid);
        list.add(MagicItemType.maxSP);
        list.add(MagicItemType.dropRate);
        list.add(MagicItemType.penetrate);
        list.add(MagicItemType.physicalAttack);
        list.add(MagicItemType.magicAttack);
        list.add(MagicItemType.magicDefense);
        list.add(MagicItemType.hpReply);
        list.add(MagicItemType.healthRecovery);
        list.add(MagicItemType.manaReply);
        list.add(MagicItemType.magicRelief);
        return list;
    }

    public int getEffectCount(World world, int drop, Random rand) {
        int id;
        int data = 200 - (drop - 100);
        if (data < 50) {
            data = 50;
        }
        if ((id = rand.nextInt(data)) < 20) {
            return 4;
        }
        if (id < 50) {
            return 3;
        }
        if (id < 100) {
            return 2;
        }
        return 1;
    }

    public float getEffect(MagicItemType type, World world, Random rand) {
        switch (type) {
            case magicDefense: {
                return 5 + rand.nextInt(11);
            }
            case physicalAttack: {
                return 2 + rand.nextInt(11);
            }
            case magicAttack: {
                return 2 + rand.nextInt(11);
            }
            case crit: {
                return 4 + rand.nextInt(11);
            }
            case avoid: {
                return 4 + rand.nextInt(11);
            }
            case hpReply: {
                return 3 + rand.nextInt(8);
            }
            case manaReply: {
                return 3 + rand.nextInt(8);
            }
            case attackMultiplier: {
                return MathHelper.func_151240_a((Random)rand, (float)0.01f, (float)0.08f);
            }
            case defenseMultiplier: {
                return MathHelper.func_151240_a((Random)rand, (float)0.01f, (float)0.05f);
            }
            case maxSP: {
                return 50 + rand.nextInt(101);
            }
            case healthRecovery: {
                return MathHelper.func_151240_a((Random)rand, (float)0.1f, (float)0.3f);
            }
            case dropRate: {
                return 5 + rand.nextInt(11);
            }
            case penetrate: {
                return 1 + rand.nextInt(3);
            }
            case magicRelief: {
                return MathHelper.func_151240_a((Random)rand, (float)0.01f, (float)0.05f);
            }
        }
        return 1.0f;
    }

    public void doaddEffect(ItemStack item, World world, EntityPlayer player) {
        if (item != null) {
            int s;
            ManaMetalModRoot root = MMM.getEntityNBT(player);
            if (root == null) {
                return;
            }
            Random rand = new Random();
            MagicItemType[] effects = new MagicItemType[this.getEffectCount(world, root.carrer.getFinalDropRate(), rand)];
            float[] val = new float[effects.length];
            List<MagicItemType> list = this.getRenderTypes(item.func_77960_j());
            for (int s2 = 0; s2 < effects.length; ++s2) {
                MagicItemType type;
                int id = rand.nextInt(list.size());
                effects[s2] = type = list.get(id);
                list.remove(id);
            }
            NBTTagList listEffect = new NBTTagList();
            int[] ids = new int[effects.length];
            for (s = 0; s < val.length; ++s) {
                val[s] = this.getEffect(effects[s], world, rand);
                ids[s] = effects[s].ordinal();
            }
            for (s = 0; s < val.length; ++s) {
                listEffect.func_74742_a((NBTBase)new NBTTagFloat(val[s]));
            }
            NBTTagCompound tag = new NBTTagCompound();
            if (item.func_77942_o()) {
                tag = item.func_77978_p();
            }
            tag.func_74783_a("listID", ids);
            tag.func_74782_a("listEffect", (NBTBase)listEffect);
            int gamepoint = NBTHelp.getIntSafe("gamepoint", item.func_77978_p(), -1);
            if (gamepoint > 0) {
                tag.func_74768_a("gamepoint", gamepoint);
            }
            item.func_77982_d(tag);
        }
    }

    @Override
    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (item.func_77942_o() && !item.func_77978_p().func_150297_b("listID", 11)) {
            this.doaddEffect(item, world, player);
            return item;
        }
        return super.func_77659_a(item, world, player);
    }

    @Override
    public void func_77624_a(ItemStack item, EntityPlayer player, List List2, boolean booleans) {
        int flydata;
        List2.add(EnumChatFormatting.GREEN + MMM.getTranslateText("manaItemType." + this.getType(item).toString()));
        List2.add(EnumChatFormatting.YELLOW + MMM.getTranslateText("game.info.item.lore.armorLV") + this.getNeedLV(item, player));
        if (item.func_77942_o()) {
            int gamepoint = NBTHelp.getIntSafe("gamepoint", item.func_77978_p(), -1) * 5;
            if (gamepoint > 0) {
                List2.add(EnumChatFormatting.AQUA + MMM.getTranslateText("manaItem.HP") + "+" + gamepoint);
                List2.add(EnumChatFormatting.AQUA + MMM.getTranslateText("manaItem.maxMana") + "+" + gamepoint);
            }
            if (!item.func_77978_p().func_150297_b("listID", 11)) {
                List2.add(MMM.getTranslateText("MagicItemTextile.unknown.use"));
            }
        }
        if ((flydata = NbtBaubles.hasFlyMagic(item)) > 0) {
            List2.add(EnumChatFormatting.AQUA + MMM.getTranslateText("manaItem.flydata") + "+" + flydata);
        }
    }

    @Override
    public List<IMagicEffect> getItemEffect(ItemStack item) {
        ArrayList<IMagicEffect> list = new ArrayList<IMagicEffect>();
        if (item.func_77942_o()) {
            int[] listID = NBTHelp.getIntArraySafe("listID", item.func_77978_p(), new int[0]);
            NBTTagList listEffect = NBTHelp.getNBTTagListSafe("listEffect", item.func_77978_p(), 5, new NBTTagList());
            for (int s = 0; s < listID.length; ++s) {
                IMagicEffect effect = new IMagicEffect(MagicItemType.values()[listID[s]], listEffect.func_150308_e(s));
                list.add(effect);
            }
            int gamepoint = NBTHelp.getIntSafe("gamepoint", item.func_77978_p(), -1);
            if (gamepoint > 0) {
                list.add(new IMagicEffect(MagicItemType.HP, gamepoint * 5));
                list.add(new IMagicEffect(MagicItemType.manaMax, gamepoint * 5));
            }
        }
        return list;
    }

    @Override
    public long getValue(ItemStack item) {
        return 100L;
    }

    @Override
    public Quality getQuality(ItemStack item) {
        return Quality.Epic;
    }
}

