/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.statistics;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.api.MoneySourceType;
import project.studio.manametalmod.api.StrengtheningStoneSourceType;
import project.studio.manametalmod.food_collection.FoodCollectionItem;

public class StatisticsData {
    public String playername;
    public long[] moneys = new long[MoneySourceType.values().length];
    public int[] stones = new int[StrengtheningStoneSourceType.values().length];

    public StatisticsData(String name) {
        this.playername = name;
    }

    public static final FoodCollectionItem get(ItemStack item) {
        String nameItem = Item.field_150901_e.func_148750_c((Object)item.func_77973_b());
        int metadata = item.func_77960_j();
        int size = ManaMetalAPI.FoodCollectionItemList.size();
        for (int s = 0; s < size; ++s) {
            FoodCollectionItem temp = ManaMetalAPI.FoodCollectionItemList.get(s);
            if (!temp.itemID.equals(nameItem) || temp.metadata != metadata) continue;
            return temp;
        }
        return null;
    }

    public static void saveToNBT(NBTTagCompound tag, StatisticsData temp) {
        int size1 = temp.moneys.length;
        for (int s = 0; s < size1; ++s) {
            tag.func_74772_a("LMS" + s, temp.moneys[s]);
        }
        int size2 = temp.stones.length;
        for (int s = 0; s < size2; ++s) {
            tag.func_74768_a("SST" + s, temp.stones[s]);
        }
    }

    public static StatisticsData readFromNBT(NBTTagCompound nbt, String name) {
        StatisticsData sd = new StatisticsData(name);
        sd.playername = name;
        int size = sd.moneys.length;
        for (int s = 0; s < size; ++s) {
            sd.moneys[s] = nbt.func_150297_b("LMS" + s, 4) ? nbt.func_74763_f("LMS" + s) : 0L;
        }
        int size2 = sd.stones.length;
        for (int s = 0; s < size2; ++s) {
            sd.stones[s] = nbt.func_150297_b("SST" + s, 3) ? nbt.func_74762_e("SST" + s) : 0;
        }
        return sd;
    }
}

