/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityTankMana
extends TileEntity
implements IFluidTank {
    protected FluidStack fluid = null;
    protected int capacity = 80000;
    protected TileEntity tile = this;
    protected boolean needsUpdate;

    public void func_145845_h() {
        if (this.needsUpdate) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.needsUpdate = false;
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            this.setFluid(fluid);
        } else {
            this.setFluid(null);
        }
        super.func_145839_a(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        if (this.fluid != null) {
            this.fluid.writeToNBT(nbt);
        } else {
            nbt.func_74778_a("Empty", "");
        }
        super.func_145841_b(nbt);
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
        this.needsUpdate = true;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        this.needsUpdate = true;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (this.fluid == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            this.needsUpdate = true;
            return Math.min(this.capacity - this.fluid.amount, resource.amount);
        }
        if (this.fluid == null) {
            this.fluid = new FluidStack(resource, Math.min(this.capacity, resource.amount));
            if (this.tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluid, this.tile.func_145831_w(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, (IFluidTank)this, this.fluid.amount));
            }
            this.needsUpdate = true;
            return this.fluid.amount;
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.amount;
        if (resource.amount < filled) {
            this.fluid.amount += resource.amount;
            filled = resource.amount;
        } else {
            this.fluid.amount = this.capacity;
        }
        if (this.tile != null) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluid, this.tile.func_145831_w(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, (IFluidTank)this, filled));
        }
        this.needsUpdate = true;
        return filled;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluid == null) {
            return null;
        }
        int drained = maxDrain;
        if (this.fluid.amount < drained) {
            drained = this.fluid.amount;
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (doDrain) {
            this.fluid.amount -= drained;
            if (this.fluid.amount <= 0) {
                this.fluid = null;
            }
            if (this.tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.fluid, this.tile.func_145831_w(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, (IFluidTank)this, drained));
            }
        }
        this.needsUpdate = true;
        return stack;
    }
}

