/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.watergame;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.watergame.TileEntityWaterGame;
import project.studio.manametalmod.watergame.WaterDirection;
import project.studio.manametalmod.watergame.WaterGameType;

public class BlockWaterGame
extends Block
implements ITileEntityProvider {
    WaterGameType id;

    public BlockWaterGame(WaterGameType id) {
        super(Material.field_151575_d);
        this.func_149663_c("BlockWaterGame." + (Object)((Object)id));
        this.func_149647_a(ManaMetalMod.tab_Machine);
        this.func_149711_c(-1.0f);
        this.func_149752_b(1.0E8f);
        this.func_149715_a(0.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149658_d(MMM.getMODID() + ":BlockWaterGame." + (Object)((Object)id));
        this.id = id;
    }

    public void func_149689_a(World worldIn, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (angle == 0) {
            worldIn.func_72921_c(x, y, z, 0, 2);
        }
        if (angle == 1) {
            worldIn.func_72921_c(x, y, z, 1, 2);
        }
        if (angle == 2) {
            worldIn.func_72921_c(x, y, z, 2, 2);
        }
        if (angle == 3) {
            worldIn.func_72921_c(x, y, z, 3, 2);
        }
        if (this.id == WaterGameType.rock) {
            return;
        }
        if (this.id == WaterGameType.Pillar) {
            if (!(worldIn.func_147439_a(x, y - 1, z) instanceof BlockWaterGame)) {
                MMM.breakBlock(worldIn, x, y, z, true);
            }
            return;
        }
        if (!this.canPush(worldIn, x, y, z)) {
            MMM.breakBlock(worldIn, x, y, z, true);
        }
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        super.func_149699_a(world, x, y, z, player);
        TileEntityWaterGame tile = (TileEntityWaterGame)world.func_147438_o(x, y, z);
        if (tile.canMove && !MMM.isPlayerCreativeMode(player)) {
            MMM.breakBlock(world, x, y, z, true);
        }
    }

    public boolean canPush(World world, int x, int y, int z) {
        if (!(world.func_147439_a(x, y - 1, z) instanceof BlockWaterGame)) {
            for (int dx = -3; dx < 4; ++dx) {
                for (int dz = -3; dz < 4; ++dz) {
                    for (int dy = -2; dy < 0; ++dy) {
                        if (!(world.func_147439_a(x + dx, y + dy, z + dz) instanceof BlockWaterGame)) continue;
                        TileEntityWaterGame tile = (TileEntityWaterGame)world.func_147438_o(x + dx, y + dy, z + dz);
                        if (tile.type != WaterGameType.Pillar) continue;
                        return true;
                    }
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public TileEntity func_149915_a(World World2, int id) {
        return new TileEntityWaterGame(this.id, WaterDirection.Dowm);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        if (!world.field_72995_K) {
            TileEntityWaterGame tile = (TileEntityWaterGame)world.func_147438_o(x, y, z);
            world.func_147453_f(x, y, z, (Block)this);
            if (MMM.isPlayerCreativeMode(player)) {
                tile.canMove = !tile.canMove;
                tile.update = false;
                return true;
            }
        }
        return false;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntityWaterGame tile = (TileEntityWaterGame)world.func_147438_o(x, y, z);
        if (tile.type == WaterGameType.end && tile.hasWater) {
            return 15;
        }
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 80097;
    }
}

