/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.world.ore;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.newmc.NewMinecraftCore;
import project.studio.manametalmod.produce.mine.MineCore;

public class OreSpawnMain
implements IWorldGenerator {
    public int EventSize = M3Config.OreSpawnSize;
    public int EventSpawn = M3Config.OreSpawnCount;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g != -1 && world.field_73011_w.field_76574_g != 1) {
            try {
                this.spawnOre(random, chunkX * 16, chunkZ * 16, world);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void spawnOreBase(Random random, int x, int z, World world) {
        int s;
        if (M3Config.LongTermMode && random.nextInt(10) == 0) {
            return;
        }
        if (M3Config.ForeverMode && random.nextInt(5) == 0) {
            return;
        }
        for (s = 0; s < 4; ++s) {
            this.addOreSpawn(ManaMetalAPI.orelist_overworld_main.get(random.nextInt(ManaMetalAPI.orelist_overworld_main.size())), world, random, x, z, 16, 16, 8 + random.nextInt(7 + this.EventSize), 8 + this.EventSpawn, 1, 128);
        }
        for (s = 0; s < 4; ++s) {
            this.addOreSpawn(ManaMetalAPI.orelist_overworld_general.get(random.nextInt(ManaMetalAPI.orelist_overworld_general.size())), world, random, x, z, 16, 16, 8 + random.nextInt(6 + this.EventSize), 12 + this.EventSpawn, 1, 128);
        }
        if (random.nextInt(3) == 0) {
            for (s = 0; s < 2; ++s) {
                this.addOreSpawn(ManaMetalAPI.orelist_overworld_legend.get(random.nextInt(ManaMetalAPI.orelist_overworld_legend.size())), world, random, x, z, 16, 16, 8 + random.nextInt(4 + this.EventSize), 4 + this.EventSpawn, 1, 32);
            }
        }
        if (random.nextInt(4) == 0) {
            this.addOreSpawn(ManaMetalAPI.orelist_overworld_gem.get(random.nextInt(ManaMetalAPI.orelist_overworld_gem.size())), world, random, x, z, 16, 16, 8 + random.nextInt(4 + this.EventSize), 4 + this.EventSpawn, 1, 32);
        }
        if (random.nextInt(200) == 0) {
            this.addOreSpawn(ManaMetalAPI.orelist_overworld_special.get(random.nextInt(ManaMetalAPI.orelist_overworld_special.size())), world, random, x, z, 16, 16, 20 + random.nextInt(30 + this.EventSize), 4 + this.EventSpawn, 1, 32);
        }
        if (random.nextInt(2000) == 0) {
            this.addOreSpawn(MineCore.BlockOreTreasures, random.nextInt(16), world, random, x, z, 16, 16, 4, 2, 1, 32);
        }
        if (M3Config.WorldGenPoorOre) {
            for (s = 0; s < 10; ++s) {
                this.addOreSpawn(ManaMetalAPI.orelist_overworld_poor.get(random.nextInt(ManaMetalAPI.orelist_overworld_poor.size())), world, random, x, z, 16, 16, 8 + random.nextInt(7 + this.EventSize), 8 + this.EventSpawn, 32, 128);
            }
        }
        if (M3Config.WorldGenStone) {
            for (s = 0; s < 2; ++s) {
                this.addOreSpawn(NewMinecraftCore.RockBlockNewMinecraft, 1, world, random, x, z, 16, 16, 20 + random.nextInt(20), 5, 1, 64);
                this.addOreSpawn(NewMinecraftCore.RockBlockNewMinecraft, 3, world, random, x, z, 16, 16, 20 + random.nextInt(20), 5, 1, 64);
                this.addOreSpawn(NewMinecraftCore.RockBlockNewMinecraft, 5, world, random, x, z, 16, 16, 20 + random.nextInt(20), 5, 1, 64);
                this.addOreSpawn(NewMinecraftCore.deepslate, 0, world, random, x, z, 16, 16, 20 + random.nextInt(20), 5, 1, 32);
                this.addOreSpawn(NewMinecraftCore.RockBlockNewMinecraft3_, 0, world, random, x, z, 16, 16, 20 + random.nextInt(20), 5, 1, 64);
            }
        }
    }

    public void spawnOreDispersion(Random random, int x, int z, World world) {
        switch (random.nextInt(10)) {
            case 0: 
            case 1: 
            case 2: {
                if (ManaMetalAPI.orelist_overworld_main.isEmpty()) break;
                this.addOreSpawn(ManaMetalAPI.orelist_overworld_main.get(random.nextInt(ManaMetalAPI.orelist_overworld_main.size())), world, random, x, z, 16, 16, 8 + random.nextInt(7 + this.EventSize), 8 + this.EventSpawn, 1, 128);
                break;
            }
            case 3: {
                if (ManaMetalAPI.orelist_overworld_general.isEmpty()) break;
                this.addOreSpawn(ManaMetalAPI.orelist_overworld_general.get(random.nextInt(ManaMetalAPI.orelist_overworld_general.size())), world, random, x, z, 16, 16, 8 + random.nextInt(6 + this.EventSize), 12 + this.EventSpawn, 1, 128);
                break;
            }
            case 4: {
                if (random.nextInt(3) != 0 || ManaMetalAPI.orelist_overworld_legend.isEmpty()) break;
                this.addOreSpawn(ManaMetalAPI.orelist_overworld_legend.get(random.nextInt(ManaMetalAPI.orelist_overworld_legend.size())), world, random, x, z, 16, 16, 8 + random.nextInt(4 + this.EventSize), 4 + this.EventSpawn, 1, 32);
                break;
            }
            case 5: {
                if (random.nextInt(4) != 0 || ManaMetalAPI.orelist_overworld_gem.isEmpty()) break;
                this.addOreSpawn(ManaMetalAPI.orelist_overworld_gem.get(random.nextInt(ManaMetalAPI.orelist_overworld_gem.size())), world, random, x, z, 16, 16, 8 + random.nextInt(4 + this.EventSize), 4 + this.EventSpawn, 1, 32);
                break;
            }
            case 6: {
                if (random.nextInt(200) == 0 && !ManaMetalAPI.orelist_overworld_special.isEmpty()) {
                    this.addOreSpawn(ManaMetalAPI.orelist_overworld_special.get(random.nextInt(ManaMetalAPI.orelist_overworld_special.size())), world, random, x, z, 16, 16, 20 + random.nextInt(30 + this.EventSize), 4 + this.EventSpawn, 1, 32);
                }
                if (random.nextInt(2000) != 0) break;
                this.addOreSpawn(MineCore.BlockOreTreasures, random.nextInt(16), world, random, x, z, 16, 16, 4, 4, 1, 32);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                if (!M3Config.WorldGenPoorOre || ManaMetalAPI.orelist_overworld_poor.isEmpty()) break;
                this.addOreSpawn(ManaMetalAPI.orelist_overworld_poor.get(random.nextInt(ManaMetalAPI.orelist_overworld_poor.size())), world, random, x, z, 16, 16, 8 + random.nextInt(7 + this.EventSize), 8 + this.EventSpawn, 32, 128);
            }
        }
        if (M3Config.WorldGenStone) {
            this.addOreSpawn(NewMinecraftCore.RockBlockNewMinecraft, 1, world, random, x, z, 16, 16, 20 + random.nextInt(20), 5, 1, 64);
            this.addOreSpawn(NewMinecraftCore.RockBlockNewMinecraft, 3, world, random, x, z, 16, 16, 20 + random.nextInt(20), 5, 1, 64);
            this.addOreSpawn(NewMinecraftCore.RockBlockNewMinecraft, 5, world, random, x, z, 16, 16, 20 + random.nextInt(20), 5, 1, 64);
            this.addOreSpawn(NewMinecraftCore.deepslate, 0, world, random, x, z, 16, 16, 20 + random.nextInt(20), 5, 1, 32);
            this.addOreSpawn(NewMinecraftCore.RockBlockNewMinecraft3_, 0, world, random, x, z, 16, 16, 20 + random.nextInt(20), 5, 1, 64);
        }
    }

    public void spawnOre(Random random, int x, int z, World world) {
        if (M3Config.UseDispersionOreSpawn) {
            for (int s = 0; s < 12; ++s) {
                this.spawnOreDispersion(random, x, z, world);
            }
        } else {
            this.spawnOreBase(random, x, z, world);
        }
    }

    public void addOreSpawn(Block block, World world, Random random, int x, int z, int maxX, int maxZ, int Size, int Spawn, int minY, int maxY) {
        int diffBtwnMinMaxY = maxY - minY;
        for (int i = 0; i < Spawn; ++i) {
            int Xpos = x + random.nextInt(maxX);
            int Ypos = minY + random.nextInt(diffBtwnMinMaxY);
            int Zpos = z + random.nextInt(maxZ);
            OreSpawnMain.generate(world, random, Xpos, Ypos, Zpos, Size, block, 0, Blocks.field_150348_b);
        }
    }

    public void addOreSpawn(Block block, int id, World world, Random random, int x, int z, int maxX, int maxZ, int Size, int Spawn, int minY, int maxY) {
        int diffBtwnMinMaxY = maxY - minY;
        for (int i = 0; i < Spawn; ++i) {
            int Xpos = x + random.nextInt(maxX);
            int Ypos = minY + random.nextInt(diffBtwnMinMaxY);
            int Zpos = z + random.nextInt(maxZ);
            OreSpawnMain.generate(world, random, Xpos, Ypos, Zpos, Size, block, id, Blocks.field_150348_b);
        }
    }

    public static boolean generate(World world, Random rand, int dx, int dy, int dz, int numberOfBlocks, Block ore, int data, Block stone) {
        float f = rand.nextFloat() * (float)Math.PI;
        double d0 = (float)(dx + 8) + MathHelper.func_76126_a((float)f) * (float)numberOfBlocks / 8.0f;
        double d1 = (float)(dx + 8) - MathHelper.func_76126_a((float)f) * (float)numberOfBlocks / 8.0f;
        double d2 = (float)(dz + 8) + MathHelper.func_76134_b((float)f) * (float)numberOfBlocks / 8.0f;
        double d3 = (float)(dz + 8) - MathHelper.func_76134_b((float)f) * (float)numberOfBlocks / 8.0f;
        double d4 = dy + rand.nextInt(3) - 2;
        double d5 = dy + rand.nextInt(3) - 2;
        for (int l = 0; l <= numberOfBlocks; ++l) {
            double d6 = d0 + (d1 - d0) * (double)l / (double)numberOfBlocks;
            double d7 = d4 + (d5 - d4) * (double)l / (double)numberOfBlocks;
            double d8 = d2 + (d3 - d2) * (double)l / (double)numberOfBlocks;
            double d9 = rand.nextDouble() * (double)numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)numberOfBlocks)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)numberOfBlocks)) + 1.0f) * d9 + 1.0;
            int i1 = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int l1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int i2 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int j2 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int k2 = i1; k2 <= l1; ++k2) {
                double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int l2 = j1; l2 <= i2; ++l2) {
                    double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int i3 = k1; i3 <= j2; ++i3) {
                        double d14 = ((double)i3 + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || !world.func_147439_a(k2, l2, i3).isReplaceableOreGen(world, k2, l2, i3, stone)) continue;
                        world.func_147465_d(k2, l2, i3, ore, data, 2);
                    }
                }
            }
        }
        return true;
    }

    public static boolean generate_data(World world, Random rand, int dx, int dy, int dz, int numberOfBlocks, Block ore, int data, Block stone, int stonemetadata) {
        float f = rand.nextFloat() * (float)Math.PI;
        double d0 = (float)(dx + 8) + MathHelper.func_76126_a((float)f) * (float)numberOfBlocks / 8.0f;
        double d1 = (float)(dx + 8) - MathHelper.func_76126_a((float)f) * (float)numberOfBlocks / 8.0f;
        double d2 = (float)(dz + 8) + MathHelper.func_76134_b((float)f) * (float)numberOfBlocks / 8.0f;
        double d3 = (float)(dz + 8) - MathHelper.func_76134_b((float)f) * (float)numberOfBlocks / 8.0f;
        double d4 = dy + rand.nextInt(3) - 2;
        double d5 = dy + rand.nextInt(3) - 2;
        for (int l = 0; l <= numberOfBlocks; ++l) {
            double d6 = d0 + (d1 - d0) * (double)l / (double)numberOfBlocks;
            double d7 = d4 + (d5 - d4) * (double)l / (double)numberOfBlocks;
            double d8 = d2 + (d3 - d2) * (double)l / (double)numberOfBlocks;
            double d9 = rand.nextDouble() * (double)numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)numberOfBlocks)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)numberOfBlocks)) + 1.0f) * d9 + 1.0;
            int i1 = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int l1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int i2 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int j2 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int k2 = i1; k2 <= l1; ++k2) {
                double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int l2 = j1; l2 <= i2; ++l2) {
                    double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int i3 = k1; i3 <= j2; ++i3) {
                        double d14 = ((double)i3 + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || world.func_147439_a(k2, l2, i3) != stone || world.func_72805_g(k2, l2, i3) != stonemetadata) continue;
                        world.func_147465_d(k2, l2, i3, ore, data, 2);
                    }
                }
            }
        }
        return true;
    }
}

