/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.Lapuda;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import project.studio.manametalmod.Lapuda.EntityBlossCrystal10;
import project.studio.manametalmod.Lapuda.EntityBlossCrystal13;
import project.studio.manametalmod.Lapuda.IAdvancedBoss;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.api.IDeadCountBoss;
import project.studio.manametalmod.api.IEntityData;
import project.studio.manametalmod.api.ILegendEntity;
import project.studio.manametalmod.api.ISynchronousEntity;
import project.studio.manametalmod.battle.AttackType;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.IJobAdvEntity;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.core.ProjectileHelp;
import project.studio.manametalmod.core.Vector3;
import project.studio.manametalmod.decoration.Decoration;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.fx.EntityPlayerAttackFX;
import project.studio.manametalmod.instance_dungeon.IDungeonBoss;
import project.studio.manametalmod.instance_dungeon.IDungeonDifficult;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonType;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.magic.EntityLightningBoltPower;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.mob.Entity3DThrowable;
import project.studio.manametalmod.mob.EntityAbsorbCrystal;
import project.studio.manametalmod.mob.EntityArrowBase;
import project.studio.manametalmod.mob.EntityBlossDoomsMeteoriteUltimate;
import project.studio.manametalmod.mob.EntityBlossRune;
import project.studio.manametalmod.mob.EntityMagicBallGravity;
import project.studio.manametalmod.mob.EntityMagicBallNew;
import project.studio.manametalmod.mob.EntityMagicObject;
import project.studio.manametalmod.mob.EntityMobAntiMagic;
import project.studio.manametalmod.mob.EntityRoseBomb;
import project.studio.manametalmod.mob.EntityRoseEye;
import project.studio.manametalmod.mob.EntityRosePoisonCrystal;
import project.studio.manametalmod.mob.EntitySmokeCrystal;
import project.studio.manametalmod.network.MessageFX;
import project.studio.manametalmod.network.PacketHandlerMana;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;
import project.studio.manametalmod.spell.EntitySkill2DObjFX;
import project.studio.manametalmod.spell.SpellType;
import project.studio.manametalmod.tileentity.TileEntityFloatingPlatform;

public class BossAstrid
extends EntityMobAntiMagic
implements IAdvancedBoss,
IBossDisplayData,
IEntityAdditionalSpawnData,
IEntityData,
IDungeonBoss,
IJobAdvEntity,
ILegendEntity,
IDeadCountBoss,
IRangedAttackMob,
ISynchronousEntity {
    public static final float[] shield = new float[]{0.3f, 0.3f};
    public EntityAIArrowAttack aiArrowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 40, 20.0f);
    public EntityAIAttackOnCollide aiAttackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.3, false);
    public IDungeonDifficult Difficult = IDungeonDifficult.EASY;
    public long mobuuid = -1L;
    public int deadCount = 0;
    public int stage = 0;
    public int music = 0;
    public int time = 0;
    public Pos spawnPointPos = new Pos();
    public int superBalls = 0;
    public boolean setPos = false;
    public int field_70729_aU = 0;
    public int gravityBall = 0;
    public int slowBall = 0;
    public int lightattack = 0;
    public int summonTower = 0;
    public EntityLivingBase useUltimateLightningTarget = null;
    public int combatMax = 50;
    public int combat = 50;
    public AstridStyle style = AstridStyle.Melee;
    public int styleCount = 0;
    public int styleTime = 0;
    public int styleAttack = 0;
    public float lastHP = 0.0f;
    public boolean fail = false;
    public int arrowstorm = 0;
    public int bigarrow = 200;
    public int spawnHammer = 300;
    public int timeAreaAoe;
    public int areaAoeType = 0;
    public int spawnEye = 0;
    public int spawnEyeMax = 4200;
    public boolean canChangeStyle = true;
    public boolean canDarkAoe = true;
    public int timeDarkArea = 3000;
    public int spawnFloatingPlatformTime = 2000;
    public int redShield = 0;
    public int rosePoison = 0;
    public int timeRoseBomb;
    public int timeUltimateLightning = 0;
    public boolean useUltimateLightning = false;
    public int timeUltimateLightningAttack = 0;
    public boolean isBigSkill = false;
    public boolean isBigSkillOver = false;
    public int bigSkillTime = 0;
    public int crossBowHitCount = 0;
    public int failTime = 0;
    public int mechanismSkillType;
    public int noAttackTime;
    public int timeDarkBarrierCD = 0;
    public int isDarkBarrier = 0;
    public int timeLifeCrystal = 0;
    public int speedBuff = 0;
    public int timeFireShuriken = 0;
    public int timeReplenishAmmunition;
    public List<Pos> spearList;
    public List<Pos> cannonballList;

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.styleCount);
        buffer.writeInt(this.combat);
        buffer.writeInt(this.style.ordinal());
        buffer.writeInt(this.rosePoison);
        buffer.writeInt(this.combatMax);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.styleCount = additionalData.readInt();
        this.combat = additionalData.readInt();
        this.style = AstridStyle.values()[additionalData.readInt()];
        this.rosePoison = additionalData.readInt();
        this.combatMax = additionalData.readInt();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.spawnPointPos.saveToNBT(nbt);
        nbt.func_74768_a("deadCount", this.deadCount);
        nbt.func_74768_a("stage", this.stage);
        nbt.func_74768_a("gravityBall", this.gravityBall);
        nbt.func_74768_a("slowBall", this.slowBall);
        nbt.func_74768_a("summonTower", this.summonTower);
        nbt.func_74768_a("lightattack", this.lightattack);
        nbt.func_74768_a("superBalls", this.superBalls);
        nbt.func_74772_a("mobuuid", this.mobuuid);
        nbt.func_74768_a("Difficult", this.Difficult.ordinal());
        nbt.func_74757_a("setPos", this.setPos);
        nbt.func_74768_a("combat", this.combat);
        nbt.func_74768_a("style", this.style.ordinal());
        nbt.func_74768_a("styleCount", this.styleCount);
        nbt.func_74768_a("styleTime", this.styleTime);
        nbt.func_74768_a("styleAttack", this.styleAttack);
        nbt.func_74757_a("fail", this.fail);
        nbt.func_74768_a("arrowstorm", this.arrowstorm);
        nbt.func_74768_a("bigarrow", this.bigarrow);
        nbt.func_74768_a("spawnHammer", this.spawnHammer);
        nbt.func_74768_a("timeAreaAoe", this.timeAreaAoe);
        nbt.func_74768_a("areaAoeType", this.areaAoeType);
        nbt.func_74768_a("spawnEye", this.spawnEye);
        nbt.func_74768_a("spawnEyeMax", this.spawnEyeMax);
        nbt.func_74757_a("canChangeStyle", this.canChangeStyle);
        nbt.func_74757_a("canDarkAoe", this.canDarkAoe);
        nbt.func_74768_a("timeDarkArea", this.timeDarkArea);
        nbt.func_74768_a("spawnFloatingPlatformTime", this.spawnFloatingPlatformTime);
        nbt.func_74768_a("redShield", this.redShield);
        nbt.func_74768_a("rosePoison", this.rosePoison);
        nbt.func_74768_a("timeRoseBomb", this.timeRoseBomb);
        nbt.func_74768_a("timeUltimateLightning", this.timeUltimateLightning);
        nbt.func_74757_a("useUltimateLightning", this.useUltimateLightning);
        nbt.func_74768_a("timeUltimateLightningAttack", this.timeUltimateLightningAttack);
        nbt.func_74757_a("isBigSkill", this.isBigSkill);
        nbt.func_74757_a("isBigSkillOver", this.isBigSkillOver);
        nbt.func_74768_a("bigSkillTime", this.bigSkillTime);
        nbt.func_74768_a("crossBowHitCount", this.crossBowHitCount);
        nbt.func_74768_a("failTime", this.failTime);
        nbt.func_74768_a("mechanismSkillType", this.mechanismSkillType);
        nbt.func_74768_a("noAttackTime", this.noAttackTime);
        nbt.func_74768_a("timeDarkBarrier", this.timeDarkBarrierCD);
        nbt.func_74768_a("isDarkBarrier", this.isDarkBarrier);
        nbt.func_74768_a("timeLifeCrystal", this.timeLifeCrystal);
        nbt.func_74768_a("speedBuff", this.speedBuff);
        nbt.func_74768_a("timeFireShuriken", this.timeFireShuriken);
        nbt.func_74768_a("timeReplenishAmmunition", this.timeReplenishAmmunition);
        nbt.func_74768_a("combatMax", this.combatMax);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.spawnPointPos.readFromNBT(nbt);
        this.deadCount = NBTHelp.getIntSafe("deadCount", nbt, 0);
        this.stage = NBTHelp.getIntSafe("stage", nbt, 0);
        this.gravityBall = NBTHelp.getIntSafe("gravityBall", nbt, 0);
        this.slowBall = NBTHelp.getIntSafe("slowBall", nbt, 0);
        this.summonTower = NBTHelp.getIntSafe("summonTower", nbt, 0);
        this.lightattack = NBTHelp.getIntSafe("lightattack", nbt, 0);
        this.superBalls = NBTHelp.getIntSafe("superBalls", nbt, 0);
        this.mobuuid = NBTHelp.getLongSafe("mobuuid", nbt, -1L);
        this.Difficult = IDungeonDifficult.values()[NBTHelp.getIntSafe("Difficult", nbt, 0)];
        this.setPos = NBTHelp.getBooleanSafe("setPos", nbt, false);
        this.combat = NBTHelp.getIntSafe("combat", nbt, 50);
        this.style = AstridStyle.values()[NBTHelp.getIntSafe("style", nbt, 0)];
        this.styleCount = NBTHelp.getIntSafe("styleCount", nbt, 0);
        this.styleTime = NBTHelp.getIntSafe("styleTime", nbt, 0);
        this.styleAttack = NBTHelp.getIntSafe("styleAttack", nbt, 0);
        this.fail = NBTHelp.getBooleanSafe("fail", nbt, false);
        this.arrowstorm = NBTHelp.getIntSafe("arrowstorm", nbt, 0);
        this.bigarrow = NBTHelp.getIntSafe("bigarrow", nbt, 200);
        this.spawnHammer = NBTHelp.getIntSafe("spawnHammer", nbt, 300);
        this.timeAreaAoe = NBTHelp.getIntSafe("timeAreaAoe", nbt, 0);
        this.areaAoeType = NBTHelp.getIntSafe("areaAoeType", nbt, 0);
        this.spawnEye = NBTHelp.getIntSafe("spawnEye", nbt, 0);
        this.spawnEyeMax = NBTHelp.getIntSafe("spawnEyeMax", nbt, 4200);
        this.canChangeStyle = NBTHelp.getBooleanSafe("canChangeStyle", nbt, true);
        this.canDarkAoe = NBTHelp.getBooleanSafe("canDarkAoe", nbt, true);
        this.timeDarkArea = NBTHelp.getIntSafe("timeDarkArea", nbt, 0);
        this.spawnFloatingPlatformTime = NBTHelp.getIntSafe("spawnFloatingPlatformTime", nbt, 2000);
        this.redShield = NBTHelp.getIntSafe("redShield", nbt, 0);
        this.rosePoison = NBTHelp.getIntSafe("rosePoison", nbt, 0);
        this.timeRoseBomb = NBTHelp.getIntSafe("timeRoseBomb", nbt, 0);
        this.timeUltimateLightning = NBTHelp.getIntSafe("timeUltimateLightning", nbt, 0);
        this.useUltimateLightning = NBTHelp.getBooleanSafe("useUltimateLightning", nbt, false);
        this.timeUltimateLightningAttack = NBTHelp.getIntSafe("timeUltimateLightningAttack", nbt, 0);
        this.isBigSkill = NBTHelp.getBooleanSafe("isBigSkill", nbt, false);
        this.isBigSkillOver = NBTHelp.getBooleanSafe("isBigSkillOver", nbt, false);
        this.bigSkillTime = NBTHelp.getIntSafe("bigSkillTime", nbt, 0);
        this.crossBowHitCount = NBTHelp.getIntSafe("crossBowHitCount", nbt, 0);
        this.failTime = NBTHelp.getIntSafe("failTime", nbt, 0);
        this.mechanismSkillType = NBTHelp.getIntSafe("mechanismSkillType", nbt, 0);
        this.noAttackTime = NBTHelp.getIntSafe("noAttackTime", nbt, 0);
        this.timeDarkBarrierCD = NBTHelp.getIntSafe("timeDarkBarrier", nbt, 0);
        this.isDarkBarrier = NBTHelp.getIntSafe("isDarkBarrier", nbt, 0);
        this.timeLifeCrystal = NBTHelp.getIntSafe("timeLifeCrystal", nbt, 0);
        this.speedBuff = NBTHelp.getIntSafe("speedBuff", nbt, 0);
        this.timeFireShuriken = NBTHelp.getIntSafe("timeFireShuriken", nbt, 0);
        this.timeReplenishAmmunition = NBTHelp.getIntSafe("timeReplenishAmmunition", nbt, 0);
        this.combatMax = NBTHelp.getIntSafe("combatMax", nbt, 100);
    }

    public BossAstrid(World world) {
        super(world);
        this.func_70105_a(1.9f, 3.5f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70178_ae = true;
        this.func_110163_bv();
        this.setAttributes();
        this.func_70105_a(1.1f, 2.5f);
        if (world != null && !world.field_72995_K) {
            this.setCombatTask();
        }
    }

    public void setAttributes() {
        double HPMAX = 2.5E9;
        switch (this.Difficult) {
            case EASY: {
                HPMAX = 1.25E9;
                break;
            }
            case NORMAL: {
                HPMAX = 2.5E9;
                break;
            }
            case HARD: {
                HPMAX = 7.500000256E9;
                break;
            }
            case HELL: {
                HPMAX = 2.2499999744E10;
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(HPMAX);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(3000 * this.Difficult.getDiffcultAttackmultiplier()));
        this.func_70606_j(this.func_110138_aP());
        if (!this.field_70170_p.field_72995_K) {
            int playercount = MMM.findPlayersNoCreate((Entity)this, 128.0f).size();
            if (playercount > 10) {
                playercount = 10;
            }
            this.combatMax += playercount * 25;
            this.setCombatMax(this.combatMax);
            this.combat = (int)((float)this.combatMax * 0.5f + 1.0f);
            this.setCombat(this.combat);
            this.synchronousLivingTag((EntityLiving)this, 128.0f);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
    }

    public void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        if (this.style == AstridStyle.Melee) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    public byte getCombatMax() {
        return this.field_70180_af.func_75683_a(22);
    }

    public void setCombatMax(int combat) {
        this.field_70180_af.func_75692_b(22, (Object)((byte)combat));
    }

    public boolean getRedShield() {
        return (this.field_70180_af.func_75683_a(21) & 1) != 0;
    }

    public void setRedShield(boolean data) {
        if (data) {
            this.field_70180_af.func_75692_b(21, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(21, (Object)0);
        }
    }

    public byte getCombat() {
        return this.field_70180_af.func_75683_a(20);
    }

    public void setCombat(int combat) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)combat));
    }

    public AstridStyle getAstridStyle() {
        return AstridStyle.values()[this.field_70180_af.func_75683_a(18)];
    }

    public void setAstridStyle(AstridStyle data) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)data.ordinal()));
    }

    public byte getStyleCount() {
        return this.field_70180_af.func_75683_a(19);
    }

    public void setStyleCount(int time) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)time));
    }

    @Override
    public void setIDungeonDifficult(IDungeonDifficult diff) {
        this.Difficult = diff;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void setType(int type) {
    }

    protected void func_70623_bb() {
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public float getAttackMultiplier() {
        float damage = 1.0f;
        if ((float)this.combat > (float)this.combatMax * 0.7f) {
            damage += 0.02f * (float)(this.combat - 70);
        }
        switch (this.Difficult) {
            case EASY: {
                return damage + 0.03f * (float)this.styleAttack;
            }
            case NORMAL: {
                return damage + 0.05f * (float)this.styleAttack;
            }
            case HARD: {
                return damage + 0.07f * (float)this.styleAttack;
            }
            case HELL: {
                return damage + 0.09f * (float)this.styleAttack;
            }
        }
        return damage += (float)this.Difficult.ordinal() * 3.0f;
    }

    public int attack(int attack) {
        return (int)((float)attack * this.getAttackMultiplier());
    }

    public void reduceStyleAttack() {
        switch (this.Difficult) {
            case EASY: {
                this.styleAttack = (int)((float)this.styleAttack * 0.3f);
                break;
            }
            case NORMAL: {
                this.styleAttack = (int)((float)this.styleAttack * 0.4f);
                break;
            }
            case HARD: {
                this.styleAttack = (int)((float)this.styleAttack * 0.5f);
                break;
            }
            case HELL: {
                this.styleAttack = (int)((float)this.styleAttack * 0.6f);
            }
        }
    }

    public void changeStyle() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.time % 20 == 0) {
                ++this.styleAttack;
            }
            float combatdata = this.combat / this.combatMax;
            int tick = 90 - 60 * this.combat / this.combatMax;
            if (combatdata < 0.0f) {
                tick = 90;
            }
            ++this.styleTime;
            if (this.styleTime > tick) {
                this.styleTime = 0;
                ++this.styleCount;
                this.setStyleCount(this.styleCount);
                if (this.styleCount == 30) {
                    this.style = AstridStyle.Range;
                    this.setAstridStyle(this.style);
                    this.reduceStyleAttack();
                    this.setCombatTask();
                    this.mechanismSkillType = 1;
                    this.initMechanismSkill();
                } else if (this.styleCount == 60) {
                    this.style = AstridStyle.Magic;
                    this.setAstridStyle(this.style);
                    this.reduceStyleAttack();
                    this.setCombatTask();
                    this.mechanismSkillType = 2;
                    this.initMechanismSkill();
                } else if (this.styleCount > 90) {
                    this.styleCount = 0;
                    this.style = AstridStyle.Melee;
                    this.setAstridStyle(this.style);
                    this.reduceStyleAttack();
                    this.setCombatTask();
                    this.mechanismSkillType = 3;
                    this.initMechanismSkill();
                }
            }
        }
    }

    public void changeCombat() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.combat <= 0) {
                this.fail = true;
                return;
            }
            if (this.time % 100 == 0) {
                int playercount = MMM.findPlayersNoCreate((Entity)this, 128.0f).size();
                float finalcombat = 0.0f;
                switch (this.Difficult) {
                    case EASY: {
                        finalcombat += 5.0f;
                        break;
                    }
                    case NORMAL: {
                        finalcombat += 4.0f;
                        break;
                    }
                    case HARD: {
                        finalcombat += 3.0f;
                        break;
                    }
                    case HELL: {
                        finalcombat += 2.0f;
                    }
                }
                this.combat = (int)((float)this.combat + (finalcombat *= 0.5f + 0.5f * (float)playercount));
                float hptemp1 = this.func_110138_aP() * 0.01f;
                if (this.lastHP - this.func_110143_aJ() > hptemp1) {
                    ++this.combat;
                }
                this.lastHP = this.func_110143_aJ();
                if (this.combat > this.combatMax) {
                    this.combat = this.combatMax;
                }
                this.setCombat(this.combat);
            }
            if (this.time % 20 == 0) {
                this.setCombat(this.combat);
                this.setStyleCount(this.styleCount);
                this.setAstridStyle(this.style);
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity target) {
        if (this.mechanismSkillType == 3 || this.canChangeStyle) {
            if (super.func_70652_k(target)) {
                if (target instanceof EntityLivingBase) {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 100, this.Difficult.ordinal() > 1 ? 1 : 0));
                }
                this.func_71038_i();
                int id = this.field_70170_p.field_73012_v.nextInt(3);
                EntityPlayerAttackFX fx = new EntityPlayerAttackFX(this.field_70170_p, 10, 0, id);
                fx.func_70080_a(this.field_70165_t, this.field_70163_u + (double)1.4f, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                if (!this.field_70170_p.field_72995_K) {
                    MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":sword" + id, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 1.0, 2.0);
                    this.field_70170_p.func_72838_d((Entity)fx);
                }
                float knockback = 1.0f;
                if ((knockback += 0.1f * (float)this.Difficult.ordinal()) > 0.0f) {
                    target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f));
                    this.field_70159_w *= 0.6;
                    this.field_70179_y *= 0.6;
                }
                this.speedBuff = 0;
                return true;
            }
            return false;
        }
        return false;
    }

    public void addEffect() {
        List<EntityPlayer> list;
        if (this.time % 50 == 0 && !(list = MMM.findPlayers((Entity)this, 64)).isEmpty()) {
            for (int s = 0; s < list.size(); ++s) {
                PotionEffectM3.addPotion((EntityLivingBase)list.get(s), PotionM3.potionPressure, 5, this.stage + 2);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextInt(20) == 0 && this.getRedShield() && !this.func_70644_a(Potion.field_76441_p)) {
            Vector3 vec = Vector3.fromEntityCenter((Entity)this);
            Vector3 endVec = vec.copy().add(this.findRandomXZ(), this.field_70170_p.field_73012_v.nextInt(4) - this.field_70170_p.field_73012_v.nextInt(4), this.findRandomXZ());
            ManaMetalMod.proxy.dolightningFX(this.field_70170_p, vec, endVec, 2.0f, 0xA01000, 0xFFFFFF, 0.06f);
        }
        ++this.music;
        if (this.music > 4050) {
            this.music = 0;
            this.field_70170_p.func_72956_a((Entity)this, MMM.getMODID() + ":event.boss30", 10.0f, 1.0f);
        }
        if (!this.setPos) {
            this.setPos = true;
            this.setPos();
            this.setAttributes();
        }
        ++this.time;
        if (this.time % 20 == 0 && this.noAttackTime > 0) {
            --this.noAttackTime;
            this.canChangeStyle = false;
        }
        if (!this.field_70170_p.field_72995_K && this.fail) {
            ++this.failTime;
            if (this.failTime == 40) {
                PotionEffectM3.addPotion((EntityLivingBase)this, PotionM3.potionInvincible, 999999, 1);
                this.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 999999, 0));
                MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.fail.0");
                MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.fail.1");
                MMM.teleport((Entity)this, this.spawnPointPos);
                this.deadKillObject();
                ManaMetalModRoot root = MMM.getEntityNBT((EntityLivingBase)this);
                if (root != null && root.ManaEntityData != null && root.ManaEntityData.getBossReward() != null) {
                    root.ManaEntityData.getBossReward().clear();
                }
                this.func_70606_j(this.func_110138_aP());
                List<EntityPlayer> list = MMM.findPlayersNoCreate((Entity)this, 64.0f);
                for (int s = 0; s < list.size(); ++s) {
                    EntityPlayer temp = list.get(s);
                    if (!(temp.field_70163_u > (double)(this.spawnPointPos.Y - 4))) continue;
                    temp.func_70097_a(AttackType.AbsoluteDamage, temp.func_110138_aP() * 2.0f);
                }
            }
            if (this.failTime == 120) {
                this.field_70163_u = -100.0;
                this.func_70106_y();
                return;
            }
        }
        if (this.field_70128_L || this.fail || this.noAttackTime > 0) {
            return;
        }
        if (this.mechanismSkillType <= 0) {
            this.changeCombat();
        }
        this.changeTarget();
        this.canChangeStyle = true;
        if (this.time % 20 == 0) {
            if (this.redShield > 0) {
                --this.redShield;
                if (this.redShield <= 0) {
                    this.setRedShield(true);
                }
            }
            if (this.rosePoison > 0) {
                --this.rosePoison;
            }
        }
        this.addEffect();
        if (this.stage > 0 && this.time % 20 == 0) {
            this.func_70691_i(this.stage * 1000);
        }
        if (this.isDarkBarrier > 0) {
            --this.isDarkBarrier;
            if (this.time % 20 == 0) {
                this.attackBarrier(this.isBigSkill && !this.isBigSkillOver, 0.1f);
            }
        }
        this.replenishAmmunition();
        if (this.roseHell()) {
            return;
        }
        if (this.mechanismSkillType > 0) {
            this.canChangeStyle = false;
            this.doMechanismSkill();
            return;
        }
        if (this.stage == 0) {
            this.spawnEye();
            this.spawnFloatingPlatform();
            this.spawnRoseBomb();
            this.darkBarrier();
            this.spawnLifeCrystal();
        }
        if (this.stage == 1 && this.doPotionGrassAOE()) {
            this.spawnEye();
            this.spawnFloatingPlatform();
            this.spawnRoseBomb();
            this.darkBarrier();
            this.spawnLifeCrystal();
        }
        if (this.stage >= 2 && this.ultimateLightning() && this.darkArea() && this.doPotionGrassAOE()) {
            this.spawnEye();
            this.spawnFloatingPlatform();
            this.spawnRoseBomb();
            this.darkBarrier();
            this.spawnLifeCrystal();
        }
        if (this.canChangeStyle) {
            this.changeStyle();
            switch (this.style) {
                case Magic: {
                    this.fireBallAttackgravity(22);
                    this.spawnBloodTower();
                    break;
                }
                case Melee: {
                    this.speedBuff();
                    this.spawnHammer();
                    this.fireShuriken();
                    break;
                }
                case Range: {
                    this.doArrowstorm();
                    this.doBigArrow();
                }
            }
        }
    }

    public void fireShuriken() {
        if (!this.field_70170_p.field_72995_K) {
            ++this.timeFireShuriken;
            if (this.timeFireShuriken > 1200) {
                this.timeFireShuriken = 0;
                int swordtime = 800;
                EntityMagicObject obj = new EntityMagicObject(this.field_70170_p, swordtime, 71, this.attack(10000), this.func_70638_az());
                obj.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)obj);
            }
        }
    }

    public void replenishAmmunition() {
        if (!this.field_70170_p.field_72995_K) {
            ++this.timeReplenishAmmunition;
            if (this.timeReplenishAmmunition > 500) {
                int metadata;
                this.timeReplenishAmmunition = 0;
                if (this.spearList == null || this.cannonballList == null) {
                    this.spearList = new ArrayList<Pos>();
                    this.cannonballList = new ArrayList<Pos>();
                    int x = this.spawnPointPos.X;
                    int y = this.spawnPointPos.Y - 2;
                    int z = this.spawnPointPos.Z;
                    for (int dx = -24; dx < 25; ++dx) {
                        for (int dz = -24; dz < 25; ++dz) {
                            for (int dy = 0; dy < 4; ++dy) {
                                Block block = this.field_70170_p.func_147439_a(x + dx, y + dy, z + dz);
                                if (block == Decoration.BlockDungeonRotate36 || block == Decoration.BlockDungeonRotate38) {
                                    this.spearList.add(new Pos(x + dx, y + dy, z + dz));
                                    continue;
                                }
                                if (block != Decoration.BlockDungeonRotate37 && block != Decoration.BlockDungeonRotate39) continue;
                                this.cannonballList.add(new Pos(x + dx, y + dy, z + dz));
                            }
                        }
                    }
                }
                if (this.spearList != null) {
                    Pos pos = MMM.getRandomItemFromList(this.spearList);
                    metadata = this.field_70170_p.func_72805_g(pos.X, pos.Y, pos.Z);
                    this.field_70170_p.func_147465_d(pos.X, pos.Y, pos.Z, Decoration.BlockDungeonRotate36, metadata, 2);
                }
                if (this.cannonballList != null) {
                    Pos pos = MMM.getRandomItemFromList(this.cannonballList);
                    metadata = this.field_70170_p.func_72805_g(pos.X, pos.Y, pos.Z);
                    this.field_70170_p.func_147465_d(pos.X, pos.Y, pos.Z, Decoration.BlockDungeonRotate37, metadata, 2);
                }
            }
        }
    }

    public void speedBuff() {
        ++this.speedBuff;
        if (this.speedBuff > 240) {
            this.speedBuff = 0;
            this.func_70690_d(new PotionEffect(Potion.field_76424_c.func_76396_c(), 120, 1));
        }
    }

    public void spawnLifeCrystal() {
        ++this.timeLifeCrystal;
        if (this.timeLifeCrystal > 3000) {
            this.timeLifeCrystal = 0;
            List<Entity> list = MMM.findEntity((Entity)this, 100);
            if (!list.isEmpty()) {
                for (int s = 0; s < list.size(); ++s) {
                    if (!(list.get(s) instanceof EntityBlossCrystal13)) continue;
                    return;
                }
            }
            EntityBlossCrystal13 temp = new EntityBlossCrystal13(this.field_70170_p);
            int x = 10 - this.field_70170_p.field_73012_v.nextInt(21);
            int z = 10 - this.field_70170_p.field_73012_v.nextInt(21);
            temp.func_70080_a(this.spawnPointPos.X + x, this.spawnPointPos.Y, this.spawnPointPos.Z + z, 0.0f, 0.0f);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)temp);
            }
        }
    }

    public void darkBarrier() {
        ++this.timeDarkBarrierCD;
        if (this.timeDarkBarrierCD == 3900) {
            MMM.teleport((Entity)this, this.spawnPointPos);
            if (!this.field_70170_p.field_72995_K) {
                MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.darkBarrier.1");
            }
        }
        if (this.timeDarkBarrierCD > 4000) {
            this.timeDarkBarrierCD = 0;
            this.spawnDarkBarrier();
        }
        if (this.timeDarkBarrierCD < 3900) {
            if (this.time % 20 == 0) {
                List<EntityPlayer> list = MMM.findPlayersNoCreate((Entity)this, 100.0f);
                for (int s = 0; s < list.size(); ++s) {
                    int rage;
                    EntityPlayer temp = list.get(s);
                    if (!(temp.field_70163_u > (double)(this.spawnPointPos.Y - 7)) || (rage = MMM.getBlockDistance(temp.field_70165_t, temp.field_70163_u, temp.field_70161_v, (double)this.spawnPointPos.X, (double)this.spawnPointPos.Y, (double)this.spawnPointPos.Z)) <= 22 && !(temp.field_70163_u <= (double)(this.spawnPointPos.Y - 2))) continue;
                    this.timeDarkBarrierCD += 40;
                }
            }
            if (this.timeDarkBarrierCD > 3999) {
                this.timeDarkBarrierCD = 3999;
            }
        }
    }

    public void spawnDarkBarrier() {
        EntityMagicObject obj = new EntityMagicObject(this.field_70170_p, 1370, 70, 0.0f, (EntityLivingBase)this);
        obj.func_70080_a((float)this.spawnPointPos.X + 0.5f, (float)this.spawnPointPos.Y + 0.8f, (float)this.spawnPointPos.Z + 0.5f, 0.0f, 0.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)obj);
            this.isDarkBarrier = 1370;
        }
    }

    public void attackBarrier(boolean tp, float damage) {
        if (this.time % 20 == 0) {
            List<EntityPlayer> list = MMM.findPlayersNoCreate((Entity)this, 64.0f);
            block6: for (int s = 0; s < list.size(); ++s) {
                int rage;
                EntityPlayer temp = list.get(s);
                if (!(temp.field_70163_u > (double)(this.spawnPointPos.Y - 7)) || (rage = MMM.getBlockDistance(temp.field_70165_t, temp.field_70163_u, temp.field_70161_v, (double)this.spawnPointPos.X, (double)this.spawnPointPos.Y, (double)this.spawnPointPos.Z)) <= 22 && !(temp.field_70163_u <= (double)(this.spawnPointPos.Y - 2))) continue;
                temp.func_70097_a(AttackType.ChaosDamage, temp.func_110138_aP() * damage);
                if (!tp) continue;
                switch (this.field_70170_p.field_73012_v.nextInt(3)) {
                    case 0: {
                        MMM.teleport(temp, this.spawnPointPos.X + 7, this.spawnPointPos.Y + 1, this.spawnPointPos.Z);
                        continue block6;
                    }
                    case 1: {
                        MMM.teleport(temp, this.spawnPointPos.X - 7, this.spawnPointPos.Y + 1, this.spawnPointPos.Z);
                        continue block6;
                    }
                    case 2: {
                        MMM.teleport(temp, this.spawnPointPos.X, this.spawnPointPos.Y + 1, this.spawnPointPos.Z + 7);
                        continue block6;
                    }
                    case 3: {
                        MMM.teleport(temp, this.spawnPointPos.X, this.spawnPointPos.Y + 1, this.spawnPointPos.Z - 7);
                    }
                }
            }
        }
    }

    public void clearBarrier() {
        List<Entity> list = MMM.findEntity((Entity)this, 125);
        if (!list.isEmpty()) {
            for (int s = 0; s < list.size(); ++s) {
                if (!(list.get(s) instanceof EntityMagicObject)) continue;
                EntityMagicObject obj = (EntityMagicObject)list.get(s);
                if (obj.type != 70) continue;
                obj.func_70106_y();
            }
        }
        this.isDarkBarrier = 0;
    }

    public boolean roseHell() {
        if (!this.field_70170_p.field_72995_K && this.isBigSkill && !this.isBigSkillOver) {
            ++this.bigSkillTime;
            this.canChangeStyle = false;
            if (this.bigSkillTime == 1) {
                MMM.teleport((Entity)this, this.spawnPointPos);
                this.disableMechanismSkill();
                this.noAttackTime = 0;
                this.mechanismSkillType = 0;
                PotionEffectM3.addPotion((EntityLivingBase)this, PotionM3.potionInvincible, 999999, 1);
                this.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 999999, 5));
                MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.roseHell.0");
            }
            if (this.bigSkillTime == 3) {
                this.spawnRuneFXServerSound((EntityLivingBase)this, ManaElements.Dark, 200, 4.0f, true, 64);
            }
            if (this.bigSkillTime == 95) {
                PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(9, 0.0f, 0.0f, 0.0f, 0, 0, 0), new NetworkRegistry.TargetPoint(MMM.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
            }
            if (this.bigSkillTime > 20 && this.bigSkillTime < 80 && this.bigSkillTime % 13 == 0) {
                this.arcLightning_vanilla(this.field_70170_p, this.spawnPointPos.add(this.field_70170_p.field_73012_v.nextInt(11) - 5, 0, this.field_70170_p.field_73012_v.nextInt(11) - 5), 1.0f, 0.0f, 30.0f, 255.0f);
            }
            if (this.bigSkillTime == 30) {
                this.clearBarrier();
                this.spawnDarkBarrier();
            }
            if (this.bigSkillTime > 100) {
                int sp;
                int s;
                List<EntityPlayer> list;
                if (this.bigSkillTime < 200 && this.bigSkillTime % 2 == 0) {
                    list = MMM.findPlayersNoCreate((Entity)this, 20.0f);
                    for (s = 0; s < list.size(); ++s) {
                        EntityPlayer temp = list.get(s);
                        if (!(temp.field_70163_u > (double)(this.spawnPointPos.Y - 4))) continue;
                        this.arcLightning_vanilla(this.field_70170_p, new Pos((Entity)temp), this.attack(4000), 0.0f, 30.0f, 255.0f);
                    }
                }
                if (this.bigSkillTime > 200 && this.bigSkillTime < 350) {
                    if (this.bigSkillTime % 2 == 0 && this.func_70638_az() != null) {
                        int x = 0;
                        int y = 0;
                        int z = 0;
                        for (sp = 0; sp < 32; ++sp) {
                            x = (int)this.func_70638_az().field_70165_t + this.field_70170_p.field_73012_v.nextInt(11) - 5;
                            if (MMM.getBlockDistance(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, (double)x, (double)(y = (int)this.func_70638_az().field_70163_u + this.field_70170_p.field_73012_v.nextInt(7) - 3), (double)(z = (int)this.func_70638_az().field_70161_v + this.field_70170_p.field_73012_v.nextInt(11) - 5)) <= 1 || !this.field_70170_p.func_147437_c(x, y, z) || !MMM.canEntityBeSeen(this.field_70170_p, (Entity)this.func_70638_az(), x, y, z)) continue;
                            this.doArrowAttack(x, y, z, this.func_70638_az(), this.attack(4000));
                            break;
                        }
                    }
                    this.see_target();
                    if (this.bigSkillTime % 15 == 0) {
                        this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Dark), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                        EntityMagicBallGravity ball0 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 100.0f, 22, 2.0f, 0, 3.0f);
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70170_p.func_72838_d((Entity)ball0);
                        }
                    }
                }
                if (this.bigSkillTime > 350 && this.bigSkillTime < 500) {
                    if (this.bigSkillTime % 3 == 0 && this.func_70638_az() != null) {
                        EntityMagicBallNew ball = new EntityMagicBallNew(this.field_70170_p, (EntityLivingBase)this, this.attack(3000), ManaElements.Ice, 0, (Entity)this.func_70638_az());
                        this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Ice), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                        this.field_70170_p.func_72838_d((Entity)ball);
                    }
                    if (this.bigSkillTime % 20 == 0) {
                        list = MMM.findPlayersNoCreate((Entity)this, 20.0f);
                        for (s = 0; s < list.size(); ++s) {
                            EntityPlayer temp = list.get(s);
                            if (!(temp.field_70163_u > (double)(this.spawnPointPos.Y - 4))) continue;
                            temp.func_85030_a(MMM.getMODID() + ":starexp", 3.0f, 1.0f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                            PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(10, temp.field_70165_t, temp.field_70163_u, temp.field_70161_v, 0, 0, 0), new NetworkRegistry.TargetPoint(MMM.getDimensionID(this.field_70170_p), temp.field_70165_t, temp.field_70163_u, temp.field_70161_v, 32.0));
                            temp.func_70097_a(DamageSource.field_76376_m, (float)this.attack(3000));
                            EntityMagicObject obj = new EntityMagicObject(this.field_70170_p, 150, 51, 1.0f, null);
                            obj.func_70080_a(temp.field_70165_t, temp.field_70163_u + 1.0, temp.field_70161_v, 0.0f, 0.0f);
                            if (this.field_70170_p.field_72995_K) continue;
                            this.field_70170_p.func_72838_d((Entity)obj);
                        }
                    }
                }
                if (this.bigSkillTime > 500 && this.bigSkillTime < 600 && this.bigSkillTime % 4 == 0 && this.func_70638_az() != null) {
                    this.field_70170_p.func_72956_a((Entity)this.func_70638_az(), "random.bow", 2.0f, 0.66f);
                    Entity3DThrowable arrow = new Entity3DThrowable(this.field_70170_p, (EntityLivingBase)this, this.attack(8000), ManaElements.Fire, 38, 400);
                    arrow.func_70080_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.0f, 0.0f);
                    arrow.field_70125_A -= -20.0f;
                    double d0 = this.func_70638_az().field_70165_t + this.func_70638_az().field_70159_w - this.field_70165_t + (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
                    double d1 = this.func_70638_az().field_70163_u + 1.0 - this.field_70163_u + (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
                    double d2 = this.func_70638_az().field_70161_v + this.func_70638_az().field_70179_y - this.field_70161_v + (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f);
                    float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                    arrow.func_70186_c(d0, d1, d2, 1.5f, 1.0f);
                    this.field_70170_p.func_72838_d((Entity)arrow);
                }
                if (this.bigSkillTime > 600 && this.bigSkillTime < 780 && this.func_70638_az() != null) {
                    PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(55, this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u + (double)(this.func_70638_az().field_70131_O * 0.5f), this.func_70638_az().field_70161_v), new NetworkRegistry.TargetPoint(MMM.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 32.0));
                    if (this.bigSkillTime % 3 == 0) {
                        ManaMetalModRoot root;
                        if (this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.attack(12500)) && (root = MMM.getEntityNBT(this.func_70638_az())) != null) {
                            PotionEffectM3.addPotion(root, PotionM3.potionCurse, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionLavaDead, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionPoison, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionMissed, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionBadArmor, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionParalysis, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionFireDisabled, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionFireTwitch, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionBreakArmor, 10, 0);
                        }
                        this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Thunder), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    }
                }
                if (this.bigSkillTime > 780 && this.bigSkillTime < 890) {
                    if (this.bigSkillTime % 5 == 0 && this.func_70638_az() != null) {
                        int spawned = this.field_70170_p.field_73012_v.nextInt(20);
                        Vector3 look = new Vector3(this.func_70040_Z());
                        look.y = 0.0;
                        look.normalize().negate().multiply(2.0);
                        int div = spawned / 5;
                        int mod = spawned % 5;
                        Vector3 pl = look.copy().add(Vector3.fromEntityCenter((Entity)this)).add(0.0, 1.6, (double)div * 0.1);
                        Random rand = this.field_70170_p.field_73012_v;
                        Vector3 axis = look.copy().normalize().crossProduct(new Vector3(-1.0, 0.0, -1.0)).normalize();
                        Vector3 axis1 = axis.copy();
                        double rot = (double)mod * Math.PI / 4.0 - 1.5707963267948966;
                        axis1.multiply((double)div * 3.5 + 5.0).rotate(rot, look);
                        if (axis1.y < 0.0) {
                            axis1.y = -axis1.y;
                        }
                        Vector3 end = pl.copy().add(axis1);
                        Entity3DThrowable balls = new Entity3DThrowable(this.field_70170_p, (EntityLivingBase)this, this.attack(3000), ManaElements.Light, 35, 200);
                        ManaElements.Light.playerSoundAtEntity((Entity)this);
                        balls.setAimedTo((Entity)this.func_70638_az());
                        balls.field_70165_t = end.x;
                        balls.field_70163_u = end.y;
                        balls.field_70161_v = end.z;
                        balls.spelltype = SpellType.Time;
                        balls.field_70177_z = this.field_70177_z;
                        this.field_70170_p.func_72838_d((Entity)balls);
                        this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Magic), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    }
                    this.see_target();
                    if (this.bigSkillTime % 15 == 0) {
                        this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Dark), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                        EntityMagicBallGravity ball0 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 100.0f, 22, 2.0f, 0, 3.0f);
                        this.field_70170_p.func_72838_d((Entity)ball0);
                    }
                }
                if (this.bigSkillTime > 890 && this.bigSkillTime < 1050) {
                    if (this.bigSkillTime % 2 == 0 && this.func_70638_az() != null) {
                        int x = 0;
                        int y = 0;
                        int z = 0;
                        for (sp = 0; sp < 32; ++sp) {
                            x = (int)this.func_70638_az().field_70165_t + this.field_70170_p.field_73012_v.nextInt(11) - 5;
                            if (MMM.getBlockDistance(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, (double)x, (double)(y = (int)this.func_70638_az().field_70163_u + 9), (double)(z = (int)this.func_70638_az().field_70161_v + this.field_70170_p.field_73012_v.nextInt(11) - 5)) <= 1 || !this.field_70170_p.func_147437_c(x, y, z) || !MMM.canEntityBeSeen(this.field_70170_p, (Entity)this.func_70638_az(), x, y, z)) continue;
                            this.doArrowAttackBig(x, y, z, this.func_70638_az(), this.attack(9000));
                            break;
                        }
                    }
                    this.see_target();
                    if (this.bigSkillTime % 15 == 0) {
                        this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Dark), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                        EntityMagicBallGravity ball0 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, 100.0f, 22, 2.0f, 0, 3.0f);
                        this.field_70170_p.func_72838_d((Entity)ball0);
                    }
                }
                if (this.bigSkillTime == 1051) {
                    PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(9, 0.0f, 0.0f, 0.0f, 0, 0, 0), new NetworkRegistry.TargetPoint(MMM.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
                    this.func_70690_d(new PotionEffect(Potion.field_76441_p.func_76396_c(), 999999, 1));
                    this.timeReplenishAmmunition = 9999;
                }
                if (this.bigSkillTime == 1060) {
                    EntityBlossDoomsMeteoriteUltimate ball = new EntityBlossDoomsMeteoriteUltimate(this.field_70170_p);
                    ball.func_70080_a((float)this.spawnPointPos.X + 0.5f, (float)this.spawnPointPos.Y + 24.0f, (float)this.spawnPointPos.Z + 0.5f, 0.0f, 0.0f);
                    ball.extraspeed -= 0.05f + (float)this.Difficult.ordinal() * 0.01f;
                    if (M3Config.SoloMode) {
                        ball.extraspeed *= 0.7f;
                    }
                    this.field_70170_p.func_72838_d((Entity)ball);
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.roseHell.2");
                    MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":opendoor", this.spawnPointPos, 1.0, 1.0, 32.0);
                }
                if (this.bigSkillTime > 1400) {
                    this.disableMechanismSkill();
                    this.isBigSkillOver = true;
                }
            }
            return true;
        }
        return false;
    }

    public void doArrowAttackBig(float x, float y, float z, EntityLivingBase target, float arrowDamage) {
        double targetdist = target.func_70092_e((double)x, (double)y, (double)z);
        Entity3DThrowable arrow = new Entity3DThrowable(this.field_70170_p, (EntityLivingBase)this, this.attack(3000), ManaElements.Fire, 38, 400);
        arrow.func_70107_b(x + 0.5f, y + 0.5f, z + 0.5f);
        float accuracy = 1.0f;
        float dist = MathHelper.func_76129_c((float)((float)targetdist));
        double mx = target.field_70159_w;
        double mz = target.field_70179_y;
        double distFactor = (mx * mx + mz * mz) * 100.0 * (double)dist;
        double arrowMotionX = target.field_70165_t - (double)x + target.field_70159_w * distFactor;
        double arrowMotionZ = target.field_70161_v - (double)z + target.field_70179_y * distFactor;
        double arrowMotionY = target.field_70163_u + (double)target.func_70047_e() - arrow.field_70163_u + (double)dist * 0.2;
        float hFact = 1.0f;
        if (dist > 14.0f) {
            hFact = 1.0f + dist * 0.025f;
        }
        if (dist > 50.0f) {
            arrowMotionY += (double)(dist * 0.11f);
        } else if (dist > 25.0f) {
            arrowMotionY += (double)(dist * 0.07f);
        }
        arrow.func_70186_c(arrowMotionX, arrowMotionY, arrowMotionZ, 1.0f, accuracy);
        arrow.field_70159_w *= (double)Math.max(1.0f, hFact);
        arrow.field_70179_y *= (double)Math.max(1.0f, hFact);
        arrow.field_70181_x *= (double)Math.max(1.0f, hFact);
        target.field_70170_p.func_72838_d((Entity)arrow);
        target.field_70170_p.func_72956_a((Entity)target, "random.bow", 1.0f, 1.0f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
    }

    public void doArrowAttack(float x, float y, float z, EntityLivingBase target, float arrowDamage) {
        double targetdist = target.func_70092_e((double)x, (double)y, (double)z);
        EntityArrowBase arrow = new EntityArrowBase(target.field_70170_p, (EntityLivingBase)this, 0.0f, new ItemStack(Items.field_151032_g));
        arrow.func_70107_b(x + 0.5f, y + 0.5f, z + 0.5f);
        arrow.canHitPlayer = true;
        float accuracy = 1.0f;
        arrow.func_70243_d(true);
        float dist = MathHelper.func_76129_c((float)((float)targetdist));
        double mx = target.field_70159_w;
        double mz = target.field_70179_y;
        double distFactor = (mx * mx + mz * mz) * 100.0 * (double)dist;
        double arrowMotionX = target.field_70165_t - (double)x + target.field_70159_w * distFactor;
        double arrowMotionZ = target.field_70161_v - (double)z + target.field_70179_y * distFactor;
        double arrowMotionY = target.field_70163_u + (double)target.func_70047_e() - arrow.field_70163_u + (double)dist * 0.2;
        float hFact = 1.0f;
        if (dist > 14.0f) {
            hFact = 1.0f + dist * 0.025f;
        }
        if (dist > 50.0f) {
            arrowMotionY += (double)(dist * 0.11f);
        } else if (dist > 25.0f) {
            arrowMotionY += (double)(dist * 0.07f);
        }
        arrow.func_70186_c(arrowMotionX, arrowMotionY, arrowMotionZ, 1.0f, accuracy);
        arrow.func_70239_b(arrowDamage);
        arrow.field_70159_w *= (double)Math.max(1.0f, hFact);
        arrow.field_70179_y *= (double)Math.max(1.0f, hFact);
        arrow.field_70181_x *= (double)Math.max(1.0f, hFact);
        arrow.field_70251_a = 2;
        target.field_70170_p.func_72838_d((Entity)arrow);
        target.field_70170_p.func_72956_a((Entity)target, "random.bow", 1.0f, 1.0f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
    }

    public void disableMechanismSkill() {
        PotionEffectM3.removePotion((EntityLivingBase)this, PotionM3.potionInvincible);
        this.func_82170_o(Potion.field_76421_d.func_76396_c());
        this.func_82170_o(Potion.field_76441_p.func_76396_c());
        this.func_82170_o(Potion.field_76424_c.func_76396_c());
        this.mechanismSkillType = 0;
        this.noAttackTime = 4;
        MMM.teleport((Entity)this, this.spawnPointPos);
        this.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 80, 5));
        this.canChangeStyle = false;
        MMM.fakeExplosion(this.field_70170_p, (Entity)this, 1, 1.0f, false);
        this.timeFireShuriken = 1000;
        this.timeReplenishAmmunition = 9999;
    }

    public void initMechanismSkill() {
        MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.mechanismSkillType." + this.mechanismSkillType);
        if (this.mechanismSkillType == 1) {
            PotionEffectM3.addPotion((EntityLivingBase)this, PotionM3.potionInvincible, 999999, 1);
            MMM.teleport((Entity)this, this.spawnPointPos);
            this.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 999999, 5));
            this.crossBowHitCount = 0;
        }
        if (this.mechanismSkillType == 2) {
            PotionEffectM3.addPotion((EntityLivingBase)this, PotionM3.potionInvincible, 999999, 1);
            this.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 999999, 0));
            EntityAbsorbCrystal eac1 = new EntityAbsorbCrystal(this.field_70170_p);
            EntityAbsorbCrystal eac2 = new EntityAbsorbCrystal(this.field_70170_p);
            eac1.func_70080_a((float)(this.spawnPointPos.X + 7) + 0.5f, (float)this.spawnPointPos.Y + 1.0f, (float)this.spawnPointPos.Z + 0.5f, 0.0f, 0.0f);
            eac2.func_70080_a((float)(this.spawnPointPos.X - 7) + 0.5f, (float)this.spawnPointPos.Y + 1.0f, (float)this.spawnPointPos.Z + 0.5f, 0.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)eac1);
            this.field_70170_p.func_72838_d((Entity)eac2);
            if (this.Difficult.ordinal() > 1) {
                EntityAbsorbCrystal eac3 = new EntityAbsorbCrystal(this.field_70170_p);
                EntityAbsorbCrystal eac4 = new EntityAbsorbCrystal(this.field_70170_p);
                eac3.func_70080_a((float)this.spawnPointPos.X + 0.5f, (float)this.spawnPointPos.Y + 1.0f, (float)(this.spawnPointPos.Z + 7) + 0.5f, 0.0f, 0.0f);
                eac4.func_70080_a((float)this.spawnPointPos.X + 0.5f, (float)this.spawnPointPos.Y + 1.0f, (float)(this.spawnPointPos.Z - 7) + 0.5f, 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)eac3);
                this.field_70170_p.func_72838_d((Entity)eac4);
            }
        }
        if (this.mechanismSkillType == 3) {
            PotionEffectM3.addPotion((EntityLivingBase)this, PotionM3.potionInvincible, 999999, 1);
            this.func_70690_d(new PotionEffect(Potion.field_76441_p.func_76396_c(), 999999, 1));
            this.func_70690_d(new PotionEffect(Potion.field_76424_c.func_76396_c(), 999999, 0));
            EntitySmokeCrystal esc1 = new EntitySmokeCrystal(this.field_70170_p);
            EntitySmokeCrystal esc2 = new EntitySmokeCrystal(this.field_70170_p);
            esc1.func_70080_a((float)(this.spawnPointPos.X + 7) + 0.5f, (float)this.spawnPointPos.Y + 1.0f, (float)this.spawnPointPos.Z + 0.5f, 0.0f, 0.0f);
            esc2.func_70080_a((float)(this.spawnPointPos.X - 7) + 0.5f, (float)this.spawnPointPos.Y + 1.0f, (float)this.spawnPointPos.Z + 0.5f, 0.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)esc1);
            this.field_70170_p.func_72838_d((Entity)esc2);
            if (this.Difficult.ordinal() > 1) {
                EntitySmokeCrystal esc3 = new EntitySmokeCrystal(this.field_70170_p);
                EntitySmokeCrystal esc4 = new EntitySmokeCrystal(this.field_70170_p);
                esc3.func_70080_a((float)this.spawnPointPos.X + 0.5f, (float)this.spawnPointPos.Y + 1.0f, (float)(this.spawnPointPos.Z + 7) + 0.5f, 0.0f, 0.0f);
                esc4.func_70080_a((float)this.spawnPointPos.X + 0.5f, (float)this.spawnPointPos.Y + 1.0f, (float)(this.spawnPointPos.Z - 7) + 0.5f, 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)esc3);
                this.field_70170_p.func_72838_d((Entity)esc4);
            }
        }
    }

    public void doMechanismSkill() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.mechanismSkillType == 1) {
                this.canChangeStyle = false;
                List<EntityPlayer> list = MMM.findPlayersNoCreate((Entity)this, 24.0f);
                for (int s = 0; s < list.size(); ++s) {
                    EntityPlayer temp = list.get(s);
                    if (!(temp.field_70163_u > (double)(this.spawnPointPos.Y - 4))) continue;
                    MMM.attackEntityNoKnockBack((Entity)temp, DamageSource.field_76376_m, this.attack(1500));
                    for (int zz = 0; zz < 4; ++zz) {
                        EntityMagicBallNew ball = new EntityMagicBallNew(this.field_70170_p, (EntityLivingBase)this, 100, ManaElements.Fire, 13, null);
                        ball.field_70165_t = temp.field_70165_t + (0.5 - (double)this.field_70170_p.field_73012_v.nextFloat()) * 2.0;
                        ball.field_70163_u = temp.field_70163_u + 5.0 + (double)this.field_70170_p.field_73012_v.nextFloat();
                        ball.field_70161_v = temp.field_70161_v + (0.5 - (double)this.field_70170_p.field_73012_v.nextFloat()) * 2.0;
                        ball.field_70159_w = 0.0;
                        ball.field_70181_x = -1.2f;
                        ball.field_70179_y = 0.0;
                        ball.particle = null;
                        ball.setSize(1.25f);
                        ball.setImpactFX(false);
                        ball.sound = true;
                        ball.setSpaceTextureID(7);
                        ball.spelltype = SpellType.Poison;
                        this.field_70170_p.func_72838_d((Entity)ball);
                    }
                }
            }
            if (this.mechanismSkillType == 2 && this.time % 20 == 0) {
                boolean has = false;
                List<Entity> listentity = MMM.findEntity((Entity)this, 125);
                if (!listentity.isEmpty()) {
                    for (int s = 0; s < listentity.size(); ++s) {
                        if (!(listentity.get(s) instanceof EntityAbsorbCrystal)) continue;
                        has = true;
                        break;
                    }
                }
                if (has) {
                    int tempheal = 0;
                    int heal = 0;
                    List<EntityPlayer> list = MMM.findPlayersNoCreate((Entity)this, 64.0f);
                    for (int s = 0; s < list.size(); ++s) {
                        EntityPlayer temp = list.get(s);
                        if (!(temp.field_70163_u > (double)(this.spawnPointPos.Y - 4))) continue;
                        PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(56, temp.field_70165_t, temp.field_70163_u + (double)(temp.field_70131_O * 0.5f), temp.field_70161_v, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O * 0.5f), this.field_70161_v), new NetworkRegistry.TargetPoint(MMM.getDimensionID(this.field_70170_p), temp.field_70165_t, temp.field_70163_u + 1.0, temp.field_70161_v, 32.0));
                        tempheal = (int)(temp.func_110138_aP() * 0.03f);
                        switch (this.Difficult) {
                            case EASY: {
                                temp.func_70097_a(AttackType.ChaosDamage, 0.02f);
                                break;
                            }
                            case NORMAL: {
                                temp.func_70097_a(AttackType.ChaosDamage, 0.03f);
                                break;
                            }
                            case HARD: {
                                temp.func_70097_a(AttackType.ChaosDamage, 0.05f);
                                break;
                            }
                            case HELL: {
                                temp.func_70097_a(AttackType.ChaosDamage, 0.1f);
                            }
                        }
                        heal += tempheal;
                    }
                    if (heal > 0) {
                        switch (this.Difficult) {
                            case EASY: {
                                heal *= 100;
                                break;
                            }
                            case NORMAL: {
                                heal *= 150;
                                break;
                            }
                            case HARD: {
                                heal *= 200;
                                break;
                            }
                            case HELL: {
                                heal *= 300;
                            }
                        }
                        this.func_70691_i(heal);
                    }
                } else {
                    this.disableMechanismSkill();
                }
            }
            if (this.mechanismSkillType == 3 && this.time % 20 == 0) {
                boolean has = false;
                List<Entity> listentity = MMM.findEntity((Entity)this, 125);
                if (!listentity.isEmpty()) {
                    for (int s = 0; s < listentity.size(); ++s) {
                        if (!(listentity.get(s) instanceof EntitySmokeCrystal)) continue;
                        has = true;
                        break;
                    }
                }
                if (!has) {
                    this.disableMechanismSkill();
                }
            }
        }
    }

    public boolean ultimateLightning() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.combat >= this.combatMax) {
                ++this.timeUltimateLightning;
            }
            if (this.timeUltimateLightning > 4800) {
                this.useUltimateLightning = true;
                this.timeUltimateLightning = 0;
            }
            if (this.useUltimateLightning) {
                ++this.timeUltimateLightningAttack;
                this.canChangeStyle = false;
                if (this.useUltimateLightningTarget == null) {
                    this.useUltimateLightningTarget = this.func_70638_az();
                }
                if (this.useUltimateLightningTarget != null) {
                    PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(55, this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v, this.useUltimateLightningTarget.field_70165_t, this.useUltimateLightningTarget.field_70163_u + (double)(this.useUltimateLightningTarget.field_70131_O * 0.5f), this.useUltimateLightningTarget.field_70161_v), new NetworkRegistry.TargetPoint(MMM.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 32.0));
                    if (this.timeUltimateLightningAttack % 3 == 0) {
                        ManaMetalModRoot root;
                        if (this.useUltimateLightningTarget.func_70097_a(DamageSource.field_76376_m, (float)this.attack(12500)) && (root = MMM.getEntityNBT(this.useUltimateLightningTarget)) != null) {
                            PotionEffectM3.addPotion(root, PotionM3.potionCurse, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionLavaDead, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionPoison, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionMissed, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionBadArmor, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionParalysis, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionFireDisabled, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionFireTwitch, 10, 0);
                            PotionEffectM3.addPotion(root, PotionM3.potionBreakArmor, 10, 0);
                        }
                        this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Thunder), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    }
                    if (this.useUltimateLightningTarget.field_70128_L) {
                        this.timeUltimateLightningAttack = 0;
                        this.useUltimateLightning = false;
                        this.useUltimateLightningTarget = null;
                    }
                }
                if (this.timeUltimateLightningAttack > 200) {
                    this.timeUltimateLightningAttack = 0;
                    this.useUltimateLightning = false;
                    this.useUltimateLightningTarget = null;
                }
                return false;
            }
        }
        return true;
    }

    public boolean darkArea() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.canDarkAoe) {
                ++this.timeDarkArea;
            }
            if (this.timeDarkArea > 4200 && this.timeDarkArea < 4301) {
                this.canChangeStyle = false;
                if (this.timeDarkArea == 4201) {
                    this.func_85030_a("mob.endermen.portal", 2.0f, 1.0f);
                    MMM.teleport((Entity)this, (double)((float)this.spawnPointPos.X + 0.5f), (double)((float)this.spawnPointPos.Y + 1.0f), (double)((float)this.spawnPointPos.Z + 0.5f));
                    this.areaAoeType = this.field_70170_p.field_73012_v.nextInt(2);
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.darkaoe");
                }
                if (this.timeDarkArea == 4204) {
                    this.func_70690_d(new PotionEffect(2, 140, 6));
                    PotionEffectM3.addPotion((EntityLivingBase)this, PotionM3.potionInvincible, 7, 0);
                    this.spawnRuneFXServerSound((EntityLivingBase)this, ManaElements.Dark, 130, 4.0f, true, 64);
                }
                if (this.timeDarkArea == 4300) {
                    this.timeAreaAoe -= 200;
                    this.gravityBall = 0;
                    this.repBlocks(Blocks.field_150371_ca, ItemCraft10.BlockDarkAreas);
                }
                return false;
            }
            if (this.timeDarkArea > 5500) {
                this.timeDarkArea = 1000 - this.combat * 10;
                this.repBlocks(ItemCraft10.BlockDarkAreas, Blocks.field_150371_ca);
            }
        }
        return true;
    }

    public void repBlocks(Block source, Block target) {
        for (int x = -23; x < 24; ++x) {
            for (int z = -23; z < 24; ++z) {
                if (this.field_70170_p.func_147439_a(this.spawnPointPos.X + x, this.spawnPointPos.Y - 2, this.spawnPointPos.Z + z) != source) continue;
                this.field_70170_p.func_147465_d(this.spawnPointPos.X + x, this.spawnPointPos.Y - 2, this.spawnPointPos.Z + z, target, 0, 2);
            }
        }
    }

    public void spawnRoseBomb() {
        if (!this.field_70170_p.field_72995_K) {
            ++this.timeRoseBomb;
            if (this.timeRoseBomb > 400) {
                this.timeRoseBomb = 0;
                List<EntityPlayer> list = MMM.findPlayersNoCreate((Entity)this, 48.0f);
                for (int s = 0; s < list.size() && s < 2; ++s) {
                    EntityPlayer temp = list.get(s);
                    if (temp.field_70153_n != null || !(temp.field_70163_u > (double)(this.spawnPointPos.Y - 4))) continue;
                    EntityRoseBomb bomb = new EntityRoseBomb(this.field_70170_p);
                    bomb.func_70080_a(temp.field_70165_t, temp.field_70163_u + 2.0, temp.field_70161_v, 0.0f, 0.0f);
                    this.field_70170_p.func_72838_d((Entity)bomb);
                    bomb.func_70078_a((Entity)temp);
                }
            }
        }
    }

    public void spawnFloatingPlatform() {
        if (!this.field_70170_p.field_72995_K) {
            ++this.spawnFloatingPlatformTime;
            if (this.spawnFloatingPlatformTime > 4999) {
                int time = 420 - this.Difficult.ordinal() * 30;
                if (this.spawnFloatingPlatformTime == 5000) {
                    this.floatingPlatform(this.spawnPointPos.X + 29, this.spawnPointPos.Y - 3, this.spawnPointPos.Z, time);
                    this.floatingPlatform(this.spawnPointPos.X - 29, this.spawnPointPos.Y - 3, this.spawnPointPos.Z, time);
                    MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":fly_stair", this.spawnPointPos.X, this.spawnPointPos.Y, this.spawnPointPos.Z, 6.0, 0.93f, 32.0);
                    MMM.teleport((Entity)this, (double)((float)this.spawnPointPos.X + 0.5f), (double)((float)this.spawnPointPos.Y + 1.0f), (double)((float)this.spawnPointPos.Z + 0.5f));
                }
                if (this.spawnFloatingPlatformTime == 5015) {
                    this.floatingPlatform(this.spawnPointPos.X + 29, this.spawnPointPos.Y - 2, this.spawnPointPos.Z + 5, time);
                    this.floatingPlatform(this.spawnPointPos.X + 29, this.spawnPointPos.Y - 2, this.spawnPointPos.Z - 5, time);
                    this.floatingPlatform(this.spawnPointPos.X - 29, this.spawnPointPos.Y - 2, this.spawnPointPos.Z + 5, time);
                    this.floatingPlatform(this.spawnPointPos.X - 29, this.spawnPointPos.Y - 2, this.spawnPointPos.Z - 5, time);
                    MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":fly_stair", this.spawnPointPos.X, this.spawnPointPos.Y, this.spawnPointPos.Z, 6.0, 0.9f, 32.0);
                }
                if (this.spawnFloatingPlatformTime == 5030) {
                    this.floatingPlatform(this.spawnPointPos.X + 29, this.spawnPointPos.Y - 1, this.spawnPointPos.Z + 9, time);
                    this.floatingPlatform(this.spawnPointPos.X + 29, this.spawnPointPos.Y - 1, this.spawnPointPos.Z - 9, time);
                    this.floatingPlatform(this.spawnPointPos.X - 29, this.spawnPointPos.Y - 1, this.spawnPointPos.Z + 9, time);
                    this.floatingPlatform(this.spawnPointPos.X - 29, this.spawnPointPos.Y - 1, this.spawnPointPos.Z - 9, time);
                    MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":fly_stair", this.spawnPointPos.X, this.spawnPointPos.Y, this.spawnPointPos.Z, 6.0, 0.87f, 32.0);
                }
                if (this.spawnFloatingPlatformTime == 5045) {
                    this.floatingPlatform(this.spawnPointPos.X + 29, this.spawnPointPos.Y + 0, this.spawnPointPos.Z + 13, time);
                    this.floatingPlatform(this.spawnPointPos.X + 29, this.spawnPointPos.Y + 0, this.spawnPointPos.Z - 13, time);
                    this.floatingPlatform(this.spawnPointPos.X - 29, this.spawnPointPos.Y + 0, this.spawnPointPos.Z + 13, time);
                    this.floatingPlatform(this.spawnPointPos.X - 29, this.spawnPointPos.Y + 0, this.spawnPointPos.Z - 13, time);
                    MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":fly_stair", this.spawnPointPos.X, this.spawnPointPos.Y, this.spawnPointPos.Z, 6.0, 0.84f, 32.0);
                }
                if (this.spawnFloatingPlatformTime == 5060) {
                    this.floatingPlatform(this.spawnPointPos.X + 29, this.spawnPointPos.Y + 1, this.spawnPointPos.Z + 17, time);
                    this.floatingPlatform(this.spawnPointPos.X + 29, this.spawnPointPos.Y + 1, this.spawnPointPos.Z - 17, time);
                    this.floatingPlatform(this.spawnPointPos.X - 29, this.spawnPointPos.Y + 1, this.spawnPointPos.Z + 17, time);
                    this.floatingPlatform(this.spawnPointPos.X - 29, this.spawnPointPos.Y + 1, this.spawnPointPos.Z - 17, time);
                    MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":fly_stair", this.spawnPointPos.X, this.spawnPointPos.Y, this.spawnPointPos.Z, 6.0, 0.81f, 32.0);
                }
                if (this.spawnFloatingPlatformTime == 5075) {
                    this.floatingPlatform(this.spawnPointPos.X + 29, this.spawnPointPos.Y + 2, this.spawnPointPos.Z + 21, time);
                    this.floatingPlatform(this.spawnPointPos.X + 29, this.spawnPointPos.Y + 2, this.spawnPointPos.Z - 21, time);
                    this.floatingPlatform(this.spawnPointPos.X - 29, this.spawnPointPos.Y + 2, this.spawnPointPos.Z + 21, time);
                    this.floatingPlatform(this.spawnPointPos.X - 29, this.spawnPointPos.Y + 2, this.spawnPointPos.Z - 21, time);
                    MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":fly_stair", this.spawnPointPos.X, this.spawnPointPos.Y, this.spawnPointPos.Z, 6.0, 0.78f, 32.0);
                }
                if (this.spawnFloatingPlatformTime == 5090) {
                    int true2;
                    boolean[] data = new boolean[4];
                    int true1 = this.field_70170_p.field_73012_v.nextInt(4);
                    while ((true2 = this.field_70170_p.field_73012_v.nextInt(4)) == true1) {
                    }
                    data[true1] = true;
                    data[true2] = true;
                    this.floatingPlatformCrystal(this.spawnPointPos.X + 29, this.spawnPointPos.Y + 3, this.spawnPointPos.Z + 25, time, data[0]);
                    this.floatingPlatformCrystal(this.spawnPointPos.X + 29, this.spawnPointPos.Y + 3, this.spawnPointPos.Z - 25, time, data[1]);
                    this.floatingPlatformCrystal(this.spawnPointPos.X - 29, this.spawnPointPos.Y + 3, this.spawnPointPos.Z + 25, time, data[2]);
                    this.floatingPlatformCrystal(this.spawnPointPos.X - 29, this.spawnPointPos.Y + 3, this.spawnPointPos.Z - 25, time, data[3]);
                    MMM.playSoundFromServer(this.field_70170_p, MMM.getMODID() + ":fly_stair", this.spawnPointPos.X, this.spawnPointPos.Y, this.spawnPointPos.Z, 6.0, 0.75, 32.0);
                }
                if (this.spawnFloatingPlatformTime > 5095) {
                    this.spawnFloatingPlatformTime = 0;
                }
            }
        }
    }

    public void floatingPlatformCrystal(int x, int y, int z, int time, boolean hasCrystal) {
        for (int dx = -1; dx < 2; ++dx) {
            for (int dz = -1; dz < 2; ++dz) {
                TileEntityFloatingPlatform.setFloatingPlatform(this.field_70170_p, x + dx, y, z + dz, 0, time);
                if (!hasCrystal || dx != 0 || dz != 0) continue;
                EntityRosePoisonCrystal erpc = new EntityRosePoisonCrystal(this.field_70170_p);
                erpc.func_70080_a((float)(x + dx) + 0.5f, (float)y + 1.0f, (float)(z + dz) + 0.5f, 0.0f, 0.0f);
                erpc.maxtime = time;
                this.field_70170_p.func_72838_d((Entity)erpc);
            }
        }
    }

    public void floatingPlatform(int x, int y, int z, int time) {
        for (int dx = -1; dx < 2; ++dx) {
            for (int dz = -1; dz < 2; ++dz) {
                TileEntityFloatingPlatform.setFloatingPlatform(this.field_70170_p, x + dx, y, z + dz, 0, time);
            }
        }
    }

    public void spawnEye() {
        if (!this.field_70170_p.field_72995_K) {
            ++this.spawnEye;
            if (this.spawnEye > this.spawnEyeMax) {
                this.spawnEye = 0;
                this.spawnEyeMax = 4200 + this.combat * 20;
                List<Entity> listentity = MMM.findEntity((Entity)this, 125);
                if (!listentity.isEmpty()) {
                    for (int s = 0; s < listentity.size(); ++s) {
                        if (!(listentity.get(s) instanceof EntityRoseEye)) continue;
                        return;
                    }
                }
                EntityRoseEye eye = new EntityRoseEye(this.field_70170_p);
                eye.func_70080_a((float)this.spawnPointPos.X + 0.5f, (float)this.spawnPointPos.Y + 5.0f, (float)this.spawnPointPos.Z + 0.5f, 0.0f, 0.0f);
                eye.miniTargetPosY = this.spawnPointPos.Y - 4;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)eye);
                    this.arcLightning_vanilla(this.field_70170_p, this.spawnPointPos, 100.0f, 220.0f, 0.0f, 0.0f);
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.spawnEye");
                }
            }
        }
    }

    public boolean doPotionGrassAOE() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.isDarkBarrier <= 0) {
                ++this.timeAreaAoe;
            }
            if (this.timeAreaAoe > 1200) {
                this.canChangeStyle = false;
                this.canDarkAoe = false;
                if (this.timeAreaAoe == 1201) {
                    this.func_85030_a("mob.endermen.portal", 2.0f, 1.0f);
                    MMM.teleport((Entity)this, (double)((float)this.spawnPointPos.X + 0.5f), (double)((float)this.spawnPointPos.Y + 1.0f), (double)((float)this.spawnPointPos.Z + 0.5f));
                    this.areaAoeType = this.field_70170_p.field_73012_v.nextInt(2);
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.aoe." + this.areaAoeType);
                }
                if (this.timeAreaAoe == 1204) {
                    this.func_70690_d(new PotionEffect(2, 140, 6));
                    PotionEffectM3.addPotion((EntityLivingBase)this, PotionM3.potionInvincible, 7, 0);
                    this.spawnRuneFXServerSound((EntityLivingBase)this, ManaElements.Grass, 130, 4.0f, true, 64);
                }
                if (this.timeAreaAoe % 4 == 0) {
                    PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(44, this.field_70165_t, this.field_70163_u + (double)1.8f, this.field_70161_v, 0, 0, 0), MMM.getTargetPoint((Entity)this, 64.0f));
                }
                if (this.timeAreaAoe > 1324) {
                    EntityPlayer temp;
                    int s;
                    this.canDarkAoe = true;
                    this.timeDarkArea -= 100;
                    this.timeAreaAoe = 0;
                    this.gravityBall = 0;
                    int count = 0;
                    List<EntityPlayer> list = MMM.findPlayersNoCreate((Entity)this, 64.0f);
                    if (this.areaAoeType == 0) {
                        for (s = 0; s < list.size(); ++s) {
                            temp = list.get(s);
                            if (!(temp.field_70163_u > (double)(this.spawnPointPos.Y - 4)) || this.isBlock(temp, (Block)Blocks.field_150349_c)) continue;
                            PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(41, this.field_70165_t, this.field_70163_u + (double)1.8f, this.field_70161_v, temp.field_70165_t, temp.field_70163_u + (double)(temp.field_70131_O * 0.5f), temp.field_70161_v), MMM.getTargetPoint((Entity)this, 64.0f));
                            MMM.attackUseChaos((EntityLivingBase)temp, 1.0f);
                            MMM.fakeExplosion(this.field_70170_p, (Entity)temp, 3, 100.0f, true);
                            ++count;
                        }
                    }
                    if (this.areaAoeType == 1) {
                        for (s = 0; s < list.size(); ++s) {
                            temp = list.get(s);
                            if (!(temp.field_70163_u > (double)(this.spawnPointPos.Y - 4)) || this.isBlock(temp, (Block)Blocks.field_150398_cm)) continue;
                            PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(41, this.field_70165_t, this.field_70163_u + (double)1.8f, this.field_70161_v, temp.field_70165_t, temp.field_70163_u + (double)(temp.field_70131_O * 0.5f), temp.field_70161_v), MMM.getTargetPoint((Entity)this, 64.0f));
                            MMM.attackUseChaos((EntityLivingBase)temp, 1.0f);
                            MMM.fakeExplosion(this.field_70170_p, (Entity)temp, 3, 100.0f, true);
                            ++count;
                        }
                    }
                    if (count > 0) {
                        this.combat -= count * 5;
                        this.setCombat(this.combat);
                    }
                }
                return false;
            }
        }
        return true;
    }

    public boolean isBlock(EntityPlayer target, Block block) {
        int dx = (int)target.field_70165_t;
        int dy = (int)target.field_70163_u;
        int dz = (int)target.field_70161_v;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = -2; y < 2; ++y) {
                    if (target.field_70170_p.func_147439_a(dx + x, dy + y, dz + z) != block) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void arcLightning_vanilla(World world, Pos pos, float damage, float r, float g, float b) {
        if (!world.field_72995_K) {
            world.func_72942_c((Entity)new EntityLightningBoltPower(world, pos.X, pos.Y, pos.Z, damage, r, g, b));
            PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(5, (float)pos.X, (float)pos.Y, (float)pos.Z, (int)r, (int)g, (int)b), new NetworkRegistry.TargetPoint(MMM.getDimensionID(world), (double)pos.X, (double)pos.Y, (double)pos.Z, 64.0));
            MMM.playSoundFromServer(world, MMM.getMODID() + ":thunder4", pos.X, pos.Y, pos.Z, 8.0, 0.8f + world.field_73012_v.nextFloat() * 0.2f, 64.0);
        }
    }

    public boolean isCombat(float data) {
        return (float)this.combat >= (float)this.combatMax * data;
    }

    public void spawnHammer() {
        --this.spawnHammer;
        if (this.spawnHammer < 0) {
            this.spawnHammer = this.Difficult == IDungeonDifficult.HELL ? 200 : 300;
            int count = this.Difficult.ordinal() > 1 ? 3 : 2;
            block0: for (int dd = 0; dd < count; ++dd) {
                for (int s = 0; s < 64; ++s) {
                    int dz;
                    int dy;
                    int dx = (int)(this.field_70165_t - 16.0 + (double)this.field_70170_p.field_73012_v.nextInt(33));
                    if (MMM.getBlockDistance((double)dx, (double)(dy = (int)this.field_70163_u + 1), (double)(dz = (int)(this.field_70161_v - 16.0 + (double)this.field_70170_p.field_73012_v.nextInt(33))), this.field_70165_t, this.field_70163_u, this.field_70161_v) <= 1 || !this.field_70170_p.func_147437_c(dx, dy, dz) || !MMM.canEntityBeSeen(this.field_70170_p, (Entity)this, dx, dy, dz)) continue;
                    EntityMagicObject obj = new EntityMagicObject(this.field_70170_p, 300, 68, this.attack(5000), (EntityLivingBase)this);
                    obj.func_70080_a((float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, 0.0f, 0.0f);
                    obj.data1 = 1;
                    if (this.isCombat(0.7f)) {
                        obj.data2 = 1;
                    }
                    if (this.field_70170_p.field_72995_K) continue block0;
                    this.field_70170_p.func_72838_d((Entity)obj);
                    this.arcLightning_vanilla(this.field_70170_p, new Pos(dx, dy, dz), 100.0f, 220.0f, 0.0f, 0.0f);
                    continue block0;
                }
            }
        }
    }

    public void spawnBloodTower() {
        ++this.summonTower;
        if (this.summonTower == 180 || this.summonTower == 200) {
            int count = this.isCombat(0.7f) ? 3 : 2;
            block0: for (int dd = 0; dd < count; ++dd) {
                for (int s = 0; s < 32; ++s) {
                    int dz;
                    int dy;
                    int dx = (int)(this.field_70165_t - 12.0 + (double)this.field_70170_p.field_73012_v.nextInt(25));
                    if (MMM.getBlockDistance((double)dx, (double)(dy = (int)this.field_70163_u), (double)(dz = (int)(this.field_70161_v - 12.0 + (double)this.field_70170_p.field_73012_v.nextInt(25))), this.field_70165_t, this.field_70163_u, this.field_70161_v) <= 1 || !this.field_70170_p.func_147437_c(dx, dy, dz) || !MMM.canEntityBeSeen(this.field_70170_p, (Entity)this, dx, dy, dz)) continue;
                    EntityBlossCrystal10 temp = new EntityBlossCrystal10(this.field_70170_p);
                    temp.typedata = 1;
                    temp.func_70080_a((float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, 0.0f, 0.0f);
                    if (this.field_70170_p.field_72995_K) continue block0;
                    this.field_70170_p.func_72838_d((Entity)temp);
                    continue block0;
                }
            }
        }
        if (this.summonTower > 201) {
            this.summonTower = 0;
        }
    }

    public boolean fireBallAttackgravity(int type) {
        if (this.func_70638_az() != null) {
            ++this.gravityBall;
            if (this.gravityBall > 100) {
                this.see_target();
                if (this.gravityBall == 101) {
                    this.spawnRuneFXServerSound((EntityLivingBase)this, ManaElements.Dark, 100, 4.0f, true, 32);
                    this.func_70690_d(new PotionEffect(2, 100, 5));
                }
                if (this.gravityBall > 150) {
                    if (this.gravityBall % 10 == 0) {
                        float attack_ball = 3500.0f;
                        float basespeed = (float)this.combat > (float)this.combatMax * 0.7f ? 3.5f : 2.5f;
                        this.field_70170_p.func_72956_a((Entity)this, ManaElements.getElementsSounds(ManaElements.Dark), 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                        EntityMagicBallGravity ball0 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, attack_ball, type, 2.0f, 0, basespeed);
                        EntityMagicBallGravity ball1 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, attack_ball, type, 2.0f, 16, basespeed);
                        EntityMagicBallGravity ball2 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, attack_ball, type, 2.0f, 32, basespeed);
                        EntityMagicBallGravity ball3 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, attack_ball, type, 2.0f, -16, basespeed);
                        EntityMagicBallGravity ball4 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, attack_ball, type, 2.0f, -32, basespeed);
                        EntityMagicBallGravity ball5 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, attack_ball, type, 2.0f, 48, basespeed);
                        EntityMagicBallGravity ball6 = new EntityMagicBallGravity(this.field_70170_p, (EntityLivingBase)this, attack_ball, type, 2.0f, -48, basespeed);
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70170_p.func_72838_d((Entity)ball0);
                            this.field_70170_p.func_72838_d((Entity)ball1);
                            this.field_70170_p.func_72838_d((Entity)ball2);
                            this.field_70170_p.func_72838_d((Entity)ball4);
                            this.field_70170_p.func_72838_d((Entity)ball3);
                            this.field_70170_p.func_72838_d((Entity)ball5);
                            this.field_70170_p.func_72838_d((Entity)ball6);
                        }
                    }
                    if (this.gravityBall > 180) {
                        this.gravityBall = 0;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public void doArrowstorm() {
        ++this.arrowstorm;
        if (this.arrowstorm > 300) {
            if (this.time % 2 == 0 && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 20.0f) {
                ProjectileHelp.doArrowAttack((EntityLivingBase)this, this.func_70638_az(), this.attack(5000), true, false, 10, 0);
            }
            if (this.arrowstorm > 400) {
                this.arrowstorm = 0;
            }
        }
    }

    public void doBigArrow() {
        --this.bigarrow;
        if (this.bigarrow < 0) {
            switch (this.Difficult) {
                case EASY: {
                    this.bigarrow = 100;
                    break;
                }
                case NORMAL: {
                    this.bigarrow = 80;
                    break;
                }
                case HARD: 
                case HELL: {
                    this.bigarrow = 60;
                }
            }
            List<EntityPlayer> list = MMM.findPlayersNoCreate((Entity)this, 64.0f);
            int z = 0;
            if (!list.isEmpty()) {
                boolean isover70 = this.isCombat(0.7f);
                block5: for (int s = 0; s < list.size() && s < 2; ++s) {
                    EntityPlayer player = list.get(s);
                    if (player == null || !player.func_70685_l((Entity)this)) continue;
                    int spawncount = 0;
                    for (int sp = 0; sp < 32; ++sp) {
                        int y;
                        int x = (int)player.field_70165_t + this.field_70170_p.field_73012_v.nextInt(11) - 5;
                        if (MMM.getBlockDistance(player.field_70165_t, player.field_70163_u, player.field_70161_v, (double)x, (double)(y = (int)player.field_70163_u), (double)(z = (int)player.field_70161_v + this.field_70170_p.field_73012_v.nextInt(11) - 5)) <= 1 || !this.field_70170_p.func_147437_c(x, y, z) || !MMM.canEntityBeSeen(this.field_70170_p, (Entity)player, x, y, z)) continue;
                        EntityMagicObject obj = new EntityMagicObject(this.field_70170_p, 80, 66, this.attack(20000), (EntityLivingBase)this);
                        obj.func_70080_a((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, 0.0f, 0.0f);
                        if (isover70) {
                            obj.data1 = 1;
                        }
                        this.field_70170_p.func_72838_d((Entity)obj);
                        if (++spawncount > 1) continue block5;
                    }
                }
            }
        }
    }

    @Override
    public void changeTarget() {
        if (this.func_70638_az() != null && this.func_70638_az() instanceof EntityRoseEye) {
            this.func_70624_b(null);
        }
        super.changeTarget();
    }

    public int findRandomXZ() {
        int temp;
        while ((temp = this.field_70170_p.field_73012_v.nextInt(16) - this.field_70170_p.field_73012_v.nextInt(16)) <= 8 && temp >= -8) {
        }
        return temp;
    }

    public void setPos() {
        this.spawnPointPos = new Pos((Entity)this);
        if (!this.field_70170_p.field_72995_K) {
            MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.say1");
            MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.say2");
        }
        this.func_70690_d(new PotionEffect(2, 100, 0));
        PotionEffectM3.addPotion((EntityLivingBase)this, PotionM3.potionInvincible, 5, 0);
    }

    public void see_target() {
        if (this.func_70638_az() != null) {
            EntityLivingBase targetedEntity = this.func_70638_az();
            this.func_70671_ap().func_75650_a(targetedEntity.field_70165_t, targetedEntity.field_70163_u + (double)targetedEntity.func_70047_e(), targetedEntity.field_70161_v, 10.0f, (float)this.func_70646_bf());
            this.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getAngle(targetedEntity.field_70165_t, targetedEntity.field_70161_v, this.field_70165_t, this.field_70161_v) + 90.0f, (float)(targetedEntity.field_70163_u - this.field_70163_u + (double)targetedEntity.func_70047_e()));
            this.func_70671_ap().func_75649_a();
        }
    }

    @Override
    protected void func_70628_a(boolean playerHIT, int luck) {
        super.func_70628_a(playerHIT, luck);
    }

    protected void func_70785_a(Entity target, float distance) {
        if (distance > 2.0f && distance < 6.0f && this.field_70146_Z.nextInt(10) == 0 && MMM.canUpdate((EntityLivingBase)this)) {
            if (this.field_70122_E) {
                double d0 = target.field_70165_t - this.field_70165_t;
                double d1 = target.field_70161_v - this.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w = d0 / (double)f2 * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
                this.field_70179_y = d1 / (double)f2 * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
                this.field_70181_x = 0.4f;
            }
        } else {
            super.func_70785_a(target, distance);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == AttackType.Kill) {
            return super.func_70097_a(source, damage);
        }
        if (PotionEffectM3.isPotion((EntityLivingBase)this, PotionM3.potionInvincible) && source != AttackType.CombatCannon && source != AttackType.CombatCrossbow) {
            return false;
        }
        if (source.func_76346_g() != null && (source.func_76346_g() instanceof BossAstrid || source.func_76346_g() instanceof EntityRoseEye)) {
            return false;
        }
        if (source == AttackType.GravityDamage || source.field_76373_n.equals(AttackType.GravityDamage.field_76373_n)) {
            return false;
        }
        if (source == AttackType.CombatCrossbow) {
            if (!this.field_70170_p.field_72995_K) {
                this.styleAttack = (int)((float)this.styleAttack * 0.8f);
            }
            if (this.mechanismSkillType == 1 && !this.field_70170_p.field_72995_K) {
                ++this.crossBowHitCount;
                int needHit = 4;
                if (this.Difficult.ordinal() > 1) {
                    needHit = 8;
                }
                if (this.crossBowHitCount >= needHit) {
                    this.disableMechanismSkill();
                }
                damage = 0.0f;
                return false;
            }
        }
        if (source == AttackType.CombatCannon) {
            this.styleAttack = (int)((float)this.styleAttack * 0.9f);
        }
        if (source == AttackType.CombatCannon || source == AttackType.CombatCrossbow) {
            this.setRedShield(false);
            this.redShield = 30;
            damage = 0.0f;
            return false;
        }
        this.changeStage(1, 0.85f);
        this.changeStage(2, 0.75f);
        this.changeStage(3, 0.5f);
        this.changeStage(4, 0.2f);
        return super.func_70097_a(source, damage);
    }

    public void changeStage(int target, float hp) {
        if (this.func_110143_aJ() < this.func_110138_aP() * hp && this.stage == target - 1) {
            List<EntityPlayer> list;
            this.stage = target;
            MMM.sendBossMessage((Entity)this, target, 0, 0, 64);
            MMM.arcLightning_vanilla(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0f, 255.0f, 0.0f, 0.0f);
            if (!this.field_70170_p.field_72995_K && M3Config.DEBUG && !(list = MMM.findPlayers((Entity)this, 64)).isEmpty()) {
                for (int s = 0; s < list.size(); ++s) {
                    MMM.addMessage(list.get(s), "boss stage : " + this.stage);
                }
            }
            if (target == 1) {
                // empty if block
            }
            if (target == 2 && !this.field_70170_p.field_72995_K) {
                MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.stage2");
            }
            if (target == 3) {
                if (!this.field_70170_p.field_72995_K) {
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.stage3");
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.stage3.1");
                }
                PotionEffectM3.addPotion((EntityLivingBase)this, PotionM3.potionInvincible, 999999, 0);
                this.spawnEye = 99999;
            }
            if (target == 4 && !this.field_70170_p.field_72995_K) {
                MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.stage4");
                this.isBigSkill = true;
            }
        }
    }

    public void teleportToEntity(EntityLivingBase target) {
        this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_70080_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70177_z, target.field_70125_A);
    }

    @Override
    protected boolean teleportTo(double x, double y, double z) {
        int k;
        int j;
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = event.targetX;
        this.field_70163_u = event.targetY;
        this.field_70161_v = event.targetZ;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        this.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    @Override
    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (double)this.field_70146_Z.nextInt(10) - 5.0;
        double d1 = this.field_70163_u + (double)this.field_70146_Z.nextInt(6) - 3.0;
        double d2 = this.field_70161_v + (double)this.field_70146_Z.nextInt(10) - 5.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportRandomlyEntity(Entity entity) {
        double d0 = entity.field_70165_t + (double)this.field_70146_Z.nextInt(4) - 1.0;
        double d1 = entity.field_70163_u;
        double d2 = entity.field_70161_v + (double)this.field_70146_Z.nextInt(4) - 1.0;
        return this.teleportTo(d0, d1, d2);
    }

    public float getAngle(double px1, double py1, double px2, double py2) {
        double x = px2 - px1;
        double y = py2 - py1;
        double hypotenuse = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        double cos = x / hypotenuse;
        double radian = Math.acos(cos);
        double angle = 180.0 / (Math.PI / radian);
        if (y < 0.0) {
            angle = -angle;
        } else if (y == 0.0 && x < 0.0) {
            angle = 180.0;
        }
        return (float)angle;
    }

    public void deadKillObject() {
        List<Entity> list = MMM.findEntity((Entity)this, 125);
        if (!list.isEmpty()) {
            for (int s = 0; s < list.size(); ++s) {
                Entity target = list.get(s);
                if (target instanceof EntityAbsorbCrystal) {
                    target.func_70106_y();
                }
                if (target instanceof EntityBlossDoomsMeteoriteUltimate) {
                    target.func_70106_y();
                }
                if (target instanceof EntityMagicBallGravity) {
                    target.func_70106_y();
                }
                if (target instanceof EntityRoseBomb) {
                    target.func_70106_y();
                }
                if (target instanceof EntityMagicObject) {
                    target.func_70106_y();
                }
                if (target instanceof EntityRoseEye) {
                    target.func_70106_y();
                }
                if (target instanceof EntityRosePoisonCrystal) {
                    target.func_70106_y();
                }
                if (!(target instanceof EntitySmokeCrystal)) continue;
                target.func_70106_y();
            }
        }
        this.repBlocks(ItemCraft10.BlockDarkAreas, Blocks.field_150371_ca);
    }

    protected void func_70609_aI() {
        ++this.field_70729_aU;
        if (this.field_70729_aU % 2 == 0) {
            int dx = 9 - this.field_70170_p.field_73012_v.nextInt(18);
            int dz = 9 - this.field_70170_p.field_73012_v.nextInt(18);
            EntitySkill2DObjFX data = new EntitySkill2DObjFX(this.field_70170_p, 0, 11, 3);
            data.func_70080_a(this.field_70165_t + (double)dx, this.field_70163_u, this.field_70161_v + (double)dz, 0.0f, 0.0f);
            data.size = 3.0f;
            data.sizeY = 60.0f;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)data);
            }
        }
        if (this.field_70729_aU > 100) {
            if (this.field_70729_aU == 101) {
                List<EntityPlayer> list;
                if (!this.field_70170_p.field_72995_K) {
                    PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(9, 0.0f, 0.0f, 0.0f, 0, 0, 0), new NetworkRegistry.TargetPoint(MMM.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.dead1");
                    MMM.addMessageWorldDistance(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, "MMM.info.BossAstrid.dead2");
                }
                if (!(list = MMM.findPlayers((Entity)this, 64)).isEmpty()) {
                    for (int s = 0; s < list.size(); ++s) {
                        MMM.healEntity((EntityLivingBase)list.get(s), 1.0f);
                    }
                }
                this.deadKillObject();
            }
            super.func_70609_aI();
        }
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    public IDungeonDifficult getIDungeonDifficult() {
        return this.Difficult;
    }

    @Override
    public long getMobUUID() {
        return this.mobuuid;
    }

    @Override
    public ManaElements getEntityElements() {
        return ManaElements.Fire;
    }

    @Override
    public float getDefense() {
        float data;
        float defense = 0.45f;
        if ((float)this.combat > (float)this.combatMax * 0.7f) {
            data = 100.0f - (float)(this.combat / this.combatMax) * 100.0f;
            defense -= 0.005f * data;
        }
        if ((float)this.combat < (float)this.combatMax * 0.3f) {
            data = 100.0f - (float)(this.combat / this.combatMax) * 100.0f;
            defense += 0.02f * data;
        }
        if (this.redShield <= 0) {
            defense += 0.08f;
        }
        if (this.rosePoison > 0) {
            defense -= 0.08f;
        }
        if (defense > 0.9f) {
            defense = 0.9f;
        }
        if (defense < 0.0f) {
            defense = 0.0f;
        }
        return defense;
    }

    @Override
    public int getLV() {
        return 125;
    }

    @Override
    public float getExtraAttack() {
        return 0.0f;
    }

    @Override
    public int getFightPower() {
        return 0;
    }

    @Override
    public int getPenetrationDefense() {
        return 325;
    }

    @Override
    public boolean canPlayerAttackThis(EntityPlayer player, boolean is2Job) {
        return is2Job;
    }

    @Override
    public float[] getShield() {
        return shield;
    }

    @Override
    public int getDeadCount(Entity Entity2) {
        return this.deadCount;
    }

    @Override
    public void addDeadCount(Entity Entity2) {
        ++this.deadCount;
    }

    @Override
    public int getMaxDeadCount(Entity Entity2) {
        return 10;
    }

    @Override
    public void deadEffect(Entity Entity2) {
        this.combat -= 5;
    }

    public void func_82196_d(EntityLivingBase target, float rage) {
        if (this.canChangeStyle && this.style == AstridStyle.Range && this.arrowstorm < 300) {
            int attack = this.attack(5000);
            ProjectileHelp.doArrowAttack((EntityLivingBase)this, target, attack, true, false, 10, 0);
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (player.func_71045_bC() != null) {
            if (player.func_71045_bC().func_77973_b() == ManaMetalMod.rainbowapple) {
                if (player.func_70093_af()) {
                    if (this.combat == 100) {
                        this.combat = 50;
                        this.setCombat(this.combat);
                    } else if (this.combat > 50) {
                        this.combat = 80;
                        this.setCombat(this.combat);
                    } else {
                        this.combat = 50;
                        this.setCombat(this.combat);
                    }
                } else if (this.styleCount < 29) {
                    this.styleCount = 29;
                    this.setStyleCount(this.styleCount);
                } else if (this.styleCount < 59) {
                    this.styleCount = 59;
                    this.setStyleCount(this.styleCount);
                } else if (this.styleCount < 89) {
                    this.styleCount = 89;
                    this.setStyleCount(this.styleCount);
                }
                return true;
            }
            if (player.func_71045_bC().func_77973_b() == ItemCraft10.ItemRosePoisonCrystal) {
                this.rosePoison = 120;
                MMM.removePlayerCurrentItem(player);
                this.field_70170_p.func_72926_e(2002, (int)Math.round(this.field_70165_t), (int)Math.round(this.field_70163_u), (int)Math.round(this.field_70161_v), 0);
                this.styleAttack = (int)((float)this.styleAttack * 0.7f);
                return true;
            }
        }
        return false;
    }

    public void spawnRuneFXServerSound(EntityLivingBase entity, ManaElements eme, int time, float size, boolean sound, int range) {
        EntityBlossRune rune = new EntityBlossRune(entity.field_70170_p, time, eme, size);
        rune.func_70080_a(entity.field_70165_t, entity.field_70163_u - 1.0, entity.field_70161_v, 0.0f, 0.0f);
        if (entity instanceof EntityMob || entity instanceof IMob) {
            rune.isMob = true;
        }
        if (!entity.field_70170_p.field_72995_K) {
            entity.field_70170_p.func_72838_d((Entity)rune);
            if (sound) {
                MMM.playSoundFromServer(entity.field_70170_p, ManaElements.getElementsSounds(eme), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 2.0, 1.0, range);
            }
        }
    }

    @Override
    public InstanceDungeonType getDungeonType() {
        return InstanceDungeonType.RoseGarden;
    }

    public static enum AstridStyle {
        Melee,
        Range,
        Magic;

    }
}

