/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.api.weapon;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.api.IQualityItem;
import project.studio.manametalmod.api.ISpecialItem;
import project.studio.manametalmod.api.Quality;
import project.studio.manametalmod.core.ManaItemType;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.entity.nbt.NbtBaubles;
import project.studio.manametalmod.inventory.ContainerManaItem;
import project.studio.manametalmod.magic.magicItem.IMagicEffect;
import project.studio.manametalmod.magic.magicItem.IMagicItemData;
import project.studio.manametalmod.magic.magicItem.MagicItemType;

public abstract class IMagicItem
extends Item
implements ISpecialItem,
IQualityItem {
    public IIcon[] icons;
    public String Names;
    public int size;
    public static final List<IMagicItemData> IMagicItemList = new ArrayList<IMagicItemData>();

    public IMagicItem(String Name) {
        this.func_77637_a(ManaMetalMod.tab_MMMBaubles);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_111206_d("");
        this.func_77655_b("");
        this.size = this.TypeCount();
        this.icons = new IIcon[this.size];
        this.Names = Name;
        this.setNoRepair();
        IMagicItemList.add(new IMagicItemData(this, this.TypeCount()));
    }

    public boolean func_77616_k(ItemStack item) {
        return false;
    }

    public abstract ManaItemType getType(ItemStack var1);

    public abstract int getNeedLV(ItemStack var1, EntityPlayer var2);

    public abstract int TypeCount();

    public abstract List<IMagicEffect> getItemEffect(ItemStack var1);

    public abstract void onEquipment(ItemStack var1, EntityLivingBase var2);

    public abstract void onDisrobe(ItemStack var1, EntityLivingBase var2);

    @Deprecated
    public abstract void onBeAttack(ItemStack var1, EntityPlayer var2, EntityLivingBase var3, DamageSource var4);

    @Deprecated
    public abstract void onAttack(ItemStack var1, EntityPlayer var2, EntityLivingBase var3, DamageSource var4);

    @Deprecated
    public abstract void onCrit(ItemStack var1, EntityPlayer var2, EntityLivingBase var3, DamageSource var4);

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean booleans) {
        list.add(EnumChatFormatting.GREEN + MMM.getTranslateText("manaItemType." + this.getType(item).toString()));
        IMagicEffect.addInformation(item, player, list, this.getItemEffect(item));
        int flydata = NbtBaubles.hasFlyMagic(item);
        if (flydata > 0) {
            list.add(EnumChatFormatting.AQUA + MMM.getTranslateText("manaItem.flydata") + "+" + flydata);
        }
    }

    public static boolean hasMagicData(ItemStack item) {
        if (item.func_77942_o()) {
            return item.func_77978_p().func_150297_b("effectData", 9);
        }
        return false;
    }

    public static void addMagicDataLore(ItemStack item, List list, EntityPlayer player) {
        ArrayList<IMagicEffect> effects = new ArrayList<IMagicEffect>();
        NBTTagList data = item.func_77978_p().func_150295_c("effectData", 10);
        for (int s = 0; s < data.func_74745_c(); ++s) {
            NBTTagCompound tag = new NBTTagCompound();
            effects.add(new IMagicEffect(MagicItemType.values()[tag.func_74762_e("effectData_type")], tag.func_74760_g("effectData_count")));
        }
        IMagicEffect.addInformation(item, player, list, effects);
    }

    public int hasFlyMagic(ItemStack item) {
        if (item.func_77978_p().func_150297_b("flydata", 3)) {
            return item.func_77978_p().func_74762_e("flydata");
        }
        return 0;
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            ManaMetalModRoot root = MMM.getEntityNBT(player);
            if (root.carrer.getLv() >= this.getNeedLV(item, player) && this.useMagicItem(item, world, player, root)) {
                --item.field_77994_a;
                return item;
            }
        }
        return item;
    }

    public boolean tryPushItem(int slot, ManaMetalModRoot root, ItemStack item, World world) {
        if (root.item.func_70301_a(slot) == null) {
            if (this.getType(item) != ManaItemType.Ring) {
                for (int s = 0; s < root.item.func_70302_i_(); ++s) {
                    if (root.item.func_70301_a(s) == null || !MMM.isItemStackEqualNoNBT(item, root.item.func_70301_a(s))) continue;
                    return false;
                }
            }
            root.item.func_70299_a(slot, item.func_77946_l());
            root.item.wearItem(item.func_77946_l(), true);
            return true;
        }
        return false;
    }

    public boolean useMagicItem(ItemStack item, World world, EntityPlayer player, ManaMetalModRoot root) {
        try {
            for (int s = 0; s < ContainerManaItem.slots.length; ++s) {
                if (s == 41 || ContainerManaItem.slots[s] == null || ContainerManaItem.slots[s] != this.getType(item) || !this.tryPushItem(s, root, item, world)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public abstract long getValue(ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta < this.icons.length) {
            return this.icons[meta];
        }
        return this.icons[0];
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public String func_77667_c(ItemStack is) {
        if (is.func_77960_j() < this.size) {
            return super.func_77667_c(is) + this.Names + is.func_77960_j();
        }
        return super.func_77667_c(is);
    }

    public String getMODID() {
        return MMM.getMODID();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        for (int i = 0; i < this.size; ++i) {
            this.icons[i] = reg.func_94245_a(this.getMODID() + ":" + this.Names + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itm, CreativeTabs tab, List lst) {
        for (int i = 0; i < this.size; ++i) {
            lst.add(new ItemStack(itm, 1, i));
        }
    }

    @Override
    public Quality getQuality(ItemStack item) {
        return Quality.Normal;
    }
}

