/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.archeology;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.archeology.ObjectArcheology;
import project.studio.manametalmod.archeology.ObjectArcheologyType;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Particle;
import project.studio.manametalmod.core.TileEntityUpdate;
import project.studio.manametalmod.instance_dungeon.IDungeonDifficult;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonType;

public class TileEntityArcheology
extends TileEntityUpdate {
    public ObjectArcheology[] obj;
    public InstanceDungeonType DungeonType = InstanceDungeonType.FireDungeon;
    public IDungeonDifficult diff = IDungeonDifficult.EASY;
    public boolean digging = false;
    public int textures = 0;
    boolean particlesFX = false;
    public boolean advanced = false;

    public void particlesFX() {
        this.particlesFX = true;
    }

    public void onDigging() {
        this.digging = true;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(4), 2);
        this.textures = this.field_145850_b.field_73012_v.nextBoolean() ? 1 : 0;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_150297_b("ObjectArcheology", 9)) {
            this.obj = new ObjectArcheology[16];
            NBTTagList list = tag.func_150295_c("ObjectArcheology", 10);
            for (int s = 0; s < list.func_74745_c(); ++s) {
                if (s >= this.obj.length) continue;
                this.obj[s] = new ObjectArcheology();
                this.obj[s].readFromNBT(list.func_150305_b(s));
            }
        }
        this.digging = NBTHelp.getBooleanSafe("digging", tag, false);
        this.textures = NBTHelp.getIntSafe("textures", tag, 0);
        this.advanced = NBTHelp.getBooleanSafe("advanced", tag, false);
        this.DungeonType = InstanceDungeonType.values()[NBTHelp.getIntSafe("DungeonType", tag, 0)];
        this.diff = IDungeonDifficult.values()[NBTHelp.getIntSafe("diff", tag, 0)];
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.obj != null) {
            NBTTagList list = new NBTTagList();
            for (int s = 0; s < this.obj.length; ++s) {
                NBTTagCompound nbt = new NBTTagCompound();
                this.obj[s].writeToNBT(nbt);
                list.func_74742_a((NBTBase)nbt);
            }
            tag.func_74782_a("ObjectArcheology", (NBTBase)list);
        }
        tag.func_74757_a("digging", this.digging);
        tag.func_74768_a("textures", this.textures);
        tag.func_74757_a("advanced", this.advanced);
        tag.func_74768_a("DungeonType", this.DungeonType.ordinal());
        tag.func_74768_a("diff", this.diff.ordinal());
    }

    public static int getBaseStoneHP(ObjectArcheologyType type) {
        switch (type) {
            case stone: {
                return 105;
            }
            case andesite: {
                return 70;
            }
            case diorite: {
                return 133;
            }
        }
        return 0;
    }

    public void set() {
        if (!this.field_145850_b.field_72995_K) {
            this.obj = new ObjectArcheology[16];
            ObjectArcheologyType stone = ObjectArcheologyType.stone;
            int stonetype = this.field_145850_b.field_73012_v.nextInt(100);
            if (stonetype < 15) {
                stone = ObjectArcheologyType.diorite;
            } else if (stonetype < 30) {
                stone = ObjectArcheologyType.andesite;
            }
            for (int s = 0; s < this.obj.length; ++s) {
                this.obj[s] = new ObjectArcheology();
                this.obj[s].levels[1] = stone;
                this.obj[s].objectHP[1] = this.getStoneHP(stone);
                this.obj[s].hasItem = this.advanced ? this.field_145850_b.field_73012_v.nextInt(100) > 20 : this.field_145850_b.field_73012_v.nextBoolean();
                if (this.field_145850_b.field_73012_v.nextInt(100) < 10) {
                    int type2 = this.field_145850_b.field_73012_v.nextInt(100);
                    if (type2 < 20) {
                        this.obj[s].levels[2] = ObjectArcheologyType.gravel;
                        this.obj[s].objectHP[2] = this.field_145850_b.field_73012_v.nextInt(7);
                    } else if (type2 < 90) {
                        this.obj[s].levels[2] = ObjectArcheologyType.sand;
                        this.obj[s].objectHP[2] = this.field_145850_b.field_73012_v.nextInt(7);
                    } else {
                        this.obj[s].levels[2] = ObjectArcheologyType.web;
                        this.obj[s].objectHP[2] = 1;
                    }
                } else {
                    this.obj[s].levels[2] = ObjectArcheologyType.none;
                }
                if (this.field_145850_b.field_73012_v.nextInt(100) < 15) {
                    int type0 = this.field_145850_b.field_73012_v.nextInt(100);
                    if (type0 < 30) {
                        this.obj[s].levels[0] = ObjectArcheologyType.gravel;
                        this.obj[s].objectHP[0] = this.field_145850_b.field_73012_v.nextInt(7);
                        continue;
                    }
                    if (type0 < 75) {
                        this.obj[s].levels[0] = ObjectArcheologyType.sand;
                        this.obj[s].objectHP[0] = this.field_145850_b.field_73012_v.nextInt(7);
                        continue;
                    }
                    this.obj[s].levels[0] = ObjectArcheologyType.web;
                    this.obj[s].objectHP[0] = 1;
                    continue;
                }
                this.obj[s].levels[0] = ObjectArcheologyType.none;
            }
        }
    }

    public int getStoneHP(ObjectArcheologyType type) {
        return this.field_145850_b.field_73012_v.nextInt(4) > 0 ? TileEntityArcheology.getBaseStoneHP(type) : (int)((float)TileEntityArcheology.getBaseStoneHP(type) - (float)TileEntityArcheology.getBaseStoneHP(type) * (this.field_145850_b.field_73012_v.nextFloat() * 0.3f));
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K && (this.particlesFX || this.digging)) {
            for (int s = 0; s < 2; ++s) {
                double d0 = (float)this.field_145851_c + this.field_145850_b.field_73012_v.nextFloat() - 0.5f;
                double d1 = (float)this.field_145848_d + (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.4f;
                double d2 = (float)this.field_145849_e + this.field_145850_b.field_73012_v.nextFloat() - 0.5f;
                FXHelp.spawnParticle(this.field_145850_b, Particle.shining_rainbow, d0 + (double)0.65f, d1, d2 + 0.5, 0.0, 0.0, 0.0, -1.0f, true);
            }
            this.particlesFX = false;
        }
    }
}

