/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.blueprint;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import project.studio.manametalmod.MMM;

public class SchematicExport {
    public static void saveToSchematic(String name, short Width, short Height2, short Length, World world, int x, int y, int z) {
        try {
            NBTTagCompound nbtdata = new NBTTagCompound();
            nbtdata.func_74777_a("Width", (short)Width);
            nbtdata.func_74777_a("Height", (short)Height2);
            nbtdata.func_74777_a("Length", (short)Length);
            byte[] blocks = new byte[Width * Height2 * Length];
            byte[] data = new byte[Width * Height2 * Length];
            int d = 0;
            for (int dy = 0; dy < Height2; ++dy) {
                for (int dz = 0; dz < Length; ++dz) {
                    for (int dx = 0; dx < Width; ++dx) {
                        blocks[d] = (byte)Block.func_149682_b((Block)world.func_147439_a(x + dx + 1, y + dy, z + dz + 1));
                        data[d] = (byte)world.func_72805_g(x + dx + 1, y + dy, z + dz + 1);
                        ++d;
                    }
                }
            }
            nbtdata.func_74773_a("Blocks", blocks);
            nbtdata.func_74773_a("Data", data);
            MMM.Logg("Schematic size:" + Width + " x " + Height2 + " x " + Length);
            File file = new File(DimensionManager.getCurrentSaveRootDirectory(), "ManaMetalMod/SchematicExport/" + name + ".schematic");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                MMM.Logg("Folder does not exist : ManaMetalMod/SchematicExport/");
            }
            CompressedStreamTools.func_74795_b((NBTTagCompound)nbtdata, (File)file);
            return;
        }
        catch (Exception e) {
            MMM.Error("can't save schematic");
            e.printStackTrace();
            return;
        }
    }
}

