/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import com.google.gson.Gson;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.MMM;

public class AbstractItemStack {
    public String name;
    public String modid;
    public int count;
    public int damage;
    public ItemStack cacheitem = null;
    public NBTTagCompound itemTag = null;

    public AbstractItemStack(String modid, String name, int count, int damage) {
        this(modid, name, count, damage, null);
    }

    public AbstractItemStack(String modid, String name, int count, int damage, NBTTagCompound itemTag) {
        this.name = name;
        this.modid = modid;
        this.count = count;
        this.damage = damage;
        this.itemTag = itemTag;
    }

    public ItemStack toItemStack() {
        if (this.cacheitem == null) {
            this.cacheitem = MMM.findItemStack(this.name, this.modid, this.count, this.damage);
            if (this.itemTag != null) {
                this.cacheitem.func_77982_d(this.itemTag);
            }
        }
        return this.cacheitem;
    }

    public static AbstractItemStack fromItemStack(ItemStack item) {
        String[] ID = Item.field_150901_e.func_148750_c((Object)item.func_77973_b()).split(":");
        return new AbstractItemStack(ID[0], ID[1], item.field_77994_a, item.func_77960_j(), item.func_77978_p());
    }

    public void saveToNBT(NBTTagCompound tag) {
        tag.func_74778_a("modid", this.modid);
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("count", this.count);
        tag.func_74768_a("damage", this.damage);
        if (this.itemTag != null) {
            tag.func_74782_a("itemTag", (NBTBase)this.itemTag);
        }
    }

    public static AbstractItemStack readFromNBT(NBTTagCompound tag) {
        return new AbstractItemStack(tag.func_74779_i("modid"), tag.func_74779_i("name"), tag.func_74762_e("count"), tag.func_74762_e("damage"), tag.func_150297_b("itemTag", 10) ? tag.func_74775_l("itemTag") : null);
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }
}

