/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.Pos;

public class Location
extends Pos {
    public int DimensionID = 0;

    public Location() {
        this.X = 199999999;
        this.Y = 199999999;
        this.Z = 199999999;
        this.DimensionID = 0;
    }

    public Location(ChunkCoordinates coord, int id) {
        super(coord);
        this.DimensionID = id;
    }

    public Location(Vec3 vc3, int id) {
        super(vc3);
        this.DimensionID = id;
    }

    public Location(MovingObjectPosition mop, int id) {
        super(mop);
        this.DimensionID = id;
    }

    public Location(int x, int y, int z, int id) {
        super(x, y, z);
        this.DimensionID = id;
    }

    public Location(float x, float y, float z, int id) {
        super(x, y, z);
        this.DimensionID = id;
    }

    public Location(double x, double y, double z, int id) {
        super(x, y, z);
        this.DimensionID = id;
    }

    public Location(int x, int y, int z) {
        super(x, y, z);
    }

    public Location(float x, float y, float z) {
        super(x, y, z);
    }

    public Location(double x, double y, double z) {
        super(x, y, z);
    }

    public Location(TileEntity tile) {
        super(tile);
        this.DimensionID = MMM.getDimensionID(tile.func_145831_w());
    }

    public Location(Entity entity) {
        super(entity);
        this.DimensionID = MMM.getDimensionID(entity.field_70170_p);
    }

    public Location(Location pos) {
        super(pos);
    }

    public Location(Pos pos) {
        super(pos);
    }

    @Override
    public Location copy() {
        return new Location(this);
    }

    @Override
    public String toString() {
        return "[Pos] X:" + this.X + " Y:" + this.Y + " Z:" + this.Z + " DID:" + this.DimensionID;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Location) {
            Location pos = (Location)object;
            if (pos.X == this.X && pos.Y == this.Y && pos.Z == this.Z && pos.DimensionID == this.DimensionID) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canReadFromNBT(NBTTagCompound nbt) {
        return nbt.func_150297_b("DimensionID", 3) && super.canReadFromNBT(nbt);
    }

    @Override
    public void saveToNBT(NBTTagCompound nbt) {
        super.saveToNBT(nbt);
        nbt.func_74768_a("DimensionID", this.DimensionID);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.DimensionID = nbt.func_74762_e("DimensionID");
    }

    @Override
    public boolean canReadFromNBT(NBTTagCompound nbt, int id) {
        return nbt.func_150297_b("DimensionID" + id, 3) && super.canReadFromNBT(nbt, id);
    }

    @Override
    public void saveToNBT(NBTTagCompound nbt, int id) {
        super.saveToNBT(nbt, id);
        nbt.func_74768_a("DimensionID" + id, this.DimensionID);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, int id) {
        super.readFromNBT(nbt, id);
        this.DimensionID = nbt.func_74762_e("DimensionID" + id);
    }
}

