/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.entity.nbt;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.core.EntityNBTBaseM3;
import project.studio.manametalmod.core.Icommodity;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.npc.EntityNpc;
import project.studio.manametalmod.npc.IChat;
import project.studio.manametalmod.npc.NpcBattleCardLV;
import project.studio.manametalmod.npc.NpcGender;
import project.studio.manametalmod.npc.NpcRace;
import project.studio.manametalmod.npc.NpcRandomData;
import project.studio.manametalmod.npc.NpcStoreType;
import project.studio.manametalmod.npc.NpcSuite;
import tw.pearki.mcmod.muya.common.SendType;

public class NbtNpcData
extends EntityNBTBaseM3 {
    public final ManaMetalModRoot obj;
    public int guiType = 0;
    public int battleCardPower = 100;
    public NpcBattleCardLV BattleCardLV = NpcBattleCardLV.Ordinary;
    public List<Icommodity> storesList = null;
    public List<IChat> npcChats = new ArrayList<IChat>();
    public boolean updateData = false;
    public String NpcName = "";
    public String NpcLastName = "";
    public NpcRace Race = NpcRace.Humanity;
    public ItemStack[] Card;
    public ItemStack[] CardStack;
    public String storeName = "store";
    public boolean hasSpawn = false;
    public NpcStoreType type = NpcStoreType.other1;
    public boolean custom_store = false;
    public int store_seedV2 = 0;

    public NbtNpcData(ManaMetalModRoot obj) {
        this.obj = obj;
    }

    public boolean testCard() {
        return this.Card != null && this.Card.length == 5 && this.CardStack != null && this.CardStack.length == 10;
    }

    public EntityNpc getNPC() {
        return (EntityNpc)this.entity;
    }

    protected void Init() {
        this.setRandomNpc();
    }

    public void setRandomNpc() {
        NpcStoreType storeType;
        if (this.hasSpawn) {
            return;
        }
        EntityNpc npc = (EntityNpc)this.entity;
        this.hasSpawn = true;
        NpcSuite NpcSuite2 = new NpcSuite();
        if (npc.gender == NpcGender.Male) {
            NpcSuite2 = ManaMetalAPI.NpcSuiteHumanMale.get(NpcRandomData.random.nextInt(ManaMetalAPI.NpcSuiteHumanMale.size()));
            this.NpcName = NpcRandomData.getNpcName(NpcGender.Male);
        } else {
            NpcSuite2 = ManaMetalAPI.NpcSuiteHumanFemale.get(NpcRandomData.random.nextInt(ManaMetalAPI.NpcSuiteHumanFemale.size()));
            this.NpcName = NpcRandomData.getNpcName(NpcGender.Female);
        }
        this.npcChats = NpcSuite2.npcChats;
        this.Race = NpcSuite2.race;
        this.type = storeType = NpcStoreType.getTypeRandom();
        this.storesList = null;
        this.custom_store = false;
        this.store_seedV2 = MMM.rand.nextInt();
        this.storeName = this.type.toString();
        NpcBattleCardLV BattleCardLV = NpcBattleCardLV.getRandomNpcBattleCardLV(NpcRandomData.random);
        this.Card = NpcRandomData.getRendemCards(5, BattleCardLV);
        this.CardStack = NpcRandomData.getRendemCards(10, BattleCardLV);
        this.setBattleCardLV(BattleCardLV);
        this.setBattleCardPower(NpcRandomData.getBattleCardPower(this.Card) + NpcRandomData.getBattleCardPower(this.CardStack));
        npc.func_94058_c(this.NpcName);
        npc.func_110163_bv();
    }

    public void setNpc(NpcSuite NpcSuite2) {
        this.NpcName = NpcSuite2.npcName;
        this.npcChats = NpcSuite2.npcChats;
        this.Race = NpcSuite2.race;
        this.storesList = NpcSuite2.storesList;
    }

    public void setNpcTextName() {
    }

    public void setClear() {
        this.storesList = new ArrayList<Icommodity>();
        this.npcChats = new ArrayList<IChat>();
        this.guiType = 0;
    }

    public List<Icommodity> getStores() {
        return this.storesList;
    }

    public List<IChat> getChats() {
        return this.npcChats;
    }

    public void setStores(List<Icommodity> list) {
        this.storesList = list;
    }

    public void setChats(List<IChat> list) {
        this.npcChats = list;
    }

    public int getTpye() {
        return this.guiType;
    }

    public void setTpye(int type) {
        this.guiType = type;
    }

    public void LoadNBT(NBTTagCompound nbt) {
        int i;
        this.store_seedV2 = NBTHelp.getIntSafe("store_seedV2", nbt, 0);
        this.custom_store = NBTHelp.getBooleanSafe("custom_store", nbt, false);
        this.type = NpcStoreType.values()[NBTHelp.getIntSafe("NpcStoreType", nbt, 0)];
        this.guiType = nbt.func_74762_e("guiType");
        this.NpcName = nbt.func_74779_i("NpcName");
        this.storeName = nbt.func_74779_i("storeName");
        this.hasSpawn = nbt.func_74767_n("hasSpawn");
        this.setBattleCardPower(nbt.func_74762_e("battleCardPower"));
        this.setBattleCardLV(NpcBattleCardLV.values()[nbt.func_74762_e("BattleCardLV")]);
        this.Race = NpcRace.getTypeFromID(nbt.func_74762_e("Race"));
        if (nbt.func_150297_b("storesList", 9)) {
            NBTTagList nbttaglist = nbt.func_150295_c("storesList", 10);
            this.storesList = new ArrayList<Icommodity>();
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbtItems = nbttaglist.func_150305_b(i);
                Icommodity item = new Icommodity();
                item.loadFromNBT(nbtItems);
                this.storesList.add(item);
            }
        } else {
            this.storesList = null;
        }
        NBTTagList nbttaglist2 = nbt.func_150295_c("npcChats", 10);
        this.npcChats = new ArrayList<IChat>();
        for (i = 0; i < nbttaglist2.func_74745_c(); ++i) {
            NBTTagCompound chatsitem = nbttaglist2.func_150305_b(i);
            IChat chat = new IChat();
            chat.loadFromNBT(chatsitem);
            this.npcChats.add(chat);
        }
        NBTTagList nbttaglist3 = nbt.func_150295_c("Card", 10);
        this.Card = new ItemStack[5];
        for (int z = 0; z < 5; ++z) {
            NBTTagCompound card = nbttaglist3.func_150305_b(z);
            this.Card[z] = ItemStack.func_77949_a((NBTTagCompound)card);
        }
        NBTTagList nbttaglist4 = nbt.func_150295_c("CardStack", 10);
        this.CardStack = new ItemStack[10];
        for (int z = 0; z < 10; ++z) {
            NBTTagCompound card = nbttaglist4.func_150305_b(z);
            this.CardStack[z] = ItemStack.func_77949_a((NBTTagCompound)card);
        }
    }

    @Override
    public void SaveNBT(SendType type, NBTTagCompound nbt) {
        nbt.func_74768_a("store_seedV2", this.store_seedV2);
        nbt.func_74757_a("custom_store", this.custom_store);
        nbt.func_74768_a("NpcStoreType", this.type.ordinal());
        nbt.func_74768_a("guiType", this.guiType);
        nbt.func_74778_a("NpcName", this.NpcName);
        nbt.func_74778_a("storeName", this.storeName);
        nbt.func_74768_a("Race", this.Race.getID());
        nbt.func_74757_a("hasSpawn", this.hasSpawn);
        nbt.func_74768_a("battleCardPower", this.getBattleCardPower());
        nbt.func_74768_a("BattleCardLV", this.getBattleCardLV().ordinal());
        if (this.storesList != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int z = 0; z < this.storesList.size(); ++z) {
                Icommodity item = this.storesList.get(z);
                NBTTagCompound nbtItems = new NBTTagCompound();
                item.saveToNBT(nbtItems);
                nbttaglist.func_74742_a((NBTBase)nbtItems);
            }
            nbt.func_74782_a("storesList", (NBTBase)nbttaglist);
        }
        NBTTagList nbttaglistchat = new NBTTagList();
        for (int s = 0; s < this.npcChats.size(); ++s) {
            NBTTagCompound chats = new NBTTagCompound();
            this.npcChats.get(s).saveToNBT(chats);
            nbttaglistchat.func_74742_a((NBTBase)chats);
        }
        nbt.func_74782_a("npcChats", (NBTBase)nbttaglistchat);
        NBTTagList nbttaglist2 = new NBTTagList();
        if (this.Card != null) {
            for (int s = 0; s < 5; ++s) {
                NBTTagCompound cards = new NBTTagCompound();
                if (this.Card[s] == null) continue;
                this.Card[s].func_77955_b(cards);
                nbttaglist2.func_74742_a((NBTBase)cards);
            }
            nbt.func_74782_a("Card", (NBTBase)nbttaglist2);
        }
        NBTTagList nbttaglist3 = new NBTTagList();
        if (this.CardStack != null) {
            for (int s = 0; s < 10; ++s) {
                NBTTagCompound cards = new NBTTagCompound();
                if (this.CardStack[s] == null) continue;
                this.CardStack[s].func_77955_b(cards);
                nbttaglist3.func_74742_a((NBTBase)cards);
            }
            nbt.func_74782_a("CardStack", (NBTBase)nbttaglist3);
        }
    }

    public void send2() {
        if (this.GetSide().isServer()) {
            this.Send();
        }
    }

    public void Update() {
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public int getBattleCardPower() {
        return this.battleCardPower;
    }

    public void setBattleCardPower(int battleCardPower) {
        this.battleCardPower = battleCardPower;
    }

    public NpcBattleCardLV getBattleCardLV() {
        return this.BattleCardLV;
    }

    public void setBattleCardLV(NpcBattleCardLV battleCardLV) {
        this.BattleCardLV = battleCardLV;
    }
}

