/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.entity.nbt;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.core.EntityNBTBaseM3;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.network.MessageManaSpecialization;
import tw.pearki.mcmod.muya.common.SendType;

public class NbtSpecialization
extends EntityNBTBaseM3 {
    public int pointNew = 4;
    public int usePoint = 4;
    public int eatBook = 0;
    public static final int maxBook = 10;
    private boolean[] effect = new boolean[81];
    protected final ManaMetalModRoot obj;

    public void remove() {
        this.pointNew = this.usePoint;
        for (int s = 0; s < this.effect.length; ++s) {
            if (this.effect[s]) {
                MessageManaSpecialization.addEffect(this.obj, (EntityPlayerMP)this.entity, s, true);
            }
            this.effect[s] = false;
        }
        this.send2();
    }

    public void apply() {
        for (int s = 0; s < this.effect.length; ++s) {
            if (!this.effect[s]) continue;
            MessageManaSpecialization.addEffect(this.obj, (EntityPlayerMP)this.entity, s, false);
        }
        this.send2();
    }

    public void send() {
        if (this.GetSide().isServer()) {
            this.Send();
        }
    }

    public void send2() {
        if (this.entity instanceof EntityPlayerMP) {
            this.SendTo((EntityPlayerMP)this.entity);
        }
    }

    public NbtSpecialization(ManaMetalModRoot obj) {
        this.obj = obj;
    }

    public Class<? extends EntityLivingBase> AddChildCondition() {
        return EntityPlayer.class;
    }

    public int getPointNew() {
        return this.pointNew;
    }

    public void addPoint(int ammon) {
        this.pointNew += ammon;
        this.send2();
    }

    public void setPointNew(int ammon) {
        this.pointNew = ammon;
        this.send2();
    }

    public void LoadNBT(NBTTagCompound nbt) {
        this.pointNew = NBTHelp.getIntSafe("pointNew", nbt, 4);
        this.usePoint = NBTHelp.getIntSafe("usePoint", nbt, 4);
        this.eatBook = NBTHelp.getIntSafe("eatBook", nbt, 0);
        this.effect = new boolean[81];
        for (int s = 0; s < this.effect.length; ++s) {
            this.effect[s] = NBTHelp.getBooleanSafe("e" + s, nbt, false);
        }
    }

    @Override
    public void SaveNBT(SendType type, NBTTagCompound nbt) {
        nbt.func_74768_a("pointNew", this.pointNew);
        nbt.func_74768_a("usePoint", this.usePoint);
        nbt.func_74768_a("eatBook", this.eatBook);
        for (int s = 0; s < this.effect.length; ++s) {
            nbt.func_74757_a("e" + s, this.effect[s]);
        }
    }

    public void Update() {
    }

    public boolean[] getEffect() {
        return this.effect;
    }

    public boolean getEffect(int index) {
        return this.effect[index];
    }

    public boolean getMainEffect(MainSpecialization index) {
        switch (index.ordinal()) {
            case 0: {
                return this.effect[0];
            }
            case 1: {
                return this.effect[8];
            }
            case 2: {
                return this.effect[72];
            }
            case 3: {
                return this.effect[80];
            }
        }
        return false;
    }

    public static MainSpecialization getMainEffectType(int index) {
        switch (index) {
            case 0: {
                return MainSpecialization.upperLeft;
            }
            case 8: {
                return MainSpecialization.upperRight;
            }
            case 72: {
                return MainSpecialization.bottomLeft;
            }
            case 80: {
                return MainSpecialization.bottomRight;
            }
        }
        return null;
    }

    public static int getID(MainSpecialization index) {
        switch (index) {
            case upperLeft: {
                return 0;
            }
            case upperRight: {
                return 8;
            }
            case bottomLeft: {
                return 72;
            }
            case bottomRight: {
                return 80;
            }
        }
        return -1;
    }

    public static final boolean isMainEffect(int index) {
        return NbtSpecialization.getID(MainSpecialization.upperLeft) == index || NbtSpecialization.getID(MainSpecialization.upperRight) == index || NbtSpecialization.getID(MainSpecialization.bottomLeft) == index || NbtSpecialization.getID(MainSpecialization.bottomRight) == index;
    }

    public void setEffect(boolean[] effect) {
        this.effect = effect;
        this.send2();
    }

    public void setEffect(boolean effect, int index) {
        this.effect[index] = effect;
        this.send2();
    }

    protected void Init() {
    }

    public static enum MainSpecialization {
        upperLeft,
        upperRight,
        bottomLeft,
        bottomRight;

    }
}

