/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.event;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.api.IFood;
import project.studio.manametalmod.api.IFreezerContainer;
import project.studio.manametalmod.blocks.BlockTileEntityIceBox;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.Craft;
import project.studio.manametalmod.core.HumanReformMagic;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.event.EventGUI;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft3;
import project.studio.manametalmod.items.ItemFoodRoot;
import project.studio.manametalmod.produce.cuisine.TileEntityIceBox;
import project.studio.manametalmod.produce.fishing.FishingCore;
import project.studio.manametalmod.season.WorldSeason;
import project.studio.manametalmod.target.TargetTrigger;
import project.studio.manametalmod.world.thuliumempire.DemonReform;

public class EventFoodRot {
    public static final int maxFoodTime = 800;
    public static Item rotFood = new ItemFoodRoot("rotFood").func_77637_a(ManaMetalMod.tab_Foods);
    public static Item rotEgg = new ItemFoodRoot("rotEgg").func_77637_a(ManaMetalMod.tab_Foods);
    public static int rootDebugTime = 0;
    public static final String hasHoney = MMM.getTranslateText("item.food.hasHoney");
    public static final String foodSalted = MMM.getTranslateText("item.food.rootsalt");
    public static final String hasHoneyLore = "\ue008\ue00e" + MMM.getTranslateText("item.food.hasHoney.effect");
    public static final String foodSaltedLore = "\ue008\ue00e" + MMM.getTranslateText("item.food.rootsalt.effect");
    public static final String foodCantFreezer = "\ue008\ue00e" + MMM.getTranslateText("item.food.cant.freezer");
    public static final String newfood = MMM.getTranslateText("item.food.rottime.new");
    public static final String rootfood1 = MMM.getTranslateText("item.food.rottime.root2");
    public static final String rootfood2 = MMM.getTranslateText("item.food.rottime.root");
    public static final String rootfood3 = MMM.getTranslateText("item.food.rottime.root3");

    public static void init() {
        GameRegistry.registerItem((Item)rotFood, (String)"rotFood");
        GameRegistry.registerItem((Item)rotEgg, (String)"rotEgg");
        ManaMetalAPI.FoodRootBlackList.add(Items.field_151070_bp);
        ManaMetalAPI.FoodRootBlackList.add(Items.field_151078_bh);
        ManaMetalAPI.FoodRootBlackList.add((Item)ManaMetalMod.salt);
        ManaMetalAPI.FoodRootBlackList.add((Item)ManaMetalMod.saltingot);
        ManaMetalAPI.FoodRootBlackList.add((Item)ManaMetalMod.sugaringot);
        ManaMetalAPI.FoodRootItemList.put(Items.field_151015_O, rotFood);
        ManaMetalAPI.FoodRootItemList.put(Items.field_151110_aK, rotEgg);
        ManaMetalAPI.FoodRootItemList.put(Item.func_150898_a((Block)Blocks.field_150423_aK), rotFood);
        ManaMetalAPI.FoodRootItemList.put(Item.func_150898_a((Block)Blocks.field_150338_P), rotFood);
        ManaMetalAPI.FoodRootItemList.put(Item.func_150898_a((Block)Blocks.field_150337_Q), rotFood);
        ManaMetalAPI.FoodRootItemList.put(Items.field_151009_A, Items.field_151054_z);
        ManaMetalAPI.FoodRootItemList.put(ItemCraft3.bigMilkCow, ManaMetalMod.bigpotion);
        ManaMetalAPI.FoodRootItemList.put(ItemCraft3.bigMilkSheep, ManaMetalMod.bigpotion);
        ManaMetalAPI.FoodRootItemList.put(Items.field_151117_aB, Items.field_151133_ar);
        ManaMetalAPI.FoodRootItemList.put(Items.field_151105_aU, rotFood);
        ManaMetalAPI.FoodRootItemList.put(Item.func_150898_a((Block)ManaMetalMod.blockChocolate), rotFood);
        ManaMetalAPI.FoodRootItemList.put(Items.field_151105_aU, rotFood);
        Craft.addShapelessRecipe(new ItemStack(Items.field_151016_H, 2), rotEgg, new ItemStack(Items.field_151044_h), Items.field_151065_br);
    }

    public static void ItemTip(List<String> list, ItemStack item) {
        if ((item.func_77973_b() instanceof ItemFood || ManaMetalAPI.FoodRootItemList.containsKey(item.func_77973_b())) && item.func_77942_o() && item.func_77978_p().func_150297_b("foodData", 10)) {
            NBTTagCompound tag = item.func_77978_p().func_74775_l("foodData");
            float time = tag.func_74762_e("foodTime");
            float max = tag.func_74762_e("foodTimeMax");
            float rotdata = time / max;
            StringBuilder sb = new StringBuilder();
            list.add(EventGUI.ItemRoot + (int)(rotdata * 100.0f) + "%");
            if ((double)rotdata < 0.25) {
                sb.append(newfood);
            } else if ((double)rotdata < 0.5) {
                sb.append(rootfood1);
            } else if ((double)rotdata < 0.75) {
                sb.append(rootfood2);
            } else {
                sb.append(rootfood3);
            }
            if (tag.func_74767_n("foodSalted")) {
                sb.append(foodSalted);
                list.add(foodSaltedLore);
            }
            if (tag.func_74767_n("hasHoney")) {
                sb.append(hasHoney);
                list.add(hasHoneyLore);
            }
            int timemax = 800;
            if (item.func_77973_b() instanceof IFood) {
                timemax = ((IFood)item.func_77973_b()).maxRoot(item);
                if (!((IFood)item.func_77973_b()).canFreezer(item)) {
                    list.add(foodCantFreezer);
                }
            }
            list.add(EventGUI.ItemMaxRoot + timemax);
            sb.append(list.get(0));
            if (item.func_77973_b() != FishingCore.fish_M3_Life) {
                list.set(0, sb.toString());
            }
        }
    }

    public static void onEntityItemFoodDropWorld(EntityJoinWorldEvent event) {
        EntityItem items;
        if (!event.world.field_72995_K && ((items = (EntityItem)event.entity).func_92059_d().func_77973_b() instanceof ItemFood || ManaMetalAPI.FoodRootItemList.containsKey(items.func_92059_d().func_77973_b()))) {
            int maxfoodtimetemp = 800;
            if (items.func_92059_d().func_77973_b() instanceof IFood) {
                IFood IFood2 = (IFood)items.func_92059_d().func_77973_b();
                maxfoodtimetemp = IFood2.maxRoot(items.func_92059_d());
                if (!IFood2.canRoot(items.func_92059_d())) {
                    return;
                }
            }
            if (ManaMetalAPI.FoodRootBlackList.contains(items.func_92059_d().func_77973_b())) {
                return;
            }
            if (!items.func_92059_d().func_77942_o() || !items.func_92059_d().func_77978_p().func_150297_b("foodData", 10)) {
                NBTTagCompound nbt = new NBTTagCompound();
                NBTTagCompound data = new NBTTagCompound();
                if (items.func_92059_d().func_77942_o()) {
                    nbt = items.func_92059_d().func_77978_p();
                }
                data.func_74772_a("foodTimeWorld", EventFoodRot.getWorldTime());
                data.func_74768_a("foodTime", 0);
                data.func_74768_a("foodTimeMax", maxfoodtimetemp);
                data.func_74757_a("foodSalted", false);
                data.func_74757_a("foodMarinated", false);
                nbt.func_74782_a("foodData", (NBTBase)data);
                items.func_92059_d().func_77982_d(nbt);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void pickFood(EntityItemPickupEvent event) {
        if (!event.entityPlayer.field_70170_p.field_72995_K) {
            if (event.isCanceled() || ManaMetalAPI.FoodRootBlackList.contains(event.item.func_92059_d().func_77973_b())) {
                return;
            }
            if (event.item.func_92059_d().func_77973_b() instanceof ItemFood || ManaMetalAPI.FoodRootItemList.containsKey(event.item.func_92059_d().func_77973_b())) {
                IFood IFood2;
                TargetTrigger.onPickItem(event.entityPlayer, event.item.func_92059_d().func_77946_l());
                if (event.item.func_92059_d().func_77973_b() instanceof IFood && !(IFood2 = (IFood)event.item.func_92059_d().func_77973_b()).canRoot(event.item.func_92059_d())) {
                    return;
                }
                if (MMM.InventoryPlayerHasSpace(event.entityPlayer) && event.item.func_92059_d().field_77994_a > 0) {
                    ItemStack food = event.item.func_92059_d().func_77946_l();
                    int size = MMM.insertItemStackFoodToPlayer(food, event.entityPlayer);
                    event.item.func_92059_d().field_77994_a = 0;
                    event.setCanceled(true);
                    event.item.func_70106_y();
                    event.entityPlayer.field_70170_p.func_72956_a((Entity)event.entityPlayer, "random.pop", 0.2f, ((event.entityPlayer.field_70170_p.field_73012_v.nextFloat() - event.entityPlayer.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    if (size > 0) {
                        ItemStack foodClone = event.item.func_92059_d().func_77946_l();
                        foodClone.field_77994_a = size;
                        if (event.entityPlayer.field_71071_by.func_70441_a(foodClone)) {
                            event.entityPlayer.func_71019_a(foodClone, true);
                        }
                    }
                }
            }
        }
    }

    public boolean pushPlayerItem(ItemStack item, EntityPlayer player) {
        int size = item.field_77994_a;
        for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
            if (!MMM.isItemStackEqualNoNBT(item, player.field_71071_by.func_70301_a(s)) || player.field_71071_by.func_70301_a(s).func_77976_d() >= player.field_71071_by.func_70301_a((int)s).field_77994_a) continue;
            if ((size -= player.field_71071_by.func_70301_a(s).func_77976_d() - player.field_71071_by.func_70301_a((int)s).field_77994_a) > 0) {
                player.field_71071_by.func_70301_a((int)s).field_77994_a = player.field_71071_by.func_70301_a(s).func_77976_d();
                continue;
            }
            if (size > 0) continue;
            player.field_71071_by.func_70301_a((int)s).field_77994_a += item.field_77994_a;
            return true;
        }
        item.field_77994_a = size;
        return false;
    }

    public static void tickPlayerFood(EntityPlayer player, ManaMetalModRoot obj) {
        if (HumanReformMagic.hasDemonReform(obj, DemonReform.PoisonousHeart) && player.field_70170_p.field_73012_v.nextInt(100) < 50) {
            return;
        }
        EventFoodRot.updatePlayerFoods(player);
    }

    public static ItemStack doOpenBackpakFoodIce(World world, ItemStack itemFood) {
        if (M3Config.FoodRot && M3Config.OpenBackpackFoodRot && (itemFood.func_77973_b() instanceof ItemFood || ManaMetalAPI.FoodRootItemList.containsKey(itemFood.func_77973_b()))) {
            NBTTagCompound nbt;
            boolean canFreezer = true;
            if (ManaMetalAPI.FoodRootBlackList.contains(itemFood.func_77973_b())) {
                return itemFood;
            }
            int maxRoot = 800;
            if (itemFood.func_77973_b() instanceof IFood) {
                IFood IFood2 = (IFood)itemFood.func_77973_b();
                if (!IFood2.canRoot(itemFood)) {
                    return itemFood;
                }
                maxRoot = IFood2.maxRoot(itemFood);
                canFreezer = IFood2.canFreezer(itemFood);
            }
            if (!canFreezer) {
                return EventFoodRot.doOpenBackpakFood(world, itemFood);
            }
            if (!itemFood.func_77942_o() || !itemFood.func_77978_p().func_150297_b("foodData", 10)) {
                nbt = new NBTTagCompound();
                NBTTagCompound data = new NBTTagCompound();
                if (itemFood.func_77942_o()) {
                    nbt = itemFood.func_77978_p();
                }
                data.func_74772_a("foodTimeWorld", EventFoodRot.getWorldTime());
                data.func_74768_a("foodTime", 0);
                data.func_74768_a("foodTimeMax", maxRoot);
                data.func_74757_a("foodSalted", false);
                data.func_74757_a("foodMarinated", false);
                nbt.func_74782_a("foodData", (NBTBase)data);
                itemFood.func_77982_d(nbt);
            } else if (itemFood.func_77978_p().func_150297_b("foodData", 10)) {
                nbt = itemFood.func_77978_p();
                NBTTagCompound data = (NBTTagCompound)nbt.func_74775_l("foodData").func_74737_b();
                data.func_74772_a("foodTimeWorld", EventFoodRot.getWorldTime());
                nbt.func_74782_a("foodData", (NBTBase)data);
                itemFood.func_77982_d(nbt);
            }
        }
        return itemFood;
    }

    public static ItemStack doOpenBackpakFood(World world, ItemStack itemFood) {
        if (M3Config.FoodRot && M3Config.OpenBackpackFoodRot && itemFood != null && (itemFood.func_77973_b() instanceof ItemFood || ManaMetalAPI.FoodRootItemList.containsKey(itemFood.func_77973_b()))) {
            NBTTagCompound nbt;
            if (ManaMetalAPI.FoodRootBlackList.contains(itemFood.func_77973_b())) {
                return itemFood;
            }
            int maxRoot = 800;
            if (itemFood.func_77973_b() instanceof IFood) {
                IFood IFood2 = (IFood)itemFood.func_77973_b();
                if (!IFood2.canRoot(itemFood)) {
                    return itemFood;
                }
                maxRoot = IFood2.maxRoot(itemFood);
            }
            if (!itemFood.func_77942_o() || !itemFood.func_77978_p().func_150297_b("foodData", 10)) {
                nbt = new NBTTagCompound();
                NBTTagCompound data = new NBTTagCompound();
                if (itemFood.func_77942_o()) {
                    nbt = itemFood.func_77978_p();
                }
                data.func_74772_a("foodTimeWorld", EventFoodRot.getWorldTime());
                data.func_74768_a("foodTime", 0);
                data.func_74768_a("foodTimeMax", maxRoot);
                data.func_74757_a("foodSalted", false);
                data.func_74757_a("foodMarinated", false);
                nbt.func_74782_a("foodData", (NBTBase)data);
                itemFood.func_77982_d(nbt);
            } else if (itemFood.func_77978_p().func_150297_b("foodData", 10)) {
                nbt = itemFood.func_77978_p();
                NBTTagCompound data = (NBTTagCompound)nbt.func_74775_l("foodData").func_74737_b();
                int rots = data.func_74762_e("foodTime");
                if (data.func_74763_f("foodTimeWorld") != -1L && EventFoodRot.getWorldTime() - data.func_74763_f("foodTimeWorld") > 500L) {
                    rots += new Long((EventFoodRot.getWorldTime() - data.func_74763_f("foodTimeWorld")) / 100L).intValue();
                }
                if (rots >= data.func_74762_e("foodTimeMax")) {
                    int count = itemFood.field_77994_a;
                    if (itemFood.func_77973_b() instanceof IFood) {
                        IFood IFood3 = (IFood)itemFood.func_77973_b();
                        ItemStack rot = IFood3.getRootItem(itemFood).func_77946_l();
                        rot.field_77994_a = count;
                        return rot.func_77946_l();
                    }
                    if (ManaMetalAPI.FoodRootItemList.containsKey(itemFood.func_77973_b())) {
                        return new ItemStack(ManaMetalAPI.FoodRootItemList.get(itemFood.func_77973_b()), count);
                    }
                    return new ItemStack(rotFood, count);
                }
                data.func_74772_a("foodTimeWorld", EventFoodRot.getWorldTime() - (long)rootDebugTime);
                data.func_74768_a("foodTime", rots);
                nbt.func_74782_a("foodData", (NBTBase)data);
                itemFood.func_77982_d(nbt);
            }
        }
        return itemFood;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerOpenBox(PlayerInteractEvent event) {
        if (event.isCanceled()) {
            return;
        }
        try {
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                TileEntity tile;
                IFreezerContainer ifc;
                TileEntityIceBox te;
                Block block = event.world.func_147439_a(event.x, event.y, event.z);
                boolean isFreezerContainer = false;
                if (!M3Config.FoodRot || !M3Config.OpenContainerFoodRot || block == Blocks.field_150457_bL || block == FishingCore.BlockFishPools) {
                    isFreezerContainer = true;
                }
                if (block == FishingCore.BlockTileEntityFishBoxs) {
                    isFreezerContainer = true;
                }
                if (block == ManaMetalMod.BLOCKPlayerStore) {
                    isFreezerContainer = true;
                }
                if (block instanceof BlockTileEntityIceBox && (te = (TileEntityIceBox)event.world.func_147438_o(event.x, event.y, event.z)) != null && te.cold > 0) {
                    isFreezerContainer = true;
                }
                if (ManaMetalAPI.FreezerContainerList.contains(block)) {
                    isFreezerContainer = true;
                }
                if (block instanceof IFreezerContainer && (ifc = (IFreezerContainer)block).isFreezer(event.world, block, event.x, event.y, event.z, event.entityPlayer)) {
                    isFreezerContainer = true;
                }
                if (block instanceof ITileEntityProvider && (tile = event.world.func_147438_o(event.x, event.y, event.z)) != null && tile instanceof IInventory) {
                    IInventory items1 = (IInventory)tile;
                    for (int s = 0; s < items1.func_70302_i_(); ++s) {
                        NBTTagCompound data;
                        NBTTagCompound nbt;
                        if (items1.func_70301_a(s) == null || !(items1.func_70301_a(s).func_77973_b() instanceof ItemFood) && !ManaMetalAPI.FoodRootItemList.containsKey(items1.func_70301_a(s).func_77973_b())) continue;
                        boolean canFreezer = true;
                        ItemStack itemFood = items1.func_70301_a(s);
                        if (ManaMetalAPI.FoodRootBlackList.contains(itemFood.func_77973_b())) continue;
                        int maxRoot = 800;
                        if (itemFood.func_77973_b() instanceof IFood) {
                            IFood IFood2 = (IFood)itemFood.func_77973_b();
                            if (!IFood2.canRoot(itemFood)) continue;
                            canFreezer = IFood2.canFreezer(itemFood);
                            maxRoot = IFood2.maxRoot(itemFood);
                        }
                        if (isFreezerContainer && canFreezer) continue;
                        if (!itemFood.func_77942_o() || !itemFood.func_77978_p().func_150297_b("foodData", 10)) {
                            nbt = new NBTTagCompound();
                            data = new NBTTagCompound();
                            if (itemFood.func_77942_o()) {
                                nbt = itemFood.func_77978_p();
                            }
                            data.func_74772_a("foodTimeWorld", EventFoodRot.getWorldTime());
                            data.func_74768_a("foodTime", 0);
                            data.func_74768_a("foodTimeMax", maxRoot);
                            data.func_74757_a("foodSalted", false);
                            data.func_74757_a("foodMarinated", false);
                            nbt.func_74782_a("foodData", (NBTBase)data);
                            itemFood.func_77982_d(nbt);
                            continue;
                        }
                        if (!itemFood.func_77978_p().func_150297_b("foodData", 10)) continue;
                        nbt = itemFood.func_77978_p();
                        data = (NBTTagCompound)nbt.func_74775_l("foodData").func_74737_b();
                        int rots = data.func_74762_e("foodTime");
                        if (data.func_74763_f("foodTimeWorld") != -1L && EventFoodRot.getWorldTime() - data.func_74763_f("foodTimeWorld") > 500L) {
                            rots += new Long((EventFoodRot.getWorldTime() - data.func_74763_f("foodTimeWorld")) / 100L).intValue();
                        }
                        if (rots >= data.func_74762_e("foodTimeMax")) {
                            int count = itemFood.field_77994_a;
                            if (itemFood.func_77973_b() instanceof IFood) {
                                IFood IFood3 = (IFood)itemFood.func_77973_b();
                                ItemStack rot = IFood3.getRootItem(itemFood).func_77946_l();
                                rot.field_77994_a = count;
                                items1.func_70299_a(s, rot);
                                continue;
                            }
                            if (ManaMetalAPI.FoodRootItemList.containsKey(itemFood.func_77973_b())) {
                                items1.func_70299_a(s, new ItemStack(ManaMetalAPI.FoodRootItemList.get(itemFood.func_77973_b()), count));
                                continue;
                            }
                            items1.func_70299_a(s, new ItemStack(rotFood, count));
                            continue;
                        }
                        data.func_74772_a("foodTimeWorld", EventFoodRot.getWorldTime() - (long)rootDebugTime);
                        data.func_74768_a("foodTime", rots);
                        nbt.func_74782_a("foodData", (NBTBase)data);
                        itemFood.func_77982_d(nbt);
                    }
                }
            }
        }
        catch (Exception e) {
            MMM.Error("player box foot rood has error!");
        }
    }

    public static long getWorldTime() {
        if (DimensionManager.getWorld((int)0) != null) {
            return DimensionManager.getWorld((int)0).func_82737_E();
        }
        return 0L;
    }

    protected static void updatePlayerFoods(EntityPlayer player) {
        try {
            for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
                NBTTagCompound data;
                NBTTagCompound nbt;
                ItemStack itemFood = player.field_71071_by.func_70301_a(s);
                int maxRoot = 800;
                if (itemFood == null || !(itemFood.func_77973_b() instanceof ItemFood) && !ManaMetalAPI.FoodRootItemList.containsKey(itemFood.func_77973_b())) continue;
                if (itemFood.func_77973_b() instanceof IFood) {
                    IFood IFood2 = (IFood)itemFood.func_77973_b();
                    if (!IFood2.canRoot(itemFood)) continue;
                    maxRoot = IFood2.maxRoot(itemFood);
                }
                if (ManaMetalAPI.FoodRootBlackList.contains(itemFood.func_77973_b())) continue;
                if (!itemFood.func_77942_o() || !itemFood.func_77978_p().func_150297_b("foodData", 10)) {
                    nbt = new NBTTagCompound();
                    data = new NBTTagCompound();
                    if (itemFood.func_77942_o()) {
                        nbt = itemFood.func_77978_p();
                    }
                    data.func_74772_a("foodTimeWorld", EventFoodRot.getWorldTime());
                    data.func_74768_a("foodTime", 0);
                    data.func_74768_a("foodTimeMax", maxRoot);
                    data.func_74757_a("foodSalted", false);
                    data.func_74757_a("foodMarinated", false);
                    nbt.func_74782_a("foodData", (NBTBase)data);
                    itemFood.func_77982_d(nbt);
                    continue;
                }
                if (!itemFood.func_77978_p().func_150297_b("foodData", 10)) continue;
                nbt = itemFood.func_77978_p();
                data = (NBTTagCompound)nbt.func_74775_l("foodData").func_74737_b();
                int rots = data.func_74762_e("foodTime");
                if (data.func_74763_f("foodTimeWorld") != -1L && EventFoodRot.getWorldTime() - data.func_74763_f("foodTimeWorld") > 500L) {
                    rots += new Long((EventFoodRot.getWorldTime() - data.func_74763_f("foodTimeWorld")) / 100L).intValue();
                }
                if (rots >= data.func_74762_e("foodTimeMax")) {
                    int count = itemFood.field_77994_a;
                    if (itemFood.func_77973_b() instanceof IFood) {
                        IFood IFood3 = (IFood)itemFood.func_77973_b();
                        ItemStack rot = IFood3.getRootItem(itemFood).func_77946_l();
                        rot.field_77994_a = count;
                        player.field_71071_by.func_70299_a(s, rot);
                        continue;
                    }
                    if (ManaMetalAPI.FoodRootItemList.containsKey(itemFood.func_77973_b())) {
                        player.field_71071_by.func_70299_a(s, new ItemStack(ManaMetalAPI.FoodRootItemList.get(itemFood.func_77973_b()), count));
                        continue;
                    }
                    player.field_71071_by.func_70299_a(s, new ItemStack(rotFood, count));
                    continue;
                }
                switch (WorldSeason.NowSeason) {
                    case autumn: {
                        data.func_74768_a("foodTime", rots + 2);
                        break;
                    }
                    case spring: {
                        data.func_74768_a("foodTime", rots + 2);
                        break;
                    }
                    case summer: {
                        data.func_74768_a("foodTime", rots + 3);
                        break;
                    }
                    case winter: {
                        data.func_74768_a("foodTime", rots + 1);
                    }
                }
                data.func_74772_a("foodTimeWorld", EventFoodRot.getWorldTime());
                nbt.func_74782_a("foodData", (NBTBase)data);
                itemFood.func_77982_d(nbt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

