/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.favorites;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.api.IBlockUnbreakable;
import project.studio.manametalmod.blocks.BlockBaseSub;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.favorites.FavoritesType;
import project.studio.manametalmod.favorites.TileEntityFavorites;

public class BlockFavorites
extends BlockBaseSub
implements ITileEntityProvider,
IBlockUnbreakable {
    public BlockFavorites() {
        super(Material.field_151576_e, FavoritesType.values().length, "BlockFavorites");
        this.func_149647_a(ManaMetalMod.tab_Machine);
        this.func_149711_c(3.0f);
        this.func_149752_b(1.0E8f);
        this.func_149715_a(0.0f);
        this.func_149672_a(field_149769_e);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.field_149761_L;
        }
        return super.func_149691_a(side, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister IIconRegister2) {
        this.field_149761_L = IIconRegister2.func_94245_a(MMM.getTextureName("BlockTileEntityManaPawnshop_top"));
        super.func_149651_a(IIconRegister2);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityFavorites();
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase placer, ItemStack stack) {
        super.func_149689_a(world, x, y, z, placer, stack);
        try {
            TileEntityFavorites tile = (TileEntityFavorites)world.func_147438_o(x, y, z);
            if (placer instanceof EntityPlayer) {
                if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_150297_b("player_name", 8)) {
                    NBTTagCompound tag = stack.func_77978_p();
                    String name = NBTHelp.getStringSafe("player_name", tag, placer.func_70005_c_());
                    FavoritesType type = FavoritesType.values()[NBTHelp.getIntSafe("data_type", tag, 0)];
                    boolean[] datas = NBTHelp.getBooleanArraySafe(tag, "FavoritesData", new boolean[TileEntityFavorites.getFavoritesList(type).size()]);
                    tile.name = name;
                    tile.type = type;
                    tile.data = (boolean[])datas.clone();
                    return;
                }
                tile.onBlock((EntityPlayer)placer, stack.func_77960_j());
                tile.update_data();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void func_149749_a(World world, int x, int y, int z, Block Block2, int data) {
        try {
            TileEntityFavorites tile = (TileEntityFavorites)world.func_147438_o(x, y, z);
            String name = tile.name;
            FavoritesType type = tile.type;
            boolean[] datas = (boolean[])tile.data.clone();
            ItemStack item = new ItemStack((Block)this, 1, data);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("player_name", name);
            tag.func_74768_a("data_type", type.ordinal());
            NBTHelp.setBooleanArray(tag, "FavoritesData", datas);
            item.func_77982_d(tag);
            MMM.spawnItemInWorld(world, item, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.func_149749_a(world, x, y, z, Block2, data);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        if (world.field_72995_K) {
            TileEntityFavorites tile = (TileEntityFavorites)world.func_147438_o(x, y, z);
            if (tile.name != null && tile.name.equals(player.func_70005_c_())) {
                player.openGui((Object)ManaMetalMod.instance, 232, world, x, y, z);
            } else {
                MMM.addMessage(player, "MMM.info.cantopenBlockFavorites");
            }
        }
        return true;
    }

    @Override
    public boolean canBreak(World world, int x, int y, int z, EntityPlayer player) {
        TileEntityFavorites tile = (TileEntityFavorites)world.func_147438_o(x, y, z);
        return tile.name.equals(player.func_70005_c_());
    }
}

