/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.IEquipmentStrengthenItem;
import project.studio.manametalmod.api.IQualityPearl;
import project.studio.manametalmod.api.MoneySourceType;
import project.studio.manametalmod.api.Quality;
import project.studio.manametalmod.core.IRepair;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.item.customize.ItemCustomizeTools;
import project.studio.manametalmod.rpg.ItemStrengthenHelp;
import project.studio.manametalmod.rpg.WeaponTableEffect;
import project.studio.manametalmod.tileentity.TileEntityItemUseTable;
import project.studio.manametalmod.tileentity.TileEntityQualityTable;
import project.studio.manametalmod.tileentity.TileEntityWeaponTable;

public class MessageWeaponTable
implements IMessage,
IMessageHandler<MessageWeaponTable, IMessage> {
    private int type;
    private int id;
    private int x;
    private int y;
    private int z;

    public MessageWeaponTable() {
    }

    public MessageWeaponTable(int type, int id, int x, int y, int z) {
        this.type = type;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static final void setRepairMoney(TileEntityWeaponTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(1) != null && tile.func_70301_a(1).func_77960_j() < tile.func_70301_a(1).func_77958_k() && MMM.can_repair(tile.func_70301_a(1))) {
            int damage = tile.func_70301_a(1).func_77960_j() * 2;
            int money = damage + 500;
            if (tile.func_70301_a(1).func_77973_b() instanceof IRepair) {
                IRepair ir = (IRepair)tile.func_70301_a(1).func_77973_b();
                money = ir.baseRepairConsume(tile.func_70301_a(1), (EntityPlayer)player);
            }
            tile.useMoney = Math.min(money, 1000000);
            tile.type = WeaponTableEffect.Repair;
            tile.update_data();
        }
    }

    public static final void setRemoveEnchantmentMoney(TileEntityWeaponTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(1) != null && tile.func_70301_a((int)1).field_77990_d != null && tile.func_70301_a((int)1).field_77990_d.func_150297_b("ench", 9)) {
            int weaponLV = MMM.getEquipmentNeedLV(tile.func_70301_a(1));
            int money = 1000 * weaponLV;
            if (money <= 0) {
                money = 1000;
            }
            tile.useMoney = money;
            tile.type = WeaponTableEffect.RemoveEnchantment;
            tile.update_data();
        }
    }

    public static final void setTransferEnchantmentMoney(TileEntityWeaponTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(0) != null && tile.func_70301_a((int)0).field_77990_d != null && tile.func_70301_a((int)0).field_77990_d.func_150297_b("ench", 9) && !tile.func_70301_a(0).func_77978_p().func_150297_b("DarkEnchanting", 1) && tile.func_70301_a(1) != null && (tile.func_70301_a(1).func_77973_b() instanceof ItemTool || tile.func_70301_a(1).func_77973_b() instanceof ItemArmor || MMM.getItemIsWeapon(tile.func_70301_a(1)))) {
            int weaponLV = MMM.getEquipmentNeedLV(tile.func_70301_a(1));
            int money = 10000 * weaponLV;
            if (money <= 0) {
                money = 10000;
            }
            tile.useMoney = money;
            tile.type = WeaponTableEffect.TransferEnchantment;
            tile.update_data();
        }
    }

    public static final void setRemakeMoney(TileEntityWeaponTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(1) != null) {
            int weaponLV = MMM.getEquipmentNeedLV(tile.func_70301_a(1));
            int money = 2000 * weaponLV;
            if (money <= 0) {
                money = 1000;
            }
            tile.useMoney = money;
            tile.type = WeaponTableEffect.Remake;
            tile.update_data();
        }
    }

    public static final void setExtractEnchantmentMoney(TileEntityWeaponTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(0) != null && tile.func_70301_a((int)0).field_77990_d != null && tile.func_70301_a((int)0).field_77990_d.func_150297_b("ench", 9)) {
            int weaponLV = MMM.getEquipmentNeedLV(tile.func_70301_a(0));
            int money = 2500 * weaponLV;
            if (money <= 0) {
                money = 1000;
            }
            tile.useMoney = money;
            tile.type = WeaponTableEffect.ExtractEnchantment;
            tile.update_data();
        }
    }

    public static final void setCombinationMoney(TileEntityWeaponTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(0) != null && tile.func_70301_a(1) != null && tile.func_70301_a(0).func_77973_b() == tile.func_70301_a(1).func_77973_b() && MMM.getItemIsWeapon(tile.func_70301_a(0))) {
            int weaponLV = MMM.getEquipmentNeedLV(tile.func_70301_a(1));
            int money = 20000 * weaponLV;
            if (money <= 0) {
                money = 20000;
            }
            tile.useMoney = money;
            tile.type = WeaponTableEffect.Combination;
            tile.update_data();
        }
    }

    public static final void doRepair(TileEntityWeaponTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(1) != null && MMM.can_repair(tile.func_70301_a(1)) && tile.func_70301_a(1).func_77960_j() < tile.func_70301_a(1).func_77958_k()) {
            tile.func_70301_a(1).func_77964_b(0);
        }
    }

    public static final void doRemoveEnchantment(TileEntityWeaponTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(1) != null && tile.func_70301_a((int)1).field_77990_d != null) {
            if (tile.func_70301_a((int)1).field_77990_d.func_150297_b("ench", 9)) {
                tile.func_70301_a((int)1).field_77990_d.func_82580_o("ench");
            }
            if (tile.func_70301_a(1).func_77978_p().func_150297_b("DarkEnchanting", 1)) {
                tile.func_70301_a((int)1).field_77990_d.func_82580_o("DarkEnchanting");
            }
            if (tile.func_70301_a(1).func_77978_p().func_150297_b("ChaosEnchanting", 1)) {
                tile.func_70301_a((int)1).field_77990_d.func_82580_o("ChaosEnchanting");
            }
        }
    }

    public static final void doRemake(TileEntityWeaponTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(1) != null) {
            ItemStrengthenHelp.reWeapon(tile.func_70301_a(1));
        }
    }

    public static final void doTransferEnchantment(TileEntityWeaponTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(0) != null && tile.func_70301_a((int)0).field_77990_d != null && tile.func_70301_a((int)0).field_77990_d.func_150297_b("ench", 9) && tile.func_70301_a(1) != null && !tile.func_70301_a(0).func_77978_p().func_150297_b("DarkEnchanting", 1)) {
            EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)tile.func_70301_a(0)), (ItemStack)tile.func_70301_a(1));
            tile.func_70299_a(0, null);
        }
    }

    public static final void doExtractEnchantment(TileEntityWeaponTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(0) != null && tile.func_70301_a((int)0).field_77990_d != null && tile.func_70301_a((int)0).field_77990_d.func_150297_b("ench", 9)) {
            NBTTagList list = tile.func_70301_a((int)0).field_77990_d.func_150295_c("ench", 10);
            ItemStack item = new ItemStack((Item)Items.field_151134_bR, 1, 0);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("StoredEnchantments", (NBTBase)list);
            item.func_77982_d(tag);
            MMM.addItemToPlayer(item, (EntityPlayer)player);
            tile.func_70299_a(0, null);
        }
    }

    public static final void doCombination(TileEntityWeaponTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(0) != null && tile.func_70301_a(1) != null && tile.func_70301_a(0).func_77973_b() == tile.func_70301_a(1).func_77973_b() && MMM.getItemIsWeapon(tile.func_70301_a(0))) {
            Quality q1 = MessageWeaponTable.getQuality(tile.func_70301_a(0));
            Quality q2 = MessageWeaponTable.getQuality(tile.func_70301_a(1));
            boolean has = false;
            if (ItemCustomizeTools.hasIItemCustomizeTag(tile.func_70301_a(0)) && ItemCustomizeTools.hasIItemCustomizeTag(tile.func_70301_a(1))) {
                has = true;
            }
            int data = q1.ordinal() * q2.ordinal();
            ItemStack item = tile.func_70301_a(1).func_77946_l();
            if (item.func_77942_o()) {
                if (item.field_77990_d.func_150297_b("ench", 9)) {
                    item.field_77990_d.func_82580_o("ench");
                }
                if (item.field_77990_d.func_150297_b("DarkEnchanting", 1)) {
                    item.field_77990_d.func_82580_o("DarkEnchanting");
                }
                if (item.field_77990_d.func_150297_b("ChaosEnchanting", 1)) {
                    item.field_77990_d.func_82580_o("ChaosEnchanting");
                }
                if (item.field_77990_d.func_150297_b("weapon_strengthen", 10)) {
                    item.field_77990_d.func_82580_o("weapon_strengthen");
                }
            }
            if (tile.func_145831_w().field_73012_v.nextInt(200) < data || has) {
                int special_power = tile.func_145831_w().field_73012_v.nextInt(10);
                ItemCustomizeTools.setIItemCustomizeTag(item, special_power);
            }
            tile.func_70299_a(0, null);
            tile.func_70299_a(1, item);
        }
    }

    public static Quality getQuality(ItemStack item) {
        Quality data = Quality.Junk;
        if (item.func_77942_o() && item.func_77978_p().func_150297_b("weapon_strengthen", 10)) {
            data = Quality.values()[item.func_77978_p().func_74775_l("weapon_strengthen").func_74762_e("quality")];
        }
        return data == Quality.Unknown ? Quality.Junk : data;
    }

    public IMessage onMessage(MessageWeaponTable message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        ManaMetalModRoot root = MMM.getEntityNBT((EntityPlayer)player);
        if (root != null) {
            TileEntity tile;
            TileEntity temptile = player.field_70170_p.func_147438_o(message.x, message.y, message.z);
            if (message.type == 0 && temptile instanceof TileEntityWeaponTable) {
                tile = (TileEntityWeaponTable)temptile;
                if (message.id < WeaponTableEffect.values().length && message.id > 0) {
                    WeaponTableEffect type = WeaponTableEffect.values()[message.id];
                    if (type != WeaponTableEffect.Start) {
                        switch (type) {
                            case Combination: {
                                break;
                            }
                            case ExtractEnchantment: {
                                MessageWeaponTable.setExtractEnchantmentMoney((TileEntityWeaponTable)tile, player, root);
                                break;
                            }
                            case Remake: {
                                MessageWeaponTable.setRemakeMoney((TileEntityWeaponTable)tile, player, root);
                                break;
                            }
                            case RemoveEnchantment: {
                                MessageWeaponTable.setRemoveEnchantmentMoney((TileEntityWeaponTable)tile, player, root);
                                break;
                            }
                            case Repair: {
                                MessageWeaponTable.setRepairMoney((TileEntityWeaponTable)tile, player, root);
                                break;
                            }
                            case TransferEnchantment: {
                                MessageWeaponTable.setTransferEnchantmentMoney((TileEntityWeaponTable)tile, player, root);
                            }
                        }
                    } else if (root.money.getMoney() >= (long)tile.useMoney) {
                        switch (tile.type) {
                            case Combination: {
                                break;
                            }
                            case ExtractEnchantment: {
                                MessageWeaponTable.doExtractEnchantment((TileEntityWeaponTable)tile, player, root);
                                break;
                            }
                            case Remake: {
                                MessageWeaponTable.doRemake((TileEntityWeaponTable)tile, player, root);
                                break;
                            }
                            case RemoveEnchantment: {
                                MessageWeaponTable.doRemoveEnchantment((TileEntityWeaponTable)tile, player, root);
                                break;
                            }
                            case Repair: {
                                MessageWeaponTable.doRepair((TileEntityWeaponTable)tile, player, root);
                                break;
                            }
                            case TransferEnchantment: {
                                MessageWeaponTable.doTransferEnchantment((TileEntityWeaponTable)tile, player, root);
                            }
                        }
                        root.money.addMoney(-tile.useMoney, MoneySourceType.EquipmentTable);
                        tile.type = WeaponTableEffect.None;
                        tile.useMoney = 0;
                        player.field_70170_p.func_72926_e(1020, message.x, message.y, message.z, 0);
                        tile.update_data();
                    }
                }
            }
            if (message.type == 1 && temptile instanceof TileEntityQualityTable) {
                tile = (TileEntityQualityTable)temptile;
                MessageWeaponTable.doChangeQuality((TileEntityQualityTable)tile, player, root);
            }
            if (message.type == 2 && temptile instanceof TileEntityItemUseTable) {
                tile = (TileEntityItemUseTable)temptile;
                MessageWeaponTable.doUseItem((TileEntityItemUseTable)tile, player, root);
            }
        }
        return null;
    }

    public static final void doChangeQuality(TileEntityQualityTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        if (tile.func_70301_a(1) != null && TileEntityQualityTable.canQuality(tile, (EntityPlayer)player, root)) {
            int need = TileEntityQualityTable.getChangeQualityMoney(tile, (EntityPlayer)player, root);
            if (root.money.getMoney() >= (long)need && tile.func_70301_a(1).func_77942_o() && tile.func_70301_a(1).func_77978_p().func_150297_b("weapon_strengthen", 10)) {
                root.money.addMoney(-need, MoneySourceType.EquipmentTable);
                NBTTagCompound tag = tile.func_70301_a(1).func_77978_p().func_74775_l("weapon_strengthen");
                Quality quality = Quality.values()[tag.func_74762_e("quality")];
                boolean success = false;
                float probability = TileEntityQualityTable.success(quality);
                if (tile.func_70301_a(0) != null && tile.func_70301_a(0).func_77973_b() instanceof IQualityPearl) {
                    IQualityPearl QP = (IQualityPearl)tile.func_70301_a(0).func_77973_b();
                    if (QP.getMaxQuality(tile.func_70301_a(0), tile.func_70301_a(1), (EntityPlayer)player, tile).ordinal() > quality.ordinal()) {
                        probability *= 1.0f + QP.getExtraProbability(tile.func_70301_a(0), tile.func_70301_a(1), (EntityPlayer)player, tile);
                    }
                    MMM.removeTileEntityItem(tile, 0);
                }
                if (1.0E-4f * (float)tile.func_145831_w().field_73012_v.nextInt(10000) < probability) {
                    tag.func_74768_a("quality", tag.func_74762_e("quality") + 1);
                    MMM.playSoundFromServer(tile.func_145831_w(), MMM.getMODID() + ":roll_1", new Pos(tile), 1.0, 1.0, 3.0);
                } else {
                    MMM.playSoundFromServer(tile.func_145831_w(), MMM.getMODID() + ":roll_2", new Pos(tile), 1.0, 1.0, 3.0);
                }
                tile.done();
            }
        }
    }

    public static final void doUseItem(TileEntityItemUseTable tile, EntityPlayerMP player, ManaMetalModRoot root) {
        IEquipmentStrengthenItem ESI;
        if (tile.func_70301_a(0) != null && tile.func_70301_a(1) != null && tile.func_70301_a(0).func_77973_b() instanceof IEquipmentStrengthenItem && (ESI = (IEquipmentStrengthenItem)tile.func_70301_a(0).func_77973_b()).canUse(tile.func_70301_a(0), tile.func_70301_a(1), (EntityPlayer)player, tile) && ESI.effect(tile.func_70301_a(0), tile.func_70301_a(1), (EntityPlayer)player, tile)) {
            MMM.removeTileEntityItem(tile, 0);
            tile.time = 5;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readInt();
        this.id = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type);
        buf.writeInt(this.id);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }
}

