/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.npc;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import project.studio.manametalmod.npc.NpcGender;
import project.studio.manametalmod.npc.NpcGiftType;

public class NpcFavorability {
    public Map<String, Integer> Favorability = new HashMap<String, Integer>();
    NpcGiftType[] typeLike = new NpcGiftType[]{NpcGiftType.Flower};
    NpcGiftType[] typeHate = new NpcGiftType[]{NpcGiftType.Weapon};
    NpcGender gender = NpcGender.Male;

    public NpcFavorability(NpcGiftType[] typeLike, NpcGiftType[] typeHate, NpcGender gender) {
        this.typeLike = typeLike;
        this.typeHate = typeHate;
        this.gender = gender;
    }

    public void saveToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (String key : this.Favorability.keySet()) {
            NBTTagCompound item = new NBTTagCompound();
            item.func_74778_a("PlayerName", key);
            item.func_74768_a("FavorabilityValue", this.Favorability.get(key).intValue());
            list.func_74742_a((NBTBase)item);
        }
        nbt.func_74782_a("FavorabilityMap", (NBTBase)list);
        nbt.func_74783_a("typeLike", this.getIDs(this.typeLike));
        nbt.func_74783_a("typeHate", this.getIDs(this.typeHate));
        nbt.func_74768_a("NpcGender", this.gender.getID());
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("FavorabilityMap", 10);
        for (int s = 0; s < list.func_74745_c(); ++s) {
            NBTTagCompound item = list.func_150305_b(s);
            this.Favorability.put(item.func_74779_i("PlayerName"), item.func_74762_e("FavorabilityValue"));
        }
        this.gender = NpcGender.getTypeFromID(nbt.func_74762_e("NpcGender"));
    }

    public int[] getIDs(NpcGiftType[] type) {
        int[] item = new int[type.length];
        for (int s = 0; s < type.length; ++s) {
            item[s] = type[s].getID();
        }
        return item;
    }

    public NpcGiftType[] toTypes(int[] id) {
        NpcGiftType[] item = new NpcGiftType[id.length];
        for (int s = 0; s < id.length; ++s) {
            item[s] = NpcGiftType.getTypeFromID(id[s]);
        }
        return item;
    }

    public boolean giftFromPlayer(ItemStack item, EntityPlayer player) {
        int s;
        String name = player.getDisplayName();
        for (s = 0; s < this.typeLike.length; ++s) {
            if (!NpcGiftType.testTypeFromItemStack(this.typeLike[s], item)) continue;
            if (this.Favorability.containsKey(name)) {
                this.Favorability.put(name, this.getFavorabilityValue(this.Favorability.get(name), 1));
            } else {
                this.Favorability.put(name, this.getFavorabilityValue(0, 1));
            }
            return true;
        }
        for (s = 0; s < this.typeHate.length; ++s) {
            if (!NpcGiftType.testTypeFromItemStack(this.typeHate[s], item)) continue;
            if (this.Favorability.containsKey(name)) {
                this.Favorability.put(name, this.getFavorabilityValue(this.Favorability.get(name), -1));
            } else {
                this.Favorability.put(name, this.getFavorabilityValue(0, -1));
            }
            return false;
        }
        return false;
    }

    public int getFavorabilityValue(int old, int giftCorrect) {
        Random random = new Random();
        if (giftCorrect == 1) {
            if (old == 0) {
                return random.nextInt(20) + 100;
            }
            if (old >= 0) {
                return old / 30 + 100 + random.nextInt(20);
            }
            if (old <= 0) {
                return random.nextInt(20) + 200;
            }
        } else if (giftCorrect == -1) {
            if (old == 0) {
                return random.nextInt(20) - 200;
            }
            if (old >= 0) {
                return -(old / 20) - 100 - random.nextInt(20);
            }
            if (old <= 0) {
                return old * 2;
            }
        }
        return 0;
    }
}

