/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.pet;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.IEntityData;
import project.studio.manametalmod.api.IFriendly;
import project.studio.manametalmod.battle.AttackType;
import project.studio.manametalmod.battle.WeaponType;
import project.studio.manametalmod.core.CareerCore;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.entity.nbt.NbtSpecialization;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.mob.Entity3DThrowable;
import project.studio.manametalmod.mob.EntityMagicBallNew;
import project.studio.manametalmod.pet.SummonerType;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;
import project.studio.manametalmod.spell.EventSpell;
import project.studio.manametalmod.spell.ISummoner;
import project.studio.manametalmod.spell.Spell;
import project.studio.manametalmod.spell.SpellData;
import project.studio.manametalmod.spell.SpellID;
import project.studio.manametalmod.spell.SpellType;

public class EntitySummoner
extends EntityTameable
implements IEntityData,
IEntityAdditionalSpawnData,
IFriendly,
IRangedAttackMob,
ISummoner {
    public SummonerType type = SummonerType.wolf;
    public int LV = 1;
    public float attack = 1.0f;
    public float HP = 100.0f;
    public int time = 0;
    public int cd1 = 0;
    public int cd2 = 0;
    public int cd3 = 0;
    public int InjuriedCD = 0;
    public EntityAIArrowAttack ballAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 30, 15.0f);
    public EntityAIAttackOnCollide baseAttack = new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true);
    public int uuidLIFE = 0;
    public int life = 12000;
    public int Penetration = 0;
    public int tpCD = 20;
    public int PlayerTransfer = 0;
    public int specialID = -1;
    public int summonTime = -1;

    @Override
    public int getPlayerTransfer() {
        return this.PlayerTransfer;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("type", this.type.ordinal());
        tag.func_74768_a("LV", this.LV);
        tag.func_74768_a("time", this.time);
        tag.func_74768_a("cd1", this.cd1);
        tag.func_74768_a("cd2", this.cd2);
        tag.func_74768_a("cd3", this.cd3);
        tag.func_74768_a("uuidLIFE", this.uuidLIFE);
        tag.func_74768_a("life", this.life);
        tag.func_74776_a("attack", this.attack);
        tag.func_74776_a("HP", this.HP);
        tag.func_74768_a("Penetration", this.Penetration);
        tag.func_74768_a("PlayerTransfer", this.PlayerTransfer);
        tag.func_74768_a("tpCD", this.tpCD);
        tag.func_74768_a("specialID", this.specialID);
        tag.func_74768_a("summonTime", this.summonTime);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.type = SummonerType.values()[NBTHelp.getIntSafe("type", tag, 0)];
        this.LV = NBTHelp.getIntSafe("LV", tag, 1);
        this.time = NBTHelp.getIntSafe("time", tag, 0);
        this.cd1 = NBTHelp.getIntSafe("cd1", tag, 0);
        this.cd2 = NBTHelp.getIntSafe("cd2", tag, 0);
        this.cd2 = NBTHelp.getIntSafe("cd3", tag, 0);
        this.uuidLIFE = NBTHelp.getIntSafe("uuidLIFE", tag, 0);
        this.life = NBTHelp.getIntSafe("life", tag, 12000);
        this.attack = NBTHelp.getFloatSafe("attack", tag, 1.0f);
        this.HP = NBTHelp.getFloatSafe("HP", tag, 1.0f);
        this.Penetration = NBTHelp.getIntSafe("Penetration", tag, 0);
        this.PlayerTransfer = NBTHelp.getIntSafe("PlayerTransfer", tag, 1);
        this.tpCD = NBTHelp.getIntSafe("tpCD", tag, 1);
        this.specialID = NBTHelp.getIntSafe("specialID", tag, -1);
        this.summonTime = NBTHelp.getIntSafe("summonTime", tag, -1);
    }

    public EntitySummoner(World World2) {
        this(World2, SummonerType.wolf);
    }

    public EntitySummoner(World World2, SummonerType type) {
        super(World2);
        this.func_70105_a(0.6f, 0.8f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.func_110163_bv();
        this.field_70178_ae = true;
        switch (type) {
            case wolf: 
            case fox: 
            case scorpion: 
            case cat: {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.baseAttack);
                break;
            }
            case dragon: 
            case snake: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.ballAttack);
            }
        }
    }

    public void onSummonerDeath() {
        if (this.func_70902_q() != null && this.func_70902_q() instanceof EntityPlayer) {
            Spell spellwater = SpellData.getData(CareerCore.Summoner, SpellID.S2_SoulDrop);
            EntityPlayer player = (EntityPlayer)this.func_70902_q();
            ManaMetalModRoot root = MMM.getEntityNBT(player);
            if (root != null) {
                int maxLV = 4;
                PotionEffectM3.addPotionUpLV(root, PotionM3.potionSoulWaterDrop, spellwater.time, maxLV);
                PotionEffectM3 effect = PotionEffectM3.getPotionEffectM3(root, PotionM3.potionSoulWaterDrop);
                if (effect != null && effect.LV >= 4) {
                    int heal = spellwater.healPower + maxLV * spellwater.pre_heal_power;
                    MMM.healPlayers(this.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, spellwater.range, Integer.MAX_VALUE, true);
                    player.func_85030_a(MMM.getMODID() + ":heal", 1.0f, 1.0f);
                }
                if (root.specialization.getMainEffect(NbtSpecialization.MainSpecialization.upperRight)) {
                    Spell spell = SpellData.getData(CareerCore.Summoner, SpellID.A104_ShadowAllay);
                    MMM.playSoundFromServer(player.field_70170_p, MMM.getMODID() + ":AllayProjectile", player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0, 1.0 + (double)player.field_70170_p.field_73012_v.nextFloat() * 0.5, 2.0);
                    int[] offset = new int[]{20, -20};
                    int attack = (int)(EventSpell.getattack(spell.weapon, root.carrer, 0.0f, player) * (spell.attack + EventSpell.getSpellLV1ToFloat(root.carrer, 4, spell.per_level_attack, 0)));
                    int time = spell.time + root.carrer.getSpellLV_1()[4] * spell.getPer_level_time();
                    int aoe_range = spell.aoe_range;
                    if (root.carrer.obj.specialization.getMainEffect(NbtSpecialization.MainSpecialization.bottomRight)) {
                        aoe_range = (int)((float)aoe_range * 0.5f);
                        attack = (int)((float)attack * 1.3f);
                    }
                    for (int s = 0; s < offset.length; ++s) {
                        Entity3DThrowable ball = new Entity3DThrowable(player.field_70170_p, (EntityLivingBase)player, attack, spell.elements, 31, 250, offset[s]);
                        ball.elements = spell.elements;
                        ball.spelltype = spell.spelltype;
                        ball.weapon = spell.weapon;
                        ball.data1 = time;
                        ball.data2 = aoe_range;
                        if (player.field_70170_p.field_72995_K) continue;
                        player.field_70170_p.func_72838_d((Entity)ball);
                    }
                }
            }
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        this.onSummonerDeath();
    }

    protected void func_70623_bb() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void onSummon(int LV2, float attack, float HP, SummonerType type, EntityPlayer player, int uuid, int life, ManaMetalModRoot root) {
        this.func_70903_f(true);
        this.func_70778_a(null);
        this.func_70624_b(null);
        this.field_70911_d.func_75270_a(false);
        this.func_152115_b(player.func_110124_au().toString());
        this.func_70908_e(true);
        this.life = life;
        this.uuidLIFE = uuid;
        this.LV = LV2;
        this.attack = attack;
        this.HP = HP;
        this.type = type;
        AttributeModifier kbMod = new AttributeModifier("EntitySummoner", (double)this.HP, 0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(kbMod);
        this.func_70606_j(this.func_110138_aP());
        if (EventSpell.getPassiveSpillLV1(root) > 0) {
            this.summonTime = 0;
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.cd1 < 0) {
            return false;
        }
        boolean isAttack = false;
        if (this.func_70902_q() != null && this.func_70902_q() instanceof EntityPlayer && entity instanceof EntityLivingBase) {
            float attacktemp = this.attack;
            if (this.specialID == 2) {
                attacktemp *= 1.1f;
            }
            if (this.summonTime > 0) {
                attacktemp += attacktemp * ((float)this.summonTime * 0.02f);
            }
            if (entity.func_70097_a((DamageSource)AttackType.getDamage((Entity)this.func_70902_q(), this.getEntityElements(), SpellType.Animal, WeaponType.Magic, true, true), attacktemp)) {
                isAttack = true;
                EntityLivingBase target = (EntityLivingBase)entity;
                target.field_70737_aN = 0;
                target.field_70172_ad = 0;
                this.cd1 = -10;
                if (this.type == SummonerType.wolf) {
                    PotionEffectM3.addPotion(target, PotionM3.potionBadArmor, 6, 0);
                    if (this.specialID == 0) {
                        target.func_70690_d(new PotionEffect(2, 100, 2));
                    }
                    if (this.specialID == 1) {
                        this.cd1 = -8;
                    }
                }
                if (this.type == SummonerType.cat) {
                    this.func_70902_q().func_70691_i(this.func_70902_q().func_110138_aP() * 0.1f);
                    if (this.specialID == 0) {
                        this.cd1 = -8;
                    }
                }
                if (this.type == SummonerType.fox) {
                    if (this.cd3 > 0) {
                        this.cd3 = -60;
                        AttackType.dotAttack(target, (EntityPlayer)this.func_70902_q(), (int)(this.attack * 0.5f), 10, ManaElements.Fire, SpellType.Puncture, WeaponType.Magic);
                    }
                    if (this.specialID == 1) {
                        this.cd3 = -8;
                    }
                }
            }
        }
        return isAttack;
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        if (this.func_70902_q() != null && this.func_70902_q() instanceof EntityPlayer) {
            float attacktemp = this.attack;
            if (this.type == SummonerType.snake && this.specialID == 1) {
                attacktemp *= 1.2f;
            }
            if (this.type == SummonerType.dragon && this.specialID == 0) {
                attacktemp *= 1.2f;
            }
            if (this.specialID == 2) {
                attacktemp *= 1.1f;
            }
            if (this.summonTime > 0) {
                attacktemp += attacktemp * ((float)this.summonTime * 0.02f);
            }
            EntityMagicBallNew ball = new EntityMagicBallNew(this.field_70170_p, (EntityLivingBase)this, (EntityPlayer)this.func_70902_q(), (int)attacktemp, ManaElements.Magic, 0, (Entity)target);
            switch (this.type) {
                case dragon: {
                    ball.elements = ManaElements.Ice;
                    ball.spelltype = SpellType.IceDamage;
                    ball.weapon = WeaponType.Magic;
                    ball.ballType = 108;
                    break;
                }
                case snake: {
                    ball.elements = ManaElements.Thunder;
                    ball.spelltype = SpellType.ThunderDamage;
                    ball.weapon = WeaponType.Magic;
                    ball.ballType = 108;
                }
            }
            ball.playerSound();
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)ball);
            }
            this.see_target((Entity)target);
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.InjuriedCD > 0) {
            return false;
        }
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer) {
            return false;
        }
        if (this.type == SummonerType.scorpion) {
            damage = this.specialID == 1 ? (damage *= 0.25f) : (damage *= 0.5f);
        }
        this.InjuriedCD = 10;
        return super.func_70097_a(source, damage);
    }

    protected String func_70639_aQ() {
        switch (this.type) {
            case cat: {
                return "mob.cat.meow";
            }
            case dragon: {
                return null;
            }
            case fox: {
                return MMM.getMODID() + ":fox";
            }
            case scorpion: {
                return MMM.getMODID() + ":scorpion";
            }
            case snake: {
                return null;
            }
            case wolf: {
                return "mob.wolf.bark";
            }
        }
        return null;
    }

    public boolean func_70085_c(EntityPlayer player) {
        return false;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public static void targetAI(int time, Entity owner, EntityTameable summon) {
        if (!summon.field_70170_p.field_72995_K && time % 20 == 0) {
            if (owner != null && owner instanceof EntityPlayer) {
                Entity temp;
                ManaMetalModRoot root;
                EntityPlayer player = (EntityPlayer)owner;
                if (player.func_110144_aD() != null) {
                    summon.func_70624_b(player.func_110144_aD());
                }
                if ((root = MMM.getEntityNBT(player)) != null && CareerCore.getPlayerCarrer(root) == CareerCore.Summoner && root.carrer.careerUseLV2_2 != -1 && (temp = summon.field_70170_p.func_73045_a(root.carrer.careerUseLV2_2)) != null && temp instanceof EntityLivingBase && summon.func_70685_l(temp)) {
                    summon.func_70624_b((EntityLivingBase)temp);
                }
            }
            if (summon.func_70638_az() != null) {
                if (summon.func_70638_az() instanceof IFriendly) {
                    summon.func_70624_b(null);
                }
                if (summon.func_70638_az() == summon.func_70902_q()) {
                    summon.func_70624_b(null);
                }
                if (summon.func_70638_az() != null && summon.func_70638_az().field_70128_L) {
                    summon.func_70624_b(null);
                }
            }
        }
    }

    public void skill() {
        if (this.time % 20 == 0) {
            this.type.onTickEvent(this, this.func_70902_q(), this.field_70170_p);
        }
    }

    public void tp() {
        if (this.tpCD > 200) {
            this.tpCD = 0;
            if (this.type.isMelee() && this.func_70638_az() != null) {
                MMM.playSoundFromServer(this.field_70170_p, "mob.endermen.portal", this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 1.0, 5.0);
                this.func_70107_b(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        ++this.time;
        --this.life;
        ++this.cd1;
        ++this.cd2;
        ++this.cd3;
        ++this.tpCD;
        EntitySummoner.targetAI(this.time, (Entity)this.func_70902_q(), this);
        this.skill();
        this.tp();
        if (this.life < 0) {
            this.func_70106_y();
        }
        if (this.InjuriedCD > 0) {
            --this.InjuriedCD;
        }
        if (this.time % 200 == 0) {
            this.legal_check(CareerCore.Summoner);
        }
        if (this.time % 40 == 0 && !this.field_70170_p.field_72995_K && this.summonTime >= 0 && this.summonTime < 60) {
            ++this.summonTime;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public void func_70903_f(boolean Tamed) {
        super.func_70903_f(Tamed);
    }

    public void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
    }

    public Item func_146068_u() {
        return Item.func_150898_a((Block)Blocks.field_150350_a);
    }

    public String getEntityName() {
        return "EntitySummoner";
    }

    public EntitySummoner createChild(EntityAgeable EntityAgeable2) {
        return null;
    }

    @Override
    public ManaElements getEntityElements() {
        switch (this.type) {
            case dragon: {
                return ManaElements.Ice;
            }
            case fox: {
                return ManaElements.Fire;
            }
            case scorpion: {
                return ManaElements.Grass;
            }
            case snake: {
                return ManaElements.Wind;
            }
            case wolf: {
                return ManaElements.Dark;
            }
            case cat: {
                return ManaElements.Light;
            }
        }
        return ManaElements.Light;
    }

    public String func_70005_c_() {
        return MMM.getTranslateText("SummonerType." + this.type.toString());
    }

    @Override
    public float getDefense() {
        return 0.0f;
    }

    @Override
    public int getLV() {
        int LV2 = this.LV;
        if (this.specialID == 2) {
            LV2 += 10;
        }
        return LV2;
    }

    @Override
    public int getPenetration() {
        return this.Penetration;
    }

    @Override
    public float getExtraAttack() {
        return 0.0f;
    }

    @Override
    public int getFightPower() {
        return 0;
    }

    @Override
    public int getPenetrationDefense() {
        return 0;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.type.ordinal());
        buffer.writeInt(this.life);
        buffer.writeInt(this.specialID);
    }

    public void readSpawnData(ByteBuf additionalData) {
        int id = additionalData.readInt();
        this.type = id < SummonerType.values().length ? SummonerType.values()[id] : SummonerType.values()[0];
        this.life = additionalData.readInt();
        this.specialID = additionalData.readInt();
    }

    public void see_target(Entity targetedEntity) {
        if (targetedEntity != null) {
            this.func_70671_ap().func_75650_a(targetedEntity.field_70165_t, targetedEntity.field_70163_u + (double)targetedEntity.func_70047_e(), targetedEntity.field_70161_v, 10.0f, (float)this.func_70646_bf());
            this.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getAngle(targetedEntity.field_70165_t, targetedEntity.field_70161_v, this.field_70165_t, this.field_70161_v) + 90.0f, (float)(targetedEntity.field_70163_u - this.field_70163_u + (double)targetedEntity.func_70047_e()));
            this.func_70671_ap().func_75649_a();
        }
    }

    public float getAngle(double px1, double py1, double px2, double py2) {
        double x = px2 - px1;
        double y = py2 - py1;
        double hypotenuse = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        double cos = x / hypotenuse;
        double radian = Math.acos(cos);
        double angle = 180.0 / (Math.PI / radian);
        if (y < 0.0) {
            angle = -angle;
        } else if (y == 0.0 && x < 0.0) {
            angle = 180.0;
        }
        return (float)angle;
    }

    @Override
    public EntityLivingBase getEntity() {
        return this;
    }

    @Override
    public EntityLivingBase getOwnerPlayer() {
        return this.func_70902_q();
    }
}

