/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.potion;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import project.studio.manametalmod.battle.AttackType;
import project.studio.manametalmod.battle.WeaponType;
import project.studio.manametalmod.core.AttackEffect;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;
import project.studio.manametalmod.produce.Produce;

public class PotionData {
    public static final int getDrop(PotionM3 ... potion) {
        int treasure = 0;
        for (int s = 0; s < potion.length; ++s) {
            treasure += PotionData.getDropBase(potion[s]);
        }
        return treasure;
    }

    public static final int getDrop(List<PotionEffectM3> list) {
        int treasure = 0;
        for (int s = 0; s < list.size(); ++s) {
            treasure += PotionData.getDropBase(list.get((int)s).ID);
        }
        return treasure;
    }

    public static final float getExtraSpellCooldown(PotionEffectM3 effect) {
        float cd = 0.0f;
        switch (effect.ID) {
            case potionFanLightS: {
                cd += 0.1f;
                break;
            }
            case potionPureSpring: {
                cd += 0.05f;
            }
        }
        return cd;
    }

    public static final float getXPBase(PotionEffectM3 effect) {
        float xp = 0.0f;
        switch (effect.ID) {
            case potiotExpdouble: {
                xp += 0.5f * (float)(effect.LV + 1);
                break;
            }
            case potionbrewing1: {
                xp += 0.1f;
                break;
            }
            case potiotGodPower: {
                xp += 0.3f;
                break;
            }
            case potionOpblessing: {
                xp += 1.0f;
                break;
            }
            case potionElves3: {
                xp += 0.4f;
                break;
            }
            case potionOfwar: {
                xp += 0.25f;
                break;
            }
            case potionGoldenDagger: {
                xp += 0.25f;
                break;
            }
            case potionFestival_1: {
                xp += 0.3f;
                break;
            }
            case potionHolyScriptures: {
                xp += 0.08f * (float)(effect.LV + 1);
                break;
            }
            case IncreaseEffectXP: {
                xp += 0.3f;
                break;
            }
            case potionForeverIce: {
                xp += 0.05f;
                break;
            }
            case potionHalloween: {
                xp += 0.1f;
                break;
            }
            case potionGreatDivineIntervention: {
                xp += 0.1f;
                break;
            }
            case potionYear8Power: {
                xp += 0.1f;
                break;
            }
            case potionWarHorn: {
                xp += 0.3f;
                break;
            }
            case potionPureSpring: {
                xp += 0.15f;
            }
        }
        return xp;
    }

    public static final int getDropBase(PotionM3 potion) {
        switch (potion) {
            case potiotMoney: 
            case potionElves1: 
            case potionBattleAxe: {
                return 30;
            }
            case potionGoldenDagger: 
            case potionGrass: {
                return 25;
            }
            case potionCofe: {
                return 10;
            }
        }
        return 0;
    }

    public static final boolean canLeaveDungeon(PotionM3 potion) {
        switch (potion) {
            case IncreaseEffectXP: 
            case IncreaseEffectHeal: 
            case IncreaseEffectDefense: 
            case IncreaseEffectPower: 
            case IncreaseEffectPenetrate: 
            case IncreaseEffectFinal: {
                return false;
            }
        }
        return true;
    }

    public static final AttackEffect effect(PotionEffectM3 PE, EntityPlayer player, AttackEffect data, boolean cantrigger, EntityLivingBase target, ManaMetalModRoot rootPlayer, ManaMetalModRoot rootTarget, WeaponType type, boolean isAttack) {
        switch (PE.ID) {
            case potionFlameGoldCup: {
                data.attack += 0.02f * (float)(1 + PE.LV);
                break;
            }
            case potionLostSoul: {
                data.InvincibilityFrames -= (1 + PE.LV) * 5;
                break;
            }
            case potionDefensiveStrategy: {
                data.defense += 1 * (1 + PE.LV);
                break;
            }
            case potionPhantom: {
                data.damage_reduce += 0.35f;
                break;
            }
            case potionPureSpring: {
                data.career_increase += 0.05f;
                break;
            }
            case potionBreakArmor: {
                data.damage_add += 0.3f * (float)(1 + PE.LV);
                break;
            }
            case potionBadArmor: {
                data.defense -= 100 * (1 + PE.LV);
                break;
            }
            case potionYear8Food: {
                data.attack = (float)((double)data.attack + 0.88);
                break;
            }
            case potionYear8Potion: {
                data.attack_base_magic += 88;
                data.attack_base_physical += 88;
                break;
            }
            case potionYear8Power: {
                data.attack = (float)((double)data.attack + 0.3);
                break;
            }
            case potionYear8Crystal: {
                data.final_attack += 0.08f;
                break;
            }
            case potionMysteriousIcecream: {
                data.attack = (float)((double)data.attack + 0.01 * (double)(1 + PE.LV));
                break;
            }
            case potionArrowSkill: {
                data.final_attack = (float)((double)data.final_attack + 0.03);
                if (PE.LV <= 0) break;
                data.final_attack = (float)((double)data.final_attack + 0.03 * (double)PE.LV);
                break;
            }
            case potionDake: {
                data.final_attack = (float)((double)data.final_attack + 0.2);
                if (PE.LV <= 0) break;
                data.final_attack = (float)((double)data.final_attack + 0.1 * (double)PE.LV);
                break;
            }
            case potionStarBash: {
                data.attack_base_physical += (1 + PE.LV) * 20;
                data.attack_base_magic += (1 + PE.LV) * 20;
                data.final_attack += (float)(1 + PE.LV) * 0.05f;
                break;
            }
            case potionBeat: {
                data.attack -= 1.0f;
                data.final_attack -= 0.1f;
                break;
            }
            case potionCurseOfTheRose: {
                data.attack -= 3.0f;
                break;
            }
            case potionGreatDivineIntervention: {
                data.avoid += 10;
                data.crit += 10;
                data.attack += 0.3f;
                data.critDamage += 0.3f;
                data.final_attack += 0.05f;
                break;
            }
            case potionRoseDivine: {
                data.avoid += 10;
                data.crit += 10;
                data.attack += 0.3f;
                data.critDamage += 0.3f;
                data.final_attack += 0.05f;
                break;
            }
            case potionWarHorn: {
                data.attack += 0.3f;
                data.final_attack += 0.05f;
                break;
            }
            case potionMysteriousClock: {
                switch (PE.LV) {
                    case 0: {
                        data.attack += 0.1f;
                        break;
                    }
                    case 1: {
                        data.critDamage += 0.1f;
                        break;
                    }
                    case 2: {
                        data.crit += 5;
                        break;
                    }
                    case 3: {
                        data.max_attack_base += 1000;
                        break;
                    }
                    case 4: {
                        data.penetration_base += 2;
                        break;
                    }
                    case 5: {
                        data.attack_base_physical += 10;
                        break;
                    }
                    case 6: {
                        data.attack_base_magic += 10;
                        break;
                    }
                    case 7: {
                        data.no_tack_damage += 100.0f;
                        break;
                    }
                    case 8: {
                        data.hp_blood += 0.01f;
                        break;
                    }
                    case 9: {
                        data.final_attack += 0.03f;
                    }
                }
                break;
            }
            case potionHalloween: {
                data.attack = (float)((double)data.attack + 0.3);
                break;
            }
            case potionPurePrayer: {
                data.final_attack += 0.05f;
                data.attack = (float)((double)data.attack + 0.6);
                data.defense += 60;
                break;
            }
            case IncreaseEffectFinal: {
                data.final_attack += 0.1f;
                break;
            }
            case IncreaseEffectPenetrate: {
                data.penetration_base += 12;
                break;
            }
            case IncreaseEffectPower: {
                data.attack_base_physical += 100;
                data.attack_base_magic += 100;
                data.attack += 1.0f;
                break;
            }
            case IncreaseEffectDefense: {
                data.defense += 40;
                data.damage_reduce += 0.3f;
                break;
            }
            case potionK4: {
                data.attack = (float)((double)data.attack + 0.2);
                if (PE.LV <= 0) break;
                data.attack += 0.2f * (float)PE.LV;
                break;
            }
            case potionLightSpeedCutting: {
                data.career_increase += 0.1f;
                break;
            }
            case potionScissors: {
                data.career_increase += 0.1f;
                break;
            }
            case potionBarrierGuardian: {
                data.career_increase += (float)(1 + PE.LV) * 0.01f;
                data.penetration_base += 1 + PE.LV;
                break;
            }
            case potionSoulFire: {
                data.attack = (float)((double)data.attack + 0.12);
                if (PE.LV <= 0) break;
                data.attack += 0.12f * (float)PE.LV;
                break;
            }
            case potionFanLightS: {
                data.attack = (float)((double)data.attack + 0.5);
                data.career_increase += 0.1f;
                data.penetration_base += 5;
                break;
            }
            case potionBarrow1: {
                data.attack += 1.0f;
                data.career_increase += 0.1f;
                break;
            }
            case potionC6: {
                data.attack += 1.0f;
                data.damage_reduce += 0.3f;
                break;
            }
            case potionC7: {
                data.attack += 0.5f;
                data.career_increase += 0.1f;
                break;
            }
            case potionDead: {
                data.attack += 0.5f;
                data.career_increase += 0.1f;
                data.penetration_base += 5;
                break;
            }
            case potionHerbalEssence: {
                data.career_increase += 0.1f;
                break;
            }
            case potionH3: {
                data.attack += 1.0f;
                if (PE.LV <= 0) break;
                data.attack += 0.4f;
                break;
            }
            case potionJunterTrack: {
                data.final_attack += 0.06f;
                data.attack += 0.6f;
                if (PE.LV > 0) {
                    data.final_attack += 0.06f * (float)PE.LV;
                    data.attack += 0.6f * (float)PE.LV;
                }
                if (PE.LV < 4) break;
                data.attack += 0.3f;
                break;
            }
            case potionFragmentTracking: {
                data.career_increase += 0.1f;
                break;
            }
            case potionBT2: {
                data.career_increase += 0.1f;
                break;
            }
            case potionBT3: {
                data.attack += 0.5f;
                break;
            }
            case potionBT4: {
                data.final_attack += 0.1f;
                data.attack += 2.0f;
                if (rootPlayer == null || rootPlayer.carrer.career_resource[1] <= 0) break;
                data.final_attack += 0.1f;
                data.career_increase += 0.1f;
                break;
            }
            case potionWolfThanks: {
                data.attack += 0.5f;
                break;
            }
            case potionPoisonMark: {
                data.career_increase += 0.1f;
                break;
            }
            case potionDarkAxeCut: {
                data.attack += 0.5f;
                data.final_attack += 0.1f;
                data.career_increase += 0.1f;
                break;
            }
            case potionMagicSave: {
                data.attack += 0.2f;
                data.final_attack += 0.02f;
                if (PE.LV <= 0) break;
                data.attack += 0.2f * (float)PE.LV;
                data.final_attack += 0.02f * (float)PE.LV;
                break;
            }
            case potionMagicFire: {
                data.attack += 0.5f;
                break;
            }
            case potionFireElement: {
                data.career_increase += 0.1f;
                break;
            }
            case potionBloodRage: {
                data.final_attack += 0.2f;
                break;
            }
            case potionRevenge: {
                data.career_increase += 0.1f;
                break;
            }
            case potionPhantomSword: {
                data.career_increase += 0.1f;
                break;
            }
            case pointAbsoluteDefense: {
                if (isAttack) break;
                data.del_damage = true;
                PotionEffectM3.reducePotionLV(rootPlayer, PotionM3.pointAbsoluteDefense);
                break;
            }
            case potionStealthAssassination: {
                data.damage_reduce += 0.25f;
                break;
            }
            case potionShadowShield: {
                data.defense += 30;
                break;
            }
            case potionASP_d7: {
                data.del_damage = true;
                break;
            }
            case potionK1: {
                if (isAttack) break;
                data.del_damage = true;
                PotionEffectM3.addPotion((EntityLivingBase)player, PotionM3.potionK2, 3, 0);
                break;
            }
            case potionSpawn1: {
                data.defense += 100;
                data.rdamage += 10;
                data.damage_reduce += 0.2f;
                break;
            }
            case potionSpawn2: {
                data.defense += 20;
                data.rdamage += 10;
                data.damage_reduce += 0.1f;
                break;
            }
            case potionMagicSword: {
                data.attack += 0.1f * (float)(PE.LV + 1);
                break;
            }
            case potionKLunaPower: {
                data.attack += 0.04f;
                if (PE.LV <= 0) break;
                data.attack += 0.04f * (float)PE.LV;
                break;
            }
            case potionK2: {
                data.final_attack += 0.3f;
                break;
            }
            case potionK3: {
                data.attack += 1.5f;
                data.final_attack += 0.5f;
                break;
            }
            case potionBowTimes: {
                int tempLV = PE.LV + 1;
                data.attack += 0.2f * (float)tempLV;
                data.final_attack += 0.02f * (float)tempLV;
                break;
            }
            case potionTea: {
                data.attack += 0.1f;
                data.penetration_base += 2;
                if (PE.LV <= 0) break;
                data.attack += 0.05f * (float)PE.LV;
                break;
            }
            case potionFocus: {
                data.attack += 0.1f;
                data.penetration_base += 5;
                if (PE.LV <= 0) break;
                data.attack += 0.05f * (float)PE.LV;
                break;
            }
            case potionTreatment: {
                if (player.field_70170_p.field_72995_K || !((float)rootPlayer.carrer.bloodData > player.func_110138_aP() * 0.9f)) break;
                int hpbloodheal = 50;
                if (PE.LV > 0) {
                    hpbloodheal += PE.LV * 50;
                }
                rootPlayer.carrer.addBloodData(hpbloodheal);
                break;
            }
            case potionGreenMirror: {
                data.attack_base_physical += 40;
                data.attack_base_magic += 40;
                data.final_attack += 0.1f;
                break;
            }
            case potionBlueMirror: {
                data.damage_reduce += 0.3f;
                data.final_attack += 0.1f;
                break;
            }
            case potionRedMirror: {
                data.attack += 0.3f;
                data.final_attack += 0.1f;
                break;
            }
            case potionASP_d1: {
                data.defense = (int)((float)data.defense + Math.max(0.0f, (float)rootPlayer.defe.getDefe() * 0.4f));
                break;
            }
            case potionASP_d2: {
                data.defense = (int)((double)data.defense + Math.max(0.0, (double)rootPlayer.defe.getDefe() * (0.05 * (double)PE.LV)));
                data.damage_reduce += 0.02f * (float)PE.LV;
                if (PE.LV < 5) break;
                data.reduce_gravity += 0.1f;
                break;
            }
            case potionASP_d3: {
                data.defense = (int)((float)data.defense + Math.max(0.0f, (float)rootPlayer.defe.getDefe() * 5.0f));
                break;
            }
            case potionASP_d4: {
                data.defense += 100;
                data.reduce_gravity += 0.1f;
                break;
            }
            case potionASP_d5: {
                data.damage_reduce += 0.3f;
                break;
            }
            case potionASP_d6: {
                data.defense = (int)((double)data.defense + Math.max(0.0, (double)rootPlayer.defe.getDefe() * (0.03 * (double)PE.LV)));
                data.damage_reduce += 0.02f * (float)PE.LV;
                if (PE.LV < 5) break;
                data.reduce_gravity += 0.08f;
                break;
            }
            case potionASP_d9: {
                data.defense = (int)((float)data.defense + Math.max(0.0f, (float)rootPlayer.defe.getDefe() * 0.15f));
                data.reduce_gravity += 0.1f;
                break;
            }
            case potionASP_r2: {
                data.attack += (float)PE.LV * 0.07f;
                data.critDamage += (float)PE.LV * 0.05f;
                break;
            }
            case potionASP_r7: {
                data.attack += (float)PE.LV * 0.05f;
                data.hp_blood += (float)PE.LV * 0.01f;
                break;
            }
            case potionASP_r9: {
                data.final_attack += 0.25f;
                data.attack_base += 48;
                break;
            }
            case potionASP_m1: 
            case potionASP_m2: {
                data.attack += (float)PE.LV * 0.15f;
                break;
            }
            case potionASP_m3: {
                data.final_attack += 0.3f;
                break;
            }
            case potionASP_m5: {
                data.attack += (float)PE.LV * 0.1f;
                break;
            }
            case potionASP_m6: {
                if (player.field_70170_p.field_72995_K) break;
                rootPlayer.mana.addPower((int)((float)rootPlayer.mana.getMagicMax() * 0.02f));
                break;
            }
            case potionASP_m7: {
                data.no_tack_damage += (float)rootPlayer.mana.getMagicMax() * 0.64f;
                break;
            }
            case potionASP_m8: {
                data.attack += (float)PE.LV * 0.03f;
                break;
            }
            case potionASP_m9: {
                data.final_attack += 0.2f;
                break;
            }
            case potionASP_f1: {
                data.attack += (float)PE.LV * 0.07f;
                break;
            }
            case potionASP_f5: {
                data.attack += (float)PE.LV * 0.04f;
                if (PE.LV < 10) break;
                data.final_attack += 0.1f;
                break;
            }
            case potionASP_f7: {
                data.attack += 0.3f;
                break;
            }
            case potionASP_f8: {
                data.damage_reduce += 0.15f;
                break;
            }
            case potionASP_f9: {
                data.damage_reduce = (float)((double)data.damage_reduce + 0.02 * (double)PE.LV);
                if (PE.LV < 5) break;
                data.no_tack_damage += player.func_110138_aP() * 0.05f;
                break;
            }
            case potionASP_f11: {
                data.damage_reduce += 0.75f;
                break;
            }
            case potionHoney: {
                data.critDamage += 0.2f;
                data.penetration_base += 3;
                if (rootPlayer.produce.getLV(Produce.Beekeeping) >= 2) {
                    data.attack += 0.05f;
                }
                if (rootPlayer.produce.getLV(Produce.Beekeeping) >= 6) {
                    data.attack += 0.05f;
                }
                if (rootPlayer.produce.getLV(Produce.Beekeeping) >= 9) {
                    data.attack += 0.05f;
                }
                if (PE.LV <= 0) break;
                data.attack += 0.05f * (float)PE.LV;
                break;
            }
            case potionCurse: {
                data.attack -= 0.3f;
                data.damage_add += 0.2f;
                if (PE.LV <= 0) break;
                data.attack -= 0.1f * (float)PE.LV;
                data.damage_add += 0.1f * (float)PE.LV;
                break;
            }
            case potionDessert: {
                data.avoid += 8;
                data.crit += 8;
                data.attack += 0.1f;
                data.critDamage += 0.2f;
                if (PE.LV <= 0) break;
                data.attack += 0.05f * (float)PE.LV;
                break;
            }
            case potionQuick: {
                data.avoid += 12;
                if (PE.LV <= 0) break;
                data.avoid += 4 * PE.LV;
                break;
            }
            case potionDamageShield: {
                if (target == null) break;
                PotionEffectM3.addPotion(target, PotionM3.potionDamageShield, 30, 0);
                break;
            }
            case potionIncrease: {
                if (type == null || type != WeaponType.PhysicalMelee) break;
                data.attack += 0.3f;
                if (PE.LV <= 0) break;
                data.attack += 0.1f * (float)PE.LV;
                break;
            }
            case potionArchery: {
                if (type == null || type != WeaponType.PhysicalRange) break;
                data.attack += 0.3f;
                if (PE.LV <= 0) break;
                data.attack += 0.1f * (float)PE.LV;
                break;
            }
            case potionMagicGuide: {
                if (type == null || type != WeaponType.Magic) break;
                data.attack += 0.3f;
                if (PE.LV <= 0) break;
                data.attack += 0.1f * (float)PE.LV;
                break;
            }
            case potiotSharp: {
                data.attack += 0.5f;
                break;
            }
            case potionDagger: {
                data.attack += 0.5f;
                break;
            }
            case potionBloodStasis: {
                data.hp_blood += 0.04f;
                data.career_increase += 0.1f;
                break;
            }
            case potionGrass: {
                data.attack = (float)((double)data.attack + 0.5);
                data.career_increase += 0.1f;
                break;
            }
            case potionbrewingS: {
                data.attack = (float)((double)data.attack + 0.3);
                data.crit += 4;
                data.penetration_base += 3;
                data.defense += 8;
                data.avoid += 4;
                data.rdamage += 2;
                if (PE.LV <= 0) break;
                data.attack += 0.1f * (float)PE.LV;
                break;
            }
            case potionCuisine: {
                data.attack = (float)((double)data.attack + 0.3);
                data.crit += 4;
                data.penetration_base += 3;
                data.defense += 8;
                data.avoid += 4;
                data.rdamage += 2;
                if (PE.LV <= 0) break;
                data.attack += 0.1f * (float)PE.LV;
                break;
            }
            case potiotGodPower: {
                data.attack = (float)((double)data.attack + 0.15);
                data.crit += 4;
                data.penetration_base += 3;
                data.defense += 8;
                data.avoid += 4;
                data.rdamage += 2;
                if (PE.LV <= 0) break;
                data.attack += 0.1f * (float)PE.LV;
                break;
            }
            case potionBattleAxe: {
                data.attack = (float)((double)data.attack + 0.15);
                data.crit += 4;
                data.penetration_base += 3;
                data.defense += 8;
                data.avoid += 4;
                data.rdamage += 2;
                break;
            }
            case potionHarp: {
                data.attack = (float)((double)data.attack + 0.15);
                data.crit += 4;
                data.penetration_base += 3;
                data.defense += 8;
                data.avoid += 4;
                data.rdamage += 2;
                if (PE.LV <= 0) break;
                data.attack += 0.05f * (float)PE.LV;
                break;
            }
            case potionHorn: {
                data.attack += 0.3f;
                if (PE.LV <= 0) break;
                data.attack += 0.1f * (float)PE.LV;
                break;
            }
            case potionPhysicallyInv: {
                data.attack += 0.4f;
                break;
            }
            case potionAccurate: {
                data.crit += 12;
                if (PE.LV <= 0) break;
                data.crit += 4 * PE.LV;
                break;
            }
            case potionMagic: {
                data.attack += 0.25f;
                if (PE.LV <= 0) break;
                data.attack += 0.1f * (float)PE.LV;
                break;
            }
            case potionStrike: {
                data.attack += 0.2f;
                if (PE.LV <= 0) break;
                data.attack += 0.1f * (float)PE.LV;
                break;
            }
            case potionPressure: {
                data.attack -= 0.3f;
                data.damage_add += 0.2f;
                if (PE.LV <= 0) break;
                data.attack -= 0.2f * (float)PE.LV;
                data.damage_add += 0.2f * (float)PE.LV;
                break;
            }
            case potionTrenches: {
                data.defense = (int)((float)data.defense + 60.0f);
                break;
            }
            case potionOfwar: {
                data.attack = (float)((double)data.attack + 0.5);
                data.final_attack += 0.1f;
                data.career_increase += 0.1f;
                break;
            }
            case potionOpblessing: {
                data.attack = (float)((double)data.attack + 0.15);
                data.crit += 4;
                data.penetration_base += 3;
                data.defense += 8;
                data.avoid += 4;
                break;
            }
            case potionSpellExcitation: {
                data.crit += 10;
                data.avoid += 10;
                data.penetration_base += 5;
                if (PE.LV <= 0) break;
                data.crit += 3 * PE.LV;
                data.avoid += 3 * PE.LV;
                break;
            }
            case potionPaoxiao: {
                data.attack += 0.3f;
                break;
            }
            case potionAlcohol: {
                data.attack += (float)(PE.LV + 1) * 0.3f;
                data.final_attack += (float)(PE.LV + 1) * 0.04f;
                break;
            }
            case potionAlcoholDrunk: {
                data.damage_add += (float)(PE.LV + 1) * 0.1f;
                data.defense -= (PE.LV + 1) * 120;
                break;
            }
            case potionbrewing1: {
                data.attack -= 0.2f;
                break;
            }
            case potionbrewing5: {
                data.penetration_base += 5;
                if (PE.LV <= 0) break;
                data.penetration_base += PE.LV;
                break;
            }
            case potionWhiteSnake: {
                data.attack += 0.3f;
                data.defense += 30;
                break;
            }
            case potionElves0: {
                data.attack = (float)((double)data.attack + 0.15);
                data.crit += 4;
                data.penetration_base += 3;
                data.defense += 8;
                data.avoid += 4;
                data.rdamage += 2;
                break;
            }
            case potionDarkPower: {
                if (PE.LV == 0) {
                    data.attack = (float)((double)data.attack + 0.3);
                    data.crit += 8;
                    data.penetration_base += 4;
                    data.defense += 16;
                    data.avoid += 8;
                    data.rdamage += 2;
                    data.final_attack += 0.3f;
                }
                if (PE.LV != 2) break;
                data.defense += 100;
                data.damage_reduce += 0.2f;
                break;
            }
            case potionFood2: {
                data.attack = (float)((double)data.attack + 0.3);
                data.crit += 4;
                data.penetration_base += 4;
                data.defense += 8;
                data.avoid += 4;
                data.rdamage += 2;
                break;
            }
            case potionAnesthetic: {
                data.attack += 1.0f;
                break;
            }
            case potionSwordman1: {
                data.attack += 1.0f;
                break;
            }
            case potionSwordman2: {
                data.attack += 0.02f;
                if (PE.LV <= 0) break;
                data.attack = (float)((double)data.attack + 0.02 * (double)PE.LV);
                break;
            }
            case potionBow2: {
                data.attack += 0.5f;
                data.career_increase += 0.1f;
                break;
            }
            case potionBook1: {
                data.attack += 0.5f;
                data.hp_blood += 0.04f;
                break;
            }
            case potionBook2: {
                data.attack += 0.5f;
                data.career_increase += 0.1f;
                break;
            }
            case potionDagger2: {
                data.attack += 0.2f;
                data.hp_blood += 0.05f;
                break;
            }
            case potionDagger3: {
                data.attack += 0.5f;
                data.final_attack += 0.1f;
                data.career_increase += 0.1f;
                break;
            }
            case potionDagger4: {
                data.final_attack += 0.3f;
                data.damage_add += 0.4f;
                break;
            }
            case potionSummon1: {
                data.attack += 0.5f;
                data.final_attack += 0.1f;
                data.career_increase += 0.1f;
                break;
            }
            case potionCruseman2: {
                data.attack += 0.2f;
                data.penetration_base += 2;
                break;
            }
            case potionL3: {
                data.attack += 0.5f;
                data.damage_reduce += 0.5f;
                data.defense = (int)((float)data.defense + 300.0f);
                break;
            }
            case potionL4: {
                data.attack = (float)((double)data.attack + 0.5);
                data.crit += 4;
                data.penetration_base += 3;
                data.defense += 8;
                data.avoid += 4;
                data.max_attack += 1.0f;
                break;
            }
            case potionElves2: {
                data.attack += 0.3f;
                break;
            }
            case potionItemLapudaArtifact1: {
                data.attack += 1.0f;
                break;
            }
            case potionPowerShield: {
                data.attack += 0.5f;
                break;
            }
            case potionCruseman1: {
                if (!player.field_70170_p.field_72995_K) {
                    rootPlayer.mana.addPower(100);
                }
                data.hp_blood += 0.05f;
                break;
            }
            case potionAncientSpell: {
                data.attack -= 1.0f;
                data.penetration_base -= 10;
                if (PE.LV <= 0) break;
                data.penetration_base -= 5 * PE.LV;
                data.attack -= 0.5f * (float)PE.LV;
                break;
            }
            case potiotFood: {
                data.career_increase += 0.1f;
                data.defense += 100;
                break;
            }
            case potionbrewing3: {
                data.defense += 36;
                if (PE.LV <= 0) break;
                data.defense += 8 * PE.LV;
                break;
            }
            case potionLavaDead: {
                data.defense -= 300;
                if (PE.LV <= 0) break;
                data.defense -= 100 * PE.LV;
                break;
            }
            case potionResistance2: {
                data.defense += 12;
                if (PE.LV <= 0) break;
                data.defense += 8 * PE.LV;
                break;
            }
            case potionFireTwitch: {
                data.avoid -= 200;
                if (PE.LV <= 0) break;
                data.avoid -= 100 * PE.LV;
                break;
            }
            case potionL1: {
                data.career_increase += 0.1f;
                break;
            }
            case potionBloodCruse: {
                if (!(player.func_110143_aJ() < player.func_110138_aP() * 0.5f)) break;
                data.attack -= 0.5f;
                data.crit -= 30;
                data.avoid -= 30;
                data.damage_add += 1.0f;
                break;
            }
            case potionParalysis: {
                data.attack = (float)((double)data.attack - 2.0);
                data.crit -= 300;
                data.penetration_base -= 50;
                data.defense -= 300;
                data.avoid -= 300;
                if (PE.LV <= 0) break;
                data.attack -= 1.0f * (float)PE.LV;
                break;
            }
            case potionDefenseCounterattack: {
                data.attack = (float)((double)data.attack + 1.0);
                break;
            }
            case potionBreakthrough: {
                data.max_attack += 3.0f;
                break;
            }
            case potionMoonEvent: {
                data.attack = (float)((double)data.attack + 0.2);
                data.crit += 4;
                data.avoid += 4;
                ++data.penetration_base;
                data.defense += 16;
            }
        }
        return data;
    }

    public static final AttackEffect targetEffect(PotionEffectM3 PE, EntityPlayer player, AttackEffect data, boolean cantrigger, EntityLivingBase target, ManaMetalModRoot rootPlayer, ManaMetalModRoot rootTarget, WeaponType type, boolean isAttack) {
        switch (PE.ID) {
            case potionShocked: {
                data.lower_toughness += 0.025f;
                data.lower_penetration_defense += 5;
                break;
            }
            case potionPaperShikigami: {
                data.lower_penetration_defense += 10;
                break;
            }
            case potionPoisonSwamp: {
                data.attack += 0.5f;
                data.lower_toughness += 0.05f;
                break;
            }
            case potionKillDemon: {
                data.attack += 0.2f;
                break;
            }
            case potionMagicArrow: {
                data.attack += 0.1f;
                break;
            }
            case potionPoisonCut: {
                data.attack += 0.1f;
                break;
            }
            case potionNightContract: {
                data.attack += 0.1f * (float)(PE.LV + 1);
                break;
            }
            case potionPoisonBlade: {
                data.attack += 0.1f;
                break;
            }
            case potionDivineLight: {
                data.attack += 0.3f;
                break;
            }
            case potionAbsoluteTenacity: {
                player.func_70097_a(AttackType.HighlyToxic, 500.0f);
                break;
            }
            case potionBreakdown: {
                data.attack += 0.1f;
                break;
            }
            case potionMoonCut: {
                data.attack += 0.2f;
                break;
            }
            case potionC3: {
                data.attack += 0.3f;
                break;
            }
            case potionASP_r1: {
                data.attack += 0.005f * (float)PE.LV;
                break;
            }
            case potionASP_r3: {
                data.attack += 0.2f;
                break;
            }
            case potionASP_f2: {
                data.attack += 0.05f * (float)PE.LV;
                break;
            }
            case potionDamageShield: {
                data.attack += 0.5f;
                break;
            }
            case potionBadArmor: {
                data.attack += 0.3f;
                if (PE.LV <= 0) break;
                data.attack += 0.3f * (float)PE.LV;
                break;
            }
            case potionSpirits: {
                data.attack += 0.2f;
                break;
            }
            case potionBow1: {
                data.attack += 0.1f;
                data.lower_toughness += 0.05f;
                break;
            }
            case potionC1: {
                data.attack += 0.5f;
                break;
            }
            case potionC2: {
                data.attack += 0.3f;
                break;
            }
            case potionC4: {
                data.attack += 0.3f;
                data.crit += 16;
                data.penetration_base += 8;
                break;
            }
            case potionC5: {
                data.attack += 0.5f;
                data.lower_penetration_defense += 10;
                break;
            }
            case potionC8: {
                data.attack += 0.3f;
                break;
            }
            case potionC9: {
                data.penetration_base += 8;
                break;
            }
            case potionC13: {
                data.attack += 0.4f;
                break;
            }
            case potionC16: {
                data.attack += 0.2f;
                break;
            }
            case potionC12: {
                data.attack += 0.3f;
                data.penetration_base += 10;
                data.critDamage += 0.3f;
                break;
            }
            case potionBowTarget: {
                data.attack += 1.5f;
                data.critDamage += 1.5f;
                break;
            }
            case potionH1: {
                data.attack += 0.1f;
                break;
            }
            case potionH2: {
                data.attack += 0.2f;
                data.lower_penetration_defense += 10;
                break;
            }
            case potionBT1: {
                data.attack += 0.3f;
                break;
            }
            case potionBT5: {
                data.attack += 0.1f;
                break;
            }
            case potionBT6: {
                data.attack += 0.2f;
                break;
            }
            case potionGuide: {
                data.attack += 0.2f;
                break;
            }
            case potionWindcut: {
                data.attack += 0.1f;
                break;
            }
            case potionInstantCut: {
                data.attack += 0.15f;
                break;
            }
            case potionTorrentSlash: {
                data.attack += 0.15f;
            }
        }
        return data;
    }

    public static final AttackEffect potionEffect(EntityPlayer player, AttackEffect data, boolean cantrigger, @Nullable EntityLivingBase target, ManaMetalModRoot rootPlayer, @Nullable ManaMetalModRoot rootTarget, @Nullable WeaponType type, boolean isAttack) {
        PotionEffectM3 PE;
        int s;
        if (isAttack && target != null && rootTarget != null) {
            List<PotionEffectM3> listtarget = PotionEffectM3.getPotions(rootTarget);
            for (s = 0; s < listtarget.size(); ++s) {
                PE = listtarget.get(s);
                PotionData.targetEffect(PE, player, data, cantrigger, target, rootPlayer, rootTarget, type, isAttack);
            }
        }
        List<PotionEffectM3> list = PotionEffectM3.getPotions(rootPlayer);
        for (s = 0; s < list.size(); ++s) {
            PE = list.get(s);
            PotionData.effect(PE, player, data, cantrigger, target, rootPlayer, rootTarget, type, isAttack);
        }
        return data;
    }
}

