/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.fishing;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.api.IFishIngRod;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.produce.Produce;
import project.studio.manametalmod.produce.fishing.EntityFishHookMana;
import project.studio.manametalmod.produce.fishing.FishingCore;
import project.studio.manametalmod.produce.fishing.FishingItemCore;
import project.studio.manametalmod.produce.fishing.FishingItemType;
import project.studio.manametalmod.produce.fishing.ItemFishBait;

public class ItemToolFistIngRod
extends ItemFishingRod
implements IFishIngRod {
    @SideOnly(value=Side.CLIENT)
    private IIcon theIcon;
    public float FishPower = 1.0f;
    Item.ToolMaterial ToolMaterial;
    public int attack;

    public ItemToolFistIngRod(Item.ToolMaterial ToolMaterialE, String name, float power, int attack) {
        this.func_77637_a(ManaMetalMod.tab_Fishery);
        this.func_77655_b(name);
        this.func_111206_d("manametalmod:" + name);
        this.FishPower = power;
        this.ToolMaterial = ToolMaterialE;
        this.func_77625_d(1);
        this.func_77656_e(-1);
        this.attack = attack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean ee) {
        list.add(MMM.getTranslateText("itemtool.mana.fishpoweropen"));
        list.add(MMM.getTranslateText("ArmorStrengthen.attack") + this.getAttack());
        list.add(EnumChatFormatting.GREEN + MMM.getTranslateText("itemtool.mana.fishpower") + (int)(this.FishPower * 100.0f) + "%");
        if (item.func_77942_o()) {
            NBTTagCompound display = new NBTTagCompound();
            display = item.field_77990_d;
            if (display.func_150297_b("Items", 9)) {
                NBTTagList nbttaglist = display.func_150295_c("Items", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                    byte b0 = nbttagcompound1.func_74771_c("Slot");
                    if (b0 < 0 || b0 >= 4) continue;
                    ItemStack items = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
                    list.add(EnumChatFormatting.YELLOW + items.func_82833_r());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.field_77791_bV = icon.func_94245_a(this.func_111208_A() + "_uncast");
        this.theIcon = icon.func_94245_a(this.func_111208_A() + "_cast");
    }

    public void setItemNBT(ItemStack item, boolean use) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = item.func_77978_p();
        tag.func_74757_a("using", use);
    }

    public boolean isCnaFishing(ItemStack item, EntityPlayer player) {
        if (item.func_77942_o()) {
            NBTTagCompound display = new NBTTagCompound();
            display = item.field_77990_d;
            if (display.func_150297_b("Items", 9)) {
                NBTTagList nbttaglist = display.func_150295_c("Items", 10);
                return nbttaglist.func_74745_c() >= 3;
            }
        }
        return false;
    }

    public int hasFishboit(EntityPlayer player) {
        for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
            ItemStack temp = player.field_71071_by.func_70301_a(s);
            if (temp == null || temp.func_77973_b() != FishingCore.ItemFishBaits) continue;
            ItemFishBait bait = (ItemFishBait)temp.func_77973_b();
            return ItemFishBait.getpower(temp.func_77960_j());
        }
        return 0;
    }

    public void clearFishboit(EntityPlayer player) {
        if (player.field_71071_by.func_146028_b(FishingCore.ItemFishOther1) && player.field_70170_p.field_73012_v.nextInt(5) == 0) {
            return;
        }
        for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
            ItemStack temp = player.field_71071_by.func_70301_a(s);
            if (temp == null || temp.func_77973_b() != FishingCore.ItemFishBaits) continue;
            --temp.field_77994_a;
            if (temp.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(s, null);
            }
            return;
        }
    }

    public void func_77663_a(ItemStack item, World world, Entity entity, int data, boolean p5) {
        super.func_77663_a(item, world, entity, data, p5);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            float check = 0.16666667f;
            if (player.func_71045_bC() == item && player.field_70733_aJ == check && !world.field_72995_K) {
                this.onItemLClick(item, world, player);
            }
        }
    }

    public ItemStack onItemLClick(ItemStack item, World world, EntityPlayer player) {
        ManaMetalModRoot root;
        if (player.field_71104_cf != null && (root = MMM.getEntityNBT(player)) != null && root.produce.isFishing() == 1) {
            if (player.field_71104_cf instanceof EntityFishHookMana) {
                if (((EntityFishHookMana)player.field_71104_cf).overtime <= 0) {
                    ((EntityFishHookMana)player.field_71104_cf).addANTPower();
                    MMM.playSoundFromServer(world, MMM.getMODID() + ":fishing2", new Pos((Entity)player), 1.0, 1.0, 3.0);
                }
            } else {
                MMM.Logg("[ERROR] fishing has error!");
            }
            player.func_71038_i();
        }
        return item;
    }

    public int getHookType(int data) {
        switch (data) {
            case 6: {
                return 1;
            }
            case 7: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 18: {
                return 4;
            }
            case 22: {
                return 5;
            }
        }
        return 0;
    }

    public int getFishlineColor(int data) {
        switch (data) {
            case 0: {
                return 0xA0A0A0;
            }
            case 1: {
                return 0x404040;
            }
            case 2: {
                return 0xEAEAEA;
            }
            case 3: {
                return 0xEAEAEA;
            }
            case 4: {
                return 3645160;
            }
            case 5: {
                return 16514872;
            }
            case 17: {
                return 0xFFFFFF;
            }
            case 21: {
                return 13831680;
            }
        }
        return 0;
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            player.openGui((Object)ManaMetalMod.instance, 202, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return item;
        }
        int power = this.hasFishboit(player);
        if (player.field_71104_cf != null) {
            ManaMetalModRoot root = MMM.getEntityNBT(player);
            if (root != null) {
                if (root.produce.isFishing() == 0) {
                    player.field_71104_cf.func_146034_e();
                    player.func_71038_i();
                } else if (root.produce.isFishing() == 2) {
                    this.setItemNBT(item, false);
                    int i = player.field_71104_cf.func_146034_e();
                    item.func_77972_a(i, (EntityLivingBase)player);
                    player.func_71038_i();
                } else if (root.produce.isFishing() == 1) {
                    if (player.field_71104_cf instanceof EntityFishHookMana) {
                        ((EntityFishHookMana)player.field_71104_cf).addPower();
                        if (world.field_73012_v.nextInt(3) == 0) {
                            player.func_85030_a(MMM.getMODID() + ":fishing1", 1.0f, 0.8f + world.field_73012_v.nextFloat() * 0.3f);
                        }
                    } else {
                        MMM.Logg("[ERROR] fishing has error!");
                    }
                } else if (root.produce.isFishing() == 3) {
                    this.setItemNBT(item, false);
                    item.func_77972_a(1, (EntityLivingBase)player);
                    player.field_71104_cf.func_70106_y();
                    player.func_71038_i();
                }
            }
        } else {
            ManaMetalModRoot root = MMM.getEntityNBT(player);
            if (root != null) {
                this.setItemNBT(item, true);
                root.produce.setFishing(0);
                root.produce.fishMoveSolt = 4;
                world.func_72956_a((Entity)player, MMM.getMODID() + ":fishrod_0", 1.0f, 1.0f);
                float[] data = new float[]{500.0f, 30 + power, 100.0f, 0 + power * 2, 1.0f, 1.0f, 0.0f};
                int hooktype = 0;
                int stringcolor = 0;
                if (item.func_77942_o()) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt = item.field_77990_d;
                    if (nbt.func_150297_b("Items", 9)) {
                        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
                        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                            NBTTagCompound tempnbt = nbttaglist.func_150305_b(i);
                            ItemStack items = ItemStack.func_77949_a((NBTTagCompound)tempnbt);
                            FishingItemType type = FishingItemCore.fish_effects.get((int)items.func_77960_j()).type;
                            for (int s = 0; s < FishingItemCore.fish_effects.get((int)items.func_77960_j()).effects.length; ++s) {
                                int n = FishingItemCore.fish_effects.get((int)items.func_77960_j()).effects[s].tyep.ordinal();
                                data[n] = data[n] + FishingItemCore.fish_effects.get((int)items.func_77960_j()).effects[s].effect;
                            }
                            if (type == FishingItemType.buoy) {
                                hooktype = this.getHookType(items.func_77960_j());
                            }
                            if (type != FishingItemType.fishline) continue;
                            stringcolor = this.getFishlineColor(items.func_77960_j());
                        }
                    }
                }
                int s = 0;
                while (s < data.length) {
                    int n = s++;
                    data[n] = data[n] * this.FishPower;
                }
                if (player.field_71071_by.func_146028_b(FishingCore.ItemFishOther3)) {
                    data[1] = data[1] + 20.0f;
                }
                EntityFishHookMana hook = new EntityFishHookMana(world, player, root.produce.getLV(Produce.Fishing), (int)data[0], (int)data[1], (int)data[2], (int)data[3], data[4], data[5], data[6], hooktype, stringcolor);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)hook);
                    if (player.field_71071_by.func_146028_b(FishingCore.ItemFishOther2)) {
                        MMM.addMessageBase(player, MMM.getTranslateText("MMM.info.fishingdata") + (int)data[1]);
                    }
                }
                this.clearFishboit(player);
                player.func_71038_i();
            }
        }
        return item;
    }

    public int func_77619_b() {
        return this.ToolMaterial.func_77995_e();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_94597_g() {
        return this.theIcon;
    }

    public boolean func_77616_k(ItemStack item) {
        return super.func_77616_k(item);
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        boolean using;
        NBTTagCompound tag;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((tag = stack.func_77978_p()).func_74764_b("using") && (using = tag.func_74767_n("using"))) {
            return this.theIcon;
        }
        return this.field_77791_bV;
    }

    @Override
    public float getFishPower() {
        return this.FishPower;
    }

    @Override
    public Item.ToolMaterial getToolMaterial() {
        return this.ToolMaterial;
    }

    @Override
    public int getAttack() {
        return this.attack;
    }
}

