/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.renderer.jsonblock;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import project.studio.manametalmod.renderer.jsonblock.ModelJson;

public class BlockJsonModelBake {
    public static List<BakedQuad> bakeElement(ModelJson.Element e, Map<String, IIcon> iconMap) {
        ArrayList<BakedQuad> out = new ArrayList<BakedQuad>();
        double x0 = (double)e.from[0] / 16.0;
        double y0 = (double)e.from[1] / 16.0;
        double z0 = (double)e.from[2] / 16.0;
        double x1 = (double)e.to[0] / 16.0;
        double y1 = (double)e.to[1] / 16.0;
        double z1 = (double)e.to[2] / 16.0;
        double[][] C = new double[8][3];
        C[BlockJsonModelBake.idx((int)0, (int)0, (int)0)] = new double[]{x0, y0, z0};
        C[BlockJsonModelBake.idx((int)1, (int)0, (int)0)] = new double[]{x1, y0, z0};
        C[BlockJsonModelBake.idx((int)0, (int)1, (int)0)] = new double[]{x0, y1, z0};
        C[BlockJsonModelBake.idx((int)1, (int)1, (int)0)] = new double[]{x1, y1, z0};
        C[BlockJsonModelBake.idx((int)0, (int)0, (int)1)] = new double[]{x0, y0, z1};
        C[BlockJsonModelBake.idx((int)1, (int)0, (int)1)] = new double[]{x1, y0, z1};
        C[BlockJsonModelBake.idx((int)0, (int)1, (int)1)] = new double[]{x0, y1, z1};
        C[BlockJsonModelBake.idx((int)1, (int)1, (int)1)] = new double[]{x1, y1, z1};
        if (e.rotation != null && e.rotation.angle != 0.0f) {
            char ax = Character.toLowerCase(e.rotation.axis.charAt(0));
            float ang = e.rotation.angle;
            float[] o = e.rotation != null ? e.rotation.origin : null;
            boolean originIsZero = o != null && o.length >= 3 && o[0] == 0.0f && o[1] == 0.0f && o[2] == 0.0f;
            float oxPx = originIsZero ? 8.0f : o[0];
            float oyPx = originIsZero ? (e.from[1] + e.to[1]) * 0.5f : o[1];
            float ozPx = originIsZero ? 8.0f : o[2];
            for (int i = 0; i < 8; ++i) {
                double[] r = BlockJsonModelBake.rotateAxisExact(C[i][0], C[i][1], C[i][2], oxPx, oyPx, ozPx, e.rotation.axis.charAt(0), e.rotation.angle);
                C[i][0] = r[0];
                C[i][1] = r[1];
                C[i][2] = r[2];
            }
        }
        BlockJsonModelBake.emitFaceFromCorners(out, e.faces.north, iconMap, C, new int[]{BlockJsonModelBake.idx(1, 1, 0), BlockJsonModelBake.idx(1, 0, 0), BlockJsonModelBake.idx(0, 0, 0), BlockJsonModelBake.idx(0, 1, 0)}, EnumFacing.NORTH);
        BlockJsonModelBake.emitFaceFromCorners(out, e.faces.south, iconMap, C, new int[]{BlockJsonModelBake.idx(0, 1, 1), BlockJsonModelBake.idx(0, 0, 1), BlockJsonModelBake.idx(1, 0, 1), BlockJsonModelBake.idx(1, 1, 1)}, EnumFacing.SOUTH);
        BlockJsonModelBake.emitFaceFromCorners(out, e.faces.west, iconMap, C, new int[]{BlockJsonModelBake.idx(0, 1, 0), BlockJsonModelBake.idx(0, 0, 0), BlockJsonModelBake.idx(0, 0, 1), BlockJsonModelBake.idx(0, 1, 1)}, EnumFacing.WEST);
        BlockJsonModelBake.emitFaceFromCorners(out, e.faces.east, iconMap, C, new int[]{BlockJsonModelBake.idx(1, 1, 1), BlockJsonModelBake.idx(1, 0, 1), BlockJsonModelBake.idx(1, 0, 0), BlockJsonModelBake.idx(1, 1, 0)}, EnumFacing.EAST);
        BlockJsonModelBake.emitFaceFromCorners(out, e.faces.down, iconMap, C, new int[]{BlockJsonModelBake.idx(0, 0, 1), BlockJsonModelBake.idx(0, 0, 0), BlockJsonModelBake.idx(1, 0, 0), BlockJsonModelBake.idx(1, 0, 1)}, EnumFacing.DOWN);
        BlockJsonModelBake.emitFaceFromCorners(out, e.faces.up, iconMap, C, new int[]{BlockJsonModelBake.idx(0, 1, 0), BlockJsonModelBake.idx(0, 1, 1), BlockJsonModelBake.idx(1, 1, 1), BlockJsonModelBake.idx(1, 1, 0)}, EnumFacing.UP);
        return out;
    }

    private static void emitFaceFromCorners(List<BakedQuad> out, ModelJson.Face f, Map<String, IIcon> iconMap, double[][] C, int[] id, EnumFacing facing) {
        if (f == null) {
            return;
        }
        IIcon icon = iconMap.get(f.texture.substring(1));
        if (icon == null) {
            return;
        }
        double[] vx = new double[4];
        double[] vy = new double[4];
        double[] vz = new double[4];
        for (int i = 0; i < 4; ++i) {
            vx[i] = C[id[i]][0];
            vy[i] = C[id[i]][1];
            vz[i] = C[id[i]][2];
        }
        float[] up = new float[4];
        float[] vp = new float[4];
        BlockJsonModelBake.assignUVForFace(f, facing, id, up, vp);
        BakedQuad q = new BakedQuad();
        for (int i = 0; i < 4; ++i) {
            q.vx[i] = vx[i];
            q.vy[i] = vy[i];
            q.vz[i] = vz[i];
            q.up[i] = up[i];
            q.vp[i] = vp[i];
        }
        q.icon = icon;
        q.face = facing;
        q.faceNormal = BlockJsonModelBake.normal(q.vx, q.vy, q.vz);
        out.add(q);
    }

    private static void assignUVForFace(ModelJson.Face f, EnumFacing face, int[] ids, float[] outU, float[] outV) {
        int steps;
        float u0 = f.uv[0];
        float v0 = f.uv[1];
        float u1 = f.uv[2];
        float v1 = f.uv[3];
        float du = u1 - u0;
        float dv = v1 - v0;
        int n = steps = f.rotation == null ? 0 : Integer.parseInt(f.rotation) / 90 & 3;
        if (face == EnumFacing.UP || face == EnumFacing.DOWN) {
            switch (steps) {
                case 1: {
                    steps = 3;
                    break;
                }
                case 3: {
                    steps = 1;
                }
            }
        }
        for (int i = 0; i < 4; ++i) {
            int idx = ids[i];
            int ix = idx & 1;
            int iz = idx >> 1 & 1;
            int iy = idx >> 2 & 1;
            float s = 0.0f;
            float t = 0.0f;
            switch (face) {
                case SOUTH: {
                    s = ix;
                    t = 1 - iy;
                    break;
                }
                case NORTH: {
                    s = 1 - ix;
                    t = 1 - iy;
                    break;
                }
                case EAST: {
                    s = 1 - iz;
                    t = 1 - iy;
                    break;
                }
                case WEST: {
                    s = iz;
                    t = 1 - iy;
                    break;
                }
                case DOWN: {
                    s = ix;
                    t = 1 - iz;
                    break;
                }
                case UP: {
                    s = ix;
                    t = iz;
                }
            }
            float ss = s;
            float tt = t;
            for (int r = 0; r < steps; ++r) {
                float ns = 1.0f - tt;
                float nt = ss;
                ss = ns;
                tt = nt;
            }
            outU[i] = u0 + du * ss;
            outV[i] = v0 + dv * tt;
        }
    }

    private static int idx(int ix, int iy, int iz) {
        return iy << 2 | iz << 1 | ix;
    }

    static double[] rotateAxisExact(double x, double y, double z, float oxPx, float oyPx, float ozPx, char axis, float angleDeg) {
        double ox = (double)oxPx / 16.0;
        double oy = (double)oyPx / 16.0;
        double oz = (double)ozPx / 16.0;
        double px = x - ox;
        double py = y - oy;
        double pz = z - oz;
        double a = Math.toRadians(angleDeg);
        double c = Math.cos(a);
        double s = Math.sin(a);
        double rx = px;
        double ry = py;
        double rz = pz;
        switch (Character.toLowerCase(axis)) {
            case 'x': {
                ry = py * c - pz * s;
                rz = py * s + pz * c;
                break;
            }
            case 'y': {
                rx = px * c - pz * s;
                rz = px * s + pz * c;
                break;
            }
            case 'z': {
                rx = px * c - py * s;
                ry = px * s + py * c;
                break;
            }
            default: {
                return new double[]{x, y, z};
            }
        }
        return new double[]{rx + ox, ry + oy, rz + oz};
    }

    public static double[] normal(double[] vx, double[] vy, double[] vz) {
        double[] dArray;
        double ay = vy[1] - vy[0];
        double bz = vz[2] - vz[0];
        double az = vz[1] - vz[0];
        double by = vy[2] - vy[0];
        double nx = ay * bz - az * by;
        double bx = vx[2] - vx[0];
        double ax = vx[1] - vx[0];
        double ny = az * bx - ax * bz;
        double nz = ax * by - ay * bz;
        double len = Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (len == 0.0) {
            double[] dArray2 = new double[3];
            dArray2[0] = 0.0;
            dArray2[1] = 1.0;
            dArray = dArray2;
            dArray2[2] = 0.0;
        } else {
            double[] dArray3 = new double[3];
            dArray3[0] = nx / len;
            dArray3[1] = ny / len;
            dArray = dArray3;
            dArray3[2] = nz / len;
        }
        return dArray;
    }

    public static class BakedQuad {
        public double[] faceNormal = new double[3];
        public final double[] vx = new double[4];
        public final double[] vy = new double[4];
        public final double[] vz = new double[4];
        public final float[] up = new float[4];
        public final float[] vp = new float[4];
        public IIcon icon;
        public EnumFacing face;
    }
}

