/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.skyadventure;

import net.minecraft.entity.player.EntityPlayer;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.skyadventure.GameSkyAdventure;
import project.studio.manametalmod.skyadventure.SkyCard;

public enum ChallengeType {
    None,
    Lightning,
    Fog,
    Wind,
    Fire,
    Rain,
    Treasure,
    Slime,
    Shark,
    Snake,
    Pirate,
    Mucus,
    Octopus,
    Dragon,
    Tortoise,
    SharkKing,
    SnakeKing,
    Battleship,
    Screw,
    OctopusPurple,
    DragonFire;

    static ChallengeType[] base;
    static ChallengeType[] d1;
    static ChallengeType[] d2;
    static ChallengeType[] d3;
    static ChallengeType[] d4;
    static ChallengeType[] d5;
    static ChallengeType[] d6;
    static ChallengeType[] d7;
    static ChallengeType[] d8;
    static ChallengeType[] d9;

    public String getUseText(GameSkyAdventure game, EntityPlayer player, SkyCard card, int type) {
        return player.getDisplayName() + game.text("try.usecard") + card.names() + game.text("try.usecard.result" + type);
    }

    public static ChallengeType getRendomTypeFromIsland(GameSkyAdventure game) {
        int LV2 = game.island;
        if (game.random.nextInt(100) > 95) {
            return ChallengeType.values()[game.random.nextInt(ChallengeType.values().length)];
        }
        if (game.random.nextInt(100) > 70) {
            return base[game.random.nextInt(base.length)];
        }
        if (LV2 > 30) {
            return d9[game.random.nextInt(d9.length)];
        }
        if (LV2 > 25) {
            return d8[game.random.nextInt(d8.length)];
        }
        if (LV2 > 21) {
            return d7[game.random.nextInt(d7.length)];
        }
        if (LV2 > 18) {
            return d6[game.random.nextInt(d6.length)];
        }
        if (LV2 > 15) {
            return d5[game.random.nextInt(d5.length)];
        }
        if (LV2 > 12) {
            return d4[game.random.nextInt(d4.length)];
        }
        if (LV2 > 9) {
            return d3[game.random.nextInt(d3.length)];
        }
        if (LV2 > 6) {
            return d2[game.random.nextInt(d2.length)];
        }
        if (LV2 > 3) {
            return d1[game.random.nextInt(d1.length)];
        }
        return d1[game.random.nextInt(d1.length)];
    }

    public int getTextureID() {
        switch (this) {
            case None: 
            case Treasure: 
            case Fire: 
            case Fog: 
            case Lightning: 
            case Rain: 
            case Wind: 
            case Slime: 
            case Shark: 
            case Snake: 
            case Pirate: 
            case Mucus: 
            case Octopus: 
            case Dragon: {
                return 1;
            }
            case Tortoise: 
            case SharkKing: 
            case SnakeKing: 
            case Battleship: 
            case Screw: 
            case OctopusPurple: 
            case DragonFire: {
                return 2;
            }
        }
        return 1;
    }

    public boolean isBattleChallenge() {
        switch (this) {
            case Slime: 
            case Shark: 
            case Snake: 
            case Pirate: 
            case Mucus: 
            case Octopus: 
            case Dragon: 
            case Tortoise: 
            case SharkKing: 
            case SnakeKing: 
            case Battleship: 
            case Screw: 
            case OctopusPurple: 
            case DragonFire: {
                return true;
            }
        }
        return false;
    }

    public int getUV() {
        switch (this) {
            case Slime: 
            case Shark: 
            case Snake: 
            case Pirate: 
            case Mucus: 
            case Octopus: 
            case Dragon: {
                return 0 + 33 * (this.ordinal() - 7);
            }
            case Tortoise: 
            case SharkKing: 
            case SnakeKing: 
            case Battleship: 
            case Screw: 
            case OctopusPurple: 
            case DragonFire: {
                return 0 + 33 * (this.ordinal() - 14);
            }
        }
        return 0;
    }

    public int getMonsterHP(GameSkyAdventure game) {
        switch (this) {
            case Slime: {
                return 100;
            }
            case Shark: {
                return 300;
            }
            case Snake: {
                return 350;
            }
            case Pirate: {
                return 400;
            }
            case Mucus: {
                return 450;
            }
            case Octopus: {
                return 700;
            }
            case Dragon: {
                return 800;
            }
            case Tortoise: {
                return 900;
            }
            case SharkKing: {
                return 950;
            }
            case SnakeKing: {
                return 1000;
            }
            case Battleship: {
                return 1100;
            }
            case Screw: {
                return 1250;
            }
            case OctopusPurple: {
                return 1300;
            }
            case DragonFire: {
                return 1500;
            }
        }
        return 0;
    }

    public int getDamageTime(GameSkyAdventure game) {
        switch (this) {
            case None: 
            case Treasure: {
                return 1;
            }
            case Fire: 
            case Fog: 
            case Lightning: 
            case Rain: 
            case Wind: {
                return 4;
            }
            case Slime: {
                return 4;
            }
            case Shark: {
                return 5;
            }
            case Pirate: 
            case Octopus: {
                return 2;
            }
            case Snake: 
            case Mucus: {
                return 3;
            }
            case Dragon: {
                return 5;
            }
            case Tortoise: {
                return 5;
            }
            case SharkKing: {
                return 2;
            }
            case SnakeKing: {
                return 4;
            }
            case Battleship: {
                return 4;
            }
            case Screw: {
                return 3;
            }
            case OctopusPurple: {
                return 3;
            }
            case DragonFire: {
                return 6;
            }
        }
        return 1;
    }

    public int getDamage(GameSkyAdventure game) {
        switch (this) {
            case None: 
            case Treasure: {
                return 0;
            }
            case Fire: 
            case Rain: {
                return 50;
            }
            case Fog: 
            case Lightning: {
                return 30 + game.random.nextInt(20);
            }
            case Wind: {
                return 40 + game.random.nextInt(20);
            }
            case Slime: {
                return 30 + game.random.nextInt(10);
            }
            case Shark: 
            case Snake: {
                return 45 + game.random.nextInt(10);
            }
            case Pirate: {
                return 30 + game.random.nextInt(10);
            }
            case Mucus: {
                return 55 + game.random.nextInt(10);
            }
            case Octopus: {
                return 40 + game.random.nextInt(10);
            }
            case Dragon: {
                return 100 + game.random.nextInt(10);
            }
            case Tortoise: {
                return 110 + game.random.nextInt(10);
            }
            case SharkKing: {
                return 40 + game.random.nextInt(10);
            }
            case SnakeKing: {
                return 80 + game.random.nextInt(10);
            }
            case Battleship: {
                return 80 + game.random.nextInt(10);
            }
            case Screw: {
                return 80 + game.random.nextInt(10);
            }
            case OctopusPurple: {
                return 90 + game.random.nextInt(10);
            }
            case DragonFire: {
                return 300 + game.random.nextInt(10);
            }
        }
        return 30;
    }

    public boolean tryUseCard(GameSkyAdventure game, EntityPlayer player, SkyCard card) {
        switch (this) {
            case None: {
                game.setGameInfo(this.getUseText(game, player, card, 4));
                return true;
            }
            case Fire: 
            case Fog: 
            case Lightning: 
            case Rain: 
            case Wind: {
                if (this.toString().equals(card.toString()) || card == SkyCard.Crossing) {
                    game.setGameInfo(this.getUseText(game, player, card, 1));
                    return true;
                }
                game.setGameInfo(this.getUseText(game, player, card, 0));
                return false;
            }
            case Treasure: {
                if (card == SkyCard.Treasure) {
                    game.setGameInfo(this.getUseText(game, player, card, 2));
                    game.addTreasure(game.gameplayer, game.random.nextInt(100) + 100);
                    game.addExp(game.gameplayer, game.random.nextInt(50) + 50);
                }
                game.setGameInfo(this.getUseText(game, player, card, 3));
                return true;
            }
            case Slime: 
            case Shark: 
            case Snake: 
            case Pirate: 
            case Mucus: 
            case Octopus: 
            case Dragon: 
            case Tortoise: 
            case SharkKing: 
            case SnakeKing: 
            case Battleship: 
            case Screw: 
            case OctopusPurple: 
            case DragonFire: {
                if (card.isBattleCard()) {
                    int damage = card.tryAttack(game);
                    if (damage > 0) {
                        game.attack(damage, card);
                    }
                    if (game.MonsterHP > 0) break;
                    return true;
                }
                game.setGameInfo(player.func_70005_c_() + MMM.getTranslateText("use.card.noattack") + card.names() + MMM.getTranslateText("GameSkyAdventure.try.usecard.result0"));
            }
        }
        return false;
    }

    public String names() {
        return MMM.getTranslateText("ChallengeType." + this.toString());
    }

    static {
        base = new ChallengeType[]{Lightning, Fog, Wind, Fire, Rain, Treasure, None};
        d1 = new ChallengeType[]{Slime, Slime, Shark, Snake};
        d2 = new ChallengeType[]{Slime, Shark, Snake, Pirate};
        d3 = new ChallengeType[]{Pirate, Mucus, Octopus};
        d4 = new ChallengeType[]{Mucus, Octopus, Dragon};
        d5 = new ChallengeType[]{Octopus, Dragon, Tortoise};
        d6 = new ChallengeType[]{Tortoise, SharkKing, SnakeKing};
        d7 = new ChallengeType[]{SharkKing, SnakeKing, Battleship, Screw};
        d8 = new ChallengeType[]{SharkKing, SnakeKing, Battleship, Screw, OctopusPurple, DragonFire};
        d9 = new ChallengeType[]{Screw, OctopusPurple, DragonFire};
    }
}

