/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.soulinherit;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.CareerCore;
import project.studio.manametalmod.core.ItemEffect;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.event.EventFx;
import project.studio.manametalmod.soulinherit.SoulInherit;
import project.studio.manametalmod.spell.EventSpell;

public class SoulInheritCore {
    public static final Map<String, SoulInherit> SoulInheritPool = new HashMap<String, SoulInherit>();
    public static final String key = "SoulInherit";
    public static final String keyList = "SoulInheritList";
    public static final String keyPlayerName = "SoulInheritPlayer";

    public static void playerLogin(EntityPlayer player) {
        String name;
        if (!player.field_70170_p.field_72995_K && !SoulInheritPool.containsKey(name = player.func_70005_c_())) {
            SoulInheritPool.put(name, new SoulInherit(name));
        }
    }

    public static void changeCareer(EntityPlayer player, CareerCore target) {
        ManaMetalModRoot root;
        if (!player.field_70170_p.field_72995_K && (root = MMM.getEntityNBT(player)) != null) {
            if (root.carrer.removeTime > 0) {
                MMM.addMessage(player, "MMM.info.cantSoulInheritCore", root.carrer.removeTime);
                return;
            }
            SoulInherit soul = SoulInheritCore.get(player);
            soul.save(root);
            if (root.carrer.getSpellLV_1()[5] > 0) {
                EventSpell.onAddPassiveSpillLV1(player, root, true, true);
            }
            if (root.carrer.getSpellLV_2()[0] > 0) {
                EventSpell.onAddPassiveSpillLV2(player, root, true, true);
            }
            CareerCore.removePoitnBase(player, root, CareerCore.CareerPoint.Power, root.carrer.getPowerPoint(), false);
            CareerCore.removePoitnBase(player, root, CareerCore.CareerPoint.Agile, root.carrer.getAgilePoint(), false);
            CareerCore.removePoitnBase(player, root, CareerCore.CareerPoint.Intelligence, root.carrer.getIntelligencePoint(), false);
            CareerCore.removePoitnBase(player, root, CareerCore.CareerPoint.Wis, root.carrer.getWisPoint(), false);
            CareerCore.removePoitnBase(player, root, CareerCore.CareerPoint.Con, root.carrer.getConPoint(), false);
            CareerCore.setPlayerCarrerModifier(player, target, true);
            CareerCore.setModPointUseRanUUID(player, ItemEffect.HP, -root.carrer.LVUPaddHP);
            root.carrer.addExtraHP(-root.carrer.LVUPaddHP);
            root.carrer.LVUPaddHP = 0;
            root.specialization.remove();
            soul.load(root, target);
            CareerCore.addPoitnBase(player, root, CareerCore.CareerPoint.Power, root.carrer.getPowerPoint(), false);
            CareerCore.addPoitnBase(player, root, CareerCore.CareerPoint.Agile, root.carrer.getAgilePoint(), false);
            CareerCore.addPoitnBase(player, root, CareerCore.CareerPoint.Intelligence, root.carrer.getIntelligencePoint(), false);
            CareerCore.addPoitnBase(player, root, CareerCore.CareerPoint.Wis, root.carrer.getWisPoint(), false);
            CareerCore.addPoitnBase(player, root, CareerCore.CareerPoint.Con, root.carrer.getConPoint(), false);
            CareerCore.setPlayerCarrerModifier(player, target, false);
            root.carrer.setCareerType(target.getID());
            if (root.carrer.getSpellLV_1()[5] > 0) {
                EventSpell.onAddPassiveSpillLV1(player, root, false, true);
            }
            if (root.carrer.getSpellLV_2()[0] > 0) {
                EventSpell.onAddPassiveSpillLV2(player, root, false, true);
            }
            root.specialization.apply();
            int hpbase = target.getLVUPaddHP();
            int LV2 = root.carrer.getLv() - 1;
            if (LV2 > 0) {
                int hp = hpbase * LV2;
                CareerCore.setModPointUseRanUUID(player, ItemEffect.HP, hp);
                root.carrer.addExtraHP(hp);
                root.carrer.LVUPaddHP = hp;
            }
            player.func_70606_j(player.func_110138_aP());
            root.carrer.setCareerUse1(0);
            root.carrer.setCareerUse2(0);
            root.carrer.setCareerUse3(0);
            root.carrer.setCareerUse4(0);
            root.carrer.setCareerUse5(0);
            root.carrer.careerUseLV2_1 = 0;
            root.carrer.careerUseLV2_2 = 0;
            root.carrer.careerUseLV2_3 = 0;
            root.carrer.careerUseLV2_4 = 0;
            root.carrer.careerUseLV2_5 = 0;
            root.carrer.career_resource = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int[] spellCD_LV1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
            int[] spellCD_LV2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
            root.carrer.setSpellCD_LV1(spellCD_LV1);
            root.carrer.setSpellCD_LV2(spellCD_LV2);
            root.carrer.removeTime = MMM.isPlayerCreativeMode(player) ? 2 : 600;
            root.carrer.send2();
            root.specialization.send2();
            MMM.addMessage(player, "MMM.info.changeCareerSoul", MMM.getTranslateText("career.enum.name." + target.toString()));
            EventFx.resetPlayerAattribute(player, false);
        }
    }

    public static SoulInherit get(EntityPlayer player) {
        String name = player.func_70005_c_();
        if (SoulInheritPool.containsKey(name)) {
            return SoulInheritPool.get(name);
        }
        SoulInherit soul = new SoulInherit(name);
        SoulInheritPool.put(name, soul);
        return soul;
    }

    public static void load(WorldEvent.Load event) {
        if (!event.world.field_72995_K && MMM.getDimensionID(event.world) == 0 && MMM.getWorldData(event.world).getSoulInheritData().func_150297_b(key, 9)) {
            NBTTagList list = MMM.getWorldData(event.world).getSoulInheritData().func_150295_c(key, 10);
            int size = list.func_74745_c();
            if (size > 0) {
                SoulInheritPool.clear();
                for (int s = 0; s < size; ++s) {
                    NBTTagCompound tag = list.func_150305_b(s);
                    String playername = tag.func_74779_i(keyPlayerName);
                    SoulInheritPool.put(playername, SoulInherit.readFromNBT(tag, playername));
                }
                MMM.Logg("load SoulInherit");
            } else {
                MMM.Logg("trying to load an empty SoulInherit");
            }
        }
    }

    public static void save(WorldEvent.Save event) {
        if (!event.world.field_72995_K && MMM.getDimensionID(event.world) == 0) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<String, SoulInherit> entry : SoulInheritPool.entrySet()) {
                SoulInherit temp = entry.getValue();
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a(keyPlayerName, entry.getKey());
                SoulInherit.saveToNBT(tag, temp);
                list.func_74742_a((NBTBase)tag);
            }
            if (list.func_74745_c() > 0) {
                MMM.getWorldData(event.world).getSoulInheritData().func_74782_a(key, (NBTBase)list);
                MMM.getWorldData(event.world).func_76185_a();
                MMM.Logg("save SoulInherit");
            } else {
                MMM.Logg("trying to save an empty SoulInherit");
            }
        }
    }
}

