/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.spell;

import java.util.HashMap;
import java.util.Map;
import project.studio.manametalmod.battle.WeaponType;
import project.studio.manametalmod.core.CareerCore;
import project.studio.manametalmod.core.SpellItemType;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.spell.Spell;
import project.studio.manametalmod.spell.SpellClass;
import project.studio.manametalmod.spell.SpellID;
import project.studio.manametalmod.spell.SpellType;

public class SpellData {
    public static Map<SpellID, Spell>[] spell_map;
    public static final Spell Instantaneous;
    public static final Spell CombatMind;
    public static final Spell DarkPower;
    public static final Spell DarkPowerDestroy;
    public static final Spell DarkPowerGuard;

    public static final Spell getData(CareerCore career, SpellID spelltype) {
        return spell_map[career.ordinal()].get((Object)spelltype);
    }

    public static final void init() {
        int career_count = CareerCore.values().length;
        spell_map = new HashMap[career_count];
        for (int s = 0; s < career_count; ++s) {
            SpellData.spell_map[s] = new HashMap<SpellID, Spell>(16);
        }
        SpellData.ATTACK(SpellID.A0_SwordWave, 200, 2, 1.5f, 1, -1, -1, ManaElements.Wind, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Swordsman);
        SpellData.BUFF(SpellID.A0_CombatDefense, 300, 5, 60, 6, ManaElements.Earthm, CareerCore.Swordsman).setRidicule_time(30);
        SpellData.BUFF(SpellID.A102_SerialChop, 300, 60, 60, 6, ManaElements.Earthm, CareerCore.Swordsman).setAoe_range(4).setRidicule_time(10);
        SpellData.ATTACK(SpellID.A103_MoonCut, 200, 8, 1.0f, 5, 4, 60, ManaElements.Dark, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Swordsman);
        SpellData.ATTACK(SpellID.A104_ShadowSword, 400, 16, 1.5f, 12, 4, 60, ManaElements.Dark, WeaponType.PhysicalMelee, SpellType.Shadow, CareerCore.Swordsman).setRange(32).setAoe_range(4);
        SpellData.PASSIVE(SpellID.S1_SwordExpertise, CareerCore.Swordsman);
        SpellData.PASSIVE(SpellID.S2_SwordMaster, CareerCore.Swordsman).setBaseTimeUPLevel(120);
        SpellData.ATTACK(SpellID.A201_Anger, 600, 100, 4.5f, 1, -1, 90, ManaElements.Fire, WeaponType.PhysicalMelee, SpellType.Spirit, CareerCore.Swordsman).setAoe_range(10).setRange(10).setBaseTimeUPLevel(90);
        SpellData.ATTACK(SpellID.A202_FuriousSwordSlash, 600, 12, 4.2f, 12, 4, -1, ManaElements.Fire, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Swordsman);
        SpellData.BUFF(SpellID.A203_BloodyOath, 800, 90, 60, 6, ManaElements.Earthm, CareerCore.Swordsman).setRange(32).setHealPower(400);
        SpellData.ATTACK(SpellID.B206_TornadoSwordSlash, 1500, 600, 2.75f, 240, 5, 60, ManaElements.Wind, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Swordsman).setAoe_range(16).setSpellClass(SpellClass.superspell);
        SpellData.ATTACK(SpellID.A0_ParalyzingTrap, 200, 20, 0.5f, 20, 20, 60, ManaElements.Thunder, WeaponType.PhysicalRange, SpellType.ThunderDamage, CareerCore.Ranger).setAoe_range(4).setPerLevelTime(3);
        SpellData.ATTACK(SpellID.A0_PiercingArrow, 200, 3, 1.0f, 3, -1, 30, ManaElements.Wind, WeaponType.PhysicalRange, SpellType.Wave, CareerCore.Ranger).setPerLevelTime(1);
        SpellData.ATTACK(SpellID.A102_FiveArrows, 300, 10, 1.0f, 5, 4, -1, ManaElements.Wind, WeaponType.PhysicalRange, SpellType.FireDamage, CareerCore.Ranger);
        SpellData.ATTACK(SpellID.A103_ExplosiveArrow, 300, 15, 2.4f, 3, 5, 60, ManaElements.Fire, WeaponType.PhysicalRange, SpellType.Explosion, CareerCore.Ranger).setRange(32).setAoe_range(4).setPerLevelTime(3);
        SpellData.ATTACK(SpellID.A104_LightningArrow, 300, 20, 2.4f, 6, 20, 5, ManaElements.Thunder, WeaponType.PhysicalRange, SpellType.ThunderDamage, CareerCore.Ranger).setAoe_range(4);
        SpellData.PASSIVE(SpellID.S1_ArcheryExpertise, CareerCore.Ranger).setBaseTimeUPLevel(20);
        SpellData.PASSIVE(SpellID.S2_ChargeShot, CareerCore.Ranger).setBaseTimeUPLevel(20);
        SpellData.ATTACK(SpellID.A201_UnitedInOne, 600, 16, 3.3f, 24, 1, -1, ManaElements.Wind, WeaponType.PhysicalRange, SpellType.Puncture, CareerCore.Ranger);
        SpellData.ATTACK(SpellID.A202_PenetratingAssault, 800, 24, 3.2f, 10, -1, 60, ManaElements.Dark, WeaponType.PhysicalRange, SpellType.Wave, CareerCore.Ranger);
        SpellData.BUFF(SpellID.A203_WindGodBlessing, 800, 90, 60, 6, ManaElements.Earthm, CareerCore.Ranger).setRange(32);
        SpellData.ATTACK(SpellID.B206_StormyArrowsRain, 1500, 600, 5.0f, 600, 2, 60, ManaElements.Wind, WeaponType.PhysicalRange, SpellType.WindDamage, CareerCore.Ranger).setAoe_range(8).setSpellClass(SpellClass.superspell);
        SpellData.ATTACK(SpellID.A0_FrostCurse, 200, 10, 0.75f, 9, 5, 5, ManaElements.Ice, WeaponType.Magic, SpellType.IceDamage, CareerCore.Wizard).setAoe_range(8).setPerLevelTime(0);
        SpellData.BUFF(SpellID.A0_MagicAbsorption, 100, 90, 60, 6, ManaElements.Magic, CareerCore.Wizard).setRange(32);
        SpellData.ATTACK(SpellID.A102_FlameBall, 200, 10, 0.55f, 3, 5, 60, ManaElements.Fire, WeaponType.Magic, SpellType.FireDamage, CareerCore.Wizard).setProjectileCount(3).setAoe_range(4).setPerLevelTime(3);
        SpellData.ATTACK(SpellID.A103_MagicArrow, 400, 16, 1.0f, 12, 4, 30, ManaElements.Magic, WeaponType.Magic, SpellType.Wave, CareerCore.Wizard).setPerLevelTime(2);
        SpellData.BUFF(SpellID.A104_MagicShield, 300, 60, 60, 6, ManaElements.Magic, CareerCore.Wizard).setRange(32);
        SpellData.PASSIVE(SpellID.S1_ManaMastery, CareerCore.Wizard);
        SpellData.PASSIVE(SpellID.S2_DestroyMagic, CareerCore.Wizard);
        SpellData.ATTACK(SpellID.A201_IcicleCombo, 600, 80, 0.6f, 400, 1, 20, ManaElements.Ice, WeaponType.Magic, SpellType.IceDamage, CareerCore.Wizard).setAoe_range(50);
        SpellData.ATTACK(SpellID.A202_ElementExplosion, 800, 10, 1.0f, 5, -1, -1, ManaElements.Magic, WeaponType.Magic, SpellType.Eliminate, CareerCore.Wizard).setProjectileCount(3).setAoe_range(7);
        SpellData.BUFF(SpellID.A203_InfiniteMagic, 800, 120, 60, 6, ManaElements.Magic, CareerCore.Wizard).setRange(32);
        SpellData.ATTACK(SpellID.B206_ThunderStorm, 1500, 600, 4.25f, 400, 2, 30, ManaElements.Thunder, WeaponType.Magic, SpellType.ThunderDamage, CareerCore.Wizard).setAoe_range(16).setSpellClass(SpellClass.superspell);
        SpellData.BUFF(SpellID.A0_Thrust, 300, 1, 5, 1, ManaElements.Earthm, CareerCore.Assassin);
        SpellData.ATTACK(SpellID.A0_PoisonDagger, 200, 12, 0.4f, 2, 20, 30, ManaElements.Grass, WeaponType.PhysicalMelee, SpellType.Poison, CareerCore.Assassin).setDotDamage(0.5f, 10).setDotAttackData(WeaponType.PhysicalMelee, ManaElements.Grass, SpellType.Poison).setProjectileCount(3).setPerLevelTime(2);
        SpellData.ATTACK(SpellID.A102_ChainDarts, 300, 12, 1.0f, 5, 4, -1, ManaElements.Wind, WeaponType.PhysicalMelee, SpellType.Puncture, CareerCore.Assassin).setProjectileCount(5);
        SpellData.ATTACK(SpellID.A103_StrongLightningStrike, 300, 12, 1.05f, 5, 5, -1, ManaElements.Thunder, WeaponType.PhysicalMelee, SpellType.ThunderDamage, CareerCore.Assassin);
        SpellData.BUFF(SpellID.A104_Phagocytosis, 300, 90, 60, 6, ManaElements.Dark, CareerCore.Assassin).setRange(32);
        SpellData.PASSIVE(SpellID.S1_Trinity, CareerCore.Assassin).setBaseTimeUPLevel(10).setHealPower(3000);
        SpellData.PASSIVE(SpellID.S2_NightContract, CareerCore.Assassin).setBaseTimeUPLevel(60);
        SpellData.ATTACK(SpellID.A201_DaggerSwordDance, 600, 12, 1.68f, 3, 4, 30, ManaElements.Grass, WeaponType.PhysicalMelee, SpellType.Puncture, CareerCore.Assassin).setProjectileCount(5).setDotDamage(0.5f, 10).setDotAttackData(WeaponType.PhysicalMelee, ManaElements.Water, SpellType.Acidic);
        SpellData.ATTACK(SpellID.A202_Crosscut, 800, 24, 5.5f, 2, -1, -1, ManaElements.Dark, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Assassin).setAoe_range(3);
        SpellData.BUFF(SpellID.A203_PutAlloneEggsInOneBasket, 800, 90, 60, 6, ManaElements.Earthm, CareerCore.Assassin).setRange(32);
        SpellData.ATTACK(SpellID.B206_BladeMaze, 1500, 600, 2.55f, 1000, 2, 30, ManaElements.Wind, WeaponType.PhysicalMelee, SpellType.WindDamage, CareerCore.Assassin).setAoe_range(2).setSpellClass(SpellClass.superspell);
        SpellData.ATTACK(SpellID.A0_BattleCry, 200, 5, 1.0f, 1, -1, 20, ManaElements.Dark, WeaponType.PhysicalMelee, SpellType.Spirit, CareerCore.Knight).setAoe_range(16).setRidicule_time(30).setPerLevelTime(1);
        SpellData.BUFF(SpellID.A0_SlfRecovery, 100, 5, 60, 6, ManaElements.Earthm, CareerCore.Knight).setHealPower(800).setBaseTimeUPLevel(60).setSpeed(10);
        SpellData.ATTACK(SpellID.A102_Sacrifice, 200, 25, 2.5f, 5, -1, 60, ManaElements.Dark, WeaponType.PhysicalMelee, SpellType.Dead, CareerCore.Knight).setHealPower(6000).setRange(32).setAoe_range(10).setPerLevelTime(3);
        SpellData.ATTACK(SpellID.A103_TornadoAxe, 400, 5, 2.5f, 1, -1, 60, ManaElements.Wind, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Knight).setAoe_range(10).setRange(10).setPerLevelTime(3);
        SpellData.ATTACK(SpellID.A104_GroundHammer, 400, 30, 0.7f, 40, 5, 10, ManaElements.Earthm, WeaponType.PhysicalMelee, SpellType.Earthquake, CareerCore.Knight).setAoe_range(2);
        SpellData.PASSIVE(SpellID.S1_DefenseSystem, CareerCore.Knight);
        SpellData.PASSIVE(SpellID.S2_SurpriseBones, CareerCore.Knight).setCD(210);
        SpellData.ATTACK(SpellID.A201_ShadowHammer, 600, 40, 1.35f, 80, 5, 20, ManaElements.Dark, WeaponType.PhysicalMelee, SpellType.DarkMagic, CareerCore.Knight).setAoe_range(10);
        SpellData.ATTACK(SpellID.A202_FlameOfPurgatory, 800, 15, 4.25f, 1, -1, 60, ManaElements.Fire, WeaponType.PhysicalMelee, SpellType.Hell, CareerCore.Knight).setAoe_range(3).setProjectileCount(5).setDotDamage(0.5f, 10).setDotAttackData(WeaponType.PhysicalMelee, ManaElements.Fire, SpellType.Destroy).setPerLevelTime(3);
        SpellData.BUFF(SpellID.A203_EarthPower, 300, 180, 120, 12, ManaElements.Earthm, CareerCore.Knight).setRange(16);
        SpellData.ATTACK(SpellID.B206_SkyShield, 1500, 600, 7.5f, 10, -1, 40, ManaElements.Light, WeaponType.PhysicalMelee, SpellType.Holy, CareerCore.Knight).setAoe_range(12).setRange(16).setSpellClass(SpellClass.superspell);
        SpellData.ATTACK(SpellID.A0_Healing, 200, 10, 1.0f, 1, -1, -1, ManaElements.Light, WeaponType.Magic, SpellType.Holy, CareerCore.Priest).setHealPower(1200).setAoe_range(10).setRange(10);
        SpellData.BUFF(SpellID.A0_FightingSpirit, 200, 5, 60, 6, ManaElements.Light, CareerCore.Priest).setRange(32);
        SpellData.ATTACK(SpellID.A102_Shengguangya, 200, 10, 1.9f, 8, 7, -1, ManaElements.Light, WeaponType.Magic, SpellType.Pure, CareerCore.Priest);
        SpellData.ATTACK(SpellID.A103_HolyPrayer, 400, 30, 1.0f, 1, -1, 120, ManaElements.Light, WeaponType.Magic, SpellType.Holy, CareerCore.Priest).setHealPower(4200).setRange(12).setAoe_range(12);
        SpellData.BUFF(SpellID.A104_HealingFountain, 800, 90, 60, 2, ManaElements.Light, CareerCore.Priest).setRange(5).setSpeed(20).setHealPower(1200).setNeedItem(SpellItemType.HealDust);
        SpellData.PASSIVE(SpellID.S1_HolyHealingScriptures, CareerCore.Priest).setRange(8);
        SpellData.PASSIVE(SpellID.S2_HolyLightBurning, CareerCore.Priest).setDotDamage(0.5f, 10).setDotAttackData(WeaponType.Magic, ManaElements.Fire, SpellType.Holy).setRange(12).setBaseTimeUPLevel(16);
        SpellData.ATTACK(SpellID.A201_BrilliantHit, 600, 8, 0.75f, 1, -1, 30, ManaElements.Light, WeaponType.Magic, SpellType.Holy, CareerCore.Priest).setProjectileCount(3).setAoe_range(3).setRange(5);
        SpellData.BUFF(SpellID.A202_SacredField, 800, 90, 60, 6, ManaElements.Light, CareerCore.Priest).setRange(6).setSpeed(20);
        SpellData.ATTACK(SpellID.A203_HolyArrow, 800, 12, 0.75f, 120, 5, 15, ManaElements.Light, WeaponType.Magic, SpellType.Pure, CareerCore.Priest).setAoe_range(8);
        SpellData.ATTACK(SpellID.B206_DoorOfTruth, 1500, 600, 5.0f, 20, 5, 60, ManaElements.Light, WeaponType.Magic, SpellType.Holy, CareerCore.Priest).setAoe_range(16).setRange(32).setHealPower(50000).setPerLevelTime(1).setSpellClass(SpellClass.superspell);
        SpellData.BUFF(SpellID.A0_DemonWorldCall, 200, 10, 600, 30, ManaElements.Dark, CareerCore.Summoner).setNeedItem(SpellItemType.SummonStone);
        SpellData.BUFF(SpellID.A0_Recall, 100, 2, 20, 2, ManaElements.Dark, CareerCore.Summoner).setRange(32);
        SpellData.BUFF(SpellID.A102_Obsessed, 600, 20, 60, 6, ManaElements.Dark, CareerCore.Summoner).setRange(32);
        SpellData.ATTACK(SpellID.A103_Resurrection, 100, 10, 4.0f, 1, -1, -1, ManaElements.Magic, WeaponType.Magic, SpellType.Soul, CareerCore.Summoner).setAoe_range(6).setRange(32).setHealPower(3000);
        SpellData.ATTACK(SpellID.A104_ShadowAllay, 200, 10, 1.4f, 2, -1, 60, ManaElements.Magic, WeaponType.Magic, SpellType.Magical, CareerCore.Summoner).setProjectileCount(5).setAoe_range(4).setPerLevelTime(2);
        SpellData.PASSIVE(SpellID.S1_FlameOfLife, CareerCore.Summoner).setHealPower(100).setDotDamage(0.5f, 10).setDotAttackData(WeaponType.Magic, ManaElements.Fire, SpellType.FireDamage);
        SpellData.PASSIVE(SpellID.S2_SoulDrop, CareerCore.Summoner).setCD(600).setRange(16).setBaseTimeUPLevel(180);
        SpellData.ATTACK(SpellID.A201_GuidingArrow, 100, 1, 0.5f, 1, -1, 60, ManaElements.Light, WeaponType.Magic, SpellType.Puncture, CareerCore.Summoner).setPerLevelTime(2);
        SpellData.ATTACK(SpellID.A202_HolyBeastGuardian, 600, 60, 1.15f, -1, -1, 90, ManaElements.Fire, WeaponType.Magic, SpellType.FireDamage, CareerCore.Summoner).setHealPower(400).setRange(32);
        SpellData.ATTACK(SpellID.A203_MagicMissile, 800, 20, 0.6f, 5, 10, -1, ManaElements.Magic, WeaponType.Magic, SpellType.GiveBack, CareerCore.Summoner).setProjectileCount(5);
        SpellData.ATTACK(SpellID.B206_OathDragon, 1500, 600, 2.25f, -1, -1, 120, ManaElements.Dark, WeaponType.Magic, SpellType.DarkMagic, CareerCore.Summoner).setPerLevelTime(2).setSpellClass(SpellClass.superspell);
        SpellData.ATTACK(SpellID.A0_CharmCharge, 200, 1, 0.75f, -1, -1, 10, ManaElements.Magic, WeaponType.Magic, SpellType.Explosion, CareerCore.Curseman).setRange(12).setAoe_range(4).setHealPower(400).setPerLevelTime(1).setDotAttackData(WeaponType.Magic, ManaElements.Dark, SpellType.Cruse).setDotDamage(0.5f, 7);
        SpellData.BUFF(SpellID.A0_SpellRelease, 200, 1, -1, -1, ManaElements.Magic, CareerCore.Curseman).setRange(12).setHealPower(3000);
        SpellData.ATTACK(SpellID.A102_LightningTalisman, 200, 20, 1.85f, 5, -1, -1, ManaElements.Thunder, WeaponType.Magic, SpellType.Energy, CareerCore.Curseman);
        SpellData.BUFF(SpellID.A103_NaturalMorningLight, 200, 60, 60, 6, ManaElements.Light, CareerCore.Curseman).setRange(4).setHealPower(200).setNeedItem(SpellItemType.HealDust).setSpeed(20);
        SpellData.ATTACK(SpellID.A104_WindSpeedSymbol, 200, 5, 0.6f, 2, 7, 30, ManaElements.Wind, WeaponType.Magic, SpellType.Cruse, CareerCore.Curseman).setProjectileCount(3).setPerLevelTime(1);
        SpellData.PASSIVE(SpellID.S1_SoulFire, CareerCore.Curseman).setBaseTimeUPLevel(20).setBaseAttackUPLevel(1.0f).setWeaponType(WeaponType.Magic).setSpellType(SpellType.Pure).setManaElements(ManaElements.Light).setSpeed(12).setAoe_range(16).setCD(20);
        SpellData.PASSIVE(SpellID.S2_SpellMastery, CareerCore.Curseman);
        SpellData.ATTACK(SpellID.A201_Magician, 400, 10, 12.0f, 2, -1, 20, ManaElements.Magic, WeaponType.Magic, SpellType.Explosion, CareerCore.Curseman).setAoe_range(5).setRange(32).setHealPower(30000);
        SpellData.ATTACK(SpellID.A202_ShikigamiCut, 600, 14, 2.2f, 3, 7, 30, ManaElements.Light, WeaponType.Magic, SpellType.Pure, CareerCore.Curseman).setProjectileCount(9).setPerLevelTime(1);
        SpellData.ATTACK(SpellID.A203_GuardianBarrier, 900, 60, 3.5f, -1, 15, 300, ManaElements.Grass, WeaponType.Magic, SpellType.Plant, CareerCore.Curseman).setRange(4).setAoe_range(24);
        SpellData.ATTACK(SpellID.B206_StarBash, 1500, 600, 9.5f, 200, 20, 30, ManaElements.Dark, WeaponType.Magic, SpellType.Shock, CareerCore.Curseman).setAoe_range(16).setRange(32).setSpellClass(SpellClass.superspell);
        SpellData.ATTACK(SpellID.A0_PoisonExplosion, 200, 1, 1.0f, 1, -1, -1, ManaElements.Grass, WeaponType.PhysicalRange, SpellType.Poison, CareerCore.BlowingArrows).setAoe_range(12);
        SpellData.BUFF(SpellID.A0_NeutralizeToxins, 200, 20, 30, 3, ManaElements.Grass, CareerCore.BlowingArrows).setHealPower(2000).setRange(16);
        SpellData.ATTACK(SpellID.A102_ScatteredArrow, 200, 10, 0.65f, 4, 10, 10, ManaElements.Grass, WeaponType.PhysicalRange, SpellType.Plant, CareerCore.BlowingArrows).setProjectileCount(3).setAoe_range(2);
        SpellData.BUFF(SpellID.A103_MistTherapy, 200, 60, 60, 6, ManaElements.Grass, CareerCore.BlowingArrows).setSpeed(20).setRange(4).setHealPower(200).setNeedItem(SpellItemType.HealDust);
        SpellData.ATTACK(SpellID.A104_AcidPoison, 200, 30, 0.6f, 25, 3, 60, ManaElements.Grass, WeaponType.PhysicalRange, SpellType.Acidic, CareerCore.BlowingArrows).setDotDamage(0.25f, 12).setAoe_range(9).setDotAttackData(WeaponType.PhysicalRange, ManaElements.Grass, SpellType.Acidic).setPerLevelTime(2);
        SpellData.PASSIVE(SpellID.S1_DeadlyPoisonous, CareerCore.BlowingArrows).setBaseTimeUPLevel(10).setDotDamage(0.5f, 8).setDotAttackData(WeaponType.PhysicalRange, ManaElements.Grass, SpellType.Pain);
        SpellData.PASSIVE(SpellID.S2_AncientInscription, CareerCore.BlowingArrows);
        SpellData.ATTACK(SpellID.A201_AncestralTotem, 600, 10, 0.75f, 1, 20, 60, ManaElements.Light, WeaponType.PhysicalRange, SpellType.Energy, CareerCore.BlowingArrows).setAoe_range(12).setRange(10).setPerLevelTime(1);
        SpellData.ATTACK(SpellID.A202_BiogasPoisonousFire, 600, 12, 0.5f, 20, 4, 60, ManaElements.Fire, WeaponType.PhysicalRange, SpellType.FireDamage, CareerCore.BlowingArrows).setAoe_range(12).setDotDamage(0.75f, 10).setDotAttackData(WeaponType.PhysicalRange, ManaElements.Fire, SpellType.FireDamage);
        SpellData.ATTACK(SpellID.A203_InducedPoisonNeedle, 800, 15, 1.2f, 3, 10, 60, ManaElements.Ice, WeaponType.PhysicalRange, SpellType.IceDamage, CareerCore.BlowingArrows).setAoe_range(12).setProjectileCount(3).setDotDamage(0.25f, 12).setDotAttackData(WeaponType.PhysicalRange, ManaElements.Ice, SpellType.IceDamage);
        SpellData.ATTACK(SpellID.B206_ThousandsNeedles, 1000, 200, 6.0f, 200, 4, 40, ManaElements.Wind, WeaponType.PhysicalRange, SpellType.Poison, CareerCore.BlowingArrows).setAoe_range(8).setSpellClass(SpellClass.superspell);
        SpellData.ATTACK(SpellID.A0_CatchNet, 200, 6, 1.2f, 1, -1, 25, ManaElements.Wind, WeaponType.PhysicalRange, SpellType.Bondage, CareerCore.Hunter).setPerLevelTime(1);
        SpellData.BUFF(SpellID.A0_WildernessPreparation, 200, 10, -1, -1, ManaElements.Magic, CareerCore.Hunter).setHealPower(400);
        SpellData.ATTACK(SpellID.A102_SilverGun, 200, 6, 1.5f, 5, -1, 60, ManaElements.Light, WeaponType.PhysicalRange, SpellType.Pure, CareerCore.Hunter).setPerLevelTime(2);
        SpellData.ATTACK(SpellID.A103_BurstJavelin, 200, 8, 2.5f, 3, -1, 60, ManaElements.Fire, WeaponType.PhysicalRange, SpellType.Explosion, CareerCore.Hunter).setRange(32).setAoe_range(8).setPerLevelTime(2);
        SpellData.BUFF(SpellID.A104_HealLilyValley, 200, 40, 60, 6, ManaElements.Grass, CareerCore.Hunter).setHealPower(100).setRange(32);
        SpellData.PASSIVE(SpellID.S1_HunterTrack, CareerCore.Hunter).setBaseTimeUPLevel(120).setRange(15);
        SpellData.PASSIVE(SpellID.S2_DemonHunter, CareerCore.Hunter).setBaseTimeUPLevel(60);
        SpellData.ATTACK(SpellID.A201_SpiralJavelin, 600, 8, 2.0f, 5, -1, 60, ManaElements.Magic, WeaponType.PhysicalRange, SpellType.Wave, CareerCore.Hunter).setPerLevelTime(2);
        SpellData.ATTACK(SpellID.A202_ThornSpear, 600, 16, 1.3f, 40, 8, -1, ManaElements.Grass, WeaponType.PhysicalRange, SpellType.Plant, CareerCore.Hunter).setAoe_range(2).setHealPower(100);
        SpellData.ATTACK(SpellID.A203_BattlePack, 800, 60, 1.5f, 120, 10, 60, ManaElements.Wind, WeaponType.PhysicalRange, SpellType.Puncture, CareerCore.Hunter).setAoe_range(16);
        SpellData.ATTACK(SpellID.B206_BoundaryBreaker, 1500, 300, 4.5f, 200, 4, 40, ManaElements.Wind, WeaponType.PhysicalRange, SpellType.Gravitational, CareerCore.Hunter).setAoe_range(5).setSpellClass(SpellClass.superspell);
        SpellData.BUFF(SpellID.A0_SoulLantern, 200, 20, -1, -1, ManaElements.Dark, CareerCore.BeastTrainer).setHealPower(2000).setRange(8);
        SpellData.BUFF(SpellID.A0_ContractCall, 800, 90, -1, -1, ManaElements.Dark, CareerCore.BeastTrainer).setNeedItem(SpellItemType.SummonStone);
        SpellData.ATTACK(SpellID.A102_StingerCombo, 200, 20, 0.75f, 5, 4, 60, ManaElements.Wind, WeaponType.Magic, SpellType.Poison, CareerCore.BeastTrainer).setProjectileCount(5).setRange(32).setDotDamage(0.25f, 10).setDotAttackData(WeaponType.Magic, ManaElements.Grass, SpellType.Poison).setPerLevelTime(2);
        SpellData.ATTACK(SpellID.A103_RedFlagGuidance, 200, 24, 1.9f, 10, 8, 60, ManaElements.Magic, WeaponType.Magic, null, CareerCore.BeastTrainer).setHealPower(1200).setRidicule_time(7).setRange(16).setAoe_range(7).setPerLevelTime(2);
        SpellData.ATTACK(SpellID.A104_BlueFlagGuidance, 200, 24, 1.9f, 10, 8, 60, ManaElements.Magic, WeaponType.Magic, null, CareerCore.BeastTrainer).setHealPower(1200).setRidicule_time(7).setRange(16).setAoe_range(7).setPerLevelTime(2);
        SpellData.PASSIVE(SpellID.S1_AnimalSpecialization, CareerCore.BeastTrainer);
        SpellData.PASSIVE(SpellID.S2_WorkTogether, CareerCore.BeastTrainer).setHealPower(200).setBaseTimeUPLevel(3);
        SpellData.ATTACK(SpellID.A201_FalconShock, 600, 15, 1.25f, 3, 10, 90, ManaElements.Grass, WeaponType.Magic, SpellType.Animal, CareerCore.BeastTrainer).setPerLevelTime(3);
        SpellData.ATTACK(SpellID.A202_WildLeader, 500, 24, 9.0f, 8, 10, 60, ManaElements.Magic, WeaponType.Magic, null, CareerCore.BeastTrainer).setHealPower(1200).setRange(16).setAoe_range(7).setPerLevelTime(2);
        SpellData.ATTACK(SpellID.A203_CryWild, 500, 24, 9.0f, 8, 10, 60, ManaElements.Magic, WeaponType.Magic, null, CareerCore.BeastTrainer).setHealPower(1200).setRange(16).setAoe_range(7).setPerLevelTime(2);
        SpellData.ATTACK(SpellID.B206_BeastPromise, 1500, 600, 5.5f, 400, 9, 180, ManaElements.Dark, WeaponType.Magic, SpellType.IceDamage, CareerCore.BeastTrainer).setAoe_range(16).setSpellClass(SpellClass.superspell);
        SpellData.BUFF(SpellID.A0_StanceSwitch, 150, 1, 60, 6, ManaElements.Magic, CareerCore.Samurai).setAoe_range(2).setHealPower(200);
        SpellData.ATTACK(SpellID.A0_InstantCut, 150, 5, 1.8f, 1, -1, 30, ManaElements.Wind, WeaponType.PhysicalMelee, SpellType.WindDamage, CareerCore.Samurai).setAoe_range(4).setPerLevelTime(1);
        SpellData.ATTACK(SpellID.A102_XuanYue_EagleClaw, 150, 1, 1.45f, 2, -1, 60, ManaElements.Dark, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Samurai).setAoe_range(6).setRange(16).setPerLevelTime(2);
        SpellData.ATTACK(SpellID.A103_FlyingDuck_LiuDa, 150, 1, 1.55f, 3, -1, 5, ManaElements.Dark, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Samurai).setAoe_range(4).setBaseTimeUPLevel(5);
        SpellData.ATTACK(SpellID.A104_YanBack_Juhe, 300, 1, 1.8f, 5, 3, -1, ManaElements.Dark, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Samurai).setAoe_range(4).setHealPower(300);
        SpellData.PASSIVE(SpellID.S1_Heaven_Earth_Flow_Kendo, CareerCore.Samurai).setBaseTimeUPLevel(15);
        SpellData.PASSIVE(SpellID.S2_HeavenEarthFlowSecret, CareerCore.Samurai).setBaseTimeUPLevel(60);
        SpellData.ATTACK(SpellID.A201_Flooded_Assaulted, 300, 1, 4.0f, 5, 4, 3, ManaElements.Fire, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Samurai).setAoe_range(4);
        SpellData.ATTACK(SpellID.A202_WaterWheel_Flash, 300, 1, 3.3f, 5, 3, 30, ManaElements.Water, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Samurai).setAoe_range(4).setPerLevelTime(1);
        SpellData.ATTACK(SpellID.A203_PointWater_EagleAttack, 300, 1, 3.2f, 2, 4, -1, ManaElements.Water, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Samurai).setAoe_range(4);
        SpellData.ATTACK(SpellID.B206_MoonShadow_SunDisk, 750, 200, 7.2f, 20, 3, 90, ManaElements.Wind, WeaponType.PhysicalMelee, SpellType.Hacking, CareerCore.Samurai).setAoe_range(6).setRange(16).setPerLevelTime(3).setSpellClass(SpellClass.superspell);
    }

    public static final Spell ATTACK(SpellID skill, int needmagic, int CD, float attack, int count, int speed, int time, ManaElements elements, WeaponType weapon, SpellType spelltype, CareerCore career) {
        Spell temp = new Spell(needmagic, CD);
        temp.setBaseAttackUPLevel(attack);
        temp.count = count;
        temp.speed = speed;
        temp.time = time;
        temp.weapon = weapon;
        temp.elements = elements;
        temp.spelltype = spelltype;
        temp.spellClass = SpellClass.initiative;
        spell_map[career.ordinal()].put(skill, temp);
        return temp;
    }

    public static final Spell BUFF(SpellID skill, int needmagic, int CD, int time, int per_level_time, ManaElements elements, CareerCore career) {
        Spell temp = new Spell(needmagic, CD);
        temp.elements = elements;
        temp.time = time;
        temp.per_level_time = per_level_time;
        temp.spellClass = SpellClass.initiative;
        spell_map[career.ordinal()].put(skill, temp);
        return temp;
    }

    public static final Spell PASSIVE(SpellID skill, CareerCore career) {
        Spell temp = new Spell();
        temp.spellClass = SpellClass.passive;
        spell_map[career.ordinal()].put(skill, temp);
        return temp;
    }

    static {
        Instantaneous = new Spell().setSpellClass(SpellClass.passive).setBaseTimeUPLevel(4);
        CombatMind = new Spell().setSpellClass(SpellClass.passive);
        DarkPower = new Spell(1000, 600).setSpellClass(SpellClass.passive).setBaseTimeUPLevel(60);
        DarkPowerDestroy = new Spell(1000, 600).setSpellClass(SpellClass.passive).setBaseTimeUPLevel(300).setAoe_range(8).setBaseAttackUPLevel(0.5f).setWeaponType(WeaponType.Magic).setSpellType(SpellType.Destroy).setManaElements(ManaElements.Dark);
        DarkPowerGuard = new Spell(1000, 600).setSpellClass(SpellClass.passive).setBaseTimeUPLevel(300).setHealPower(400);
    }
}

