/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.statistics;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.MoneySourceType;
import project.studio.manametalmod.api.StrengtheningStoneSourceType;
import project.studio.manametalmod.statistics.StatisticsData;

public class PlayerStatisticsCore {
    public static final Map<String, StatisticsData> PlayerStatisticsPool = new HashMap<String, StatisticsData>();
    public static final String key = "PlayerStatistics";
    public static final String keyList = "PlayerStatisticsList";
    public static final String keyPlayerName = "PlayerStatisticsPlayer";

    public static StatisticsData get(EntityPlayer player) {
        String name = player.func_70005_c_();
        if (PlayerStatisticsPool.containsKey(name)) {
            return PlayerStatisticsPool.get(name);
        }
        StatisticsData sd = new StatisticsData(name);
        PlayerStatisticsPool.put(name, sd);
        return sd;
    }

    public static void addStoneStatistics(EntityPlayer player, int stone, StrengtheningStoneSourceType type) {
        String name = player.func_70005_c_();
        StatisticsData data = PlayerStatisticsCore.get(player);
        int n = type.ordinal();
        data.stones[n] = data.stones[n] + stone;
    }

    public static void addMoneyStatistics(EntityPlayer player, long money, MoneySourceType type) {
        String name = player.func_70005_c_();
        StatisticsData data = PlayerStatisticsCore.get(player);
        int n = type.ordinal();
        data.moneys[n] = data.moneys[n] + money;
    }

    public static void load(WorldEvent.Load event) {
        if (!event.world.field_72995_K && MMM.getDimensionID(event.world) == 0 && MMM.getWorldData(event.world).getPlayerStatisticsData().func_150297_b(key, 9)) {
            PlayerStatisticsPool.clear();
            NBTTagList list = MMM.getWorldData(event.world).getPlayerStatisticsData().func_150295_c(key, 10);
            int size = list.func_74745_c();
            for (int s = 0; s < size; ++s) {
                NBTTagCompound tag = list.func_150305_b(s);
                String playername = tag.func_74779_i(keyPlayerName);
                PlayerStatisticsPool.put(playername, StatisticsData.readFromNBT(tag, playername));
                MMM.Logg("load PlayerStatistics ", playername);
            }
        }
    }

    public static void save(WorldEvent.Save event) {
        if (!event.world.field_72995_K && MMM.getDimensionID(event.world) == 0) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<String, StatisticsData> entry : PlayerStatisticsPool.entrySet()) {
                StatisticsData temp = entry.getValue();
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a(keyPlayerName, entry.getKey());
                StatisticsData.saveToNBT(tag, temp);
                list.func_74742_a((NBTBase)tag);
            }
            MMM.getWorldData(event.world).getPlayerStatisticsData().func_74782_a(key, (NBTBase)list);
            MMM.getWorldData(event.world).func_76185_a();
        }
    }
}

