/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.tileentity;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.blocks.BlockTileEntityBase;
import project.studio.manametalmod.core.FuelType;
import project.studio.manametalmod.core.RecipeOre;

public class TileEntityBase
extends TileEntity
implements ISidedInventory {
    public ItemStack[] items = new ItemStack[4];
    public String TileName = null;
    public List<RecipeOre> recipe;
    public FuelType Fuel;
    public int speedMax = 0;
    public int time = 0;
    public boolean isCook = false;
    public boolean update = false;
    public int fuelTime = 0;
    public int fuelTimeMax = 0;
    public boolean hasIngredient = false;
    public int runetime = 0;
    public static final int[] hopperIMP = new int[]{0, 3};
    public static final int[] hopperOUT = new int[]{1};
    public static final int[] hopperFUEL = new int[]{2};

    public TileEntityBase(String name, List<RecipeOre> list, int speedMax, FuelType type) {
        this.items = new ItemStack[4];
        this.recipe = list;
        this.TileName = name;
        this.Fuel = type;
        this.speedMax = speedMax;
        this.time = 0;
        this.hasIngredient = true;
    }

    public TileEntityBase() {
    }

    public int[] func_94128_d(int side) {
        if (side == 0) {
            return hopperOUT;
        }
        if (side != 1) {
            return hopperFUEL;
        }
        return hopperIMP;
    }

    public boolean isCanIMP(int id) {
        if (this.items[id] == null) {
            return true;
        }
        return MMM.isStackNoFull(this.items[id]);
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot == 2) {
            return this.isOKFuel(item);
        }
        if (slot == 0) {
            return this.isItemRecipe(item) == 0;
        }
        if (slot == 3) {
            return this.isItemRecipe2(item) == 3;
        }
        return false;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == 1;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.items.length) continue;
            this.items[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.TileName = nbt.func_74779_i("TileName");
        this.Fuel = FuelType.values()[nbt.func_74762_e("Fuel")];
        this.isCook = nbt.func_74767_n("isCook");
        this.speedMax = nbt.func_74762_e("speedMax");
        this.time = nbt.func_74762_e("time");
        this.fuelTime = nbt.func_74762_e("fuelTime");
        this.fuelTimeMax = nbt.func_74762_e("fuelTimeMax");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.items[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        nbt.func_74778_a("TileName", this.TileName);
        nbt.func_74768_a("Fuel", this.Fuel.ordinal());
        nbt.func_74757_a("isCook", this.isCook);
        nbt.func_74768_a("speedMax", this.speedMax);
        nbt.func_74768_a("time", this.time);
        nbt.func_74768_a("fuelTime", this.fuelTime);
        nbt.func_74768_a("fuelTimeMax", this.fuelTimeMax);
    }

    public int isItemRecipe2(ItemStack item) {
        if (this.recipe != null) {
            for (int s = 0; s < this.recipe.size(); ++s) {
                for (int r = 0; r < this.recipe.get(s).getImp2().getItem().size(); ++r) {
                    if (!TileEntityBase.isItemStackEqualNoNBT(item, this.recipe.get(s).getImp2().getItem().get(r))) continue;
                    return 3;
                }
            }
        }
        return -1;
    }

    public int isItemRecipe(ItemStack item) {
        if (this.recipe != null) {
            for (int s = 0; s < this.recipe.size(); ++s) {
                for (int x = 0; x < this.recipe.get(s).getImp1().getItem().size(); ++x) {
                    if (!TileEntityBase.isItemStackEqualNoNBT(item, this.recipe.get(s).getImp1().getItem().get(x))) continue;
                    return 0;
                }
                for (int r = 0; r < this.recipe.get(s).getImp2().getItem().size(); ++r) {
                    if (!TileEntityBase.isItemStackEqualNoNBT(item, this.recipe.get(s).getImp2().getItem().get(r))) continue;
                    return 3;
                }
            }
        }
        return -1;
    }

    public void maker() {
        if (this.recipe == null) {
            if (this.func_145838_q() instanceof BlockTileEntityBase) {
                BlockTileEntityBase block = (BlockTileEntityBase)this.func_145838_q();
                this.recipe = block.recipe;
            } else {
                MMM.warningM3("[TileEntityBase] same tile update event has error !");
                this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
                return;
            }
        }
        if (this.recipe != null) {
            ++this.runetime;
            if (this.runetime > 19) {
                this.runetime = 0;
                if (this.fuelTime > 0) {
                    --this.fuelTime;
                }
                if (this.items[0] != null && this.items[3] != null) {
                    this.addFuel();
                    if (this.fuelTime > 0) {
                        for (int s = 0; s < this.recipe.size(); ++s) {
                            for (int x = 0; x < this.recipe.get(s).getImp1().getItem().size(); ++x) {
                                if (!TileEntityBase.isItemStackEqualNoNBT(this.items[0], this.recipe.get(s).getImp1().getItem().get(x))) continue;
                                for (int r = 0; r < this.recipe.get(s).getImp2().getItem().size(); ++r) {
                                    if (!TileEntityBase.isItemStackEqualNoNBT(this.items[3], this.recipe.get(s).getImp2().getItem().get(r))) continue;
                                    if (this.items[1] == null) {
                                        if (this.time >= this.speedMax) {
                                            this.done(this.recipe.get(s).getOut().func_77946_l());
                                            continue;
                                        }
                                        ++this.time;
                                        continue;
                                    }
                                    if (!TileEntityBase.isItemStackEqualNoNBT(this.items[1], this.recipe.get(s).getOut()) || this.items[1].field_77994_a + this.recipe.get((int)s).getOut().field_77994_a > this.items[1].func_77976_d()) continue;
                                    if (this.time >= this.speedMax) {
                                        this.done(this.recipe.get(s).getOut().func_77946_l());
                                        continue;
                                    }
                                    ++this.time;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static boolean isItemStackEqualNoNBT(ItemStack item1, ItemStack target) {
        if (item1 != null && target != null && item1.func_77973_b() == target.func_77973_b()) {
            if (item1.func_77960_j() == target.func_77960_j()) {
                return true;
            }
            if (item1.func_77960_j() == Short.MAX_VALUE) {
                return true;
            }
            if (target.func_77960_j() == Short.MAX_VALUE) {
                return true;
            }
        }
        return false;
    }

    public void addFuel() {
        if (this.fuelTime < 1) {
            int temp = 0;
            switch (this.Fuel) {
                case Base: {
                    temp = (int)((float)this.getItemBurnTime(this.items[2]) * 0.05f);
                    if (temp <= 0) break;
                    this.fuelTime = ++temp;
                    this.fuelTimeMax = temp;
                    MMM.removeTileEntityItemReturn(this, 2);
                    break;
                }
                case Mana: {
                    temp = (int)((float)MMM.getManaItemFuelTime(this.items[2]) * 0.05f);
                    if (temp <= 0) break;
                    this.fuelTime = ++temp;
                    this.fuelTimeMax = temp;
                    MMM.removeTileEntityItemReturn(this, 2);
                    break;
                }
                case None: {
                    this.fuelTime = temp = 100;
                    this.fuelTimeMax = temp;
                }
            }
        }
    }

    public int getItemBurnTime(ItemStack itemstack) {
        return MMM.getItemStackFuelValue(itemstack);
    }

    public boolean isOKFuel(ItemStack item) {
        if (item == null) {
            return false;
        }
        switch (this.Fuel) {
            case Base: {
                return this.getItemBurnTime(item) > 0;
            }
            case Mana: {
                return MMM.getManaItemFuelTime(item) > 0;
            }
            case None: {
                return true;
            }
        }
        return false;
    }

    public void clearItems() {
        MMM.removeTileEntityItem(this, 3);
        MMM.removeTileEntityItem(this, 0);
    }

    public void done(ItemStack out) {
        if (this.items[1] == null) {
            this.items[1] = out;
            this.time = 0;
            this.clearItems();
            return;
        }
        if (TileEntityBase.isItemStackEqualNoNBT(this.items[1], out)) {
            this.items[1].field_77994_a += out.field_77994_a;
            if (this.items[1].field_77994_a > this.items[1].func_77976_d()) {
                this.items[1].field_77994_a = this.items[1].func_77976_d();
            }
            this.time = 0;
            this.clearItems();
            return;
        }
    }

    public void func_145845_h() {
        this.maker();
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int id) {
        return this.items[id];
    }

    public ItemStack func_70298_a(int id, int count) {
        if (this.items[id] != null) {
            if (this.items[id].field_77994_a <= count) {
                ItemStack itemstack = this.items[id];
                this.items[id] = null;
                return itemstack;
            }
            ItemStack itemstack = this.items[id].func_77979_a(count);
            if (this.items[id].field_77994_a == 0) {
                this.items[id] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.items[slot] = item;
    }

    public String func_145825_b() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

