/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.world.thuliumempire;

import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.world.thuliumempire.ISoulEnergyUse;

public class SoulEnergy {
    public int Energy;

    public SoulEnergy(int energy) {
        this.Energy = energy;
    }

    public SoulEnergy(SoulEnergy energy) {
        this.Energy = energy.getEnergy();
    }

    public int getEnergy() {
        return this.Energy;
    }

    public void removeEnergy(int value) {
        this.Energy -= value;
    }

    public void addEnergy(int value) {
        this.Energy += value;
    }

    public boolean isEmpty() {
        return this.getEnergy() == 0;
    }

    public void setEnergy(int value) {
        this.Energy = value;
    }

    public void moveEnergy(SoulEnergy energy, ISoulEnergyUse target, int value) {
        if (energy.getEnergy() > 0) {
            if (value + target.getSoulEnergy().getEnergy() > target.getMaxSoulEnergy()) {
                value = target.getMaxSoulEnergy() - target.getSoulEnergy().getEnergy();
            }
            if (value > energy.getEnergy()) {
                value = energy.getEnergy();
            }
            this.Energy += value;
            energy.removeEnergy(value);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.setEnergy(NBTHelp.getIntSafe("SoulEnergy", nbt, 0));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("SoulEnergy", this.getEnergy());
    }

    public boolean equals(Object obj) {
        return obj instanceof SoulEnergy && ((SoulEnergy)obj).getEnergy() == this.getEnergy();
    }

    public String toString() {
        return "SoulEnergy:" + this.getEnergy();
    }
}

