/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("netherportalcoordinatescale.json");
    public double scale = 1.0;
    private static Config instance;

    public static Config getInstance() {
        if (instance == null) {
            Config.load();
        }
        return instance;
    }

    private static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                instance = (Config)GSON.fromJson(json, Config.class);
            }
            catch (IOException e) {
                instance = new Config();
            }
        } else {
            instance = new Config();
            Config.save();
        }
    }

    private static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)instance), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

