/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.gildedarmor.configs;

import com.craftjakob.configapi.config.ConfigBuilder;
import com.craftjakob.configapi.config.ConfigValueTypes;
import com.craftjakob.configapi.config.IConfigurator;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import org.jetbrains.annotations.NotNull;

public class ServerConfig
implements IConfigurator {
    public static ConfigValueTypes.DoubleValue ADDITIONAL_GILDED_ARMOR;
    public static ConfigValueTypes.DoubleValue ADDITIONAL_GILDED_ARMOR_TOUGHNESS;
    public static ConfigValueTypes.ListValue<LootTableConfig> GOLDEN_CORE_LOOT_TABLES;

    public void configure(ConfigBuilder builder) {
        ADDITIONAL_GILDED_ARMOR = builder.comment(new String[]{"The extra Armor which is added to the item."}).defineInRange("AdditionalGildedArmor", 0.0, 0.0, Double.MAX_VALUE);
        ADDITIONAL_GILDED_ARMOR_TOUGHNESS = builder.comment(new String[]{"The extra Armor Toughness which is added to the item."}).defineInRange("AdditionalGildedArmorToughness", 0.5, 0.0, Double.MAX_VALUE);
        GOLDEN_CORE_LOOT_TABLES = builder.requiresWorldRestart().comment(new String[]{"The loot tables in which the golden core should spawn, with chance in range of 0.0F to 1.0F"}).defineList("GoldenCoreLootTables", List.of(new LootTableConfig(class_39.field_22402.method_29177(), 0.075f, true), new LootTableConfig(class_39.field_24046.method_29177(), 0.075f, true), new LootTableConfig(class_39.field_24047.method_29177(), 0.05f, false), new LootTableConfig(class_39.field_24048.method_29177(), 0.05f, false), new LootTableConfig(class_39.field_24049.method_29177(), 0.05f, false), new LootTableConfig(class_39.field_615.method_29177(), 0.05f, false), new LootTableConfig(class_39.field_24050.method_29177(), 0.001f, true)), LootTableConfig::parse);
    }

    public record LootTableConfig(class_2960 lootTableId, float chance, boolean enabled) {
        public static LootTableConfig parse(String s) {
            String[] parts = s.split(";", 3);
            class_2960 lootTableId = class_2960.method_60654((String)parts[0]);
            float chance = Float.parseFloat(parts[1]);
            boolean enabled = Boolean.parseBoolean(parts[2]);
            return new LootTableConfig(lootTableId, chance, enabled);
        }

        @Override
        @NotNull
        public String toString() {
            return String.valueOf(this.lootTableId) + ";" + this.chance + ";" + this.enabled;
        }
    }
}

