package cc.idrnkcrl.lessfire;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class LessFireClient implements ClientModInitializer {
    public static final String MODID = "less_clutter_low_fire";

    public static boolean ENABLED   = true;
    public static boolean DEBUG_LOG = true;

    public static float FIRE_HEIGHT_SCALE = 0.30f; // 0..1
    public static float FIRE_PIVOT_Y      = 0.0f;
    public static float FIRE_NUDGE        = 1.0f;

    /** 0 = auto, 69/70/71 = force a single target */
    public static int FORCE_METHOD = 0;
    /** internal: only print “hooked” once */
    public static boolean LOGGED_METHOD = false;

    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @Override
    public void onInitializeClient() {
        loadConfig();
        if (DEBUG_LOG) {
            System.out.println("[LessFire] cfg enabled=" + ENABLED
                    + " height=" + FIRE_HEIGHT_SCALE + " pivot=" + FIRE_PIVOT_Y
                    + " nudge=" + FIRE_NUDGE + " forceMethod=" + FORCE_METHOD);
        }
    }

    private static void loadConfig() {
        try {
            Path cfgFile = FabricLoader.getInstance().getConfigDir().resolve("less_clutter_low_fire.json");
            if (!Files.exists(cfgFile)) {
                JsonObject obj = new JsonObject();
                obj.addProperty("enabled", ENABLED);                 // true
                obj.addProperty("debug", DEBUG_LOG);                 // true
                obj.addProperty("height", FIRE_HEIGHT_SCALE);        // 0.30
                obj.addProperty("pivot", FIRE_PIVOT_Y);              // 0.0
                obj.addProperty("nudge", FIRE_NUDGE);                // 1.0
                obj.addProperty("forceMethod", FORCE_METHOD);        // 70
                try (BufferedWriter w = Files.newBufferedWriter(cfgFile, StandardCharsets.UTF_8)) {
                    GSON.toJson(obj, w);
                }
                return; // first run: file created with your defaults
            }

            try (BufferedReader r = Files.newBufferedReader(cfgFile, StandardCharsets.UTF_8)) {
                JsonObject obj = new Gson().fromJson(r, JsonObject.class);
                if (obj == null) return;
                if (obj.has("enabled"))     ENABLED = obj.get("enabled").getAsBoolean();
                if (obj.has("debug"))       DEBUG_LOG = obj.get("debug").getAsBoolean();
                if (obj.has("height"))      FIRE_HEIGHT_SCALE = clamp01(obj.get("height").getAsFloat());
                if (obj.has("pivot"))       FIRE_PIVOT_Y      = obj.get("pivot").getAsFloat();
                if (obj.has("nudge"))       FIRE_NUDGE        = obj.get("nudge").getAsFloat();
                if (obj.has("forceMethod")) FORCE_METHOD      = obj.get("forceMethod").getAsInt();
            }
        } catch (IOException e) {
            System.out.println("[LessFire] Failed to load config, using defaults: " + e.getMessage());
        }
    }

    private static float clamp01(float v) { return v < 0f ? 0f : (v > 1f ? 1f : v); }
}
