package cc.idrnkcrl.lessfire.mixin;

import cc.idrnkcrl.lessfire.LessFireClient;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4603;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Low-fire overlay: pivot-corrected vertical scale + tiny downward nudge.
 * Robustness:
 *  - Only one method is used at runtime (forceable via config).
 *  - Depth-safe push/pop: no broken matrix stack if multiple hooks fire.
 *  - No scissor calls (shader-friendly).
 */
@Mixin(class_4603.class)
public abstract class InGameOverlayRenderer_LowFireMixin {

    // Obf signature used by 1.21.8 variants
    private static final String SIG = "(Lnet/minecraft/class_4587;Lnet/minecraft/class_4597;)V";
    private static final String M69 = "method_23069" + SIG;
    private static final String M70 = "method_23070" + SIG;
    private static final String M71 = "method_23071" + SIG;

    // Depth counter to balance push/pop even if pre is invoked multiple times
    private static int DEPTH = 0;

    private static boolean shouldHook(String methodId) {
        // If user set forceMethod (69/70/71), only hook that one
        int forced = LessFireClient.FORCE_METHOD; // 0=auto
        if (forced == 0) return true;
        return (forced == 69 && methodId.endsWith("23069"+SIG))
                || (forced == 70 && methodId.endsWith("23070"+SIG))
                || (forced == 71 && methodId.endsWith("23071"+SIG));
    }

    // ---- method_23069 ----
    @Inject(method = M69, at = @At("HEAD"), remap = false, require = 0)
    private static void lessfire$pre69(class_4587 m, class_4597 c, CallbackInfo ci) { if (shouldHook(M69)) begin(m, "23069"); }
    @Inject(method = M69, at = @At("TAIL"), remap = false, require = 0)
    private static void lessfire$post69(class_4587 m, class_4597 c, CallbackInfo ci) { if (shouldHook(M69)) end(m, "23069"); }

    // ---- method_23070 ----
    @Inject(method = M70, at = @At("HEAD"), remap = false, require = 0)
    private static void lessfire$pre70(class_4587 m, class_4597 c, CallbackInfo ci) { if (shouldHook(M70)) begin(m, "23070"); }
    @Inject(method = M70, at = @At("TAIL"), remap = false, require = 0)
    private static void lessfire$post70(class_4587 m, class_4597 c, CallbackInfo ci) { if (shouldHook(M70)) end(m, "23070"); }

    // ---- method_23071 ----
    @Inject(method = M71, at = @At("HEAD"), remap = false, require = 0)
    private static void lessfire$pre71(class_4587 m, class_4597 c, CallbackInfo ci) { if (shouldHook(M71)) begin(m, "23071"); }
    @Inject(method = M71, at = @At("TAIL"), remap = false, require = 0)
    private static void lessfire$post71(class_4587 m, class_4597 c, CallbackInfo ci) { if (shouldHook(M71)) end(m, "23071"); }

    private static void begin(class_4587 matrices, String id) {
        if (!LessFireClient.ENABLED) return;

        // "Safe mode": height ~1 and nudge 0 means no visible transform, just prove the hook is ok.
        float s = Math.max(0.01f, Math.min(1.0f, LessFireClient.FIRE_HEIGHT_SCALE));
        float pivot = LessFireClient.FIRE_PIVOT_Y;
        float nudge = LessFireClient.FIRE_NUDGE;

        matrices.method_22903();
        DEPTH++;

        // Only apply transform if it will visibly change things.
        if (s < 0.999f || nudge != 0.0f) {
            matrices.method_46416(0.0F, pivot, 0.0F);
            matrices.method_22905(1.0F, s, 1.0F);
            matrices.method_46416(0.0F, -pivot, 0.0F);
            if (nudge != 0.0f) matrices.method_46416(0.0F, -nudge, 0.0F);
        }

        if (LessFireClient.DEBUG_LOG && !LessFireClient.LOGGED_METHOD) {
            System.out.println("[LessFire] Hooked fire overlay (method_" + id + "), height=" + s + " pivot=" + pivot + " nudge=" + nudge + " forced=" + LessFireClient.FORCE_METHOD);
            LessFireClient.LOGGED_METHOD = true;
        }
    }

    private static void end(class_4587 matrices, String id) {
        if (!LessFireClient.ENABLED) return;
        if (DEPTH > 0) {
            matrices.method_22909();
            DEPTH--;
        }
    }
}
