/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.events;

import BlockDynasty.Economy.domain.events.SerializableEvent;
import BlockDynasty.Economy.domain.events.offersEvents.OfferAccepted;
import BlockDynasty.Economy.domain.events.offersEvents.OfferCanceled;
import BlockDynasty.Economy.domain.events.offersEvents.OfferCreated;
import BlockDynasty.Economy.domain.events.offersEvents.OfferEvent;
import BlockDynasty.Economy.domain.events.offersEvents.OfferExpired;
import BlockDynasty.Economy.domain.events.transactionsEvents.DepositEvent;
import BlockDynasty.Economy.domain.events.transactionsEvents.SetEvent;
import BlockDynasty.Economy.domain.events.transactionsEvents.TradeEvent;
import BlockDynasty.Economy.domain.events.transactionsEvents.TransferEvent;
import BlockDynasty.Economy.domain.events.transactionsEvents.WithdrawEvent;
import com.BlockDynasty.gson.Gson;
import com.BlockDynasty.gson.GsonBuilder;
import com.BlockDynasty.gson.JsonElement;
import com.BlockDynasty.gson.JsonObject;
import com.BlockDynasty.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;

public class EventRegistry {
    private static final Map<String, Class<? extends SerializableEvent>> deserializerEvent = new HashMap<String, Class<? extends SerializableEvent>>();
    private static final Map<String, Class<? extends OfferEvent>> deserializersOffersEvent = new HashMap<String, Class<? extends OfferEvent>>();

    private static void registerEventTypeTransaction(Class<? extends SerializableEvent> eventClass) {
        deserializerEvent.put(eventClass.getSimpleName(), eventClass);
    }

    private static void registerEventTypeOffers(Class<? extends OfferEvent> eventClass) {
        deserializersOffersEvent.put(eventClass.getSimpleName(), eventClass);
    }

    public static SerializableEvent deserializeEvent(String jsonString) {
        try {
            JsonObject jsonObject = JsonParser.parseString(jsonString).getAsJsonObject();
            String eventType = jsonObject.get("eventType").getAsString();
            Class<? extends SerializableEvent> eventClass = deserializerEvent.get(eventType);
            if (eventClass == null) {
                return null;
            }
            JsonObject data = jsonObject.get("data").getAsJsonObject();
            Gson gson = new GsonBuilder().create();
            return gson.fromJson((JsonElement)data, eventClass);
        }
        catch (Exception e) {
            throw new RuntimeException("Error deserializing event: " + e.getMessage(), e);
        }
    }

    public static OfferEvent deserializeOfferEvent(String jsonString) {
        try {
            JsonObject jsonObject = JsonParser.parseString(jsonString).getAsJsonObject();
            String eventType = jsonObject.get("eventType").getAsString();
            Class<? extends OfferEvent> eventClass = deserializersOffersEvent.get(eventType);
            if (eventClass == null) {
                return null;
            }
            JsonObject data = jsonObject.get("data").getAsJsonObject();
            Gson gson = new GsonBuilder().create();
            return gson.fromJson((JsonElement)data, eventClass);
        }
        catch (Exception e) {
            throw new RuntimeException("Error deserializing event: " + e.getMessage(), e);
        }
    }

    static {
        EventRegistry.registerEventTypeTransaction(DepositEvent.class);
        EventRegistry.registerEventTypeTransaction(WithdrawEvent.class);
        EventRegistry.registerEventTypeTransaction(TransferEvent.class);
        EventRegistry.registerEventTypeTransaction(SetEvent.class);
        EventRegistry.registerEventTypeTransaction(TradeEvent.class);
        EventRegistry.registerEventTypeTransaction(OfferCreated.class);
        EventRegistry.registerEventTypeTransaction(OfferCanceled.class);
        EventRegistry.registerEventTypeTransaction(OfferExpired.class);
        EventRegistry.registerEventTypeTransaction(OfferAccepted.class);
        EventRegistry.registerEventTypeOffers(OfferCreated.class);
        EventRegistry.registerEventTypeOffers(OfferCanceled.class);
        EventRegistry.registerEventTypeOffers(OfferExpired.class);
        EventRegistry.registerEventTypeOffers(OfferAccepted.class);
    }
}

