/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.useCase.account;

import BlockDynasty.Economy.aplication.useCase.account.SearchAccountUseCase;
import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.result.Result;
import BlockDynasty.Economy.domain.services.IAccountService;
import java.util.UUID;

public class DeleteAccountUseCase {
    IRepository repository;
    IAccountService accountService;
    SearchAccountUseCase searchAccountUseCase;

    public DeleteAccountUseCase(IRepository repository, IAccountService accountService) {
        this.searchAccountUseCase = new SearchAccountUseCase(accountService, repository);
        this.repository = repository;
        this.accountService = accountService;
    }

    public Result<Void> execute(String name) {
        Result<Account> accountResult = this.searchAccountUseCase.getAccount(name);
        if (!accountResult.isSuccess()) {
            return Result.failure("Account not found for player: " + name, accountResult.getErrorCode());
        }
        Result<Void> result = this.repository.deleteAccount(accountResult.getValue());
        this.accountService.removeAccountOnline(accountResult.getValue().getUuid());
        if (!result.isSuccess()) {
            return Result.failure("Failed to delete account for player: " + name, result.getErrorCode());
        }
        return Result.success();
    }

    public Result<Void> execute(UUID uuid) {
        Result<Account> accountResult = this.searchAccountUseCase.getAccount(uuid);
        if (!accountResult.isSuccess()) {
            return Result.failure("Account not found for UUID: " + String.valueOf(uuid), accountResult.getErrorCode());
        }
        Result<Void> result = this.repository.deleteAccount(accountResult.getValue());
        this.accountService.removeAccountOnline(accountResult.getValue().getUuid());
        if (!result.isSuccess()) {
            return Result.failure("Failed to delete account for UUID: " + String.valueOf(uuid), result.getErrorCode());
        }
        return Result.success();
    }
}

