/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.useCase.currency;

import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyAlreadyExist;
import BlockDynasty.Economy.domain.persistence.Exceptions.TransactionException;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.services.IAccountService;
import BlockDynasty.Economy.domain.services.ICurrencyService;
import BlockDynasty.Economy.domain.services.courier.Courier;
import java.util.UUID;

public class CreateCurrencyUseCase {
    private final ICurrencyService currencyService;
    private final IRepository dataStore;
    private final Courier updateForwarder;
    private final IAccountService accountService;

    public CreateCurrencyUseCase(ICurrencyService currencyService, IAccountService accountService, Courier updateForwarder, IRepository dataStore) {
        this.currencyService = currencyService;
        this.accountService = accountService;
        this.dataStore = dataStore;
        this.updateForwarder = updateForwarder;
    }

    public void execute(String singular, String plural) {
        if (this.currencyService.currencyExist(singular) || this.currencyService.currencyExist(plural)) {
            throw new CurrencyAlreadyExist("Currency already exist");
        }
        Currency currency = new Currency(UUID.randomUUID(), singular, plural);
        currency.setExchangeRate(1.0);
        if (this.currencyService.getCurrencies().isEmpty()) {
            currency.setDefaultCurrency(true);
        }
        try {
            this.dataStore.saveCurrency(currency);
            this.currencyService.add(currency);
            this.accountService.syncDbWithOnlineAccounts();
            if (this.updateForwarder != null) {
                this.updateForwarder.sendUpdateMessage("currency", currency.getUuid().toString());
            }
        }
        catch (TransactionException e) {
            throw new TransactionException("Error creating currency");
        }
    }
}

