/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.useCase.transaction;

import BlockDynasty.Economy.aplication.events.EventManager;
import BlockDynasty.Economy.aplication.useCase.transaction.TransactionUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.interfaces.ISetBalanceUseCase;
import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.events.Context;
import BlockDynasty.Economy.domain.events.transactionsEvents.SetEvent;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.result.ErrorCode;
import BlockDynasty.Economy.domain.result.Result;
import BlockDynasty.Economy.domain.services.IAccountService;
import BlockDynasty.Economy.domain.services.ICurrencyService;
import BlockDynasty.Economy.domain.services.courier.Courier;
import BlockDynasty.Economy.domain.services.log.Log;
import java.math.BigDecimal;

public class SetBalanceUseCase
extends TransactionUseCase
implements ISetBalanceUseCase {
    public SetBalanceUseCase(ICurrencyService currencyService, IAccountService accountService, IRepository dataStore, Courier updateForwarder, Log economyLogger, EventManager eventManager) {
        super(accountService, currencyService, dataStore, updateForwarder, economyLogger, eventManager);
    }

    @Override
    protected Result<Void> performTransaction(Account account, Currency currency, BigDecimal amount, Context context) {
        if (amount.compareTo(BigDecimal.ZERO) < 0) {
            return Result.failure("Amount must be greater than -1", ErrorCode.INVALID_AMOUNT);
        }
        if (!currency.isValidAmount(amount)) {
            return Result.failure("Decimal not supported", ErrorCode.DECIMAL_NOT_SUPPORTED);
        }
        Result<Account> result = this.dataStore.setBalance(account.getUuid().toString(), currency, amount);
        if (!result.isSuccess()) {
            this.logger.log("[BALANCE SET failed] Account: " + account.getNickname() + " were set to: " + currency.format(amount) + " Error: " + result.getErrorMessage() + " Code: " + String.valueOf((Object)result.getErrorCode()));
            return Result.failure(result.getErrorMessage(), result.getErrorCode());
        }
        this.accountService.syncOnlineAccount(result.getValue());
        this.updateForwarder.sendUpdateMessage("event", new SetEvent(account.getPlayer(), currency, amount, context).toJson(), account.getUuid().toString());
        this.logger.log("[BALANCE SET] Account: " + account.getNickname() + " were set to: " + currency.format(amount));
        this.eventManager.emit(new SetEvent(account.getPlayer(), currency, amount, context));
        return Result.success();
    }
}

