/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.useCase.transaction;

import BlockDynasty.Economy.aplication.events.EventManager;
import BlockDynasty.Economy.aplication.useCase.transaction.TransactionUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.interfaces.IWithdrawUseCase;
import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.events.Context;
import BlockDynasty.Economy.domain.events.transactionsEvents.WithdrawEvent;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.result.ErrorCode;
import BlockDynasty.Economy.domain.result.Result;
import BlockDynasty.Economy.domain.services.IAccountService;
import BlockDynasty.Economy.domain.services.ICurrencyService;
import BlockDynasty.Economy.domain.services.courier.Courier;
import BlockDynasty.Economy.domain.services.log.Log;
import java.math.BigDecimal;

public class WithdrawUseCase
extends TransactionUseCase
implements IWithdrawUseCase {
    public WithdrawUseCase(ICurrencyService currencyService, IAccountService accountService, IRepository dataStore, Courier updateForwarder, Log logger2, EventManager eventManager) {
        super(accountService, currencyService, dataStore, updateForwarder, logger2, eventManager);
    }

    @Override
    protected Result<Void> performTransaction(Account account, Currency currency, BigDecimal amount, Context context) {
        if (account.isBlocked()) {
            return Result.failure("Account is blocked", ErrorCode.ACCOUNT_BLOCKED);
        }
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            return Result.failure("Amount must be greater than 0", ErrorCode.INVALID_AMOUNT);
        }
        if (!currency.isValidAmount(amount)) {
            return Result.failure("Decimal not supported", ErrorCode.DECIMAL_NOT_SUPPORTED);
        }
        Result<Account> result = this.dataStore.withdraw(account.getUuid().toString(), currency, amount);
        if (!result.isSuccess()) {
            this.logger.log("[WITHDRAW Failure] Account: " + account.getNickname() + " extrajo " + currency.format(amount) + " de " + currency.getSingular() + " - Error: " + result.getErrorMessage() + " - Code: " + String.valueOf((Object)result.getErrorCode()));
            return Result.failure(result.getErrorMessage(), result.getErrorCode());
        }
        this.accountService.syncOnlineAccount(result.getValue());
        this.updateForwarder.sendUpdateMessage("event", new WithdrawEvent(account.getPlayer(), currency, amount, context).toJson(), account.getUuid().toString());
        this.logger.log("[WITHDRAW] Account: " + account.getNickname() + " has made a withdrawal of " + currency.format(amount) + " " + currency.getSingular());
        this.eventManager.emit(new WithdrawEvent(account.getPlayer(), currency, amount, context));
        return Result.success();
    }
}

