/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.domain.entities.bank;

import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.entities.balance.Money;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Bank {
    private String name;
    private Player owner;
    private List<Money> vault;

    public Bank(String name, UUID ouwnerUUID, String owner) {
        this.name = name;
        this.owner = new Player(ouwnerUUID, ouwnerUUID.toString());
        this.vault = new ArrayList<Money>();
    }

    public String getName() {
        return this.name;
    }

    public void addBalance(Money money) {
        this.vault.add(money);
    }

    public void setVault(List<Money> monies) {
        this.vault = monies;
    }

    public String getOwnerName() {
        return this.owner.getNickname();
    }

    public UUID getOwnerUUID() {
        return this.owner.getUuid();
    }

    public BigDecimal getBalance(Currency currency) {
        for (Money money : this.vault) {
            if (!money.getCurrency().equals(currency)) continue;
            return money.getAmount();
        }
        return BigDecimal.ZERO;
    }

    public void deposit(Currency currency, BigDecimal amount) {
        for (Money money : this.vault) {
            if (!money.getCurrency().equals(currency)) continue;
            money.setAmount(money.getAmount().add(amount));
            return;
        }
    }

    public void withdraw(Currency currency, BigDecimal amount) {
        for (Money money : this.vault) {
            if (!money.getCurrency().equals(currency)) continue;
            BigDecimal newBalance = money.getAmount().subtract(amount);
            if (newBalance.compareTo(BigDecimal.ZERO) >= 0) {
                money.setAmount(newBalance);
            }
            return;
        }
    }
}

