/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.domain.events.transactionsEvents;

import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.events.SerializableEvent;
import java.math.BigDecimal;

public class TransferEvent
extends SerializableEvent {
    private final Player fromPlayer;
    private final Player toPlayer;
    private final Currency currency;
    private final BigDecimal amount;

    public TransferEvent(Player fromPlayer, Player toPlayer, Currency currency, BigDecimal amount) {
        this.fromPlayer = new Player(fromPlayer);
        this.toPlayer = new Player(toPlayer);
        this.currency = new Currency(currency);
        this.amount = amount;
    }

    public Player getFromPlayer() {
        return this.fromPlayer;
    }

    public Player getToPlayer() {
        return this.toPlayer;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String toString() {
        return "TransferEvent{player sender=" + this.fromPlayer.getNickname() + ", player receiver=" + this.toPlayer.getNickname() + ", currency=" + this.currency.getSingular() + ", amount=" + this.amount.toString() + "}";
    }
}

