/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.adapters.commands;

import BlockDynasty.adapters.commands.CommandAdapter;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.CommandExecutor;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.util.Nameable;
import org.spongepowered.plugin.PluginContainer;

public class CommandRegister {
    private static void registrarComando(RegisterCommandEvent<Command.Parameterized> event, PluginContainer container, lib.commands.abstractions.Command command) {
        Command.Builder mainCommandBuilder = CommandRegister.registrarComandoRecursivo(command);
        event.register(container, (Object)mainCommandBuilder.build(), command.getName(), new String[0]);
    }

    private static Command.Builder registrarComandoRecursivo(lib.commands.abstractions.Command command) {
        List<lib.commands.abstractions.Command> subCommands;
        Command.Builder commandBuilder = Command.builder().executor((CommandExecutor)new CommandAdapter(command));
        if (command.getArgs() != null && !command.getArgs().isEmpty()) {
            for (String argName : command.getArgs()) {
                if ("player".equalsIgnoreCase(argName)) {
                    commandBuilder.addParameter((Parameter)Parameter.string().key(argName).completer((context, currentInput) -> Sponge.server().onlinePlayers().stream().map(Nameable::name).filter(name -> name.toLowerCase().startsWith(currentInput.toLowerCase())).map(CommandCompletion::of).collect(Collectors.toList())).build());
                    continue;
                }
                commandBuilder.addParameter((Parameter)Parameter.string().key(argName).build());
            }
            commandBuilder.addParameter(CommandAdapter.ARGS);
        }
        if (command.getPermission() != null && !command.getPermission().isEmpty()) {
            commandBuilder.permission(command.getPermission());
        }
        if ((subCommands = command.getSubCommands()) != null && !subCommands.isEmpty()) {
            for (lib.commands.abstractions.Command subCommand : subCommands) {
                Command.Builder subCommandBuilder = CommandRegister.registrarComandoRecursivo(subCommand);
                commandBuilder.addChild(subCommandBuilder.build(), new String[]{subCommand.getName()});
            }
        }
        return commandBuilder;
    }

    public static void registerCommands(RegisterCommandEvent<Command.Parameterized> event, PluginContainer container, List<lib.commands.abstractions.Command> commands) {
        for (lib.commands.abstractions.Command command : commands) {
            CommandRegister.registrarComando(event, container, command);
        }
    }
}

