/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.adapters.integrations.spongeEconomyApi;

import BlockDynasty.Economy.domain.entities.balance.Money;
import BlockDynasty.adapters.integrations.spongeEconomyApi.CurrencyAdapter;
import BlockDynasty.adapters.integrations.spongeEconomyApi.TransactionResultAdapter;
import BlockDynasty.adapters.integrations.spongeEconomyApi.TransferResultAdapter;
import api.EconomyResponse;
import api.IApi;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.account.Account;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.service.economy.transaction.TransactionType;
import org.spongepowered.api.service.economy.transaction.TransactionTypes;
import org.spongepowered.api.service.economy.transaction.TransferResult;

public class UniqueAccountAdapter
implements UniqueAccount {
    private BlockDynasty.Economy.domain.entities.account.Account account;
    private IApi api;

    public UniqueAccountAdapter(BlockDynasty.Economy.domain.entities.account.Account account, IApi api) {
        this.account = account;
        this.api = api;
    }

    public Component displayName() {
        return Component.text((String)this.account.getNickname());
    }

    public BigDecimal defaultBalance(Currency currency) {
        return this.api.getBalance(this.account.getUuid());
    }

    public boolean hasBalance(Currency currency, Set<Context> contexts) {
        try {
            this.api.getBalance(this.account.getUuid());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasBalance(Currency currency, Cause cause) {
        try {
            this.api.getBalance(this.account.getUuid());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BigDecimal balance(Currency currency, Set<Context> contexts) {
        try {
            return this.api.getBalance(this.account.getUuid());
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public BigDecimal balance(Currency currency, Cause cause) {
        try {
            return this.api.getBalance(this.account.getUuid());
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public Map<Currency, BigDecimal> balances(Set<Context> contexts) {
        List<Money> moneyList = this.account.getWallet().getBalances();
        HashMap<Currency, BigDecimal> balances = new HashMap<Currency, BigDecimal>();
        for (Money money : moneyList) {
            balances.put(new CurrencyAdapter(money.getCurrency()), money.getAmount());
        }
        return balances;
    }

    public Map<Currency, BigDecimal> balances(Cause cause) {
        List<Money> moneyList = this.account.getWallet().getBalances();
        HashMap<Currency, BigDecimal> balances = new HashMap<Currency, BigDecimal>();
        for (Money money : moneyList) {
            balances.put(new CurrencyAdapter(money.getCurrency()), money.getAmount());
        }
        return balances;
    }

    public TransactionResult setBalance(Currency currency, BigDecimal amount, Set<Context> contexts) {
        EconomyResponse response = this.api.setBalance(this.account.getUuid(), amount, PlainTextComponentSerializer.plainText().serialize(currency.displayName()));
        return new TransactionResultAdapter(response, currency, (Account)this, amount, (TransactionType)TransactionTypes.DEPOSIT.get());
    }

    public TransactionResult setBalance(Currency currency, BigDecimal amount, Cause cause) {
        EconomyResponse response = this.api.setBalance(this.account.getUuid(), amount, PlainTextComponentSerializer.plainText().serialize(currency.displayName()));
        return new TransactionResultAdapter(response, currency, (Account)this, amount, (TransactionType)TransactionTypes.DEPOSIT.get());
    }

    public Map<Currency, TransactionResult> resetBalances(Set<Context> contexts) {
        return Map.of();
    }

    public Map<Currency, TransactionResult> resetBalances(Cause cause) {
        return Map.of();
    }

    public TransactionResult resetBalance(Currency currency, Set<Context> contexts) {
        return null;
    }

    public TransactionResult resetBalance(Currency currency, Cause cause) {
        return null;
    }

    public TransactionResult deposit(Currency currency, BigDecimal amount, Set<Context> contexts) {
        EconomyResponse response = this.api.deposit(this.account.getUuid(), amount, PlainTextComponentSerializer.plainText().serialize(currency.displayName()));
        return new TransactionResultAdapter(response, currency, (Account)this, amount, (TransactionType)TransactionTypes.DEPOSIT.get());
    }

    public TransactionResult deposit(Currency currency, BigDecimal amount, Cause cause) {
        EconomyResponse response = this.api.deposit(this.account.getUuid(), amount, PlainTextComponentSerializer.plainText().serialize(currency.displayName()));
        return new TransactionResultAdapter(response, currency, (Account)this, amount, (TransactionType)TransactionTypes.DEPOSIT.get());
    }

    public TransactionResult withdraw(Currency currency, BigDecimal amount, Set<Context> contexts) {
        EconomyResponse response = this.api.withdraw(this.account.getUuid(), amount, PlainTextComponentSerializer.plainText().serialize(currency.displayName()));
        return new TransactionResultAdapter(response, currency, (Account)this, amount, (TransactionType)TransactionTypes.WITHDRAW.get());
    }

    public TransactionResult withdraw(Currency currency, BigDecimal amount, Cause cause) {
        EconomyResponse response = this.api.withdraw(this.account.getUuid(), amount, PlainTextComponentSerializer.plainText().serialize(currency.displayName()));
        return new TransactionResultAdapter(response, currency, (Account)this, amount, (TransactionType)TransactionTypes.WITHDRAW.get());
    }

    public TransferResult transfer(Account to, Currency currency, BigDecimal amount, Set<Context> contexts) {
        EconomyResponse response = this.api.transfer(this.identifier(), to.identifier(), PlainTextComponentSerializer.plainText().serialize(currency.displayName()), amount);
        return new TransferResultAdapter(response, currency, (Account)this, to, amount);
    }

    public TransferResult transfer(Account to, Currency currency, BigDecimal amount, Cause cause) {
        EconomyResponse response = this.api.transfer(this.identifier(), to.identifier(), PlainTextComponentSerializer.plainText().serialize(currency.displayName()), amount);
        return new TransferResultAdapter(response, currency, (Account)this, to, amount);
    }

    public String identifier() {
        return this.account.getNickname();
    }

    public UUID uniqueId() {
        return this.account.getUuid();
    }
}

